/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.collect.Lists;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.ClientApiSchema;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.schema.HasSchemaProperties;
import com.mware.core.model.schema.SchemaElement;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.values.storable.Value;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.atteo.evo.inflector.English;

public abstract class Concept
implements SchemaElement,
HasSchemaProperties {
    private final String parentConceptName;
    private final Collection<SchemaProperty> properties;

    protected Concept(String parentConceptName, Collection<SchemaProperty> properties) {
        this.parentConceptName = parentConceptName;
        this.properties = properties;
    }

    public abstract String getId();

    public abstract String getName();

    public abstract boolean hasGlyphIconResource();

    public abstract boolean hasGlyphIconSelectedResource();

    public abstract String getColor();

    public abstract String getDisplayName();

    public abstract String getDisplayType();

    public abstract String getTitleFormula();

    public abstract Boolean getSearchable();

    public abstract String getSubtitleFormula();

    public abstract String getTimeFormula();

    @Override
    public abstract boolean getUserVisible();

    @Override
    public abstract boolean getDeleteable();

    @Override
    public abstract boolean getUpdateable();

    public abstract SandboxStatus getSandboxStatus();

    public abstract Map<String, String> getMetadata();

    public abstract List<String> getAddRelatedConceptWhiteList();

    @Override
    public Collection<SchemaProperty> getProperties() {
        return this.properties;
    }

    public String getParentConceptName() {
        return this.parentConceptName;
    }

    public ClientApiSchema.Concept toClientApi() {
        try {
            ClientApiSchema.Concept concept = new ClientApiSchema.Concept();
            concept.setId(this.getName());
            concept.setTitle(this.getName());
            concept.setDisplayName(this.getDisplayName());
            if (this.getDisplayType() != null) {
                concept.setDisplayType(this.getDisplayType());
            }
            if (this.getTitleFormula() != null) {
                concept.setTitleFormula(this.getTitleFormula());
            }
            if (this.getSearchable() != null) {
                concept.setSearchable(this.getSearchable());
            }
            if (this.getSubtitleFormula() != null) {
                concept.setSubtitleFormula(this.getSubtitleFormula());
            }
            if (this.getTimeFormula() != null) {
                concept.setTimeFormula(this.getTimeFormula());
            }
            if (this.getParentConceptName() != null) {
                concept.setParentConcept(this.getParentConceptName());
            }
            if (this.getDisplayName() != null) {
                concept.setPluralDisplayName(English.plural((String)this.getDisplayName()));
            }
            concept.setUserVisible(this.getUserVisible());
            concept.setCoreConcept(this.getCoreConcept());
            concept.setDeleteable(this.getDeleteable());
            concept.setUpdateable(this.getUpdateable());
            if (this.hasGlyphIconResource()) {
                concept.setGlyphIconHref("resource?id=" + URLEncoder.encode(this.getName(), "utf8"));
            }
            if (this.hasGlyphIconSelectedResource()) {
                concept.setGlyphIconSelectedHref("resource?state=selected&id=" + URLEncoder.encode(this.getName(), "utf8"));
            }
            if (this.getColor() != null) {
                concept.setColor(this.getColor());
            }
            if (this.getAddRelatedConceptWhiteList() != null) {
                concept.getAddRelatedConceptWhiteList().addAll(this.getAddRelatedConceptWhiteList());
            }
            if (this.getIntents() != null) {
                concept.getIntents().addAll(Arrays.asList(this.getIntents()));
            }
            if (this.properties != null) {
                for (SchemaProperty schemaProperty : this.properties) {
                    concept.getProperties().add(schemaProperty.getName());
                }
            }
            for (Map.Entry entry : this.getMetadata().entrySet()) {
                concept.getMetadata().put((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.getSandboxStatus() != null) {
                concept.setSandboxStatus(this.getSandboxStatus());
            }
            return concept;
        }
        catch (UnsupportedEncodingException e) {
            throw new BcException("bad encoding", e);
        }
    }

    public String toString() {
        return String.format("%s (%s)", this.getDisplayName(), this.getName());
    }

    public static Collection<ClientApiSchema.Concept> toClientApiConcepts(Iterable<Concept> concepts) {
        ArrayList<ClientApiSchema.Concept> results = new ArrayList<ClientApiSchema.Concept>();
        for (Concept concept : concepts) {
            results.add(concept.toClientApi());
        }
        return results;
    }

    public abstract void setProperty(String var1, Value var2, User var3, Authorizations var4);

    public abstract void removeProperty(String var1, Authorizations var2);

    public abstract byte[] getGlyphIcon();

    public abstract byte[] getGlyphIconSelected();

    public abstract String getGlyphIconFilePath();

    public abstract String getGlyphIconSelectedFilePath();

    public abstract byte[] getMapGlyphIcon();

    public abstract String[] getIntents();

    public abstract void addIntent(String var1, User var2, Authorizations var3);

    public abstract void removeIntent(String var1, Authorizations var2);

    public void updateIntents(String[] newIntents, User user, Authorizations authorizations) {
        ArrayList toBeRemovedIntents = Lists.newArrayList((Object[])this.getIntents());
        for (String newIntent : newIntents) {
            if (toBeRemovedIntents.contains(newIntent)) {
                toBeRemovedIntents.remove(newIntent);
                continue;
            }
            this.addIntent(newIntent, user, authorizations);
        }
        for (String toBeRemovedIntent : toBeRemovedIntents) {
            this.removeIntent(toBeRemovedIntent, authorizations);
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Concept)) {
            return false;
        }
        Concept other = (Concept)obj;
        return this.getName().equals(other.getName());
    }
}

