/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.FaceRecognitionSchema;
import com.mware.core.model.properties.LongRunningProcessSchema;
import com.mware.core.model.properties.MediaBcSchema;
import com.mware.core.model.properties.RawObjectSchema;
import com.mware.core.model.properties.RegexSchema;
import com.mware.core.model.properties.RoleSchema;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.properties.SearchSchema;
import com.mware.core.model.properties.UserSchema;
import com.mware.core.model.properties.WorkspaceSchema;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.LabelName;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaFactory;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.ping.PingSchema;
import com.mware.ge.TextIndexHint;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.Values;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class DefaultSchemaCreator {
    private Concept thingConcept;
    private Relationship topObjectProperty;
    private Concept userConcept;
    private SchemaRepository schemaRepository;
    private boolean simple;
    private SchemaFactory schemaFactory;

    public DefaultSchemaCreator(SchemaRepository schemaRepository) {
        this(schemaRepository, false);
    }

    public DefaultSchemaCreator(SchemaRepository schemaRepository, boolean simple) {
        this.schemaRepository = schemaRepository;
        this.simple = simple;
        this.schemaFactory = new SchemaFactory(schemaRepository);
    }

    public void createOntology() {
        this.thingConcept = this.schemaFactory.getOrCreateThingConcept();
        this.topObjectProperty = this.schemaFactory.getOrCreateRootRelationship();
        this.createMetaOntology();
        this.createUserOntology();
        this.createRoleOntology();
        this.createWorkspaceOntology();
        if (this.simple) {
            return;
        }
        this.createBaseOntology();
        this.createSearchOntology();
        this.createLongRunningProcessOntology();
        this.createPingOntology();
        this.createRegexOntology();
        this.createRawObjectAndMediaOntology();
        this.createSpongeOntology();
        this.createNerOntology();
        this.createFaceRecognitionOntology();
    }

    public void createBaseOntology() {
        Relationship hasEntity = this.schemaFactory.newRelationship().label("hasEntity").parent(this.topObjectProperty).source(this.thingConcept).target(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Has Entity")).intents("artifactHasEntity").coreConcept(true).save();
        Relationship hasDetectedEntity = this.schemaFactory.newRelationship().label("hasDetectedEntity").parent(this.topObjectProperty).source(this.thingConcept).target(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Has Detected Entity")).coreConcept(true).save();
        this.schemaFactory.newRelationship().label("hasSource").parent(this.topObjectProperty).source(this.thingConcept).target(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Has Source")).coreConcept(true).inverseOf(hasEntity).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.VISIBILITY_JSON.getPropertyName()).displayName("Visibility JSON").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.MODIFIED_BY.getPropertyName()).displayName("Modified By").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.MODIFIED_DATE.getPropertyName()).sortable(true).displayName("Modified Date").type(PropertyType.DATE).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.DATA_WORKER_BLACK_LIST.getPropertyName()).displayName("Data Worker Black List").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.DATA_WORKER_WHITE_LIST.getPropertyName()).displayName("Data Worker White List").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.TERM_MENTION_FOR_ELEMENT_ID.getPropertyName()).displayName("TM For Element ID").type(PropertyType.STRING).save();
        Concept event = this.schemaFactory.newConcept().conceptType("event").displayName("Event").parent(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).glyphIcon("event.png").save();
        this.schemaFactory.newConceptProperty().concepts(event).name(BcSchema.EVENT_TIME.getPropertyName()).displayName("Event Time").type(PropertyType.DATE).sortable(true).userVisible(true).save();
    }

    public void createMetaOntology() {
        Concept conceptConcept = this.schemaFactory.newConcept().conceptType("__oc").displayName("Ontology Concept").property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).coreConcept(true).save();
        Concept propertyConcept = this.schemaFactory.newConcept().conceptType("__op").displayName("Ontology Property").property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).coreConcept(true).save();
        Concept relationshipConcept = this.schemaFactory.newConcept().conceptType("__or").displayName("Ontology Relationship").property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).coreConcept(true).save();
        this.schemaFactory.newRelationship().label(LabelName.IS_A.toString()).source(conceptConcept, relationshipConcept).target(conceptConcept, relationshipConcept).coreConcept(true).save();
        this.schemaFactory.newRelationship().label(LabelName.HAS_EDGE.toString()).source(conceptConcept).target(relationshipConcept).coreConcept(true).save();
        this.schemaFactory.newRelationship().label(LabelName.HAS_PROPERTY.toString()).source(conceptConcept, relationshipConcept).target(propertyConcept).coreConcept(true).save();
        this.schemaFactory.newRelationship().label(LabelName.INVERSE_OF.toString()).source(relationshipConcept).target(relationshipConcept).coreConcept(true).save();
    }

    public void createUserOntology() {
        this.userConcept = this.schemaFactory.newConcept().conceptType("__usr").parent(this.thingConcept).displayName("User").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.AUTHORIZATIONS.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.CREATE_DATE.getPropertyName()).type(PropertyType.DATE).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.CURRENT_LOGIN_DATE.getPropertyName()).type(PropertyType.DATE).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.CURRENT_LOGIN_REMOTE_ADDR.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.CURRENT_WORKSPACE.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.DISPLAY_NAME.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.LOGIN_COUNT.getPropertyName()).type(PropertyType.INTEGER).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.PASSWORD_HASH.getPropertyName()).type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.PASSWORD_SALT.getPropertyName()).type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.PREVIOUS_LOGIN_DATE.getPropertyName()).type(PropertyType.DATE).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.PREVIOUS_LOGIN_REMOTE_ADDR.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name("userPrivileges").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.STATUS.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.UI_PREFERENCES.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.USERNAME.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.EMAIL_ADDRESS.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.PASSWORD_RESET_TOKEN.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.userConcept).name(UserSchema.PASSWORD_RESET_TOKEN_EXPIRATION_DATE.getPropertyName()).type(PropertyType.DATE).save();
    }

    public void createRoleOntology() {
        Concept roleConcept = this.schemaFactory.newConcept().conceptType("__rl").parent(this.thingConcept).displayName("Role").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newRelationship().label("roleToUser").parent(this.topObjectProperty).source(roleConcept).target(this.userConcept).coreConcept(true).save();
        this.schemaFactory.newConceptProperty().concepts(roleConcept).name(RoleSchema.ROLE_NAME.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(roleConcept).name(RoleSchema.DESCRIPTION.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(roleConcept).name(RoleSchema.PRIVILEGES.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(roleConcept).name(RoleSchema.GLOBAL.getPropertyName()).type(PropertyType.BOOLEAN).save();
    }

    public void createWorkspaceOntology() {
        Concept workspace = this.schemaFactory.newConcept().conceptType("__ws").parent(this.thingConcept).displayName("Workspace").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newRelationship().label("__wsToEnt").parent(this.topObjectProperty).source(workspace).target(this.thingConcept).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("To Entity")).coreConcept(true).save();
        Relationship workspaceToUser = this.schemaFactory.newRelationship().label("__wsToUsr").parent(this.topObjectProperty).source(workspace).target(this.userConcept).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("To User")).coreConcept(true).save();
        this.schemaFactory.newRelationship().label("__wsToSchema").parent(this.topObjectProperty).source(workspace).target(this.thingConcept).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("To Ontology")).coreConcept(true).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(WorkspaceSchema.WORKSPACE_TO_USER_ACCESS.getPropertyName()).type(PropertyType.STRING).forRelationships(workspaceToUser).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(WorkspaceSchema.WORKSPACE_TO_USER_IS_CREATOR.getPropertyName()).type(PropertyType.BOOLEAN).forRelationships(workspaceToUser).save();
        this.schemaFactory.newConceptProperty().concepts(workspace).name(WorkspaceSchema.TITLE.getPropertyName()).type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
    }

    public void createSearchOntology() {
        Concept savedSearch = this.schemaFactory.newConcept().conceptType("__ss").parent(this.thingConcept).displayName("Saved search").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newRelationship().label("__shss").parent(this.topObjectProperty).source(this.userConcept).target(savedSearch).coreConcept(true).save();
        this.schemaFactory.newConceptProperty().concepts(savedSearch).name(SearchSchema.NAME.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(savedSearch).name(SearchSchema.PARAMETERS.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(savedSearch).name(SearchSchema.URL.getPropertyName()).type(PropertyType.STRING).save();
    }

    public void createLongRunningProcessOntology() {
        Concept longRunningProcess = this.schemaFactory.newConcept().conceptType("__lrp").parent(this.thingConcept).displayName("Long Running Process").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newRelationship().label("__lrpToUsr").parent(this.topObjectProperty).source(this.userConcept).target(longRunningProcess).coreConcept(true).save();
        this.schemaFactory.newConceptProperty().concepts(longRunningProcess).name(LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.getPropertyName()).type(PropertyType.STRING).searchable(false).save();
    }

    public void createPingOntology() {
        Concept ping = this.schemaFactory.newConcept().conceptType("__p").parent(this.thingConcept).displayName("Ping").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.CREATE_DATE.getPropertyName()).displayName("Create Date").type(PropertyType.DATE).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.CREATE_REMOTE_ADDR.getPropertyName()).displayName("Create Remote Address").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.GRAPH_PROPERTY_WORKER_DATE.getPropertyName()).displayName("GPW Date").type(PropertyType.DATE).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.GRAPH_PROPERTY_WORKER_HOST_ADDRESS.getPropertyName()).displayName("GPW Host Address").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.GRAPH_PROPERTY_WORKER_HOSTNAME.getPropertyName()).displayName("GPW Hostname").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.GRAPH_PROPERTY_WORKER_WAIT_TIME_MS.getPropertyName()).displayName("GPW Wait Time (ms)").type(PropertyType.INTEGER).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.LONG_RUNNING_PROCESS_DATE.getPropertyName()).displayName("LRP Date").type(PropertyType.DATE).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.LONG_RUNNING_PROCESS_HOST_ADDRESS.getPropertyName()).displayName("LRP Host Address").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.LONG_RUNNING_PROCESS_HOSTNAME.getPropertyName()).displayName("LRP Hostname").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.LONG_RUNNING_PROCESS_WAIT_TIME_MS.getPropertyName()).displayName("LRP Wait Time (ms)").type(PropertyType.INTEGER).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.RETRIEVAL_TIME_MS.getPropertyName()).displayName("Retrieval Time (ms)").type(PropertyType.INTEGER).save();
        this.schemaFactory.newConceptProperty().concepts(ping).name(PingSchema.SEARCH_TIME_MS.getPropertyName()).displayName("Search Time (ms)").type(PropertyType.INTEGER).save();
    }

    public void createRegexOntology() {
        Concept regex = this.schemaFactory.newConcept().conceptType("__rgx").parent(this.thingConcept).displayName("Regex").coreConcept(true).property(SchemaProperties.UPDATEABLE.getPropertyName(), BooleanValue.FALSE).save();
        this.schemaFactory.newConceptProperty().concepts(regex).name(RegexSchema.REGEX_NAME.getPropertyName()).displayName("Regex Name").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(regex).name(RegexSchema.REGEX_PATTERN.getPropertyName()).displayName("Regex pattern").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(regex).name(RegexSchema.REGEX_CONCEPT.getPropertyName()).displayName("Regex concept").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
    }

    private void createRawObjectAndMediaOntology() {
        Concept raw = this.schemaFactory.newConcept().conceptType("raw").displayName("Raw").parent(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).save();
        Concept audio = this.schemaFactory.newConcept().conceptType("audio").displayName("Audio").parent(raw).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_TYPE.getPropertyName(), Values.stringValue("audio")).intents("audio").glyphIcon("audio.png").save();
        Concept document = this.schemaFactory.newConcept().conceptType("document").displayName("Document").parent(raw).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_TYPE.getPropertyName(), Values.stringValue("document")).intents("document").glyphIcon("document.png").save();
        Concept image = this.schemaFactory.newConcept().conceptType("image").displayName("Image").parent(raw).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_TYPE.getPropertyName(), Values.stringValue("image")).intents("image", "entityImage").glyphIcon("image.png").save();
        Concept video = this.schemaFactory.newConcept().conceptType("video").displayName("Video").parent(raw).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_TYPE.getPropertyName(), Values.stringValue("video")).intents("video").glyphIcon("video.png").save();
        this.schemaFactory.newRelationship().label("rawContainsImageOfEntity").parent(this.topObjectProperty).source(image).target(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Contains Image Of")).intents("artifactContainsImage", "artifactContainsImageOfEntity").save();
        this.schemaFactory.newRelationship().label("entityHasImageRaw").parent(this.topObjectProperty).source(this.thingConcept).target(image).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Has Image")).intents("entityHasImage").save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.LIKES.getPropertyName()).displayName("Social Likes").type(PropertyType.INTEGER).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.SHARES.getPropertyName()).displayName("Social Shares").type(PropertyType.INTEGER).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.COMMENTS.getPropertyName()).displayName("Social Comments").type(PropertyType.INTEGER).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(MediaBcSchema.AUDIO_MP3.getPropertyName()).displayName("Audio MP3").type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.CACHED_IMAGE.getPropertyName()).displayName("Cached Image").type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.CONTENT_HASH.getPropertyName()).displayName("Content Hash").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(SchemaProperties.DATA_TYPE.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.DETECTED_OBJECT.getPropertyName()).displayName("Detected Object").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.ENTITY_IMAGE_URL.getPropertyName()).displayName("Entity Image URL").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.ENTITY_IMAGE_VERTEX_ID.getPropertyName()).displayName("Entity Image Vertex ID").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.FILE_NAME.getPropertyName()).displayName("File Name").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.SOURCE.getPropertyName()).displayName("Source").type(PropertyType.STRING).userVisible(true).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.URL.getPropertyName()).displayName("URL").type(PropertyType.STRING).displayType("link").userVisible(true).textIndexHints(TextIndexHint.ALL).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.METADATA_JSON.getPropertyName()).displayName("Metadata JSON").type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.MIME_TYPE.getPropertyName()).displayName("Mime Type").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(SchemaProperties.ONTOLOGY_TITLE.getPropertyName()).type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.PROCESS.getPropertyName()).displayName("Process").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.RAW.getPropertyName()).displayName("Raw Data").type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(MediaBcSchema.RAW_POSTER_FRAME.getPropertyName()).displayName("Raw Poster Frame").type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.ROW_KEY.getPropertyName()).displayName("Row Key").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.TERM_MENTION.getPropertyName()).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.TEXT.getPropertyName()).displayName("Text").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.FULL_TEXT)).userVisible(true).displayType("longText").save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(BcSchema.TITLE.getPropertyName()).displayName("Title").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).userVisible(true).intents("artifactTitle").save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.RAW_SENTIMENT.getPropertyName()).displayName("Sentiment").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).userVisible(true).searchFacet(true).aggType("term").possibleValues((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("positive", "Positive");
                this.put("neutral", "Neutral");
                this.put("negative", "Negative");
            }
        }).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.RAW_TYPE.getPropertyName()).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).displayName("Type").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(MediaBcSchema.VIDEO_FRAME.getPropertyName()).displayName("Video Frame").type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(MediaBcSchema.VIDEO_PREVIEW_IMAGE.getPropertyName()).displayName("Video Preview Image").type(PropertyType.BINARY).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(MediaBcSchema.VIDEO_TRANSCRIPT.getPropertyName()).displayName("Video Transcript").type(PropertyType.STRING).displayType("longText").textIndexHints(EnumSet.of(TextIndexHint.FULL_TEXT)).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(video, audio).name(MediaBcSchema.MEDIA_DURATION.getPropertyName()).displayName("Duration (seconds)").type(PropertyType.STRING).textIndexHints(TextIndexHint.ALL).intents("media.duration", "audioDuration", "videoDuration").userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.GEOLOCATION_PROPERTY.getPropertyName()).displayName("Geolocation").type(PropertyType.GEO_LOCATION).userVisible(true).intents("geoLocation").save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.GEOSHAPE_PROPERTY.getPropertyName()).displayName("Geoshape").type(PropertyType.GEO_SHAPE).userVisible(false).save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_DATE_TAKEN.getPropertyName()).displayName("Date taken").type(PropertyType.DATE).userVisible(true).intents("media.dateTaken").save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_DEVICE_MAKE.getPropertyName()).displayName("Device Make").type(PropertyType.STRING).userVisible(true).textIndexHints(TextIndexHint.ALL).intents("media.deviceMake").save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_DEVICE_MODEL.getPropertyName()).displayName("Device Model").type(PropertyType.STRING).userVisible(true).textIndexHints(TextIndexHint.ALL).intents("media.deviceModel").save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_WIDTH.getPropertyName()).displayName("Media Width").type(PropertyType.INTEGER).userVisible(true).intents("media.width").save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_HEIGHT.getPropertyName()).displayName("Media Height").type(PropertyType.INTEGER).userVisible(true).intents("media.height").save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_METADATA.getPropertyName()).displayName("Media Metadata").type(PropertyType.STRING).userVisible(false).textIndexHints(EnumSet.of(TextIndexHint.FULL_TEXT)).intents("media.metadata").save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.MEDIA_FILE_SIZE.getPropertyName()).displayName("Media File Size").displayType("byte").type(PropertyType.INTEGER).userVisible(true).intents("media.fileSize").save();
        this.schemaFactory.newConceptProperty().concepts(audio, image, video).name(MediaBcSchema.MEDIA_DESCRIPTION.getPropertyName()).displayName("Media Description").type(PropertyType.STRING).userVisible(true).textIndexHints(TextIndexHint.ALL).intents("media.description").save();
        this.schemaFactory.newConceptProperty().concepts(image).name(MediaBcSchema.MEDIA_IMAGE_HEADING.getPropertyName()).displayName("Image Heading").displayType("heading").type(PropertyType.DOUBLE).userVisible(true).intents("media.imageHeading").save();
        this.schemaFactory.newConceptProperty().concepts(image).name(MediaBcSchema.MEDIA_Y_AXIS_FLIPPED.getPropertyName()).displayName("Y Axis Flipped").type(PropertyType.BOOLEAN).intents("media.yAxisFlipped").save();
        this.schemaFactory.newConceptProperty().concepts(image).name(MediaBcSchema.MEDIA_CLOCKWISE_ROTATION.getPropertyName()).displayName("Clockwise Rotation").type(PropertyType.INTEGER).intents("media.clockwiseRotation").save();
        this.schemaFactory.newConceptProperty().concepts(video).name(MediaBcSchema.MEDIA_VIDEO_FORMAT.getPropertyName()).displayName("Video Format").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(video).name(MediaBcSchema.MEDIA_VIDEO_CODEC.getPropertyName()).displayName("Video Codec").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(video, audio).name(MediaBcSchema.MEDIA_AUDIO_FORMAT.getPropertyName()).displayName("Audio Format").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(video, audio).name(MediaBcSchema.MEDIA_AUDIO_CODEC.getPropertyName()).displayName("Audio Codec").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(image, video).name(MediaBcSchema.IMAGE_TAG.getPropertyName()).displayName("Media Tag").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.FULL_TEXT)).userVisible(true).searchFacet(true).aggType("term").save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.AUTHOR.getPropertyName()).textIndexHints(TextIndexHint.ALL).displayName("Author").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.AUTHOR_ID.getPropertyName()).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).displayName("Author ID").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.AUTHOR_REFERENCE.getPropertyName()).textIndexHints(TextIndexHint.ALL).displayName("Author Reference").displayType("link").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.LINKS.getPropertyName()).textIndexHints(TextIndexHint.ALL).displayName("Links").displayType("link").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.HASHTAGS.getPropertyName()).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).displayName("Hashtags").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.PAGE_COUNT.getPropertyName()).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).displayName("Page Count").userVisible(true).type(PropertyType.INTEGER).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(RawObjectSchema.RAW_LANGUAGE.getPropertyName()).displayName("Language").type(PropertyType.STRING).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).userVisible(true).possibleValues((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("en", "English");
                this.put("fr", "French");
                this.put("de", "German");
                this.put("it", "Italian");
                this.put("ja", "Japanese");
                this.put("pt", "Portuguese");
                this.put("es", "Spanish");
                this.put("ko", "Korean");
                this.put("ro", "Romanian");
                this.put("tg", "Tagalog");
                this.put("id", "Indonesian");
                this.put("zh", "Chinese (Simplified)");
                this.put("zh-Hant", "Chinese (Traditional)");
            }
        }).save();
    }

    private void createSpongeOntology() {
        Concept raw = this.schemaRepository.getConceptByName("raw");
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.SOURCE_DATE.getPropertyName()).displayName("Source Date").type(PropertyType.DATE).sortable(true).userVisible(true).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).save();
        Concept socialPost = this.schemaFactory.newConcept().conceptType("socialPost").displayName("Social Post").parent(raw).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_TYPE.getPropertyName(), Values.stringValue("image")).glyphIcon("socialpost.png").save();
        this.schemaFactory.newConceptProperty().concepts(socialPost).name(RawObjectSchema.ORIGINAL_POST_ID.getPropertyName()).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).displayName("Original Post ID").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(socialPost).name(RawObjectSchema.ORIGINAL_POST.getPropertyName()).textIndexHints(TextIndexHint.NONE).displayType("link").displayName("Original Post Link").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(raw).name(RawObjectSchema.ORIGINAL_AUTHOR_ID.getPropertyName()).textIndexHints(EnumSet.of(TextIndexHint.EXACT_MATCH)).displayName("Original Author ID").userVisible(true).type(PropertyType.STRING).save();
        this.schemaFactory.newConceptProperty().concepts(socialPost).name(RawObjectSchema.ORIGINAL_AUTHOR.getPropertyName()).textIndexHints(TextIndexHint.NONE).displayType("link").displayName("Original Author Link").userVisible(true).type(PropertyType.STRING).save();
        Concept socialComment = this.schemaFactory.newConcept().conceptType("socialComment").displayName("Social Comment").parent(raw).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_TYPE.getPropertyName(), Values.stringValue("image")).glyphIcon("socialcomment.png").save();
        this.schemaFactory.newRelationship().label("hasSocialComment").parent(this.topObjectProperty).source(socialPost).target(socialComment).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Has Social Comment")).save();
    }

    public void createNerOntology() {
        this.schemaFactory.newConcept().conceptType("person").displayName("Person").parent(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).glyphIcon("person.png").save();
        this.schemaFactory.newConcept().conceptType("organization").displayName("Organization").parent(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).glyphIcon("organization.png").save();
        this.schemaFactory.newConcept().conceptType("location").displayName("Location").parent(this.thingConcept).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).glyphIcon("location.png").save();
    }

    public void createFaceRecognitionOntology() {
        Concept person = this.schemaRepository.getConceptByName("person");
        Concept event = this.schemaRepository.getConceptByName("event");
        Concept image = this.schemaRepository.getConceptByName("image");
        this.schemaFactory.newConceptProperty().concepts(person).name(FaceRecognitionSchema.FACE_DESCRIPTOR.getPropertyName()).displayName("Face Descriptors").type(PropertyType.STRING).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(person).name(FaceRecognitionSchema.LAST_FACE_EVENT.getPropertyName()).displayName("Face Seen On").type(PropertyType.DATE).userVisible(true).save();
        this.schemaFactory.newConceptProperty().concepts(person).name(FaceRecognitionSchema.NUMBER_OF_FACES.getPropertyName()).displayName("Numer of Faces").type(PropertyType.INTEGER).userVisible(true).save();
        this.schemaFactory.newRelationship().label("faceEvent").parent(this.topObjectProperty).source(event).target(person).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Face detection")).save();
        Relationship faceOf = this.schemaFactory.newRelationship().label("faceOf").parent(this.topObjectProperty).source(image).target(person).property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).property(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue("Face of")).save();
        this.schemaFactory.newConceptProperty().concepts(this.thingConcept).name(FaceRecognitionSchema.FACE_PROCESSED.getPropertyName()).type(PropertyType.BOOLEAN).forRelationships(faceOf).save();
    }
}

