/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.user.User;
import com.mware.core.util.JSONUtil;
import com.mware.core.util.SandboxStatusUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.Value;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;

public class GeConcept
extends Concept {
    private final Vertex vertex;
    private final String workspaceId;

    public GeConcept(Vertex vertex, String workspaceId) {
        this(vertex, null, null, workspaceId);
    }

    public GeConcept(Vertex vertex, String parentConceptName, Collection<SchemaProperty> properties, String workspaceId) {
        super(parentConceptName, properties);
        this.vertex = vertex;
        this.workspaceId = workspaceId;
    }

    @Override
    public String getId() {
        return this.vertex.getId();
    }

    @Override
    public String getName() {
        return (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(this.vertex);
    }

    @Override
    public boolean hasGlyphIconResource() {
        return this.vertex.getPropertyValue(SchemaProperties.GLYPH_ICON.getPropertyName()) != null || this.vertex.getPropertyValue(SchemaProperties.GLYPH_ICON_FILE_NAME.getPropertyName()) != null;
    }

    @Override
    public boolean hasGlyphIconSelectedResource() {
        return this.vertex.getPropertyValue(SchemaProperties.GLYPH_ICON_SELECTED.getPropertyName()) != null || this.vertex.getPropertyValue(SchemaProperties.GLYPH_ICON_SELECTED_FILE_NAME.getPropertyName()) != null;
    }

    @Override
    public String getColor() {
        return (String)SchemaProperties.COLOR.getPropertyValue(this.vertex);
    }

    @Override
    public String getDisplayName() {
        return (String)SchemaProperties.DISPLAY_NAME.getPropertyValue(this.vertex);
    }

    @Override
    public String getDisplayType() {
        return (String)SchemaProperties.DISPLAY_TYPE.getPropertyValue(this.vertex);
    }

    @Override
    public String getTitleFormula() {
        return (String)SchemaProperties.TITLE_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public Boolean getSearchable() {
        return SchemaProperties.SEARCHABLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public String getSubtitleFormula() {
        return (String)SchemaProperties.SUBTITLE_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public String getTimeFormula() {
        return (String)SchemaProperties.TIME_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public boolean getUserVisible() {
        return SchemaProperties.USER_VISIBLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public boolean getDeleteable() {
        return SchemaProperties.DELETEABLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public boolean getUpdateable() {
        return SchemaProperties.UPDATEABLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public boolean getCoreConcept() {
        return SchemaProperties.CORE_CONCEPT.getPropertyValue((Element)this.vertex, false);
    }

    @Override
    public String[] getIntents() {
        return IterableUtils.toArray(SchemaProperties.INTENT.getPropertyValues(this.vertex), String.class);
    }

    @Override
    public void addIntent(String intent, User user, Authorizations authorizations) {
        Visibility visibility = SchemaRepository.VISIBILITY.getVisibility();
        Metadata metadata = this.createPropertyMetadata(user, ZonedDateTime.now(), visibility);
        SchemaProperties.INTENT.addPropertyValue(this.vertex, intent, intent, metadata, visibility, authorizations);
        this.vertex.getGraph().flush();
    }

    @Override
    public void removeIntent(String intent, Authorizations authorizations) {
        SchemaProperties.INTENT.removeProperty(this.vertex, intent, authorizations);
        this.vertex.getGraph().flush();
    }

    @Override
    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.getSandboxStatus() == SandboxStatus.PRIVATE) {
            if (BcSchema.MODIFIED_BY.hasProperty(this.vertex)) {
                metadata.put(BcSchema.MODIFIED_BY.getPropertyName(), (String)BcSchema.MODIFIED_BY.getPropertyValue(this.vertex));
            }
            if (BcSchema.MODIFIED_DATE.hasProperty(this.vertex)) {
                metadata.put(BcSchema.MODIFIED_DATE.getPropertyName(), ((ZonedDateTime)BcSchema.MODIFIED_DATE.getPropertyValue(this.vertex)).toString());
            }
        }
        return metadata;
    }

    @Override
    public List<String> getAddRelatedConceptWhiteList() {
        JSONArray arr = (JSONArray)SchemaProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyValue(this.vertex);
        if (arr == null) {
            return null;
        }
        return JSONUtil.toStringList(arr);
    }

    @Override
    public void setProperty(String name, Value value, User user, Authorizations authorizations) {
        Visibility visibility = SchemaRepository.VISIBILITY.getVisibility();
        Metadata metadata = this.createPropertyMetadata(user, ZonedDateTime.now(), visibility);
        this.getVertex().setProperty(name, value, metadata, SchemaRepository.VISIBILITY.getVisibility(), authorizations);
        this.getVertex().getGraph().flush();
    }

    public void removeProperty(String key, String name, Authorizations authorizations) {
        this.getVertex().softDeleteProperty(key, name, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public void removeProperty(String name, Authorizations authorizations) {
        this.removeProperty("", name, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public byte[] getGlyphIcon() {
        try {
            StreamingPropertyValue spv = (StreamingPropertyValue)SchemaProperties.GLYPH_ICON.getPropertyValue(this.getVertex());
            if (spv == null) {
                return null;
            }
            return IOUtils.toByteArray((InputStream)spv.getInputStream());
        }
        catch (IOException e) {
            throw new BcResourceNotFoundException("Could not retrieve glyph icon");
        }
    }

    @Override
    public byte[] getGlyphIconSelected() {
        try {
            StreamingPropertyValue spv = (StreamingPropertyValue)SchemaProperties.GLYPH_ICON_SELECTED.getPropertyValue(this.getVertex());
            if (spv == null) {
                return null;
            }
            return IOUtils.toByteArray((InputStream)spv.getInputStream());
        }
        catch (IOException e) {
            throw new BcResourceNotFoundException("Could not retrieve glyph icon selected");
        }
    }

    @Override
    public String getGlyphIconFilePath() {
        return (String)SchemaProperties.GLYPH_ICON_FILE_NAME.getPropertyValue(this.getVertex());
    }

    @Override
    public String getGlyphIconSelectedFilePath() {
        return (String)SchemaProperties.GLYPH_ICON_SELECTED_FILE_NAME.getPropertyValue(this.getVertex());
    }

    @Override
    public byte[] getMapGlyphIcon() {
        try {
            StreamingPropertyValue spv = (StreamingPropertyValue)SchemaProperties.MAP_GLYPH_ICON.getPropertyValue(this.getVertex());
            if (spv == null) {
                return null;
            }
            return IOUtils.toByteArray((InputStream)spv.getInputStream());
        }
        catch (IOException e) {
            throw new BcResourceNotFoundException("Could not retrieve map glyph icon");
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.vertex != null ? this.vertex.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeConcept other = (GeConcept)obj;
        return this.vertex == other.vertex || this.vertex != null && this.vertex.equals(other.vertex);
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return SandboxStatusUtil.getSandboxStatus(this.vertex, this.workspaceId);
    }

    private Metadata createPropertyMetadata(User user, ZonedDateTime modifiedDate, Visibility visibility) {
        Metadata metadata = Metadata.create();
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, modifiedDate, visibility);
        if (user != null) {
            BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), visibility);
        }
        return metadata;
    }
}

