/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.user.User;
import com.mware.core.util.SandboxStatusUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeRelationship
extends Relationship {
    private final Vertex vertex;
    private final List<String> inverseOfNames;
    private final String namespace;

    public GeRelationship(String parentName, Vertex vertex, List<String> domainConceptNames, List<String> rangeConceptNames, List<String> inverseOfNames, Collection<SchemaProperty> properties, String namespace) {
        super(parentName, domainConceptNames, rangeConceptNames, properties);
        this.vertex = vertex;
        this.inverseOfNames = inverseOfNames;
        this.namespace = namespace;
    }

    @Override
    public String getId() {
        return this.vertex.getId();
    }

    @Override
    public String[] getIntents() {
        return IterableUtils.toArray(SchemaProperties.INTENT.getPropertyValues(this.vertex), String.class);
    }

    @Override
    public void addIntent(String intent, User user, Authorizations authorizations) {
        Visibility visibility = SchemaRepository.VISIBILITY.getVisibility();
        Metadata metadata = this.createPropertyMetadata(user, ZonedDateTime.now(), visibility);
        SchemaProperties.INTENT.addPropertyValue(this.vertex, intent, intent, metadata, visibility, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public void removeIntent(String intent, Authorizations authorizations) {
        SchemaProperties.INTENT.removeProperty(this.vertex, intent, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public void setProperty(String name, Value value, User user, Authorizations authorizations) {
        Visibility visibility = SchemaRepository.VISIBILITY.getVisibility();
        Metadata metadata = this.createPropertyMetadata(user, ZonedDateTime.now(), visibility);
        this.getVertex().setProperty(name, value, metadata, visibility, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public void removeProperty(String name, Authorizations authorizations) {
        this.getVertex().softDeleteProperty("", name, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public String getColor() {
        return (String)SchemaProperties.COLOR.getPropertyValue(this.vertex);
    }

    @Override
    public String getTitleFormula() {
        return (String)SchemaProperties.TITLE_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public String getSubtitleFormula() {
        return (String)SchemaProperties.SUBTITLE_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public String getTimeFormula() {
        return (String)SchemaProperties.TIME_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public String getName() {
        return (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(this.vertex);
    }

    @Override
    public String getDisplayName() {
        return (String)SchemaProperties.DISPLAY_NAME.getPropertyValue(this.vertex);
    }

    @Override
    public Iterable<String> getInverseOfNames() {
        return this.inverseOfNames;
    }

    @Override
    public boolean getUserVisible() {
        return SchemaProperties.USER_VISIBLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public boolean getDeleteable() {
        return SchemaProperties.DELETEABLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public boolean getUpdateable() {
        return SchemaProperties.UPDATEABLE.getPropertyValue((Element)this.vertex, true);
    }

    @Override
    public boolean getCoreConcept() {
        return SchemaProperties.CORE_CONCEPT.getPropertyValue((Element)this.vertex, false);
    }

    @Override
    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.getSandboxStatus() == SandboxStatus.PRIVATE) {
            if (BcSchema.MODIFIED_BY.hasProperty(this.vertex)) {
                metadata.put(BcSchema.MODIFIED_BY.getPropertyName(), (String)BcSchema.MODIFIED_BY.getPropertyValue(this.vertex));
            }
            if (BcSchema.MODIFIED_DATE.hasProperty(this.vertex)) {
                metadata.put(BcSchema.MODIFIED_DATE.getPropertyName(), ((ZonedDateTime)BcSchema.MODIFIED_DATE.getPropertyValue(this.vertex)).toString());
            }
        }
        return metadata;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return SandboxStatusUtil.getSandboxStatus(this.vertex, this.namespace);
    }

    private Metadata createPropertyMetadata(User user, ZonedDateTime modifiedDate, Visibility visibility) {
        Metadata metadata = Metadata.create();
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, modifiedDate, visibility);
        if (user != null) {
            BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), visibility);
        }
        return metadata;
    }
}

