/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.collect.ImmutableList;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.LabelName;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.user.User;
import com.mware.core.util.JSONUtil;
import com.mware.core.util.SandboxStatusUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.util.CloseableUtils;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONObject;

public class GeSchemaProperty
extends SchemaProperty {
    private final Vertex vertex;
    private final String name;
    private ImmutableList<String> dependentPropertyNames;
    private String workspaceId;

    public GeSchemaProperty(Vertex vertex, ImmutableList<String> dependentPropertyNames, String workspaceId) {
        this.vertex = vertex;
        this.dependentPropertyNames = dependentPropertyNames;
        this.name = (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(vertex);
        this.workspaceId = workspaceId;
    }

    @Override
    public void setProperty(String name, Value value, User user, Authorizations authorizations) {
        Visibility visibility = SchemaRepository.VISIBILITY.getVisibility();
        Metadata metadata = Metadata.create();
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, ZonedDateTime.now(), visibility);
        if (user != null) {
            BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), visibility);
        }
        this.getVertex().setProperty(name, value, metadata, visibility, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public String getId() {
        return this.vertex.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return (String)SchemaProperties.DISPLAY_NAME.getPropertyValue(this.vertex);
    }

    @Override
    public String getPropertyGroup() {
        return (String)SchemaProperties.PROPERTY_GROUP.getPropertyValue(this.vertex);
    }

    @Override
    public String getValidationFormula() {
        return (String)SchemaProperties.VALIDATION_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public String getDisplayFormula() {
        return (String)SchemaProperties.DISPLAY_FORMULA.getPropertyValue(this.vertex);
    }

    @Override
    public ImmutableList<String> getDependentPropertyNames() {
        return this.dependentPropertyNames;
    }

    @Override
    public String[] getIntents() {
        return IterableUtils.toArray(SchemaProperties.INTENT.getPropertyValues(this.vertex), String.class);
    }

    @Override
    public String[] getTextIndexHints() {
        return IterableUtils.toArray(SchemaProperties.TEXT_INDEX_HINTS.getPropertyValues(this.vertex), String.class);
    }

    @Override
    public void addTextIndexHints(String textIndexHints, Authorizations authorizations) {
        SchemaProperties.TEXT_INDEX_HINTS.addPropertyValue(this.vertex, textIndexHints, textIndexHints, SchemaRepository.VISIBILITY.getVisibility(), authorizations);
        this.getVertex().getGraph().flush();
    }

    public void removeTextIndexHint(String textIndexHint, Authorizations authorizations) {
        SchemaProperties.TEXT_INDEX_HINTS.removeProperty(this.vertex, textIndexHint, authorizations);
        SchemaProperties.TEXT_INDEX_HINTS.removeProperty(this.vertex, "", authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public void addIntent(String intent, Authorizations authorizations) {
        SchemaProperties.INTENT.addPropertyValue(this.vertex, intent, intent, SchemaRepository.VISIBILITY.getVisibility(), authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public void removeIntent(String intent, Authorizations authorizations) {
        SchemaProperties.INTENT.removeProperty(this.vertex, intent, authorizations);
        this.getVertex().getGraph().flush();
    }

    @Override
    public boolean getUserVisible() {
        Boolean b = (Boolean)SchemaProperties.USER_VISIBLE.getPropertyValue(this.vertex);
        if (b == null) {
            return true;
        }
        return b;
    }

    @Override
    public boolean getSearchFacet() {
        Boolean b = (Boolean)SchemaProperties.SEARCH_FACET.getPropertyValue(this.vertex);
        if (b == null) {
            return false;
        }
        return b;
    }

    @Override
    public boolean getSystemProperty() {
        Boolean b = (Boolean)SchemaProperties.SYSTEM_PROPERTY.getPropertyValue(this.vertex);
        if (b == null) {
            return false;
        }
        return b;
    }

    @Override
    public String getAggType() {
        return (String)SchemaProperties.AGG_TYPE.getPropertyValue(this.vertex);
    }

    @Override
    public int getAggPrecision() {
        Integer l = (Integer)SchemaProperties.AGG_PRECISION.getPropertyValue(this.vertex);
        if (l != null) {
            return l;
        }
        return 0;
    }

    @Override
    public String getAggInterval() {
        return (String)SchemaProperties.AGG_INTERVAL.getPropertyValue(this.vertex);
    }

    @Override
    public long getAggMinDocumentCount() {
        Long l = (Long)SchemaProperties.AGG_MIN_DOCUMENT_COUNT.getPropertyValue(this.vertex);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    @Override
    public String getAggTimeZone() {
        return (String)SchemaProperties.AGG_TIMEZONE.getPropertyValue(this.vertex);
    }

    @Override
    public String getAggCalendarField() {
        return (String)SchemaProperties.AGG_CALENDAR_FIELD.getPropertyValue(this.vertex);
    }

    @Override
    public boolean getSearchable() {
        Boolean b = (Boolean)SchemaProperties.SEARCHABLE.getPropertyValue(this.vertex);
        if (b == null) {
            return true;
        }
        return b;
    }

    @Override
    public boolean getSortable() {
        Boolean b = (Boolean)SchemaProperties.SORTABLE.getPropertyValue(this.vertex);
        if (b == null) {
            return true;
        }
        return b;
    }

    @Override
    public Integer getSortPriority() {
        return (Integer)SchemaProperties.SORT_PRIORITY.getPropertyValue(this.vertex);
    }

    @Override
    public boolean getUpdateable() {
        Boolean b = (Boolean)SchemaProperties.UPDATEABLE.getPropertyValue(this.vertex);
        if (b == null) {
            return true;
        }
        return b;
    }

    @Override
    public boolean getDeleteable() {
        Boolean b = (Boolean)SchemaProperties.DELETEABLE.getPropertyValue(this.vertex);
        if (b == null) {
            return true;
        }
        return b;
    }

    @Override
    public boolean getAddable() {
        Boolean b = (Boolean)SchemaProperties.ADDABLE.getPropertyValue(this.vertex);
        if (b == null) {
            return true;
        }
        return b;
    }

    @Override
    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.getSandboxStatus() == SandboxStatus.PRIVATE) {
            if (BcSchema.MODIFIED_BY.hasProperty(this.vertex)) {
                metadata.put(BcSchema.MODIFIED_BY.getPropertyName(), (String)BcSchema.MODIFIED_BY.getPropertyValue(this.vertex));
            }
            if (BcSchema.MODIFIED_DATE.hasProperty(this.vertex)) {
                metadata.put(BcSchema.MODIFIED_DATE.getPropertyName(), ((ZonedDateTime)BcSchema.MODIFIED_DATE.getPropertyValue(this.vertex)).toString());
            }
        }
        return metadata;
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.convert((String)SchemaProperties.DATA_TYPE.getPropertyValue(this.vertex));
    }

    public static PropertyType getDataType(Vertex vertex) {
        return PropertyType.convert((String)SchemaProperties.DATA_TYPE.getPropertyValue(vertex));
    }

    @Override
    public String getDisplayType() {
        return (String)SchemaProperties.DISPLAY_TYPE.getPropertyValue(this.vertex);
    }

    @Override
    public Double getBoost() {
        return (Double)SchemaProperties.BOOST.getPropertyValue(this.vertex);
    }

    @Override
    public Map<String, String> getPossibleValues() {
        JSONObject propertyValue = (JSONObject)SchemaProperties.POSSIBLE_VALUES.getPropertyValue(this.vertex);
        if (propertyValue == null) {
            return null;
        }
        return JSONUtil.toStringMap(propertyValue);
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public void setDependentProperties(Collection<String> newDependentPropertyNames) {
        this.dependentPropertyNames = ImmutableList.copyOf(newDependentPropertyNames);
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return SandboxStatusUtil.getSandboxStatus(this.vertex, this.workspaceId);
    }

    @Override
    public List<String> getConceptNames() {
        return this.getAssociatedElements("__oc");
    }

    @Override
    public List<String> getRelationshipNames() {
        return this.getAssociatedElements("__or");
    }

    private List<String> getAssociatedElements(String elementType) {
        Iterable<Vertex> vertices = this.vertex.getVertices(Direction.BOTH, LabelName.HAS_PROPERTY.toString(), this.vertex.getAuthorizations());
        List<String> result = StreamSupport.stream(vertices.spliterator(), false).filter(v -> elementType.equals(v.getConceptType())).map(SchemaProperties.ONTOLOGY_TITLE::getPropertyValue).collect(Collectors.toList());
        CloseableUtils.closeQuietly(vertices);
        return result;
    }
}

