/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.cache.CacheService;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.ClientApiSchema;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.graph.GraphRepository;
import com.mware.core.model.graph.GraphUpdateContext;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.GeConcept;
import com.mware.core.model.schema.GeExtendedDataTableSchemaProperty;
import com.mware.core.model.schema.GeRelationship;
import com.mware.core.model.schema.GeSchemaProperty;
import com.mware.core.model.schema.LabelName;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaElement;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaRepositoryBase;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.security.BcVisibility;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.JSONUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeInfo;
import com.mware.ge.EdgeVertexPair;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Contains;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.CloseableUtils;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.Values;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

@Singleton
public class GeSchemaRepository
extends SchemaRepositoryBase {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GeSchemaRepository.class);
    public static final String ID_PREFIX = "o_";
    public static final String ID_PREFIX_PROPERTY = "o_p_";
    public static final String ID_PREFIX_RELATIONSHIP = "o_r_";
    public static final String ID_PREFIX_CONCEPT = "o_c_";
    private final Graph graph;
    private final GraphRepository graphRepository;
    private final VisibilityTranslator visibilityTranslator;
    private Authorizations publicOntologyAuthorizations;

    @Inject
    public GeSchemaRepository(Graph graph, GraphRepository graphRepository, VisibilityTranslator visibilityTranslator, Configuration config, GraphAuthorizationRepository graphAuthorizationRepository, CacheService cacheService) throws Exception {
        super(config, graph, cacheService);
        try {
            this.graph = graph;
            this.graphRepository = graphRepository;
            this.visibilityTranslator = visibilityTranslator;
            graphAuthorizationRepository.addAuthorizationToGraph("ontology");
            graphAuthorizationRepository.addAuthorizationToGraph("workspace");
            this.defineRequiredProperties(graph);
            this.publicOntologyAuthorizations = graph.createAuthorizations("ontology", "workspace");
            this.loadOntologies();
        }
        catch (Exception ex) {
            LOGGER.error("Could not initialize: %s", this.getClass().getName(), ex);
            throw ex;
        }
    }

    @Override
    public ClientApiSchema getClientApiObject(String namespace) {
        return super.getClientApiObject(namespace);
    }

    @Override
    public void clearCache() {
        LOGGER.debug("clearing ontology cache", new Object[0]);
        super.clearCache();
        this.graph.flush();
    }

    @Override
    public void clearCache(String namespace) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Workspace should not be null");
        LOGGER.debug("clearing ontology cache for workspace %s", namespace);
        super.clearCache(namespace);
        this.graph.flush();
    }

    @Override
    public Authorizations getAuthorizations() {
        if (this.authorizations != null) {
            return this.authorizations;
        }
        return this.publicOntologyAuthorizations;
    }

    @Override
    public Iterable<Relationship> getRelationships(Iterable<String> ids, String namespace) {
        Iterable<Vertex> vertices = this.graph.getVertices(ids, this.getAuthorizations(namespace, new String[0]));
        return this.transformRelationships(vertices, namespace);
    }

    @Override
    public Iterable<Relationship> getRelationships(String namespace) {
        Iterable<Vertex> vertices = this.graph.getVerticesWithPrefix(ID_PREFIX_RELATIONSHIP, this.getAuthorizations(namespace, new String[0]));
        return this.transformRelationships(vertices, namespace);
    }

    private Relationship toGeRelationship(String parentName, Vertex relationshipVertex, List<SchemaProperty> properties, Map<String, String> relatedVertexIdToNameMap, String namespace) {
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        Set<String> domainVertexIds = IterableUtils.toSet(relationshipVertex.getVertexIds(Direction.IN, LabelName.HAS_EDGE.toString(), authorizations));
        List<String> domainNames = domainVertexIds.stream().map(relatedVertexIdToNameMap::get).collect(Collectors.toList());
        Set<String> rangeVertexIds = IterableUtils.toSet(relationshipVertex.getVertexIds(Direction.OUT, LabelName.HAS_EDGE.toString(), authorizations));
        List<String> rangeNames = rangeVertexIds.stream().map(relatedVertexIdToNameMap::get).collect(Collectors.toList());
        Set<String> inverseOfVertexIds = IterableUtils.toSet(relationshipVertex.getVertexIds(Direction.OUT, LabelName.INVERSE_OF.toString(), this.getAuthorizations(namespace, new String[0])));
        List<String> inverseOfNames = inverseOfVertexIds.stream().map(relatedVertexIdToNameMap::get).collect(Collectors.toList());
        return this.createRelationship(parentName, relationshipVertex, inverseOfNames, domainNames, rangeNames, properties, namespace);
    }

    @Override
    public String getDisplayNameForLabel(String relationshipName, String namespace) {
        String displayName = null;
        if (relationshipName != null && !relationshipName.trim().isEmpty()) {
            try {
                Relationship relationship = this.getRelationshipByName(relationshipName, namespace);
                if (relationship != null) {
                    displayName = relationship.getDisplayName();
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException(String.format("Found multiple vertices for relationship label \"%s\"", relationshipName), iae);
            }
        }
        return displayName;
    }

    @Override
    public Iterable<SchemaProperty> getProperties(Iterable<String> ids, String namespace) {
        Iterable<Vertex> vertices = this.graph.getVertices(ids, this.getAuthorizations(namespace, new String[0]));
        return this.transformProperties(vertices, namespace);
    }

    @Override
    public Iterable<SchemaProperty> getProperties(String namespace) {
        Iterable<Vertex> vertices = this.graph.getVerticesWithPrefix(ID_PREFIX_PROPERTY, this.getAuthorizations(namespace, new String[0]));
        return this.transformProperties(vertices, namespace);
    }

    protected ImmutableList<String> getDependentPropertyNames(Vertex vertex, String namespace) {
        ArrayList dependentProperties = Lists.newArrayList(vertex.getEdges(Direction.OUT, LabelName.HAS_DEPENDENT_PROPERTY.toString(), this.getAuthorizations(namespace, new String[0])));
        dependentProperties.sort((e1, e2) -> {
            Integer o1 = SchemaProperties.DEPENDENT_PROPERTY_ORDER_PROPERTY_NAME.getPropertyValue((Element)e1, Integer.valueOf(0));
            Integer o2 = SchemaProperties.DEPENDENT_PROPERTY_ORDER_PROPERTY_NAME.getPropertyValue((Element)e2, Integer.valueOf(0));
            return Integer.compare(o1, o2);
        });
        return ImmutableList.copyOf((Collection)dependentProperties.stream().map(e -> {
            String propertyId = e.getOtherVertexId((String)vertex.getId());
            Vertex v = this.graph.getVertex(propertyId, this.getAuthorizations(namespace, new String[0]));
            return (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(v);
        }).collect(Collectors.toList()));
    }

    @Override
    public Iterable<Concept> getConceptsWithProperties(String namespace) {
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        return this.transformConcepts(this.graph.getVerticesWithPrefix(ID_PREFIX_CONCEPT, authorizations), namespace);
    }

    @Override
    public Concept getRootConcept(String namespace) {
        return this.getConceptByName("__root", namespace);
    }

    @Override
    public Concept getThingConcept(String namespace) {
        return this.getConceptByName("thing", namespace);
    }

    @Override
    public List<Concept> getChildConcepts(Concept concept, String namespace) {
        Vertex conceptVertex = ((GeConcept)concept).getVertex();
        return this.toConcepts(conceptVertex.getVertices(Direction.IN, LabelName.IS_A.toString(), FetchHints.ALL_INCLUDING_HIDDEN, this.getAuthorizations(namespace, new String[0])), namespace);
    }

    @Override
    protected List<Relationship> getChildRelationships(Relationship relationship, String namespace) {
        Vertex relationshipVertex = ((GeRelationship)relationship).getVertex();
        return this.transformRelationships(relationshipVertex.getVertices(Direction.IN, LabelName.IS_A.toString(), this.getAuthorizations(namespace, new String[0])), namespace);
    }

    @Override
    public Relationship getParentRelationship(Relationship relationship, String namespace) {
        Vertex parentVertex = this.getParentVertex(((GeRelationship)relationship).getVertex(), namespace);
        if (parentVertex == null) {
            return null;
        }
        String parentName = (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(parentVertex);
        return this.getRelationshipByName(parentName, namespace);
    }

    @Override
    public Concept getParentConcept(Concept concept, String namespace) {
        Vertex parentConceptVertex = this.getParentVertex(((GeConcept)concept).getVertex(), namespace);
        if (parentConceptVertex == null) {
            return null;
        }
        String parentName = (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(parentConceptVertex);
        return this.getConceptByName(parentName, namespace);
    }

    private List<Concept> toConcepts(Iterable<Vertex> vertices, String namespace) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (Vertex vertex : vertices) {
            concepts.add(this.createConcept(vertex, namespace));
        }
        return concepts;
    }

    private List<SchemaProperty> getPropertiesByVertexNoRecursion(Vertex vertex, final String namespace) {
        return Lists.newArrayList((Iterable)new ConvertingIterable<Vertex, SchemaProperty>(vertex.getVertices(Direction.OUT, LabelName.HAS_PROPERTY.toString(), FetchHints.ALL_INCLUDING_HIDDEN, this.getAuthorizations(namespace, new String[0]))){

            @Override
            protected SchemaProperty convert(Vertex o) {
                return GeSchemaRepository.this.createOntologyProperty(o, GeSchemaRepository.this.getDependentPropertyNames(o, namespace), GeSchemaProperty.getDataType(o), namespace);
            }
        });
    }

    @Override
    public Iterable<Concept> getConcepts(Iterable<String> ids, String namespace) {
        return this.transformConcepts(this.graph.getVertices(ids, FetchHints.ALL, this.getAuthorizations(namespace, new String[0])), namespace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Concept> getConceptsByName(List<String> conceptNames, String namespace) {
        try (QueryResultsIterable<Vertex> vertices = this.getGraph().query(this.getAuthorizations(namespace, new String[0])).hasConceptType("__oc").has(SchemaProperties.ONTOLOGY_TITLE.getPropertyName(), (Predicate)Contains.IN, Values.stringArray(conceptNames.toArray(new String[0]))).vertices();){
            List<Concept> list = this.transformConcepts(vertices, namespace);
            return list;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasConceptByName(String conceptName, String namespace) {
        try (QueryResultsIterable<String> results = this.getGraph().query(this.getAuthorizations(namespace, new String[0])).hasConceptType("__oc").has(SchemaProperties.ONTOLOGY_TITLE.getPropertyName(), (Predicate)Compare.EQUAL, Values.stringValue(conceptName)).vertexIds();){
            boolean bl = results.getTotalHits() == 1L;
            return bl;
        }
        catch (IOException e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<SchemaProperty> getPropertiesByName(List<String> propertyNames, String namespace) {
        try (QueryResultsIterable<Vertex> vertices = this.getGraph().query(this.getAuthorizations(namespace, new String[0])).hasConceptType("__op").has(SchemaProperties.ONTOLOGY_TITLE.getPropertyName(), (Predicate)Contains.IN, Values.stringArray(propertyNames.toArray(new String[0]))).vertices();){
            List<SchemaProperty> list = this.transformProperties(vertices, namespace);
            return list;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Relationship> getRelationshipsByName(List<String> relationshipNames, String namespace) {
        try (QueryResultsIterable<Vertex> vertices = this.getGraph().query(this.getAuthorizations(namespace, new String[0])).hasConceptType("__or").has(SchemaProperties.ONTOLOGY_TITLE.getPropertyName(), (Predicate)Contains.IN, Values.stringArray(relationshipNames.toArray(new String[0]))).vertices();){
            List<Relationship> list = this.transformRelationships(vertices, namespace);
            return list;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SchemaProperty> getPropertiesByIntent(String intent, String namespace) {
        try (QueryResultsIterable<Vertex> vertices = this.getGraph().query(this.getAuthorizations(namespace, new String[0])).hasConceptType("__op").has(SchemaProperties.INTENT.getPropertyName(), Values.stringValue(intent)).vertices();){
            List<SchemaProperty> list = this.transformProperties(vertices, namespace);
            return list;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    private void internalDeleteObject(Vertex vertex, String namespace) {
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        Iterable<EdgeInfo> edges = vertex.getEdgeInfos(Direction.BOTH, authorizations);
        for (EdgeInfo edge : edges) {
            this.graph.deleteEdge(edge.getEdgeId(), authorizations);
        }
        this.graph.deleteVertex((String)vertex.getId(), authorizations);
    }

    @Override
    protected void internalDeleteConcept(Concept concept, String namespace) {
        Vertex vertex = ((GeConcept)concept).getVertex();
        this.internalDeleteObject(vertex, namespace);
    }

    @Override
    protected void internalDeleteProperty(SchemaProperty property, String namespace) {
        Vertex vertex = ((GeSchemaProperty)property).getVertex();
        this.internalDeleteObject(vertex, namespace);
        this.graph.removePropertyDefinition(property.getName());
    }

    @Override
    protected void internalDeleteRelationship(Relationship relationship, String namespace) {
        Vertex vertex = ((GeRelationship)relationship).getVertex();
        this.internalDeleteObject(vertex, namespace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Concept internalGetOrCreateConcept(Concept parent, String conceptName, String displayName, String glyphIconHref, String color, boolean deleteChangeableProperties, boolean isCoreConcept, User user, String namespace) {
        Concept concept = this.getConceptByName(conceptName, namespace);
        if (concept != null) {
            if (!deleteChangeableProperties) return concept;
            this.deleteChangeableProperties(concept, this.getAuthorizations(namespace, new String[0]));
            return concept;
        }
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(this.getPriority(user), user, this.getAuthorizations(namespace, new String[0]));){
            ctx.setPushOnQueue(false);
            Visibility visibility = VISIBILITY.getVisibility();
            VisibilityJson visibilityJson = new VisibilityJson(visibility.getVisibilityString());
            VertexBuilder builder = this.prepareVertex(ID_PREFIX_CONCEPT, conceptName, namespace, visibility, visibilityJson, "__oc");
            ZonedDateTime modifiedDate = ZonedDateTime.now();
            Vertex vertex = (Vertex)ctx.update(builder, modifiedDate, visibilityJson, elemCtx -> {
                Metadata metadata = this.getMetadata(modifiedDate, user, visibility);
                SchemaProperties.ONTOLOGY_TITLE.updateProperty(elemCtx, conceptName, metadata, visibility);
                SchemaProperties.DISPLAY_NAME.updateProperty(elemCtx, displayName, metadata, visibility);
                SchemaProperties.CORE_CONCEPT.updateProperty(elemCtx, Boolean.valueOf(isCoreConcept), VISIBILITY.getVisibility());
                if (conceptName.equals("thing")) {
                    SchemaProperties.TITLE_FORMULA.updateProperty(elemCtx, "prop('title') || ('Untitled ' + ontology && ontology.displayName) ", metadata, visibility);
                    SchemaProperties.SUBTITLE_FORMULA.updateProperty(elemCtx, "(ontology && ontology.displayName) || prop('source') || ''", metadata, visibility);
                    SchemaProperties.TIME_FORMULA.updateProperty(elemCtx, "prop('modifiedDate') || ''", metadata, visibility);
                }
                if (!StringUtils.isEmpty((String)glyphIconHref)) {
                    SchemaProperties.GLYPH_ICON_FILE_NAME.updateProperty(elemCtx, glyphIconHref, metadata, visibility);
                }
                if (!StringUtils.isEmpty((String)color)) {
                    SchemaProperties.COLOR.updateProperty(elemCtx, color, metadata, visibility);
                }
            }).get();
            if (parent == null) {
                concept = this.createConcept(vertex, namespace);
            } else {
                concept = this.createConcept(vertex, null, parent.getName(), namespace);
                this.findOrAddEdge(ctx, ((GeConcept)concept).getVertex(), ((GeConcept)parent).getVertex(), LabelName.IS_A.toString());
            }
            if (!this.isPublic(namespace)) {
                this.findOrAddEdge(ctx, namespace, (String)((GeConcept)concept).getVertex().getId(), "__wsToSchema");
            }
            Concept concept2 = concept;
            return concept2;
        }
        catch (Exception e) {
            throw new BcException("Could not create concept: " + conceptName, e);
        }
    }

    private Metadata getMetadata(ZonedDateTime modifiedDate, User user, Visibility visibility) {
        Metadata metadata = Metadata.create();
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, modifiedDate, visibility);
        if (user != null) {
            BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), visibility);
        }
        return metadata;
    }

    private VertexBuilder prepareVertex(String prefix, String name, String namespace, Visibility visibility, VisibilityJson visibilityJson, String conceptType) {
        if (this.isPublic(namespace)) {
            return this.graph.prepareVertex(prefix + Hashing.sha256().hashString((CharSequence)name, Charsets.UTF_8), visibility, conceptType);
        }
        String id = prefix + Hashing.sha256().hashString((CharSequence)(namespace + name), Charsets.UTF_8).toString();
        visibilityJson.addWorkspace(namespace);
        return this.graph.prepareVertex(id, this.visibilityTranslator.toVisibility(visibilityJson).getVisibility(), conceptType);
    }

    protected void findOrAddEdge(Vertex fromVertex, Vertex toVertex, String edgeLabel, User user, String namespace) {
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, user, this.getAuthorizations(namespace, new String[0]));){
            ctx.setPushOnQueue(false);
            this.findOrAddEdge(ctx, fromVertex, toVertex, edgeLabel);
        }
        catch (Exception e) {
            throw new BcException("Could not findOrAddEdge", e);
        }
    }

    protected void removeEdge(GraphUpdateContext ctx, String fromVertexId, String toVertexId) {
        String edgeId = fromVertexId + "-" + toVertexId;
        ctx.getGraph().deleteEdge(edgeId, ctx.getAuthorizations());
    }

    protected void findOrAddEdge(GraphUpdateContext ctx, String fromVertexId, String toVertexId, String edgeLabel) {
        String edgeId = fromVertexId + "-" + toVertexId;
        ctx.getOrCreateEdgeAndUpdate(edgeId, fromVertexId, toVertexId, edgeLabel, VISIBILITY.getVisibility(), elemCtx -> {
            if (elemCtx.isNewElement()) {
                VisibilityJson visibilityJson = new VisibilityJson(VISIBILITY.getVisibility().getVisibilityString());
                elemCtx.updateBuiltInProperties(ZonedDateTime.now(), visibilityJson);
            }
        });
    }

    protected void findOrAddEdge(GraphUpdateContext ctx, Vertex fromVertex, Vertex toVertex, String edgeLabel) {
        this.findOrAddEdge(ctx, (String)fromVertex.getId(), (String)toVertex.getId(), edgeLabel);
    }

    @Override
    public void addDomainConceptsToRelationshipType(String relationshipName, List<String> conceptNames, User user, String namespace) {
        this.checkPrivileges(user, namespace);
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, user, this.getAuthorizations(namespace, new String[0]));){
            ctx.setPushOnQueue(false);
            GeRelationship relationship = (GeRelationship)this.getRelationshipByName(relationshipName, namespace);
            Vertex relationshipVertex = relationship.getVertex();
            if (!this.isPublic(namespace) && relationship.getSandboxStatus() != SandboxStatus.PRIVATE) {
                throw new UnsupportedOperationException("Sandboxed updating of domain names is not currently supported for published relationships");
            }
            Iterable<Concept> concepts = this.getConceptsByName(conceptNames, namespace);
            for (Concept concept : concepts) {
                Preconditions.checkNotNull((Object)concept, (Object)"concepts cannot have null values");
                this.findOrAddEdge(ctx, ((GeConcept)concept).getVertex(), relationshipVertex, LabelName.HAS_EDGE.toString());
            }
        }
    }

    @Override
    public void addRangeConceptsToRelationshipType(String relationshipName, List<String> conceptNames, User user, String namespace) {
        this.checkPrivileges(user, namespace);
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, user, this.getAuthorizations(namespace, new String[0]));){
            ctx.setPushOnQueue(false);
            GeRelationship relationship = (GeRelationship)this.getRelationshipByName(relationshipName, namespace);
            Vertex relationshipVertex = relationship.getVertex();
            if (!this.isPublic(namespace) && relationship.getSandboxStatus() != SandboxStatus.PRIVATE) {
                throw new UnsupportedOperationException("Sandboxed updating of range names is not currently supported for published relationships");
            }
            Iterable<Concept> concepts = this.getConceptsByName(conceptNames, namespace);
            for (Concept concept : concepts) {
                Preconditions.checkNotNull((Object)concept, (Object)"concepts cannot have null values");
                this.findOrAddEdge(ctx, relationshipVertex, ((GeConcept)concept).getVertex(), LabelName.HAS_EDGE.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SchemaProperty addPropertyTo(List<Concept> concepts, List<Relationship> relationships, List<String> extendedDataTableNames, String propertyName, String displayName, PropertyType dataType, Map<String, String> possibleValues, Collection<TextIndexHint> textIndexHints, boolean userVisible, boolean searchFacet, boolean systemProperty, String aggType, int aggPrecision, String aggInterval, long aggMinDocumentCount, String aggTimeZone, String aggCalendarField, boolean searchable, boolean addable, boolean sortable, Integer sortPriority, String displayType, String propertyGroup, Double boost, String validationFormula, String displayFormula, ImmutableList<String> dependentPropertyNames, String[] intents, boolean deleteable, boolean updateable, User user, String namespace) {
        if (CollectionUtils.isEmpty(extendedDataTableNames) && CollectionUtils.isEmpty(concepts) && CollectionUtils.isEmpty(relationships)) {
            throw new BcException("Must specify concepts or relationships to add property");
        }
        Vertex vertex = this.getOrCreatePropertyVertex(propertyName, dataType, textIndexHints, sortable, boost, possibleValues, concepts, relationships, extendedDataTableNames, user, namespace);
        Preconditions.checkNotNull((Object)vertex, (Object)("Could not find property: " + propertyName));
        boolean finalSearchable = this.determineSearchable(propertyName, dataType, textIndexHints, searchable);
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, this.getSystemUser(), this.getAuthorizations(namespace, new String[0]));){
            ctx.setPushOnQueue(false);
            ZonedDateTime modifiedDate = ZonedDateTime.now();
            Visibility visibility = VISIBILITY.getVisibility();
            Metadata metadata = this.getMetadata(modifiedDate, user, visibility);
            vertex = (Vertex)ctx.update(vertex.prepareMutation(), elemCtx -> {
                SchemaProperties.SEARCHABLE.updateProperty(elemCtx, Boolean.valueOf(finalSearchable), metadata, visibility);
                SchemaProperties.SORTABLE.updateProperty(elemCtx, Boolean.valueOf(sortable), metadata, visibility);
                SchemaProperties.ADDABLE.updateProperty(elemCtx, Boolean.valueOf(addable), metadata, visibility);
                SchemaProperties.DELETEABLE.updateProperty(elemCtx, Boolean.valueOf(deleteable), metadata, visibility);
                SchemaProperties.UPDATEABLE.updateProperty(elemCtx, Boolean.valueOf(updateable), metadata, visibility);
                SchemaProperties.USER_VISIBLE.updateProperty(elemCtx, Boolean.valueOf(userVisible), metadata, visibility);
                SchemaProperties.SEARCH_FACET.updateProperty(elemCtx, Boolean.valueOf(searchFacet), visibility);
                SchemaProperties.SYSTEM_PROPERTY.updateProperty(elemCtx, Boolean.valueOf(systemProperty), visibility);
                if (sortPriority != null) {
                    SchemaProperties.SORT_PRIORITY.updateProperty(elemCtx, sortPriority, metadata, visibility);
                }
                if (aggType != null) {
                    SchemaProperties.AGG_TYPE.updateProperty(elemCtx, aggType, metadata, visibility);
                }
                if (aggInterval != null) {
                    SchemaProperties.AGG_INTERVAL.updateProperty(elemCtx, aggInterval, metadata, visibility);
                }
                SchemaProperties.AGG_MIN_DOCUMENT_COUNT.updateProperty(elemCtx, Long.valueOf(aggMinDocumentCount), metadata, visibility);
                if (aggTimeZone != null) {
                    SchemaProperties.AGG_TIMEZONE.updateProperty(elemCtx, aggTimeZone, metadata, visibility);
                }
                if (aggCalendarField != null) {
                    SchemaProperties.AGG_CALENDAR_FIELD.updateProperty(elemCtx, aggCalendarField, metadata, visibility);
                }
                if (boost != null) {
                    SchemaProperties.BOOST.updateProperty(elemCtx, boost, metadata, visibility);
                }
                if (displayName != null && !displayName.trim().isEmpty()) {
                    SchemaProperties.DISPLAY_NAME.updateProperty(elemCtx, displayName.trim(), metadata, visibility);
                }
                if (displayType != null && !displayType.trim().isEmpty()) {
                    SchemaProperties.DISPLAY_TYPE.updateProperty(elemCtx, displayType, metadata, visibility);
                }
                if (propertyGroup != null && !propertyGroup.trim().isEmpty()) {
                    SchemaProperties.PROPERTY_GROUP.updateProperty(elemCtx, propertyGroup, metadata, visibility);
                }
                if (validationFormula != null && !validationFormula.trim().isEmpty()) {
                    SchemaProperties.VALIDATION_FORMULA.updateProperty(elemCtx, validationFormula, metadata, visibility);
                }
                if (displayFormula != null && !displayFormula.trim().isEmpty()) {
                    SchemaProperties.DISPLAY_FORMULA.updateProperty(elemCtx, displayFormula, metadata, visibility);
                }
                if (possibleValues != null) {
                    SchemaProperties.POSSIBLE_VALUES.updateProperty(elemCtx, JSONUtil.toJson(possibleValues), metadata, visibility);
                }
                if (intents != null) {
                    for (String intent : intents) {
                        SchemaProperties.INTENT.updateProperty(elemCtx, intent, intent, metadata, visibility);
                    }
                }
            }).get();
            if (dependentPropertyNames != null) {
                this.saveDependentProperties(propertyName, vertex, (Collection<String>)dependentPropertyNames, user, namespace);
            }
            SchemaProperty schemaProperty = this.createOntologyProperty(vertex, dependentPropertyNames, dataType, namespace);
            return schemaProperty;
        }
        catch (Exception e) {
            throw new BcException("Could not create property: " + propertyName, e);
        }
    }

    @Override
    public void getOrCreateInverseOfRelationship(Relationship fromRelationship, Relationship inverseOfRelationship) {
        Preconditions.checkNotNull((Object)fromRelationship, (Object)"fromRelationship is required");
        Preconditions.checkNotNull((Object)fromRelationship, (Object)"inverseOfRelationship is required");
        GeRelationship fromRelationshipSg = (GeRelationship)fromRelationship;
        GeRelationship inverseOfRelationshipSg = (GeRelationship)inverseOfRelationship;
        Vertex fromVertex = fromRelationshipSg.getVertex();
        Preconditions.checkNotNull((Object)fromVertex, (Object)"fromVertex is required");
        Vertex inverseVertex = inverseOfRelationshipSg.getVertex();
        Preconditions.checkNotNull((Object)inverseVertex, (Object)"inverseVertex is required");
        User user = this.getSystemUser();
        this.findOrAddEdge(fromVertex, inverseVertex, LabelName.INVERSE_OF.toString(), user, null);
        this.findOrAddEdge(inverseVertex, fromVertex, LabelName.INVERSE_OF.toString(), user, null);
    }

    @Override
    public void removeInverseOfRelationship(Relationship fromRelationship, Relationship inverseOfRelationship) {
        Preconditions.checkNotNull((Object)fromRelationship, (Object)"fromRelationship is required");
        Preconditions.checkNotNull((Object)fromRelationship, (Object)"inverseOfRelationship is required");
        GeRelationship fromRelationshipSg = (GeRelationship)fromRelationship;
        GeRelationship inverseOfRelationshipSg = (GeRelationship)inverseOfRelationship;
        Vertex fromVertex = fromRelationshipSg.getVertex();
        Preconditions.checkNotNull((Object)fromVertex, (Object)"fromVertex is required");
        Vertex inverseVertex = inverseOfRelationshipSg.getVertex();
        Preconditions.checkNotNull((Object)inverseVertex, (Object)"inverseVertex is required");
        Iterable<String> edgeIds1 = fromVertex.getEdgeIds(inverseVertex, Direction.OUT, LabelName.INVERSE_OF.toString(), this.authorizations);
        Iterable<String> edgeIds2 = inverseVertex.getEdgeIds(fromVertex, Direction.OUT, LabelName.INVERSE_OF.toString(), this.authorizations);
        User user = this.getSystemUser();
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.NORMAL, user, this.getAuthorizations("public-ontology", new String[0]));){
            edgeIds1.forEach(eid -> ctx.getGraph().deleteEdge((String)eid, ctx.getAuthorizations()));
            edgeIds2.forEach(eid -> ctx.getGraph().deleteEdge((String)eid, ctx.getAuthorizations()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Relationship internalGetOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipName, String displayName, boolean isDeclaredInOntology, boolean coreConcept, User user, String namespace) {
        Relationship relationship = this.getRelationshipByName(relationshipName, namespace);
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(this.getPriority(user), user, this.getAuthorizations(namespace, new String[0]));){
            ctx.setPushOnQueue(false);
            if (relationship != null) {
                if (isDeclaredInOntology) {
                    this.deleteChangeableProperties(relationship, this.getAuthorizations(namespace, new String[0]));
                }
                Vertex relationshipVertex = ((GeRelationship)relationship).getVertex();
                for (Concept domainConcept : domainConcepts) {
                    if (relationship.getSourceConceptNames().contains(domainConcept.getName())) continue;
                    this.findOrAddEdge(ctx, ((GeConcept)domainConcept).getVertex(), relationshipVertex, LabelName.HAS_EDGE.toString());
                }
                Object object = rangeConcepts.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = relationship;
                        return object;
                    }
                    Concept rangeConcept = object.next();
                    if (relationship.getTargetConceptNames().contains(rangeConcept.getName())) continue;
                    this.findOrAddEdge(ctx, relationshipVertex, ((GeConcept)rangeConcept).getVertex(), LabelName.HAS_EDGE.toString());
                }
            }
            Visibility visibility = VISIBILITY.getVisibility();
            VisibilityJson visibilityJson = new VisibilityJson(visibility.getVisibilityString());
            VertexBuilder builder = this.prepareVertex(ID_PREFIX_RELATIONSHIP, relationshipName, namespace, visibility, visibilityJson, "__or");
            ZonedDateTime modifiedDate = ZonedDateTime.now();
            Vertex relationshipVertex = (Vertex)ctx.update(builder, modifiedDate, visibilityJson, elemCtx -> {
                Metadata metadata = this.getMetadata(modifiedDate, user, visibility);
                SchemaProperties.ONTOLOGY_TITLE.updateProperty(elemCtx, relationshipName, metadata, visibility);
                if (displayName != null) {
                    SchemaProperties.DISPLAY_NAME.updateProperty(elemCtx, displayName, metadata, visibility);
                }
                SchemaProperties.CORE_CONCEPT.updateProperty(elemCtx, Boolean.valueOf(coreConcept), metadata, visibility);
            }).get();
            this.validateRelationship(relationshipName, domainConcepts, rangeConcepts);
            for (Concept domainConcept : domainConcepts) {
                this.findOrAddEdge(ctx, ((GeConcept)domainConcept).getVertex(), relationshipVertex, LabelName.HAS_EDGE.toString());
            }
            for (Concept rangeConcept : rangeConcepts) {
                this.findOrAddEdge(ctx, relationshipVertex, ((GeConcept)rangeConcept).getVertex(), LabelName.HAS_EDGE.toString());
            }
            if (parent != null) {
                this.findOrAddEdge(ctx, relationshipVertex, ((GeRelationship)parent).getVertex(), LabelName.IS_A.toString());
            }
            ArrayList<String> inverseOfNames = new ArrayList<String>();
            ArrayList domainConceptNames = Lists.newArrayList((Iterable)new ConvertingIterable<Concept, String>(domainConcepts){

                @Override
                protected String convert(Concept o) {
                    return o.getName();
                }
            });
            ArrayList rangeConceptNames = Lists.newArrayList((Iterable)new ConvertingIterable<Concept, String>(rangeConcepts){

                @Override
                protected String convert(Concept o) {
                    return o.getName();
                }
            });
            if (!this.isPublic(namespace)) {
                this.findOrAddEdge(ctx, namespace, (String)relationshipVertex.getId(), "__wsToSchema");
            }
            ArrayList<SchemaProperty> properties = new ArrayList<SchemaProperty>();
            String parentName = parent == null ? null : parent.getName();
            Relationship relationship2 = this.createRelationship(parentName, relationshipVertex, inverseOfNames, domainConceptNames, rangeConceptNames, properties, namespace);
            return relationship2;
        }
        catch (Exception ex) {
            throw new BcException("Could not create relationship: " + relationshipName, ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vertex getOrCreatePropertyVertex(String propertyName, PropertyType dataType, Collection<TextIndexHint> textIndexHints, boolean sortable, Double boost, Map<String, String> possibleValues, List<Concept> concepts, List<Relationship> relationships, List<String> extendedDataTableNames, User user, String namespace) {
        Vertex propertyVertex;
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        SchemaProperty typeProperty = this.getPropertyByName(propertyName, namespace);
        if (typeProperty == null) {
            this.definePropertyOnGraph(this.graph, propertyName, PropertyType.getTypeClass(dataType), textIndexHints, boost, sortable);
            try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(this.getPriority(user), user, authorizations);){
                ctx.setPushOnQueue(false);
                Visibility visibility = VISIBILITY.getVisibility();
                VisibilityJson visibilityJson = new VisibilityJson(visibility.getVisibilityString());
                VertexBuilder builder = this.prepareVertex(ID_PREFIX_PROPERTY, propertyName, namespace, visibility, visibilityJson, "__op");
                ZonedDateTime modifiedDate = ZonedDateTime.now();
                propertyVertex = (Vertex)ctx.update(builder, modifiedDate, visibilityJson, elemCtx -> {
                    Metadata metadata = this.getMetadata(modifiedDate, user, visibility);
                    SchemaProperties.ONTOLOGY_TITLE.updateProperty(elemCtx, propertyName, metadata, visibility);
                    SchemaProperties.DATA_TYPE.updateProperty(elemCtx, dataType.toString(), metadata, visibility);
                    if (possibleValues != null) {
                        SchemaProperties.POSSIBLE_VALUES.updateProperty(elemCtx, JSONUtil.toJson(possibleValues), metadata, visibility);
                    }
                    if (textIndexHints != null && textIndexHints.size() > 0) {
                        textIndexHints.forEach(i -> {
                            String textIndexHint = i.toString();
                            SchemaProperties.TEXT_INDEX_HINTS.updateProperty(elemCtx, textIndexHint, textIndexHint, metadata, visibility);
                        });
                    }
                }).get();
                for (Concept concept : concepts) {
                    Preconditions.checkNotNull((Object)concept, (Object)"concepts cannot have null values");
                    this.findOrAddEdge(ctx, ((GeConcept)concept).getVertex(), propertyVertex, LabelName.HAS_PROPERTY.toString());
                }
                for (Relationship relationship : relationships) {
                    Preconditions.checkNotNull((Object)relationship, (Object)"relationships cannot have null values");
                    this.findOrAddEdge(ctx, ((GeRelationship)relationship).getVertex(), propertyVertex, LabelName.HAS_PROPERTY.toString());
                }
                if (extendedDataTableNames != null) {
                    for (String extendedDataTableName : extendedDataTableNames) {
                        Preconditions.checkNotNull((Object)extendedDataTableName, (Object)"extendedDataTableNames cannot have null values");
                        SchemaProperty tableProperty = this.getPropertyByName(extendedDataTableName, namespace);
                        Preconditions.checkNotNull((Object)tableProperty, (Object)("Could not find extended data property: " + extendedDataTableName));
                        if (!(tableProperty instanceof GeExtendedDataTableSchemaProperty)) {
                            throw new BcException("Found property " + extendedDataTableName + " but was expecting an extended data table property, check that the range is set to extended data property");
                        }
                        GeExtendedDataTableSchemaProperty extendedDataTableProperty = (GeExtendedDataTableSchemaProperty)tableProperty;
                        Vertex extendedDataTableVertex = extendedDataTableProperty.getVertex();
                        this.findOrAddEdge(ctx, extendedDataTableVertex, propertyVertex, LabelName.HAS_PROPERTY.toString());
                        extendedDataTableProperty.addProperty(propertyName);
                    }
                }
                if (this.isPublic(namespace)) return propertyVertex;
                this.findOrAddEdge(ctx, namespace, (String)propertyVertex.getId(), "__wsToSchema");
                return propertyVertex;
            }
            catch (Exception e) {
                throw new BcException("Could not getOrCreatePropertyVertex: " + propertyName, e);
            }
        } else {
            propertyVertex = ((GeSchemaProperty)typeProperty).getVertex();
            this.deleteChangeableProperties(typeProperty, authorizations);
        }
        return propertyVertex;
    }

    private Priority getPriority(User user) {
        return user == null ? Priority.LOW : Priority.NORMAL;
    }

    private void saveDependentProperties(String propertyName, Vertex propertyVertex, Collection<String> dependentPropertyNames, User user, String namespace) {
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        Iterable<Edge> existingDependentProperties = propertyVertex.getEdges(Direction.OUT, LabelName.HAS_DEPENDENT_PROPERTY.toString(), authorizations);
        existingDependentProperties.forEach(e -> this.graph.deleteEdge((Edge)e, authorizations));
        this.graph.flush();
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(this.getPriority(user), user, authorizations);){
            ctx.setPushOnQueue(false);
            Visibility visibility = VISIBILITY.getVisibility();
            VisibilityJson visibilityJson = new VisibilityJson(visibility.getVisibilityString());
            ZonedDateTime modifiedDate = ZonedDateTime.now();
            Metadata metadata = this.getMetadata(modifiedDate, user, visibility);
            AtomicInteger indexCounter = new AtomicInteger();
            for (String dependentPropertyName : dependentPropertyNames) {
                Vertex dependentPropVertex = this.getPropertyVertex(dependentPropertyName, authorizations);
                if (dependentPropVertex == null) {
                    throw new GeException("Could not add dependent property: " + dependentPropertyName + " to property: " + propertyName + " because the dependent property was not found.");
                }
                int i = indexCounter.getAndIncrement();
                EdgeBuilder edgeBuilder = this.graph.prepareEdge(propertyVertex, dependentPropVertex, LabelName.HAS_DEPENDENT_PROPERTY.toString(), visibility);
                ctx.update(edgeBuilder, edgeCtx -> {
                    edgeCtx.updateBuiltInProperties(modifiedDate, visibilityJson);
                    SchemaProperties.DEPENDENT_PROPERTY_ORDER_PROPERTY_NAME.updateProperty(edgeCtx, Integer.valueOf(i), metadata, visibility);
                });
            }
        }
    }

    private Vertex getPropertyVertex(String propertyName, Authorizations authorizations) {
        return this.graph.getVertex(ID_PREFIX_PROPERTY + Hashing.sha256().hashString((CharSequence)propertyName, Charsets.UTF_8), authorizations);
    }

    @Override
    public void updatePropertyDependentNames(SchemaProperty property, Collection<String> dependentPropertyNames, User user, String namespace) {
        GeSchemaProperty geOntologyProperty = (GeSchemaProperty)property;
        if (!this.isPublic(namespace) || property.getSandboxStatus() == SandboxStatus.PRIVATE) {
            throw new UnsupportedOperationException("Sandboxed updating of dependent names is not currently supported for properties");
        }
        this.saveDependentProperties(property.getName(), geOntologyProperty.getVertex(), dependentPropertyNames, user, namespace);
        this.graph.flush();
        geOntologyProperty.setDependentProperties(dependentPropertyNames);
    }

    @Override
    public void updatePropertyDomainNames(SchemaProperty property, Set<String> domainNames, User user, String namespace) {
        GeSchemaProperty geProperty = (GeSchemaProperty)property;
        if (!this.isPublic(namespace) && property.getSandboxStatus() != SandboxStatus.PRIVATE) {
            throw new UnsupportedOperationException("Sandboxed updating of domain names is not currently supported for published properties");
        }
        Iterable<EdgeVertexPair> existingConcepts = geProperty.getVertex().getEdgeVertexPairs(Direction.BOTH, LabelName.HAS_PROPERTY.toString(), this.getAuthorizations(namespace, new String[0]));
        for (EdgeVertexPair existingConcept : existingConcepts) {
            String conceptName = (String)SchemaProperties.ONTOLOGY_TITLE.getPropertyValue(existingConcept.getVertex());
            if (domainNames.remove(conceptName)) continue;
            this.getGraph().softDeleteEdge(existingConcept.getEdge(), this.getAuthorizations(namespace, new String[0]));
        }
        for (String domainName : domainNames) {
            Vertex domainVertex;
            Concept concept = this.getConceptByName(domainName, namespace);
            if (concept != null) {
                domainVertex = ((GeConcept)concept).getVertex();
            } else {
                Relationship relationship = this.getRelationshipByName(domainName, namespace);
                if (relationship != null) {
                    domainVertex = ((GeRelationship)relationship).getVertex();
                } else {
                    throw new BcException("Could not find domain with name " + domainName);
                }
            }
            this.findOrAddEdge(domainVertex, ((GeSchemaProperty)property).getVertex(), LabelName.HAS_PROPERTY.toString(), user, namespace);
        }
    }

    private Vertex getParentVertex(Vertex vertex, String namespace) {
        try {
            return (Vertex)Iterables.getOnlyElement(vertex.getVertices(Direction.OUT, LabelName.IS_A.toString(), this.getAuthorizations(namespace, new String[0])), null);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException(String.format("Unexpected number of parents for concept %s", SchemaProperties.TITLE.getPropertyValue(vertex)), iae);
        }
    }

    public Authorizations getAuthorizations(String namespace, String ... otherAuthorizations) {
        if (this.isPublic(namespace) && (otherAuthorizations == null || otherAuthorizations.length == 0)) {
            return this.publicOntologyAuthorizations;
        }
        if (this.isPublic(namespace)) {
            return this.graph.createAuthorizations(this.publicOntologyAuthorizations, otherAuthorizations);
        }
        if (otherAuthorizations == null || otherAuthorizations.length == 0) {
            return this.graph.createAuthorizations(this.publicOntologyAuthorizations, namespace);
        }
        return this.graph.createAuthorizations(this.publicOntologyAuthorizations, (String[])ArrayUtils.add((Object[])otherAuthorizations, (Object)namespace));
    }

    @Override
    protected Graph getGraph() {
        return this.graph;
    }

    protected SchemaProperty createOntologyProperty(Vertex propertyVertex, ImmutableList<String> dependentPropertyNames, PropertyType propertyType, String namespace) {
        if (propertyType.equals((Object)PropertyType.EXTENDED_DATA_TABLE)) {
            Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
            GeExtendedDataTableSchemaProperty result = new GeExtendedDataTableSchemaProperty(propertyVertex, dependentPropertyNames, namespace);
            Iterable<String> tablePropertyNames = propertyVertex.getVertexIds(Direction.OUT, LabelName.HAS_PROPERTY.toString(), authorizations);
            for (String tablePropertyName : tablePropertyNames) {
                result.addProperty(tablePropertyName.substring(ID_PREFIX_PROPERTY.length()));
            }
            return result;
        }
        return new GeSchemaProperty(propertyVertex, dependentPropertyNames, namespace);
    }

    protected Relationship createRelationship(String parentName, Vertex relationshipVertex, List<String> inverseOfNames, List<String> domainConceptNames, List<String> rangeConceptNames, Collection<SchemaProperty> properties, String namespace) {
        return new GeRelationship(parentName, relationshipVertex, domainConceptNames, rangeConceptNames, inverseOfNames, properties, namespace);
    }

    protected Concept createConcept(Vertex vertex, List<SchemaProperty> conceptProperties, String parentConceptName, String namespace) {
        return new GeConcept(vertex, parentConceptName, conceptProperties, namespace);
    }

    protected Concept createConcept(Vertex vertex, String namespace) {
        return new GeConcept(vertex, namespace);
    }

    @Override
    protected void deleteChangeableProperties(SchemaProperty property, Authorizations authorizations) {
        Vertex vertex = ((GeSchemaProperty)property).getVertex();
        this.deleteChangeableProperties(vertex, authorizations);
    }

    @Override
    protected void deleteChangeableProperties(SchemaElement element, Authorizations authorizations) {
        Vertex vertex = element instanceof GeConcept ? ((GeConcept)element).getVertex() : ((GeRelationship)element).getVertex();
        this.deleteChangeableProperties(vertex, authorizations);
    }

    private void deleteChangeableProperties(Vertex vertex, Authorizations authorizations) {
        for (Property property : vertex.getProperties()) {
            if (!SchemaProperties.CHANGEABLE_PROPERTY_NAME.contains(property.getName())) continue;
            vertex.softDeleteProperty(property.getKey(), property.getName(), authorizations);
        }
        this.graph.flush();
    }

    private List<SchemaProperty> transformProperties(Iterable<Vertex> vertices, String namespace) {
        return StreamSupport.stream(vertices.spliterator(), false).filter(vertex -> "__op".equals(vertex.getConceptType())).map(vertex -> {
            ImmutableList<String> dependentPropertyNames = this.getDependentPropertyNames((Vertex)vertex, namespace);
            PropertyType dataType = GeSchemaProperty.getDataType(vertex);
            return this.createOntologyProperty((Vertex)vertex, dependentPropertyNames, dataType, namespace);
        }).collect(Collectors.toList());
    }

    private List<Concept> transformConcepts(Iterable<Vertex> vertices, String namespace) {
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        List<Vertex> filtered = StreamSupport.stream(vertices.spliterator(), false).filter(vertex -> "__oc".equals(vertex.getConceptType())).collect(Collectors.toList());
        Map<String, String> parentVertexIdToName = this.buildParentIdToNameMap(filtered, authorizations);
        List<String> allPropertyVertexIds = filtered.stream().flatMap(vertex -> StreamSupport.stream(vertex.getVertexIds(Direction.OUT, LabelName.HAS_PROPERTY.toString(), authorizations).spliterator(), false)).distinct().collect(Collectors.toList());
        List<SchemaProperty> ontologyProperties = this.transformProperties(this.getGraph().getVertices(allPropertyVertexIds, authorizations), namespace);
        Map<String, SchemaProperty> ontologyPropertiesByVertexId = ontologyProperties.stream().collect(Collectors.toMap(ontologyProperty -> ((GeSchemaProperty)ontologyProperty).getVertex().getId(), ontologyProperty -> ontologyProperty));
        return filtered.stream().map(vertex -> {
            String parentVertexId = this.getParentVertexId((Vertex)vertex, authorizations);
            String parentName = parentVertexId == null ? null : (String)parentVertexIdToName.get(parentVertexId);
            Iterable<String> propertyVertexIds = vertex.getVertexIds(Direction.OUT, LabelName.HAS_PROPERTY.toString(), authorizations);
            List<SchemaProperty> conceptProperties = StreamSupport.stream(propertyVertexIds.spliterator(), false).map(ontologyPropertiesByVertexId::get).filter(Objects::nonNull).collect(Collectors.toList());
            return this.createConcept((Vertex)vertex, conceptProperties, parentName, namespace);
        }).collect(Collectors.toList());
    }

    private List<Relationship> transformRelationships(Iterable<Vertex> vertices, String namespace) {
        Authorizations authorizations = this.getAuthorizations(namespace, new String[0]);
        List filtered = StreamSupport.stream(vertices.spliterator(), false).filter(vertex -> "__or".equals(vertex.getConceptType())).collect(Collectors.toList());
        Set<String> allRelatedVertexIds = filtered.stream().flatMap(vertex -> StreamUtils.stream(vertex.getVertexIds(Direction.OUT, LabelName.IS_A.toString(), authorizations), vertex.getVertexIds(Direction.IN, LabelName.HAS_EDGE.toString(), authorizations), vertex.getVertexIds(Direction.OUT, LabelName.HAS_EDGE.toString(), authorizations), vertex.getVertexIds(Direction.OUT, LabelName.INVERSE_OF.toString(), authorizations))).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, String> relatedVertexIdToNameMap = this.buildVertexIdToNameMap(allRelatedVertexIds, authorizations);
        List<String> allPropertyVertexIds = filtered.stream().flatMap(vertex -> StreamSupport.stream(vertex.getVertexIds(Direction.OUT, LabelName.HAS_PROPERTY.toString(), authorizations).spliterator(), false)).distinct().collect(Collectors.toList());
        List<SchemaProperty> ontologyProperties = this.transformProperties(this.getGraph().getVertices(allPropertyVertexIds, authorizations), namespace);
        Map<String, SchemaProperty> ontologyPropertiesByVertexId = ontologyProperties.stream().collect(Collectors.toMap(ontologyProperty -> ((GeSchemaProperty)ontologyProperty).getVertex().getId(), ontologyProperty -> ontologyProperty));
        return filtered.stream().map(vertex -> {
            String parentVertexId = this.getParentVertexId((Vertex)vertex, authorizations);
            String parentName = parentVertexId == null ? null : (String)relatedVertexIdToNameMap.get(parentVertexId);
            Iterable<String> propertyVertexIds = vertex.getVertexIds(Direction.OUT, LabelName.HAS_PROPERTY.toString(), authorizations);
            List<SchemaProperty> properties = StreamSupport.stream(propertyVertexIds.spliterator(), false).map(ontologyPropertiesByVertexId::get).filter(Objects::nonNull).collect(Collectors.toList());
            return this.toGeRelationship(parentName, (Vertex)vertex, properties, relatedVertexIdToNameMap, namespace);
        }).collect(Collectors.toList());
    }

    private String getParentVertexId(Vertex vertex, Authorizations authorizations) {
        Iterable<String> parentIds = vertex.getVertexIds(Direction.OUT, LabelName.IS_A.toString(), authorizations);
        return parentIds == null ? null : (String)Iterables.getOnlyElement(parentIds, null);
    }

    private Map<String, String> buildParentIdToNameMap(Iterable<Vertex> vertices, Authorizations authorizations) {
        Set<String> parentVertexIds = StreamSupport.stream(vertices.spliterator(), false).map(vertex -> this.getParentVertexId((Vertex)vertex, authorizations)).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.buildVertexIdToNameMap(parentVertexIds, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> buildVertexIdToNameMap(Iterable<String> vertexIds, Authorizations authorizations) {
        Map<String, String> map;
        Iterable<Vertex> vertices = this.graph.getVertices(vertexIds, FetchHints.PROPERTIES, authorizations);
        try {
            map = StreamSupport.stream(vertices.spliterator(), false).collect(Collectors.toMap(ElementId::getId, SchemaProperties.ONTOLOGY_TITLE::getPropertyValue));
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(vertices);
            throw throwable;
        }
        CloseableUtils.closeQuietly(vertices);
        return map;
    }

    @Override
    public void internalPublishConcept(Concept concept, User user, String namespace) {
        assert (concept instanceof GeConcept);
        if (concept.getSandboxStatus() != SandboxStatus.PUBLIC) {
            Vertex vertex = ((GeConcept)concept).getVertex();
            this.internalPublishVertex(vertex, user, namespace);
        }
    }

    @Override
    public void internalPublishRelationship(Relationship relationship, User user, String namespace) {
        assert (relationship instanceof GeRelationship);
        if (relationship.getSandboxStatus() != SandboxStatus.PUBLIC) {
            Vertex vertex = ((GeRelationship)relationship).getVertex();
            this.internalPublishVertex(vertex, user, namespace);
        }
    }

    @Override
    public void internalPublishProperty(SchemaProperty property, User user, String namespace) {
        assert (property instanceof GeSchemaProperty);
        if (property.getSandboxStatus() != SandboxStatus.PUBLIC) {
            Vertex vertex = ((GeSchemaProperty)property).getVertex();
            this.internalPublishVertex(vertex, user, namespace);
        }
    }

    private void internalPublishVertex(Vertex vertex, User user, String namespace) {
        VisibilityJson visibilityJson = (VisibilityJson)BcSchema.VISIBILITY_JSON.getPropertyValue(vertex);
        if (visibilityJson != null && visibilityJson.getWorkspaces().contains(namespace)) {
            visibilityJson = VisibilityJson.removeFromAllWorkspace(visibilityJson);
            BcVisibility bcVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
            try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.NORMAL, user, this.getAuthorizations(namespace, new String[0]));){
                ctx.update(vertex, ZonedDateTime.now(), visibilityJson, vertexUpdateCtx -> {
                    ExistingElementMutation mutation = (ExistingElementMutation)vertexUpdateCtx.getMutation();
                    mutation.alterElementVisibility(bcVisibility.getVisibility());
                });
                this.removeEdge(ctx, namespace, (String)vertex.getId());
            }
        }
    }

    public Concept getConceptById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Authorizations authorizations = this.getAuthorizations();
        Vertex v = this.graph.getVertex(id, authorizations);
        if (v == null) {
            return null;
        }
        return IterableUtils.anyOrDefault(this.transformConcepts(Collections.singletonList(v), "public-ontology"), null);
    }

    public Relationship getRelationshipById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Authorizations authorizations = this.getAuthorizations();
        Vertex v = this.graph.getVertex(id, authorizations);
        if (v == null) {
            return null;
        }
        return IterableUtils.anyOrDefault(this.transformRelationships(Collections.singletonList(v), "public-ontology"), null);
    }

    public SchemaProperty getPropertyById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Authorizations authorizations = this.getAuthorizations();
        Vertex v = this.graph.getVertex(id, authorizations);
        if (v == null) {
            return null;
        }
        return IterableUtils.anyOrDefault(this.transformProperties(Collections.singletonList(v), "public-ontology"), null);
    }
}

