/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.collect.Lists;
import com.mware.core.model.clientapi.dto.ClientApiSchema;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.schema.HasSchemaProperties;
import com.mware.core.model.schema.SchemaElement;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public abstract class Relationship
implements SchemaElement,
HasSchemaProperties {
    private final String parentName;
    private final List<String> sourceConceptNames;
    private final List<String> targetConceptNames;
    private final Collection<SchemaProperty> properties;

    protected Relationship(String parentName, List<String> sourceConceptNames, List<String> targetConceptNames, Collection<SchemaProperty> properties) {
        this.parentName = parentName;
        this.sourceConceptNames = sourceConceptNames;
        this.targetConceptNames = targetConceptNames;
        this.properties = properties;
    }

    public abstract String getId();

    public abstract SandboxStatus getSandboxStatus();

    public abstract String getName();

    public String getParentName() {
        return this.parentName;
    }

    public abstract String getTitleFormula();

    public abstract String getSubtitleFormula();

    public abstract String getTimeFormula();

    public abstract String getDisplayName();

    public abstract String getColor();

    public abstract Iterable<String> getInverseOfNames();

    public List<String> getSourceConceptNames() {
        return this.sourceConceptNames;
    }

    public List<String> getTargetConceptNames() {
        return this.targetConceptNames;
    }

    @Override
    public abstract boolean getUserVisible();

    @Override
    public abstract boolean getDeleteable();

    @Override
    public abstract boolean getUpdateable();

    public abstract String[] getIntents();

    @Override
    public Collection<SchemaProperty> getProperties() {
        return this.properties;
    }

    public abstract void addIntent(String var1, User var2, Authorizations var3);

    public abstract void removeIntent(String var1, Authorizations var2);

    public void updateIntents(String[] newIntents, User user, Authorizations authorizations) {
        ArrayList toBeRemovedIntents = Lists.newArrayList((Object[])this.getIntents());
        for (String newIntent : newIntents) {
            if (toBeRemovedIntents.contains(newIntent)) {
                toBeRemovedIntents.remove(newIntent);
                continue;
            }
            this.addIntent(newIntent, user, authorizations);
        }
        for (String toBeRemovedIntent : toBeRemovedIntents) {
            this.removeIntent(toBeRemovedIntent, authorizations);
        }
    }

    public abstract void setProperty(String var1, Value var2, User var3, Authorizations var4);

    public abstract void removeProperty(String var1, Authorizations var2);

    public abstract Map<String, String> getMetadata();

    public ClientApiSchema.Relationship toClientApi() {
        try {
            ClientApiSchema.Relationship result = new ClientApiSchema.Relationship();
            result.setParentName(this.getParentName());
            result.setTitle(this.getName());
            result.setDisplayName(this.getDisplayName());
            result.setDomainConceptNames(this.getSourceConceptNames());
            result.setRangeConceptNames(this.getTargetConceptNames());
            result.setUserVisible(this.getUserVisible());
            result.setDeleteable(this.getDeleteable());
            result.setUpdateable(this.getUpdateable());
            result.setTitleFormula(this.getTitleFormula());
            result.setSubtitleFormula(this.getSubtitleFormula());
            result.setTimeFormula(this.getTimeFormula());
            result.setCoreConcept(this.getCoreConcept());
            if (this.getIntents() != null) {
                result.getIntents().addAll(Arrays.asList(this.getIntents()));
            }
            for (Map.Entry<String, String> additionalProperty : this.getMetadata().entrySet()) {
                result.getMetadata().put(additionalProperty.getKey(), additionalProperty.getValue());
            }
            result.setSandboxStatus(this.getSandboxStatus());
            if (this.getColor() != null) {
                result.setColor(this.getColor());
            }
            Iterable<String> inverseOfNames = this.getInverseOfNames();
            for (String inverseOfName : inverseOfNames) {
                ClientApiSchema.Relationship.InverseOf inverseOf = new ClientApiSchema.Relationship.InverseOf();
                inverseOf.setName(inverseOfName);
                inverseOf.setPrimaryName(Relationship.getPrimaryInverseOfName(this.getName(), inverseOfName));
                result.getInverseOfs().add(inverseOf);
            }
            if (this.properties != null) {
                for (SchemaProperty property : this.properties) {
                    result.getProperties().add(property.getName());
                }
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPrimaryInverseOfName(String name1, String name2) {
        if (name1.compareTo(name2) > 0) {
            return name2;
        }
        return name1;
    }

    public static Collection<ClientApiSchema.Relationship> toClientApiRelationships(Iterable<Relationship> relationships) {
        ArrayList<ClientApiSchema.Relationship> results = new ArrayList<ClientApiSchema.Relationship>();
        for (Relationship vertex : relationships) {
            results.add(vertex.toClientApi());
        }
        return results;
    }

    public String toString() {
        return "Relationship{name='" + this.getName() + '\'' + '}';
    }
}

