/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.ExtendedDataTableProperty;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.util.StreamUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Schema {
    private final String namespace;
    private final Map<String, Concept> conceptsByName;
    private final Map<String, Relationship> relationshipsByName;
    private final Map<String, ExtendedDataTableProperty> extendedDataTablesByName;
    private final Map<String, SchemaProperty> propertiesByName;

    public Schema(Iterable<Concept> concepts, Iterable<Relationship> relationships, Iterable<ExtendedDataTableProperty> extendedDataTables, Map<String, SchemaProperty> propertiesByName, String namespace) {
        this.namespace = namespace;
        HashMap propertyMap = new HashMap();
        this.conceptsByName = Collections.unmodifiableMap(StreamUtil.stream(concepts).collect(Collectors.toMap(Concept::getName, concept -> {
            Collection<SchemaProperty> properties = concept.getProperties();
            if (properties != null && properties.size() > 0) {
                properties.forEach(property -> propertyMap.put(property.getName(), property));
            }
            return concept;
        })));
        this.relationshipsByName = Collections.unmodifiableMap(StreamUtil.stream(relationships).collect(Collectors.toMap(Relationship::getName, relationship -> {
            Collection<SchemaProperty> properties = relationship.getProperties();
            if (properties != null && properties.size() > 0) {
                properties.forEach(property -> propertyMap.put(property.getName(), property));
            }
            return relationship;
        })));
        this.extendedDataTablesByName = Collections.unmodifiableMap(StreamUtil.stream(extendedDataTables).collect(Collectors.toMap(ExtendedDataTableProperty::getName, table -> {
            List<SchemaProperty> properties = StreamUtil.stream(new Iterable[]{table.getTablePropertyNames()}).map(propertiesByName::get).collect(Collectors.toList());
            properties.forEach(property -> propertyMap.put(property.getName(), property));
            return table;
        })));
        this.propertiesByName = Collections.unmodifiableMap(propertyMap);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Collection<Concept> getConcepts() {
        return this.conceptsByName.values();
    }

    public Map<String, Concept> getConceptsByName() {
        return this.conceptsByName;
    }

    public Concept getConceptByName(String name) {
        return this.conceptsByName.get(name);
    }

    public Collection<Relationship> getRelationships() {
        return this.relationshipsByName.values();
    }

    public Map<String, Relationship> getRelationshipsByName() {
        return this.relationshipsByName;
    }

    public Relationship getRelationshipByName(String name) {
        return this.relationshipsByName.get(name);
    }

    public Collection<SchemaProperty> getProperties() {
        return this.propertiesByName.values();
    }

    public Map<String, SchemaProperty> getPropertiesByName() {
        return this.propertiesByName;
    }

    public SchemaProperty getPropertyByName(String name) {
        return this.propertiesByName.get(name);
    }

    public Map<String, ExtendedDataTableProperty> getExtendedDataTablesByName() {
        return this.extendedDataTablesByName;
    }

    public SandboxStatus getSandboxStatus() {
        SandboxStatus sandboxStatus;
        for (Concept concept : this.getConcepts()) {
            sandboxStatus = concept.getSandboxStatus();
            if (sandboxStatus == SandboxStatus.PUBLIC) continue;
            return sandboxStatus;
        }
        for (Relationship relationship : this.getRelationships()) {
            sandboxStatus = relationship.getSandboxStatus();
            if (sandboxStatus == SandboxStatus.PUBLIC) continue;
            return sandboxStatus;
        }
        for (SchemaProperty property : this.getProperties()) {
            sandboxStatus = property.getSandboxStatus();
            if (sandboxStatus == SandboxStatus.PUBLIC) continue;
            return sandboxStatus;
        }
        return SandboxStatus.PUBLIC;
    }
}

