/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaContribution;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaPropertyDefinition;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.schema.SchemaRepositoryBase;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.TextIndexHint;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.Value;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class SchemaFactory {
    public static final String RESOURCE_ENTITY_PNG = "entity.png";
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SchemaFactory.class);
    private SchemaRepositoryBase schemaRepository;
    private Authorizations authorizations;
    private User systemUser = new SystemUser();
    private String workspaceId = "public-ontology";

    public SchemaFactory(SchemaRepository schemaRepository) {
        this.authorizations = schemaRepository.getAuthorizations();
        this.schemaRepository = (SchemaRepositoryBase)schemaRepository;
    }

    public Relationship getOrCreateRootRelationship() {
        return this.schemaRepository.getOrCreateRootRelationship(this.authorizations);
    }

    public SchemaFactory forNamespace(String namespace) {
        if (!StringUtils.isEmpty((CharSequence)namespace)) {
            this.workspaceId = namespace;
        }
        return this;
    }

    public Concept getOrCreateThingConcept() {
        Concept thingConcept = this.schemaRepository.getConceptByName("thing");
        if (thingConcept == null) {
            thingConcept = this.newConcept().conceptType("thing").displayName("Thing").property(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.TRUE).coreConcept(true).save();
        }
        return thingConcept;
    }

    public DefaultConcept newConcept() {
        return new DefaultConcept();
    }

    public DefaultRelationship newRelationship() {
        return new DefaultRelationship();
    }

    public DefaultConceptProperty newConceptProperty() {
        return new DefaultConceptProperty();
    }

    private void addDefaultIcon(Concept entityConcept) {
        this.addGlyphIcon(entityConcept, SchemaRepositoryBase.class.getResourceAsStream(RESOURCE_ENTITY_PNG));
    }

    private void addGlyphIcon(Concept entityConcept, InputStream icon) {
        if (entityConcept.getGlyphIcon() != null) {
            LOGGER.debug("entityConcept GlyphIcon already set. skipping addEntityGlyphIcon.", new Object[0]);
            return;
        }
        Preconditions.checkNotNull((Object)icon, (Object)"The icon input stream is null");
        LOGGER.debug("addEntityGlyphIcon", new Object[0]);
        try {
            ByteArrayOutputStream imgOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)icon, (OutputStream)imgOut);
            byte[] rawImg = imgOut.toByteArray();
            com.mware.ge.io.IOUtils.closeAllSilently((AutoCloseable[])new Closeable[]{icon, imgOut});
            this.schemaRepository.addEntityGlyphIconToEntityConcept(entityConcept, rawImg, true);
        }
        catch (IOException e) {
            throw new BcException("invalid stream for glyph icon");
        }
    }

    public Concept getConcept(String name) {
        return this.schemaRepository.getConceptByName(name, this.workspaceId);
    }

    public Relationship getRelationship(String name) {
        return this.schemaRepository.getRelationshipByName(name, this.workspaceId);
    }

    public SchemaProperty getProperty(String name) {
        return this.schemaRepository.getPropertyByName(name, this.workspaceId);
    }

    public void applyContributions(Configuration configuration) {
        try {
            InjectHelper.getInjectedServices(SchemaContribution.class, configuration).stream().filter(sc -> !sc.patchApplied(this)).forEach(sc -> sc.patchSchema(this));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not apply schema contributions", ex);
        }
    }

    public SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    public class DefaultConceptProperty {
        private Concept[] concepts;
        private String name;
        private String displayName = "";
        private String displayFormula;
        private String validationFormula;
        private boolean userVisible = false;
        private boolean searchFacet = false;
        private boolean searchable = true;
        private boolean addable = true;
        private boolean updatable = true;
        private boolean deletable = true;
        private boolean sortable = true;
        private boolean systemProperty = true;
        private String aggType;
        private Collection<TextIndexHint> textIndexHints = TextIndexHint.NONE;
        private PropertyType type;
        private String displayType;
        private String propertyGroup;
        private String[] intents;
        private Map<String, String> possibleValues;
        private Relationship[] forRelationships;
        private ImmutableList<String> dependentPropertyNames;
        private ImmutableList<String> extendedDataTableNames;

        public DefaultConceptProperty concepts(Concept ... concepts) {
            this.concepts = concepts;
            return this;
        }

        public DefaultConceptProperty name(String name) {
            this.name = name;
            return this;
        }

        public DefaultConceptProperty displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public DefaultConceptProperty displayType(String displayType) {
            this.displayType = displayType;
            return this;
        }

        public DefaultConceptProperty propertyGroup(String propertyGroup) {
            this.propertyGroup = propertyGroup;
            return this;
        }

        public DefaultConceptProperty displayFormula(String displayFormula) {
            this.displayFormula = displayFormula;
            return this;
        }

        public DefaultConceptProperty validationFormula(String validationFormula) {
            this.validationFormula = validationFormula;
            return this;
        }

        public DefaultConceptProperty userVisible(boolean userVisible) {
            this.userVisible = userVisible;
            return this;
        }

        public DefaultConceptProperty searchFacet(boolean searchFacet) {
            this.searchFacet = searchFacet;
            return this;
        }

        public DefaultConceptProperty sortable(boolean sortable) {
            this.sortable = sortable;
            return this;
        }

        public DefaultConceptProperty searchable(boolean searchable) {
            this.searchable = searchable;
            return this;
        }

        public DefaultConceptProperty addable(boolean addable) {
            this.addable = addable;
            return this;
        }

        public DefaultConceptProperty updatable(boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        public DefaultConceptProperty deletable(boolean deletable) {
            this.deletable = deletable;
            return this;
        }

        public DefaultConceptProperty systemProperty(boolean systemProperty) {
            this.systemProperty = systemProperty;
            return this;
        }

        public DefaultConceptProperty aggType(String aggType) {
            this.aggType = aggType;
            return this;
        }

        public DefaultConceptProperty type(PropertyType type) {
            this.type = type;
            return this;
        }

        public DefaultConceptProperty possibleValues(Map<String, String> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }

        public DefaultConceptProperty textIndexHints(Collection<TextIndexHint> textIndexHints) {
            this.textIndexHints = textIndexHints;
            return this;
        }

        public DefaultConceptProperty textIndexHints(TextIndexHint ... textIndexHints) {
            this.textIndexHints = Arrays.asList(textIndexHints);
            return this;
        }

        public DefaultConceptProperty forRelationships(Relationship ... relationships) {
            this.forRelationships = relationships;
            return this;
        }

        public DefaultConceptProperty intents(String ... intents) {
            this.intents = intents;
            return this;
        }

        public DefaultConceptProperty dependentPropertyNames(ImmutableList<String> dependentPropertyNames) {
            this.dependentPropertyNames = dependentPropertyNames;
            return this;
        }

        public DefaultConceptProperty extendedDataTableNames(ImmutableList<String> extendedDataTableNames) {
            this.extendedDataTableNames = extendedDataTableNames;
            return this;
        }

        public SchemaProperty save() {
            if (this.concepts == null || this.concepts.length == 0) {
                this.concepts = new Concept[]{SchemaFactory.this.getOrCreateThingConcept()};
            }
            SchemaPropertyDefinition schemaPropertyDefinition = new SchemaPropertyDefinition(Arrays.asList(this.concepts), this.name, this.displayName, this.type);
            schemaPropertyDefinition.setUserVisible(this.userVisible);
            schemaPropertyDefinition.setTextIndexHints(this.textIndexHints);
            schemaPropertyDefinition.setSearchFacet(this.searchFacet);
            schemaPropertyDefinition.setAggType(this.aggType);
            schemaPropertyDefinition.setDisplayType(this.displayType);
            schemaPropertyDefinition.setSortable(this.sortable);
            schemaPropertyDefinition.setPossibleValues(this.possibleValues);
            schemaPropertyDefinition.setSystemProperty(this.systemProperty);
            schemaPropertyDefinition.setSearchable(this.searchable);
            schemaPropertyDefinition.setAddable(this.addable);
            schemaPropertyDefinition.setUpdateable(this.updatable);
            schemaPropertyDefinition.setDeleteable(this.deletable);
            schemaPropertyDefinition.setDependentPropertyNames(this.dependentPropertyNames);
            schemaPropertyDefinition.setDisplayFormula(this.displayFormula);
            schemaPropertyDefinition.setValidationFormula(this.validationFormula);
            schemaPropertyDefinition.setPropertyGroup(this.propertyGroup);
            schemaPropertyDefinition.setExtendedDataTableDomain((List<String>)this.extendedDataTableNames);
            if (this.forRelationships != null) {
                schemaPropertyDefinition.getRelationships().addAll(Arrays.asList(this.forRelationships));
            }
            SchemaProperty prop = SchemaFactory.this.schemaRepository.addPropertyTo(schemaPropertyDefinition.getConcepts(), schemaPropertyDefinition.getRelationships(), schemaPropertyDefinition.getExtendedDataTableNames(), schemaPropertyDefinition.getPropertyName(), schemaPropertyDefinition.getDisplayName(), schemaPropertyDefinition.getDataType(), schemaPropertyDefinition.getPossibleValues(), schemaPropertyDefinition.getTextIndexHints(), schemaPropertyDefinition.isUserVisible(), schemaPropertyDefinition.isSearchFacet(), schemaPropertyDefinition.isSystemProperty(), schemaPropertyDefinition.getAggType(), schemaPropertyDefinition.getAggPrecision(), schemaPropertyDefinition.getAggInterval(), schemaPropertyDefinition.getAggMinDocumentCount(), schemaPropertyDefinition.getAggTimeZone(), schemaPropertyDefinition.getAggCalendarField(), schemaPropertyDefinition.isSearchable(), schemaPropertyDefinition.isAddable(), schemaPropertyDefinition.isSortable(), schemaPropertyDefinition.getSortPriority(), schemaPropertyDefinition.getDisplayType(), schemaPropertyDefinition.getPropertyGroup(), schemaPropertyDefinition.getBoost(), schemaPropertyDefinition.getValidationFormula(), schemaPropertyDefinition.getDisplayFormula(), schemaPropertyDefinition.getDependentPropertyNames(), schemaPropertyDefinition.getIntents(), schemaPropertyDefinition.getDeleteable(), schemaPropertyDefinition.getUpdateable(), SchemaFactory.this.systemUser, SchemaFactory.this.workspaceId);
            if (this.intents != null) {
                Arrays.stream(this.intents).forEach(intent -> prop.addIntent((String)intent, SchemaFactory.this.authorizations));
            }
            return prop;
        }
    }

    public class DefaultRelationship {
        private Relationship parent;
        private Concept[] sourceConcepts;
        private Concept[] targetConcepts;
        private Relationship inverseOf;
        private String label;
        private Map<String, Value> properties = new HashMap<String, Value>();
        private String[] intents;
        private boolean coreConcept = false;

        public DefaultRelationship() {
            this.properties.put(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.FALSE);
        }

        public DefaultRelationship parent(Relationship parentRelationship) {
            this.parent = parentRelationship;
            return this;
        }

        public DefaultRelationship label(String label) {
            this.label = label;
            return this;
        }

        public DefaultRelationship source(Concept ... sourceConcepts) {
            this.sourceConcepts = sourceConcepts;
            return this;
        }

        public DefaultRelationship target(Concept ... targetConcepts) {
            this.targetConcepts = targetConcepts;
            return this;
        }

        public DefaultRelationship property(String name, Value value) {
            this.properties.put(name, value);
            return this;
        }

        public DefaultRelationship intents(String ... intents) {
            this.intents = intents;
            return this;
        }

        public DefaultRelationship inverseOf(Relationship inverseOf) {
            this.inverseOf = inverseOf;
            return this;
        }

        public DefaultRelationship coreConcept(boolean coreConcept) {
            this.coreConcept = coreConcept;
            return this;
        }

        public Relationship save() {
            if (this.parent == null) {
                this.parent = SchemaFactory.this.getOrCreateRootRelationship();
            }
            Relationship r = SchemaFactory.this.schemaRepository.getOrCreateRelationshipType(this.parent, Arrays.asList(this.sourceConcepts), Arrays.asList(this.targetConcepts), this.label, true, this.coreConcept, SchemaFactory.this.systemUser, SchemaFactory.this.workspaceId);
            for (Map.Entry<String, Value> prop : this.properties.entrySet()) {
                r.setProperty(prop.getKey(), prop.getValue(), new SystemUser(), SchemaFactory.this.authorizations);
            }
            if (this.intents != null) {
                Arrays.stream(this.intents).forEach(intent -> r.addIntent((String)intent, new SystemUser(), SchemaFactory.this.authorizations));
            }
            if (this.inverseOf != null) {
                SchemaFactory.this.schemaRepository.getOrCreateInverseOfRelationship(r, this.inverseOf);
            }
            return r;
        }
    }

    public class DefaultConcept {
        private Concept parent;
        private String conceptType;
        private String displayName;
        private Map<String, Value> properties = new HashMap<String, Value>();
        private String[] intents;
        private String glyphIcon;
        private InputStream glyphIconStream;
        private boolean coreConcept = false;

        public DefaultConcept() {
            this.properties.put(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.FALSE);
        }

        public DefaultConcept parent(Concept parentConcept) {
            this.parent = parentConcept;
            return this;
        }

        public DefaultConcept conceptType(String conceptType) {
            this.conceptType = conceptType;
            return this;
        }

        public DefaultConcept displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public DefaultConcept glyphIcon(String glyphIcon) {
            this.glyphIcon = glyphIcon;
            return this;
        }

        public DefaultConcept glyphIcon(InputStream glyphIconStream) {
            this.glyphIconStream = glyphIconStream;
            return this;
        }

        public DefaultConcept property(String name, Value value) {
            this.properties.put(name, value);
            return this;
        }

        public DefaultConcept intents(String ... intents) {
            this.intents = intents;
            return this;
        }

        public DefaultConcept coreConcept(boolean coreConcept) {
            this.coreConcept = coreConcept;
            return this;
        }

        public Concept save() {
            if (this.parent == null && !"thing".equals(this.conceptType)) {
                this.parent = SchemaFactory.this.getOrCreateThingConcept();
            }
            Concept c = SchemaFactory.this.schemaRepository.getOrCreateConcept(this.parent, this.conceptType, this.displayName, true, this.coreConcept, SchemaFactory.this.systemUser, SchemaFactory.this.workspaceId);
            for (Map.Entry<String, Value> prop : this.properties.entrySet()) {
                c.setProperty(prop.getKey(), prop.getValue(), new SystemUser(), SchemaFactory.this.authorizations);
            }
            if (this.intents != null) {
                Arrays.stream(this.intents).forEach(intent -> c.addIntent((String)intent, new SystemUser(), SchemaFactory.this.authorizations));
            }
            if (!StringUtils.isEmpty((CharSequence)this.glyphIcon)) {
                SchemaFactory.this.addGlyphIcon(c, SchemaRepositoryBase.class.getResourceAsStream(this.glyphIcon));
            } else if (this.glyphIconStream != null) {
                SchemaFactory.this.addGlyphIcon(c, this.glyphIconStream);
            } else {
                SchemaFactory.this.addDefaultIcon(c);
            }
            return c;
        }
    }
}

