/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.ClientApiSchema;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.types.BcProperty;
import com.mware.core.model.properties.types.BooleanBcProperty;
import com.mware.core.model.properties.types.DateBcProperty;
import com.mware.core.model.properties.types.DoubleBcProperty;
import com.mware.core.model.properties.types.GeoPointBcProperty;
import com.mware.core.model.properties.types.GeoShapeBcProperty;
import com.mware.core.model.properties.types.IntegerBcProperty;
import com.mware.core.model.properties.types.StreamingBcProperty;
import com.mware.core.model.properties.types.StringBcProperty;
import com.mware.core.model.schema.ExtendedDataTableProperty;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.type.GeoCircle;
import com.mware.ge.type.GeoHash;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoShape;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SchemaProperty {
    public static final DateTimeFormatter DATE_FORMAT;
    public static final DateTimeFormatter DATE_TIME_FORMAT;
    public static final DateTimeFormatter DATE_TIME_WITH_SECONDS_FORMAT;
    public static final Pattern GEO_LOCATION_FORMAT;
    public static final Pattern GEO_LOCATION_ALTERNATE_FORMAT;

    public abstract String getId();

    public abstract SandboxStatus getSandboxStatus();

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract boolean getUserVisible();

    public abstract boolean getSearchFacet();

    public abstract boolean getSystemProperty();

    public abstract String getAggType();

    public abstract int getAggPrecision();

    public abstract String getAggInterval();

    public abstract long getAggMinDocumentCount();

    public abstract String getAggTimeZone();

    public abstract String getAggCalendarField();

    public abstract boolean getSearchable();

    public abstract boolean getAddable();

    public abstract boolean getSortable();

    public abstract PropertyType getDataType();

    public abstract Double getBoost();

    public abstract Map<String, String> getPossibleValues();

    public abstract String getDisplayType();

    public abstract String getPropertyGroup();

    public abstract String getValidationFormula();

    public abstract String getDisplayFormula();

    public abstract boolean getUpdateable();

    public abstract boolean getDeleteable();

    public abstract ImmutableList<String> getDependentPropertyNames();

    public abstract String[] getIntents();

    public abstract String[] getTextIndexHints();

    public abstract void addTextIndexHints(String var1, Authorizations var2);

    public abstract void addIntent(String var1, Authorizations var2);

    public abstract void removeIntent(String var1, Authorizations var2);

    public abstract List<String> getConceptNames();

    public abstract List<String> getRelationshipNames();

    public abstract Integer getSortPriority();

    public void updateIntents(String[] newIntents, Authorizations authorizations) {
        ArrayList toBeRemovedIntents = Lists.newArrayList((Object[])this.getIntents());
        for (String newIntent : newIntents) {
            if (toBeRemovedIntents.contains(newIntent)) {
                toBeRemovedIntents.remove(newIntent);
                continue;
            }
            this.addIntent(newIntent, authorizations);
        }
        for (String toBeRemovedIntent : toBeRemovedIntents) {
            this.removeIntent(toBeRemovedIntent, authorizations);
        }
    }

    public abstract void setProperty(String var1, Value var2, User var3, Authorizations var4);

    public static Collection<ClientApiSchema.Property> toClientApiProperties(Iterable<SchemaProperty> properties) {
        ArrayList<ClientApiSchema.Property> results = new ArrayList<ClientApiSchema.Property>();
        for (SchemaProperty property : properties) {
            results.add(property.toClientApi());
        }
        return results;
    }

    public abstract Map<String, String> getMetadata();

    public ClientApiSchema.Property toClientApi() {
        try {
            ClientApiSchema.Property result;
            if (this instanceof ExtendedDataTableProperty) {
                result = new ClientApiSchema.ExtendedDataTableProperty();
                ExtendedDataTableProperty edtp = (ExtendedDataTableProperty)((Object)this);
                ClientApiSchema.ExtendedDataTableProperty cedtp = (ClientApiSchema.ExtendedDataTableProperty)result;
                cedtp.setTitleFormula(edtp.getTitleFormula());
                cedtp.setSubtitleFormula(edtp.getSubtitleFormula());
                cedtp.setTimeFormula(edtp.getTimeFormula());
                cedtp.setTablePropertyNames((List<String>)edtp.getTablePropertyNames());
            } else {
                result = new ClientApiSchema.Property();
            }
            result.setTitle(this.getName());
            result.setDisplayName(this.getDisplayName());
            result.setUserVisible(this.getUserVisible());
            result.setSearchFacet(this.getSearchFacet());
            result.setSystemProperty(this.getSystemProperty());
            result.setAggType(this.getAggType());
            result.setAggPrecision(this.getAggPrecision());
            result.setAggInterval(this.getAggInterval());
            result.setAggMinDocumentCount(this.getAggMinDocumentCount());
            result.setAggTimeZone(this.getAggTimeZone());
            result.setAggCalendarField(this.getAggCalendarField());
            result.setSearchable(this.getSearchable());
            result.setAddable(this.getAddable());
            result.setSortable(this.getSortable());
            result.setDataType(this.getDataType());
            result.setDisplayType(this.getDisplayType());
            result.setPropertyGroup(this.getPropertyGroup());
            result.setValidationFormula(this.getValidationFormula());
            result.setDisplayFormula(this.getDisplayFormula());
            result.setDependentPropertyNames((Collection<String>)this.getDependentPropertyNames());
            result.setDeleteable(this.getDeleteable());
            result.setUpdateable(this.getUpdateable());
            result.setSandboxStatus(this.getSandboxStatus());
            result.setSortPriority(this.getSortPriority());
            if (this.getPossibleValues() != null) {
                result.getPossibleValues().putAll(this.getPossibleValues());
            }
            if (this.getIntents() != null) {
                result.getIntents().addAll(Arrays.asList(this.getIntents()));
            }
            if (this.getTextIndexHints() != null) {
                result.getTextIndexHints().addAll(Arrays.asList(this.getTextIndexHints()));
            }
            for (Map.Entry<String, String> additionalProperty : this.getMetadata().entrySet()) {
                result.getMetadata().put(additionalProperty.getKey(), additionalProperty.getValue());
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Object convert(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        PropertyType dataType = this.getDataType();
        switch (dataType) {
            case DATE: {
                if (!(value instanceof Date)) break;
                return value;
            }
            case GEO_LOCATION: {
                if (!(value instanceof GeoPoint)) break;
                return value;
            }
            case GEO_SHAPE: {
                if (!(value instanceof GeoShape)) break;
                return value;
            }
            case CURRENCY: {
                if (!(value instanceof BigDecimal)) break;
                return value;
            }
            case DOUBLE: {
                if (!(value instanceof Double)) break;
                return value;
            }
            case INTEGER: {
                if (!(value instanceof Integer)) break;
                return value;
            }
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                return value;
            }
        }
        return this.convertString(value.toString());
    }

    public Value convertString(String valueStr) throws ParseException {
        PropertyType dataType = this.getDataType();
        switch (dataType) {
            case DATE: {
                return SchemaProperty.parseDateTime(valueStr);
            }
            case GEO_LOCATION: {
                return SchemaProperty.parseGeoLocation(valueStr);
            }
            case CURRENCY: {
                return Values.floatValue(Float.parseFloat(valueStr));
            }
            case DOUBLE: {
                return Values.doubleValue(Double.parseDouble(valueStr));
            }
            case INTEGER: {
                return Values.intValue(Integer.parseInt(valueStr));
            }
            case BOOLEAN: {
                return Values.booleanValue(Boolean.parseBoolean(valueStr));
            }
        }
        return Values.stringValue(valueStr);
    }

    public static Value convert(JSONArray values, PropertyType propertyDataType, int index) throws ParseException {
        switch (propertyDataType) {
            case DATE: {
                String valueStr = values.getString(index);
                return SchemaProperty.parseDateTime(valueStr);
            }
            case GEO_LOCATION: {
                if (values.get(index) instanceof String) {
                    String valueStr = values.getString(index);
                    return Values.geoHashValue(new GeoHash(valueStr));
                }
                return Values.geoCircleValue(new GeoCircle(values.getDouble(index), values.getDouble(index + 1), values.getDouble(index + 2)));
            }
            case CURRENCY: {
                return Values.floatValue(Float.parseFloat(values.getString(index)));
            }
            case INTEGER: {
                return Values.intValue(values.getInt(index));
            }
            case DOUBLE: {
                return Values.doubleValue(values.getDouble(index));
            }
            case BOOLEAN: {
                Object result = values.get(index);
                if ("T".equals(result) || "1".equals(result)) {
                    return BooleanValue.TRUE;
                }
                if ("F".equals(result) || "0".equals(result)) {
                    return BooleanValue.FALSE;
                }
                return Values.booleanValue(values.getBoolean(index));
            }
        }
        return Values.stringValue(values.getString(index));
    }

    protected static GeoPointValue parseGeoLocation(String valueStr) {
        try {
            JSONObject json = new JSONObject(valueStr);
            double latitude = json.getDouble("latitude");
            double longitude = json.getDouble("longitude");
            String altitudeString = json.optString("altitude");
            double altitude = altitudeString == null || altitudeString.length() == 0 ? 0.0 : Double.parseDouble(altitudeString);
            return Values.geoPointValue(new GeoPoint(latitude, longitude, altitude));
        }
        catch (Exception ex) {
            Matcher match = GEO_LOCATION_FORMAT.matcher(valueStr);
            if (match.find()) {
                double latitude = Double.parseDouble(match.group(1).trim());
                double longitude = Double.parseDouble(match.group(2).trim());
                return Values.geoPointValue(latitude, longitude);
            }
            match = GEO_LOCATION_ALTERNATE_FORMAT.matcher(valueStr);
            if (match.find()) {
                double latitude = Double.parseDouble(match.group(1).trim());
                double longitude = Double.parseDouble(match.group(2).trim());
                return Values.geoPointValue(latitude, longitude);
            }
            throw new BcException("Could not parse location: " + valueStr);
        }
    }

    public boolean hasDependentPropertyNames() {
        return this.getDependentPropertyNames() != null && this.getDependentPropertyNames().size() > 0;
    }

    private static DateTimeValue parseDateTime(String valueStr) throws ParseException {
        ZonedDateTime date;
        try {
            date = ZonedDateTime.parse(valueStr, DATE_TIME_WITH_SECONDS_FORMAT);
        }
        catch (DateTimeParseException ex1) {
            try {
                date = ZonedDateTime.parse(valueStr, DATE_TIME_FORMAT);
            }
            catch (DateTimeParseException ex2) {
                try {
                    date = ZonedDateTime.parse(valueStr, DATE_FORMAT);
                }
                catch (DateTimeParseException ex3) {
                    return DateTimeValue.ofEpochMillis(Values.longValue(Long.parseLong(valueStr)));
                }
            }
        }
        return (DateTimeValue)Values.of(date);
    }

    public BcProperty geBcProperty() {
        switch (this.getDataType()) {
            case IMAGE: 
            case BINARY: {
                return new StreamingBcProperty(this.getName());
            }
            case BOOLEAN: {
                return new BooleanBcProperty(this.getName());
            }
            case DATE: {
                return new DateBcProperty(this.getName());
            }
            case CURRENCY: 
            case DOUBLE: {
                return new DoubleBcProperty(this.getName());
            }
            case GEO_LOCATION: {
                return new GeoPointBcProperty(this.getName());
            }
            case GEO_SHAPE: {
                return new GeoShapeBcProperty(this.getName());
            }
            case INTEGER: {
                return new IntegerBcProperty(this.getName());
            }
            case STRING: 
            case DIRECTORY_ENTITY: {
                return new StringBcProperty(this.getName());
            }
        }
        throw new BcException("Could not get " + BcProperty.class.getName() + " for data type " + (Object)((Object)this.getDataType()));
    }

    public String toString() {
        return this.getClass().getName() + "{name:" + this.getName() + "}";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaProperty)) {
            return false;
        }
        String otherName = ((SchemaProperty)obj).getName();
        return this.getName().equals(otherName);
    }

    static {
        GEO_LOCATION_FORMAT = Pattern.compile("POINT\\((.*?),(.*?)\\)", 2);
        GEO_LOCATION_ALTERNATE_FORMAT = Pattern.compile("(.*?),(.*)", 2);
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
        DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm z").withZone(ZoneOffset.UTC);
        DATE_TIME_WITH_SECONDS_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneOffset.UTC);
    }
}

