/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.collect.ImmutableList;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.Relationship;
import com.mware.ge.TextIndexHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SchemaPropertyDefinition {
    private final List<Concept> concepts;
    private final List<Relationship> relationships;
    private List<String> extendedDataTableNames;
    private final String propertyName;
    private final String displayName;
    private final PropertyType dataType;
    private Map<String, String> possibleValues;
    private Collection<TextIndexHint> textIndexHints;
    private Collection<String> extendedDataTableDomains;
    private boolean userVisible = true;
    private boolean analyticsVisible;
    private boolean searchFacet;
    private String aggType;
    private int aggPrecision = -1;
    private String aggInterval;
    private long aggMinDocumentCount = 0L;
    private String aggTimeZone;
    private String aggCalendarField;
    private boolean systemProperty = false;
    private boolean searchable = true;
    private boolean addable = true;
    private boolean sortable = true;
    private Integer sortPriority;
    private String displayType;
    private String propertyGroup;
    private Double boost;
    private String validationFormula;
    private String displayFormula;
    private ImmutableList<String> dependentPropertyNames;
    private String[] intents;
    private boolean deleteable = true;
    private boolean updateable = true;

    public SchemaPropertyDefinition(List<Concept> concepts, String propertyName, String displayName, PropertyType dataType) {
        this(concepts, new ArrayList<Relationship>(), propertyName, displayName, dataType);
    }

    public SchemaPropertyDefinition(List<Concept> concepts, List<Relationship> relationships, String propertyName, String displayName, PropertyType dataType) {
        this.concepts = concepts;
        this.relationships = relationships;
        this.propertyName = propertyName;
        this.displayName = displayName;
        this.dataType = dataType;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<Concept> getConcepts() {
        return this.concepts;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PropertyType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getPossibleValues() {
        return this.possibleValues;
    }

    public SchemaPropertyDefinition setPossibleValues(Map<String, String> possibleValues) {
        this.possibleValues = possibleValues;
        return this;
    }

    public Collection<TextIndexHint> getTextIndexHints() {
        return this.textIndexHints;
    }

    public SchemaPropertyDefinition setTextIndexHints(Collection<TextIndexHint> textIndexHints) {
        this.textIndexHints = textIndexHints;
        return this;
    }

    public List<String> getExtendedDataTableNames() {
        return this.extendedDataTableNames;
    }

    public SchemaPropertyDefinition setExtendedDataTableDomain(List<String> extendedDataTableNames) {
        this.extendedDataTableNames = extendedDataTableNames;
        return this;
    }

    public boolean isUserVisible() {
        return this.userVisible;
    }

    public boolean isSearchFacet() {
        return this.searchFacet;
    }

    public String getAggType() {
        return this.aggType;
    }

    public int getAggPrecision() {
        return this.aggPrecision;
    }

    public String getAggInterval() {
        return this.aggInterval;
    }

    public long getAggMinDocumentCount() {
        return this.aggMinDocumentCount;
    }

    public String getAggTimeZone() {
        return this.aggTimeZone;
    }

    public String getAggCalendarField() {
        return this.aggCalendarField;
    }

    public SchemaPropertyDefinition setUserVisible(boolean userVisible) {
        this.userVisible = userVisible;
        return this;
    }

    public SchemaPropertyDefinition setSearchFacet(boolean searchFacet) {
        this.searchFacet = searchFacet;
        return this;
    }

    public SchemaPropertyDefinition setAggType(String aggType) {
        this.aggType = aggType;
        return this;
    }

    public SchemaPropertyDefinition setAggPrecision(int aggPrecision) {
        this.aggPrecision = aggPrecision;
        return this;
    }

    public SchemaPropertyDefinition setAggInterval(String aggInterval) {
        this.aggInterval = aggInterval;
        return this;
    }

    public SchemaPropertyDefinition setAggMinDocumentCount(long aggMinDocumentCount) {
        this.aggMinDocumentCount = aggMinDocumentCount;
        return this;
    }

    public SchemaPropertyDefinition setAggTimeZone(String aggTimeZone) {
        this.aggTimeZone = aggTimeZone;
        return this;
    }

    public SchemaPropertyDefinition setAggCalendarField(String aggCalendarField) {
        this.aggCalendarField = aggCalendarField;
        return this;
    }

    public boolean isSystemProperty() {
        return this.systemProperty;
    }

    public SchemaPropertyDefinition setSystemProperty(boolean systemProperty) {
        this.systemProperty = systemProperty;
        return this;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public SchemaPropertyDefinition setSearchable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public boolean isAddable() {
        return this.addable;
    }

    public SchemaPropertyDefinition setAddable(boolean addable) {
        this.addable = addable;
        return this;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public SchemaPropertyDefinition setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public Integer getSortPriority() {
        return this.sortPriority;
    }

    public SchemaPropertyDefinition setSortPriority(Integer sortPriority) {
        this.sortPriority = sortPriority;
        return this;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public SchemaPropertyDefinition setDisplayType(String displayType) {
        this.displayType = displayType;
        return this;
    }

    public String getPropertyGroup() {
        return this.propertyGroup;
    }

    public SchemaPropertyDefinition setPropertyGroup(String propertyGroup) {
        this.propertyGroup = propertyGroup;
        return this;
    }

    public Double getBoost() {
        return this.boost;
    }

    public SchemaPropertyDefinition setBoost(Double boost) {
        this.boost = boost;
        return this;
    }

    public String getValidationFormula() {
        return this.validationFormula;
    }

    public SchemaPropertyDefinition setValidationFormula(String validationFormula) {
        this.validationFormula = validationFormula;
        return this;
    }

    public String getDisplayFormula() {
        return this.displayFormula;
    }

    public SchemaPropertyDefinition setDisplayFormula(String displayFormula) {
        this.displayFormula = displayFormula;
        return this;
    }

    public ImmutableList<String> getDependentPropertyNames() {
        return this.dependentPropertyNames;
    }

    public SchemaPropertyDefinition setDependentPropertyNames(ImmutableList<String> dependentPropertyNames) {
        this.dependentPropertyNames = dependentPropertyNames;
        return this;
    }

    public String[] getIntents() {
        return this.intents;
    }

    public SchemaPropertyDefinition setIntents(String[] intents) {
        this.intents = intents;
        return this;
    }

    public boolean getDeleteable() {
        return this.deleteable;
    }

    public void setDeleteable(boolean deleteable) {
        this.deleteable = deleteable;
    }

    public boolean getUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }
}

