/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.mware.core.model.clientapi.dto.ClientApiObject;
import com.mware.core.model.clientapi.dto.ClientApiSchema;
import com.mware.core.model.properties.types.BcProperty;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.Schema;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaPropertyDefinition;
import com.mware.core.security.BcVisibility;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.query.Query;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public interface SchemaRepository {
    public static final String THING_CONCEPT_NAME = "thing";
    public static final String ROOT_CONCEPT_NAME = "__root";
    public static final String TYPE_RELATIONSHIP = "__or";
    public static final String TYPE_CONCEPT = "__oc";
    public static final String TYPE_PROPERTY = "__op";
    public static final String VISIBILITY_STRING = "ontology";
    public static final String CONFIG_INTENT_CONCEPT_PREFIX = "ontology.intent.concept.";
    public static final String CONFIG_INTENT_RELATIONSHIP_PREFIX = "ontology.intent.relationship.";
    public static final String CONFIG_INTENT_PROPERTY_PREFIX = "ontology.intent.property.";
    public static final String PUBLIC = "public-ontology";
    public static final BcVisibility VISIBILITY = new BcVisibility("ontology");

    public void clearCache();

    public void clearCache(String var1);

    default public Iterable<Relationship> getRelationships() {
        return this.getRelationships(PUBLIC);
    }

    public Iterable<Relationship> getRelationships(String var1);

    public Iterable<Relationship> getRelationships(Iterable<String> var1, String var2);

    default public Iterable<SchemaProperty> getProperties() {
        return this.getProperties(PUBLIC);
    }

    public Iterable<SchemaProperty> getProperties(String var1);

    public Iterable<SchemaProperty> getProperties(Iterable<String> var1, String var2);

    default public String getDisplayNameForLabel(String relationshipLabel) {
        return this.getDisplayNameForLabel(relationshipLabel, PUBLIC);
    }

    public String getDisplayNameForLabel(String var1, String var2);

    default public SchemaProperty getPropertyByName(String propertyName) {
        return this.getPropertyByName(propertyName, PUBLIC);
    }

    public SchemaProperty getPropertyByName(String var1, String var2);

    public Iterable<SchemaProperty> getPropertiesByName(List<String> var1, String var2);

    default public SchemaProperty getRequiredPropertyByName(String propertyName) {
        return this.getRequiredPropertyByName(propertyName, PUBLIC);
    }

    public SchemaProperty getRequiredPropertyByName(String var1, String var2);

    default public Relationship getRelationshipByName(String relationshipName) {
        return this.getRelationshipByName(relationshipName, PUBLIC);
    }

    public Relationship getRelationshipByName(String var1, String var2);

    public Iterable<Relationship> getRelationshipsByName(List<String> var1, String var2);

    default public boolean hasRelationshipByName(String relationshipName) {
        return this.hasRelationshipByName(relationshipName, PUBLIC);
    }

    public boolean hasRelationshipByName(String var1, String var2);

    default public Iterable<Concept> getConceptsWithProperties() {
        return this.getConceptsWithProperties(PUBLIC);
    }

    public Iterable<Concept> getConceptsWithProperties(String var1);

    public Concept getRootConcept(String var1);

    default public Concept getThingConcept() {
        return this.getThingConcept(PUBLIC);
    }

    public Concept getThingConcept(String var1);

    public Relationship getOrCreateRootRelationship(Authorizations var1);

    default public Concept getParentConcept(Concept concept) {
        return this.getParentConcept(concept, PUBLIC);
    }

    public Concept getParentConcept(Concept var1, String var2);

    public Set<Concept> getAncestorConcepts(Concept var1, String var2);

    public Set<Concept> getConceptAndAncestors(Concept var1, String var2);

    default public List<Concept> getChildConcepts(Concept concept) {
        return this.getChildConcepts(concept, PUBLIC);
    }

    public List<Concept> getChildConcepts(Concept var1, String var2);

    default public Concept getConceptByName(String conceptName) {
        return this.getConceptByName(conceptName, PUBLIC);
    }

    public Concept getConceptByName(String var1, String var2);

    public Iterable<Concept> getConceptsByName(List<String> var1, String var2);

    public boolean hasConceptByName(String var1, String var2);

    default public Set<Concept> getConceptAndAllChildrenByName(String conceptName) {
        return this.getConceptAndAllChildrenByName(conceptName, PUBLIC);
    }

    public Set<Concept> getConceptAndAllChildrenByName(String var1, String var2);

    default public Set<Concept> getConceptAndAllChildren(Concept concept) {
        return this.getConceptAndAllChildren(concept, PUBLIC);
    }

    public Set<Concept> getConceptAndAllChildren(Concept var1, String var2);

    default public Set<Relationship> getRelationshipAndAllChildren(Relationship relationship) {
        return this.getRelationshipAndAllChildren(relationship, PUBLIC);
    }

    public Set<Relationship> getRelationshipAndAllChildren(Relationship var1, String var2);

    public Set<Relationship> getRelationshipAndAllChildrenByName(String var1, String var2);

    public Relationship getParentRelationship(Relationship var1, String var2);

    public Set<Relationship> getAncestorRelationships(Relationship var1, String var2);

    public Set<Relationship> getRelationshipAndAncestors(Relationship var1, String var2);

    public Iterable<Concept> getConcepts(Iterable<String> var1, String var2);

    default public Concept getOrCreateConcept(Concept parent, String conceptName, String displayName) {
        return this.getOrCreateConcept(parent, conceptName, displayName, null, PUBLIC);
    }

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, User var4, String var5);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, String var4, String var5, User var6, String var7);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, boolean var4, boolean var5);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, boolean var4, boolean var5, User var6, String var7);

    public Concept getOrCreateConcept(Concept var1, String var2, String var3, String var4, String var5, boolean var6, boolean var7, User var8, String var9);

    public void deleteConcept(String var1, User var2, String var3);

    default public Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipName, boolean deleteChangeableProperties, boolean coreConcept) {
        return this.getOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipName, null, coreConcept, deleteChangeableProperties, null, PUBLIC);
    }

    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, boolean var5, boolean var6, User var7, String var8);

    public Relationship getOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, String var5, boolean var6, boolean var7, User var8, String var9);

    public void deleteRelationship(String var1, User var2, String var3);

    public void addDomainConceptsToRelationshipType(String var1, List<String> var2, User var3, String var4);

    public void addRangeConceptsToRelationshipType(String var1, List<String> var2, User var3, String var4);

    default public SchemaProperty getOrCreateProperty(SchemaPropertyDefinition schemaPropertyDefinition) {
        return this.getOrCreateProperty(schemaPropertyDefinition, null, PUBLIC);
    }

    public SchemaProperty getOrCreateProperty(SchemaPropertyDefinition var1, User var2, String var3);

    public void deleteProperty(String var1, User var2, String var3);

    default public void resolvePropertyIds(JSONArray filterJson) throws JSONException {
        this.resolvePropertyIds(filterJson, PUBLIC);
    }

    public void resolvePropertyIds(JSONArray var1, String var2) throws JSONException;

    default public ClientApiSchema getClientApiObject() {
        return this.getClientApiObject(PUBLIC);
    }

    public ClientApiSchema getClientApiObject(String var1);

    public Schema getOntology(String var1);

    default public Concept getConceptByIntent(String intent) {
        return this.getConceptByIntent(intent, PUBLIC);
    }

    public Concept getConceptByIntent(String var1, String var2);

    default public String getConceptNameByIntent(String intent) {
        return this.getConceptNameByIntent(intent, PUBLIC);
    }

    public String getConceptNameByIntent(String var1, String var2);

    default public Concept getRequiredConceptByIntent(String intent) {
        return this.getRequiredConceptByIntent(intent, PUBLIC);
    }

    public Concept getRequiredConceptByIntent(String var1, String var2);

    default public Concept getRequiredConceptByName(String conceptName) {
        return this.getRequiredConceptByName(conceptName, PUBLIC);
    }

    public Concept getRequiredConceptByName(String var1, String var2);

    default public String getRequiredConceptNameByIntent(String intent) {
        return this.getRequiredConceptNameByIntent(intent, PUBLIC);
    }

    public String getRequiredConceptNameByIntent(String var1, String var2);

    default public Relationship getRelationshipByIntent(String intent) {
        return this.getRelationshipByIntent(intent, PUBLIC);
    }

    public Relationship getRelationshipByIntent(String var1, String var2);

    default public String getRelationshipNameByIntent(String intent) {
        return this.getRelationshipNameByIntent(intent, PUBLIC);
    }

    public String getRelationshipNameByIntent(String var1, String var2);

    @Deprecated
    default public Relationship getRequiredRelationshipByIntent(String intent) {
        return this.getRequiredRelationshipByIntent(intent, PUBLIC);
    }

    public Relationship getRequiredRelationshipByIntent(String var1, String var2);

    default public String getRequiredRelationshipNameByIntent(String intent) {
        return this.getRequiredRelationshipNameByIntent(intent, PUBLIC);
    }

    public String getRequiredRelationshipNameByIntent(String var1, String var2);

    default public SchemaProperty getPropertyByIntent(String intent) {
        return this.getPropertyByIntent(intent, PUBLIC);
    }

    public SchemaProperty getPropertyByIntent(String var1, String var2);

    default public String getPropertyNameByIntent(String intent) {
        return this.getPropertyNameByIntent(intent, PUBLIC);
    }

    public String getPropertyNameByIntent(String var1, String var2);

    default public <T extends BcProperty> T getPropertyByIntent(String intent, Class<T> propertyType) {
        return this.getPropertyByIntent(intent, propertyType, PUBLIC);
    }

    public <T extends BcProperty> T getPropertyByIntent(String var1, Class<T> var2, String var3);

    default public <T extends BcProperty> T getRequiredPropertyByIntent(String intent, Class<T> propertyType) {
        return this.getRequiredPropertyByIntent(intent, propertyType, PUBLIC);
    }

    public <T extends BcProperty> T getRequiredPropertyByIntent(String var1, Class<T> var2, String var3);

    default public List<SchemaProperty> getPropertiesByIntent(String intent) {
        return this.getPropertiesByIntent(intent, PUBLIC);
    }

    public List<SchemaProperty> getPropertiesByIntent(String var1, String var2);

    default public SchemaProperty getRequiredPropertyByIntent(String intent) {
        return this.getRequiredPropertyByIntent(intent, PUBLIC);
    }

    public SchemaProperty getRequiredPropertyByIntent(String var1, String var2);

    default public String getRequiredPropertyNameByIntent(String intent) {
        return this.getRequiredPropertyNameByIntent(intent, PUBLIC);
    }

    public String getRequiredPropertyNameByIntent(String var1, String var2);

    default public SchemaProperty getDependentPropertyParent(String propertyName) {
        return this.getDependentPropertyParent(propertyName, PUBLIC);
    }

    public SchemaProperty getDependentPropertyParent(String var1, String var2);

    default public void addConceptTypeFilterToQuery(Query query, String conceptName, boolean includeChildNodes) {
        this.addConceptTypeFilterToQuery(query, conceptName, includeChildNodes, PUBLIC);
    }

    public void addConceptTypeFilterToQuery(Query var1, String var2, boolean var3, String var4);

    default public void addConceptTypeFilterToQuery(Query query, Collection<ElementTypeFilter> filters) {
        this.addConceptTypeFilterToQuery(query, filters, PUBLIC);
    }

    public void addConceptTypeFilterToQuery(Query var1, Collection<ElementTypeFilter> var2, String var3);

    default public void addEdgeLabelFilterToQuery(Query query, String edgeLabel, boolean includeChildNodes) {
        this.addEdgeLabelFilterToQuery(query, edgeLabel, includeChildNodes, PUBLIC);
    }

    public void addEdgeLabelFilterToQuery(Query var1, String var2, boolean var3, String var4);

    default public void addEdgeLabelFilterToQuery(Query query, Collection<ElementTypeFilter> filters) {
        this.addEdgeLabelFilterToQuery(query, filters, PUBLIC);
    }

    public void addEdgeLabelFilterToQuery(Query var1, Collection<ElementTypeFilter> var2, String var3);

    default public void updatePropertyDependentNames(SchemaProperty property, Collection<String> dependentPropertyNames) {
        this.updatePropertyDependentNames(property, dependentPropertyNames, null, PUBLIC);
    }

    public void updatePropertyDependentNames(SchemaProperty var1, Collection<String> var2, User var3, String var4);

    default public void updatePropertyDomainNames(SchemaProperty property, Set<String> domainNames) {
        this.updatePropertyDomainNames(property, domainNames, null, PUBLIC);
    }

    public void updatePropertyDomainNames(SchemaProperty var1, Set<String> var2, User var3, String var4);

    public String generateDynamicName(Class var1, String var2, String var3, String ... var4);

    public String generatePropertyDynamicName(Class var1, String var2, String var3, String var4);

    public void publishConcept(Concept var1, User var2, String var3);

    public void publishRelationship(Relationship var1, User var2, String var3);

    public void publishProperty(SchemaProperty var1, User var2, String var3);

    public void setIconProperty(Concept var1, File var2, String var3, String var4, User var5, Authorizations var6) throws IOException;

    public Map<String, String> getVisibleProperties(String[] var1);

    public Authorizations getAuthorizations();

    public void getOrCreateInverseOfRelationship(Relationship var1, Relationship var2);

    public void removeInverseOfRelationship(Relationship var1, Relationship var2);

    public static class ElementTypeFilter
    implements ClientApiObject {
        public String iri;
        public boolean includeChildNodes;

        public ElementTypeFilter() {
        }

        public ElementTypeFilter(String iri, boolean includeChildNodes) {
            this.iri = iri;
            this.includeChildNodes = includeChildNodes;
        }
    }
}

