/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.cache.CacheOptions;
import com.mware.core.cache.CacheService;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcAccessDeniedException;
import com.mware.core.exception.BcException;
import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.model.clientapi.dto.ClientApiSchema;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.clientapi.dto.UserType;
import com.mware.core.model.clientapi.dto.WorkspaceAccess;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.properties.types.BcProperty;
import com.mware.core.model.properties.types.BcPropertyBase;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.DefaultSchemaCreator;
import com.mware.core.model.schema.ExtendedDataTableProperty;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.Schema;
import com.mware.core.model.schema.SchemaElement;
import com.mware.core.model.schema.SchemaFactory;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaPropertyDefinition;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.user.PrivilegeRepository;
import com.mware.core.model.workspace.WorkspaceRepository;
import com.mware.core.model.workspace.WorkspaceUser;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ExecutorServiceUtil;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.DefinePropertyBuilder;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.TextIndexHint;
import com.mware.ge.query.GraphQuery;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.StringUtil;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DefaultStreamingPropertyValue;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.Value;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SchemaRepositoryBase
implements SchemaRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SchemaRepositoryBase.class);
    private static final String ONTOLOGY_CACHE_NAME = SchemaRepository.class.getName() + ".ontology";
    private static final String ONTOLOGY_VISIBLEPROPS_CACHE_NAME = SchemaRepository.class.getName() + ".ontologyVisibleProps";
    private static final String CONFIG_ONTOLOGY_CACHE_MAX_SIZE = SchemaRepository.class.getName() + "ontologyCache.maxSize";
    private static final long CONFIG_ONTOLOGY_CACHE_MAX_SIZE_DEFAULT = 1000L;
    public static final String TOP_OBJECT_PROPERTY_NAME = "topObjectProperty";
    public static final int MAX_DISPLAY_NAME = 50;
    private final Configuration configuration;
    private final CacheService cacheService;
    private final CacheOptions ontologyCacheOptions;
    private PrivilegeRepository privilegeRepository;
    private WorkspaceRepository workspaceRepository;
    protected Authorizations authorizations;
    private final Graph graph;

    @Inject
    protected SchemaRepositoryBase(Configuration configuration, Graph graph, CacheService cacheService) {
        this.configuration = configuration;
        this.cacheService = cacheService;
        this.ontologyCacheOptions = new CacheOptions().setMaximumSize(configuration.getLong(CONFIG_ONTOLOGY_CACHE_MAX_SIZE, 1000L)).setExpireAfterWrite(new Long(5L));
        this.graph = graph;
    }

    public void loadOntologies() throws Exception {
        if (this.getThingConcept() == null) {
            Boolean simpleSchema = (Boolean)this.cacheService.getIfPresent("__cypherAcceptance", "simpleSchema");
            new DefaultSchemaCreator(this, simpleSchema != null ? simpleSchema : false).createOntology();
            this.clearCache();
        }
        new SchemaFactory(this).applyContributions(this.configuration);
    }

    @Override
    public Relationship getOrCreateRootRelationship(Authorizations authorizations) {
        User user = this.getSystemUser();
        Relationship topObjectProperty = this.internalGetOrCreateRelationshipType(null, Collections.emptyList(), Collections.emptyList(), TOP_OBJECT_PROPERTY_NAME, null, true, true, user, "public-ontology");
        if (topObjectProperty.getUserVisible()) {
            topObjectProperty.setProperty(SchemaProperties.USER_VISIBLE.getPropertyName(), BooleanValue.FALSE, user, authorizations);
        }
        return topObjectProperty;
    }

    public void addEntityGlyphIconToEntityConcept(Concept entityConcept, byte[] rawImg, boolean shouldFlush) {
        DefaultStreamingPropertyValue raw = new DefaultStreamingPropertyValue(new ByteArrayInputStream(rawImg), ByteArray.class);
        raw.searchIndex(false);
        entityConcept.setProperty(SchemaProperties.GLYPH_ICON.getPropertyName(), raw, this.getSystemUser(), this.getAuthorizations());
        if (shouldFlush) {
            this.graph.flush();
        }
    }

    @Override
    public void setIconProperty(Concept concept, File inDir, String glyphIconFileName, String propertyKey, User user, Authorizations authorizations) throws IOException {
        if (glyphIconFileName != null) {
            File iconFile = new File(inDir, glyphIconFileName);
            if (!iconFile.exists()) {
                throw new RuntimeException("Could not find icon file: " + iconFile.toString());
            }
            try (FileInputStream iconFileIn = new FileInputStream(iconFile);){
                DefaultStreamingPropertyValue value = new DefaultStreamingPropertyValue(iconFileIn, ByteArray.class);
                value.searchIndex(false);
                concept.setProperty(propertyKey, value, user, authorizations);
            }
        }
    }

    @Override
    public SchemaProperty getOrCreateProperty(SchemaPropertyDefinition schemaPropertyDefinition, User user, String namespace) {
        this.checkPrivileges(user, namespace);
        SchemaProperty property = this.getPropertyByName(schemaPropertyDefinition.getPropertyName(), namespace);
        if (property != null) {
            return property;
        }
        return this.addPropertyTo(schemaPropertyDefinition.getConcepts(), schemaPropertyDefinition.getRelationships(), schemaPropertyDefinition.getExtendedDataTableNames(), schemaPropertyDefinition.getPropertyName(), schemaPropertyDefinition.getDisplayName(), schemaPropertyDefinition.getDataType(), schemaPropertyDefinition.getPossibleValues(), schemaPropertyDefinition.getTextIndexHints(), schemaPropertyDefinition.isUserVisible(), schemaPropertyDefinition.isSearchFacet(), schemaPropertyDefinition.isSystemProperty(), schemaPropertyDefinition.getAggType(), schemaPropertyDefinition.getAggPrecision(), schemaPropertyDefinition.getAggInterval(), schemaPropertyDefinition.getAggMinDocumentCount(), schemaPropertyDefinition.getAggTimeZone(), schemaPropertyDefinition.getAggCalendarField(), schemaPropertyDefinition.isSearchable(), schemaPropertyDefinition.isAddable(), schemaPropertyDefinition.isSortable(), schemaPropertyDefinition.getSortPriority(), schemaPropertyDefinition.getDisplayType(), schemaPropertyDefinition.getPropertyGroup(), schemaPropertyDefinition.getBoost(), schemaPropertyDefinition.getValidationFormula(), schemaPropertyDefinition.getDisplayFormula(), schemaPropertyDefinition.getDependentPropertyNames(), schemaPropertyDefinition.getIntents(), schemaPropertyDefinition.getDeleteable(), schemaPropertyDefinition.getUpdateable(), user, namespace);
    }

    protected abstract SchemaProperty addPropertyTo(List<Concept> var1, List<Relationship> var2, List<String> var3, String var4, String var5, PropertyType var6, Map<String, String> var7, Collection<TextIndexHint> var8, boolean var9, boolean var10, boolean var11, String var12, int var13, String var14, long var15, String var17, String var18, boolean var19, boolean var20, boolean var21, Integer var22, String var23, String var24, Double var25, String var26, String var27, ImmutableList<String> var28, String[] var29, boolean var30, boolean var31, User var32, String var33);

    @Override
    public Set<Concept> getConceptAndAllChildrenByName(String conceptName, String namespace) {
        Concept concept = this.getConceptByName(conceptName, namespace);
        if (concept == null) {
            return null;
        }
        return this.getConceptAndAllChildren(concept, namespace);
    }

    @Override
    public Set<Concept> getConceptAndAllChildren(Concept concept, String namespace) {
        List<Concept> childConcepts = this.getChildConcepts(concept, namespace);
        HashSet result = Sets.newHashSet((Object[])new Concept[]{concept});
        if (childConcepts.size() > 0) {
            ArrayList<Concept> childrenList = new ArrayList<Concept>();
            for (Concept childConcept : childConcepts) {
                Set<Concept> child = this.getConceptAndAllChildren(childConcept, namespace);
                childrenList.addAll(child);
            }
            result.addAll(childrenList);
        }
        return result;
    }

    @Override
    public Set<Concept> getAncestorConcepts(Concept concept, String namespace) {
        HashSet result = Sets.newHashSet();
        Concept parentConcept = this.getParentConcept(concept, namespace);
        while (parentConcept != null) {
            result.add(parentConcept);
            parentConcept = this.getParentConcept(parentConcept, namespace);
        }
        return result;
    }

    @Override
    public Set<Concept> getConceptAndAncestors(Concept concept, String namespace) {
        HashSet result = Sets.newHashSet((Object[])new Concept[]{concept});
        result.addAll(this.getAncestorConcepts(concept, namespace));
        return result;
    }

    @Override
    public abstract List<Concept> getChildConcepts(Concept var1, String var2);

    @Override
    public Set<Relationship> getRelationshipAndAllChildrenByName(String relationshipName, String namespace) {
        Relationship relationship = this.getRelationshipByName(relationshipName, namespace);
        return this.getRelationshipAndAllChildren(relationship, namespace);
    }

    @Override
    public Set<Relationship> getRelationshipAndAllChildren(Relationship relationship, String namespace) {
        List<Relationship> childRelationships = this.getChildRelationships(relationship, namespace);
        HashSet result = Sets.newHashSet((Object[])new Relationship[]{relationship});
        if (childRelationships.size() > 0) {
            ArrayList<Relationship> childrenList = new ArrayList<Relationship>();
            for (Relationship childRelationship : childRelationships) {
                Set<Relationship> child = this.getRelationshipAndAllChildren(childRelationship, namespace);
                childrenList.addAll(child);
            }
            result.addAll(childrenList);
        }
        return result;
    }

    @Override
    public Set<Relationship> getAncestorRelationships(Relationship relationship, String namespace) {
        HashSet result = Sets.newHashSet();
        Relationship parentRelationship = this.getParentRelationship(relationship, namespace);
        while (parentRelationship != null) {
            result.add(parentRelationship);
            parentRelationship = this.getParentRelationship(parentRelationship, namespace);
        }
        return result;
    }

    @Override
    public Set<Relationship> getRelationshipAndAncestors(Relationship relationship, String namespace) {
        HashSet result = Sets.newHashSet((Object[])new Relationship[]{relationship});
        result.addAll(this.getAncestorRelationships(relationship, namespace));
        return result;
    }

    @Override
    public boolean hasRelationshipByName(String relationshipName, String namespace) {
        return this.getRelationshipByName(relationshipName, namespace) != null;
    }

    protected abstract List<Relationship> getChildRelationships(Relationship var1, String var2);

    @Override
    public void resolvePropertyIds(JSONArray filterJson, String namespace) throws JSONException {
        for (int i = 0; i < filterJson.length(); ++i) {
            JSONObject filter = filterJson.getJSONObject(i);
            if (!filter.has("propertyId") || filter.has("propertyName")) continue;
            String propertyVertexId = filter.getString("propertyId");
            SchemaProperty property = this.getPropertyByName(propertyVertexId, namespace);
            if (property == null) {
                throw new RuntimeException("Could not find property with id: " + propertyVertexId);
            }
            filter.put("propertyName", (Object)property.getName());
            filter.put("propertyDataType", (Object)property.getDataType());
        }
    }

    @Override
    public Concept getConceptByName(String conceptName, String namespace) {
        return (Concept)Iterables.getFirst(this.getConceptsByName(Collections.singletonList(conceptName), namespace), null);
    }

    @Override
    public Iterable<Concept> getConceptsByName(List<String> conceptNames, String namespace) {
        return StreamSupport.stream(this.getConceptsWithProperties(namespace).spliterator(), false).filter(concept -> conceptNames.contains(concept.getName())).collect(Collectors.toSet());
    }

    @Override
    public boolean hasConceptByName(String conceptName, String namespace) {
        return this.getConceptByName(conceptName, namespace) != null;
    }

    @Override
    public SchemaProperty getPropertyByName(String propertyName, String namespace) {
        return (SchemaProperty)Iterables.getFirst(this.getPropertiesByName(Collections.singletonList(propertyName), namespace), null);
    }

    @Override
    public Iterable<SchemaProperty> getPropertiesByName(List<String> propertyNames, String namespace) {
        return StreamSupport.stream(this.getProperties(namespace).spliterator(), false).filter(property -> propertyNames.contains(property.getName())).collect(Collectors.toList());
    }

    @Override
    public SchemaProperty getRequiredPropertyByName(String propertyName, String namespace) {
        SchemaProperty property = this.getPropertyByName(propertyName, namespace);
        if (property == null) {
            throw new BcException("Could not find property by name: " + propertyName);
        }
        return property;
    }

    @Override
    public Relationship getRelationshipByName(String relationshipName, String namespace) {
        return (Relationship)Iterables.getFirst(this.getRelationshipsByName(Collections.singletonList(relationshipName), namespace), null);
    }

    @Override
    public Iterable<Relationship> getRelationshipsByName(List<String> relationshipNames, String namespace) {
        return StreamSupport.stream(this.getRelationships(namespace).spliterator(), false).filter(relationship -> relationshipNames.contains(relationship.getName())).collect(Collectors.toList());
    }

    @Override
    public Concept getConceptByIntent(String intent, String namespace) {
        String configurationKey = "ontology.intent.concept." + intent;
        String conceptName = this.getConfiguration().get(configurationKey, null);
        if (conceptName != null) {
            Concept concept = this.getConceptByName(conceptName, namespace);
            if (concept == null) {
                throw new BcException("Could not find concept by configuration key: " + configurationKey);
            }
            return concept;
        }
        List<Concept> concepts = this.findLoadedConceptsByIntent(intent, namespace);
        if (concepts.size() == 0) {
            return null;
        }
        if (concepts.size() == 1) {
            return concepts.get(0);
        }
        String names = Joiner.on((char)',').join((Iterable)new ConvertingIterable<Concept, String>(concepts){

            @Override
            protected String convert(Concept o) {
                return o.getName();
            }
        });
        throw new BcException("Found multiple concepts for intent: " + intent + " (" + names + ")");
    }

    @Override
    public String getConceptNameByIntent(String intent, String namespace) {
        Concept concept = this.getConceptByIntent(intent, namespace);
        if (concept != null) {
            return concept.getName();
        }
        return null;
    }

    @Override
    public Concept getRequiredConceptByIntent(String intent, String namespace) {
        Concept concept = this.getConceptByIntent(intent, namespace);
        if (concept == null) {
            throw new BcException("Could not find concept by intent: " + intent);
        }
        return concept;
    }

    @Override
    public String getRequiredConceptNameByIntent(String intent, String namespace) {
        return this.getRequiredConceptByIntent(intent, namespace).getName();
    }

    @Override
    public Concept getRequiredConceptByName(String name, String namespace) {
        Concept concept = this.getConceptByName(name, namespace);
        if (concept == null) {
            throw new BcException("Could not find concept by name: " + name);
        }
        return concept;
    }

    @Override
    public String generateDynamicName(Class type, String displayName, String namespace, String ... extended) {
        displayName = displayName.trim().replaceAll("\\s+", "_").toLowerCase();
        displayName = StringUtil.toCamelCase(displayName);
        displayName = displayName.substring(0, Math.min(displayName.length(), 50));
        String typeId = type.toString() + namespace + displayName;
        if (extended != null && extended.length > 0) {
            typeId = typeId + Joiner.on((String)"").join((Object[])extended);
        }
        return displayName.replaceAll("[^a-zA-Z0-9_]", "") + "#" + Hashing.sha1().hashString((CharSequence)typeId, StandardCharsets.UTF_8).toString();
    }

    @Override
    public String generatePropertyDynamicName(Class type, String displayName, String namespace, String prefix) {
        displayName = prefix + "_" + StringUtil.toCamelCase(displayName);
        displayName = displayName.substring(0, Math.min(displayName.length(), 50));
        return displayName.replaceAll("[^a-zA-Z0-9_]", "");
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptName, String displayName, User user, String namespace) {
        return this.getOrCreateConcept(parent, conceptName, displayName, null, null, user, namespace);
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptName, String displayName, String glyphIconHref, String color, User user, String namespace) {
        return this.getOrCreateConcept(parent, conceptName, displayName, glyphIconHref, color, true, false, user, namespace);
    }

    @Override
    @Deprecated
    public final Concept getOrCreateConcept(Concept parent, String conceptName, String displayName, boolean deleteChangeableProperties, boolean isCoreConcept) {
        return this.getOrCreateConcept(parent, conceptName, displayName, deleteChangeableProperties, isCoreConcept, null, "public-ontology");
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptName, String displayName, boolean deleteChangeableProperties, boolean isCoreConcept, User user, String namespace) {
        this.checkPrivileges(user, namespace);
        return this.internalGetOrCreateConcept(parent, conceptName, displayName, null, null, deleteChangeableProperties, isCoreConcept, user, namespace);
    }

    @Override
    public final Concept getOrCreateConcept(Concept parent, String conceptName, String displayName, String glyphIconHref, String color, boolean deleteChangeableProperties, boolean isCoreConcept, User user, String namespace) {
        this.checkPrivileges(user, namespace);
        return this.internalGetOrCreateConcept(parent, conceptName, displayName, glyphIconHref, color, deleteChangeableProperties, isCoreConcept, user, namespace);
    }

    protected abstract Concept internalGetOrCreateConcept(Concept var1, String var2, String var3, String var4, String var5, boolean var6, boolean var7, User var8, String var9);

    @Override
    public final Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipName, boolean isDeclaredInOntology, boolean coreConcept, User user, String namespace) {
        return this.getOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipName, null, isDeclaredInOntology, coreConcept, user, namespace);
    }

    @Override
    public final Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipName, String displayName, boolean isDeclaredInOntology, boolean coreConcept, User user, String namespace) {
        this.checkPrivileges(user, namespace);
        if (parent == null && !relationshipName.equals(TOP_OBJECT_PROPERTY_NAME)) {
            parent = this.getTopObjectPropertyRelationship(namespace);
        }
        return this.internalGetOrCreateRelationshipType(parent, domainConcepts, rangeConcepts, relationshipName, displayName, isDeclaredInOntology, coreConcept, user, namespace);
    }

    protected abstract Relationship internalGetOrCreateRelationshipType(Relationship var1, Iterable<Concept> var2, Iterable<Concept> var3, String var4, String var5, boolean var6, boolean var7, User var8, String var9);

    @Override
    public Relationship getRelationshipByIntent(String intent, String namespace) {
        String configurationKey = "ontology.intent.relationship." + intent;
        String relationshipName = this.getConfiguration().get(configurationKey, null);
        if (relationshipName != null) {
            Relationship relationship = this.getRelationshipByName(relationshipName, namespace);
            if (relationship == null) {
                throw new BcException("Could not find relationship by configuration key: " + configurationKey);
            }
            return relationship;
        }
        List<Relationship> relationships = this.findLoadedRelationshipsByIntent(intent, namespace);
        if (relationships.size() == 0) {
            return null;
        }
        if (relationships.size() == 1) {
            return relationships.get(0);
        }
        String names = Joiner.on((char)',').join((Iterable)new ConvertingIterable<Relationship, String>(relationships){

            @Override
            protected String convert(Relationship o) {
                return o.getName();
            }
        });
        throw new BcException("Found multiple relationships for intent: " + intent + " (" + names + ")");
    }

    @Override
    public String getRelationshipNameByIntent(String intent, String namespace) {
        Relationship relationship = this.getRelationshipByIntent(intent, namespace);
        if (relationship != null) {
            return relationship.getName();
        }
        return null;
    }

    @Override
    public Relationship getRequiredRelationshipByIntent(String intent, String namespace) {
        Relationship relationship = this.getRelationshipByIntent(intent, namespace);
        if (relationship == null) {
            throw new BcException("Could not find relationship by intent: " + intent);
        }
        return relationship;
    }

    @Override
    public String getRequiredRelationshipNameByIntent(String intent, String namespace) {
        return this.getRequiredRelationshipByIntent(intent, namespace).getName();
    }

    @Override
    public SchemaProperty getPropertyByIntent(String intent, String namespace) {
        String configurationKey = "ontology.intent.property." + intent;
        String propertyName = this.getConfiguration().get(configurationKey, null);
        if (propertyName != null) {
            SchemaProperty property = this.getPropertyByName(propertyName, namespace);
            if (property == null) {
                throw new BcException("Could not find property by configuration key: " + configurationKey);
            }
            return property;
        }
        List<SchemaProperty> properties = this.getPropertiesByIntent(intent, namespace);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return properties.get(0);
        }
        String names = Joiner.on((char)',').join((Iterable)new ConvertingIterable<SchemaProperty, String>(properties){

            @Override
            protected String convert(SchemaProperty o) {
                return o.getName();
            }
        });
        throw new BcException("Found multiple properties for intent: " + intent + " (" + names + ")");
    }

    @Override
    public String getPropertyNameByIntent(String intent, String namespace) {
        SchemaProperty prop = this.getPropertyByIntent(intent, namespace);
        if (prop != null) {
            return prop.getName();
        }
        return null;
    }

    @Override
    public SchemaProperty getRequiredPropertyByIntent(String intent, String namespace) {
        SchemaProperty property = this.getPropertyByIntent(intent, namespace);
        if (property == null) {
            throw new BcException("Could not find property by intent: " + intent);
        }
        return property;
    }

    @Override
    public String getRequiredPropertyNameByIntent(String intent, String namespace) {
        return this.getRequiredPropertyByIntent(intent, namespace).getName();
    }

    @Override
    public SchemaProperty getDependentPropertyParent(String name, String namespace) {
        for (SchemaProperty property : this.getProperties(namespace)) {
            if (!property.getDependentPropertyNames().contains((Object)name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public <T extends BcProperty> T getPropertyByIntent(String intent, Class<T> propertyType, String namespace) {
        String propertyName = this.getPropertyNameByIntent(intent, namespace);
        if (propertyName == null) {
            LOGGER.warn("No property found for intent: %s", intent);
            return null;
        }
        try {
            Constructor<T> constructor = propertyType.getConstructor(String.class);
            return (T)((BcProperty)constructor.newInstance(propertyName));
        }
        catch (Exception ex) {
            throw new BcException("Could not create property for intent: " + intent + " (propertyName: " + propertyName + ")");
        }
    }

    @Override
    public <T extends BcProperty> T getRequiredPropertyByIntent(String intent, Class<T> propertyType, String namespace) {
        T result = this.getPropertyByIntent(intent, propertyType, namespace);
        if (result == null) {
            throw new BcException("Could not find property by intent: " + intent);
        }
        return result;
    }

    @Override
    public List<SchemaProperty> getPropertiesByIntent(String intent, String namespace) {
        ArrayList<SchemaProperty> results = new ArrayList<SchemaProperty>();
        for (SchemaProperty property : this.getProperties(namespace)) {
            String[] propertyIntents = property.getIntents();
            if (!Arrays.asList(propertyIntents).contains(intent)) continue;
            results.add(property);
        }
        return results;
    }

    @Override
    public ClientApiSchema getClientApiObject(String namespace) {
        Schema schema = this.getOntology(namespace);
        T[] results = ExecutorServiceUtil.runAllAndWait(() -> Concept.toClientApiConcepts(schema.getConcepts()), () -> SchemaProperty.toClientApiProperties(schema.getProperties()), () -> Relationship.toClientApiRelationships(schema.getRelationships()));
        ClientApiSchema clientOntology = new ClientApiSchema();
        clientOntology.addAllConcepts((Collection)results[0]);
        clientOntology.addAllProperties((Collection)results[1]);
        clientOntology.addAllRelationships((Collection)results[2]);
        return clientOntology;
    }

    @Override
    public Schema getOntology(String namespace) {
        if (namespace == null) {
            return this.getOntology("public-ontology");
        }
        Schema schema = (Schema)this.cacheService.getIfPresent(ONTOLOGY_CACHE_NAME, namespace);
        if (schema != null) {
            return schema;
        }
        T[] results = ExecutorServiceUtil.runAllAndWait(() -> this.getConceptsWithProperties(namespace), () -> this.getRelationships(namespace), () -> this.getProperties(namespace));
        Iterable concepts = (Iterable)results[0];
        Iterable relationships = (Iterable)results[1];
        Map<String, SchemaProperty> properties = StreamUtil.stream((Iterable)results[2]).collect(Collectors.toMap(SchemaProperty::getName, p -> p));
        List<ExtendedDataTableProperty> extendedDataTables = properties.values().stream().filter(p -> p instanceof ExtendedDataTableProperty).map(p -> (ExtendedDataTableProperty)((Object)p)).collect(Collectors.toList());
        schema = new Schema(concepts, relationships, extendedDataTables, properties, namespace);
        this.cacheService.put(ONTOLOGY_CACHE_NAME, namespace, schema, this.ontologyCacheOptions);
        return schema;
    }

    protected Relationship getTopObjectPropertyRelationship(String namespace) {
        return this.getRelationshipByName(TOP_OBJECT_PROPERTY_NAME, namespace);
    }

    @Override
    public void clearCache() {
        this.cacheService.invalidate(ONTOLOGY_CACHE_NAME);
        this.cacheService.invalidate(ONTOLOGY_VISIBLEPROPS_CACHE_NAME);
    }

    @Override
    public void clearCache(String namespace) {
        this.cacheService.invalidate(ONTOLOGY_CACHE_NAME, namespace);
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    protected void defineRequiredProperties(Graph graph) {
        this.definePropertyOnGraph(graph, BcSchema.MODIFIED_BY.getPropertyName(), StringValue.class, EnumSet.of(TextIndexHint.EXACT_MATCH), null, true);
        this.definePropertyOnGraph(graph, BcSchema.MODIFIED_DATE.getPropertyName(), DateTimeValue.class, TextIndexHint.NONE, null, true);
        this.definePropertyOnGraph(graph, BcSchema.VISIBILITY_JSON, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.ONTOLOGY_TITLE, StringValue.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, SchemaProperties.DISPLAY_NAME, StringValue.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, SchemaProperties.DISPLAY_TYPE, StringValue.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, SchemaProperties.INTENT, StringValue.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, SchemaProperties.TITLE_FORMULA, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.SUBTITLE_FORMULA, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.DISPLAY_FORMULA, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.TIME_FORMULA, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.GLYPH_ICON, ByteArray.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.MAP_GLYPH_ICON, ByteArray.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.GLYPH_ICON_FILE_NAME, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.DATA_TYPE, StringValue.class, EnumSet.of(TextIndexHint.EXACT_MATCH));
        this.definePropertyOnGraph(graph, SchemaProperties.USER_VISIBLE, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.SEARCHABLE, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.SEARCH_FACET, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.SYSTEM_PROPERTY, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.SORTABLE, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.ADDABLE, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.DELETEABLE, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.UPDATEABLE, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.TEXT_INDEX_HINTS, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.AGG_TYPE, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.CORE_CONCEPT, BooleanValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.COLOR, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.POSSIBLE_VALUES, StringValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.AGG_MIN_DOCUMENT_COUNT, LongValue.class, TextIndexHint.NONE);
        this.definePropertyOnGraph(graph, SchemaProperties.DEPENDENT_PROPERTY_ORDER_PROPERTY_NAME, IntValue.class, TextIndexHint.NONE);
    }

    protected void definePropertyOnGraph(Graph graph, BcPropertyBase<?> property, Class<? extends Value> dataType, Set<TextIndexHint> textIndexHint) {
        this.definePropertyOnGraph(graph, property.getPropertyName(), dataType, textIndexHint, null, false);
    }

    protected void definePropertyOnGraph(Graph graph, String propertyName, Class<? extends Value> dataType, Collection<TextIndexHint> textIndexHint, Double boost, boolean sortable) {
        if (!graph.isPropertyDefined(propertyName)) {
            DefinePropertyBuilder builder = graph.defineProperty(propertyName).dataType(dataType).sortable(sortable);
            if (textIndexHint != null) {
                builder.textIndexHint(textIndexHint);
            }
            if (boost != null) {
                if (graph.isFieldBoostSupported()) {
                    builder.boost(boost);
                } else {
                    LOGGER.warn("Field boosting is not support by the graph", new Object[0]);
                }
            }
            builder.define();
        } else {
            PropertyDefinition propertyDefinition = graph.getPropertyDefinition(propertyName);
            if (propertyDefinition.getDataType() != dataType) {
                LOGGER.warn("Ontology property type mismatch for property %s! Expected %s but found %s", propertyName, dataType.getName(), propertyDefinition.getDataType().getName());
            }
        }
    }

    protected boolean determineSearchable(String propertyNames, PropertyType dataType, Collection<TextIndexHint> textIndexHints, boolean searchable) {
        if (dataType == PropertyType.EXTENDED_DATA_TABLE) {
            return false;
        }
        if (dataType == PropertyType.STRING) {
            Preconditions.checkNotNull(textIndexHints, (Object)"textIndexHints are required for string properties");
            if (searchable && (textIndexHints.isEmpty() || textIndexHints.equals(TextIndexHint.NONE))) {
                searchable = false;
            } else if (!(searchable || textIndexHints.isEmpty() && textIndexHints.equals(TextIndexHint.NONE))) {
                LOGGER.info("textIndexHints was specified for non-UI-searchable string property:: " + propertyNames, new Object[0]);
            }
        }
        return searchable;
    }

    protected abstract Graph getGraph();

    protected abstract void internalDeleteConcept(Concept var1, String var2);

    protected abstract void internalDeleteProperty(SchemaProperty var1, String var2);

    protected abstract void internalDeleteRelationship(Relationship var1, String var2);

    @Override
    public void deleteConcept(String conceptTypeName, User user, String namespace) {
        this.checkDeletePrivileges(user, namespace);
        Set<Concept> concepts = this.getConceptAndAllChildrenByName(conceptTypeName, namespace);
        if (concepts.size() == 1) {
            for (Concept concept : concepts) {
                for (Relationship relationship : this.getRelationships(namespace)) {
                    if (!relationship.getSourceConceptNames().contains(conceptTypeName) && !relationship.getTargetConceptNames().contains(conceptTypeName)) continue;
                    throw new BcException("Unable to delete concept that is used in domain/range of relationship");
                }
                Graph graph = this.getGraph();
                Authorizations authorizations = graph.createAuthorizations(namespace);
                GraphQuery query = graph.query(authorizations);
                this.addConceptTypeFilterToQuery(query, concept.getName(), false, namespace);
                query.limit(0);
                QueryResultsIterable<? extends GeObject> resultsIterable = query.search();
                long results = resultsIterable.getTotalHits();
                this.safeClose(resultsIterable);
                if (results == 0L) {
                    List removeProperties = concept.getProperties().stream().filter(ontologyProperty -> ontologyProperty.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE) && ontologyProperty.getRelationshipNames().size() == 0 && ontologyProperty.getConceptNames().size() == 1 && ontologyProperty.getConceptNames().get(0).equals(conceptTypeName)).collect(Collectors.toList());
                    this.internalDeleteConcept(concept, namespace);
                    for (SchemaProperty property : removeProperties) {
                        this.internalDeleteProperty(property, namespace);
                    }
                    continue;
                }
                throw new BcException("Unable to delete concept that have vertices assigned to it");
            }
        } else {
            throw new BcException("Unable to delete concept that have children");
        }
        this.clearCache();
    }

    private void safeClose(QueryResultsIterable iterable) {
        if (iterable == null) {
            return;
        }
        try {
            iterable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteProperty(String propertyName, User user, String namespace) {
        this.checkDeletePrivileges(user, namespace);
        SchemaProperty property = this.getPropertyByName(propertyName, namespace);
        if (property != null) {
            Graph graph = this.getGraph();
            Authorizations authorizations = graph.createAuthorizations(namespace);
            GraphQuery query = graph.query(authorizations);
            query.has(propertyName);
            query.limit(0);
            QueryResultsIterable<? extends GeObject> resultsIterable = query.search();
            long results = resultsIterable.getTotalHits();
            this.safeClose(resultsIterable);
            if (results != 0L) {
                throw new BcException("Unable to delete property that have elements using it");
            }
        } else {
            throw new BcResourceNotFoundException("Property not found");
        }
        this.internalDeleteProperty(property, namespace);
        this.clearCache();
    }

    @Override
    public void deleteRelationship(String relationshipName, User user, String namespace) {
        this.checkDeletePrivileges(user, namespace);
        Set<Relationship> relationships = this.getRelationshipAndAllChildrenByName(relationshipName, namespace);
        if (relationships.size() == 1) {
            for (Relationship relationship : relationships) {
                Graph graph = this.getGraph();
                Authorizations authorizations = graph.createAuthorizations(namespace);
                GraphQuery query = graph.query(authorizations);
                this.addEdgeLabelFilterToQuery(query, relationshipName, false, namespace);
                query.limit(0);
                QueryResultsIterable<? extends GeObject> resultsIterable = query.search();
                long results = resultsIterable.getTotalHits();
                this.safeClose(resultsIterable);
                if (results == 0L) {
                    List removeProperties = relationship.getProperties().stream().filter(ontologyProperty -> ontologyProperty.getSandboxStatus().equals((Object)SandboxStatus.PRIVATE) && ontologyProperty.getConceptNames().size() == 0 && ontologyProperty.getRelationshipNames().size() == 1 && ontologyProperty.getRelationshipNames().get(0).equals(relationshipName)).collect(Collectors.toList());
                    this.internalDeleteRelationship(relationship, namespace);
                    for (SchemaProperty property : removeProperties) {
                        this.internalDeleteProperty(property, namespace);
                    }
                    continue;
                }
                throw new BcException("Unable to delete relationship that have edges using it");
            }
        } else {
            throw new BcException("Unable to delete relationship that have children");
        }
        this.clearCache();
    }

    @Override
    public void addConceptTypeFilterToQuery(Query query, String conceptName, boolean includeChildNodes, String namespace) {
        Preconditions.checkNotNull((Object)conceptName, (Object)"conceptName cannot be null");
        ArrayList<SchemaRepository.ElementTypeFilter> filters = new ArrayList<SchemaRepository.ElementTypeFilter>();
        filters.add(new SchemaRepository.ElementTypeFilter(conceptName, includeChildNodes));
        this.addConceptTypeFilterToQuery(query, filters, namespace);
    }

    @Override
    public void addConceptTypeFilterToQuery(Query query, Collection<SchemaRepository.ElementTypeFilter> filters, String namespace) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        Preconditions.checkNotNull(filters, (Object)"filters cannot be null");
        if (filters.isEmpty()) {
            return;
        }
        HashSet<String> conceptIds = new HashSet<String>(filters.size());
        for (SchemaRepository.ElementTypeFilter filter : filters) {
            Concept concept = this.getConceptByName(filter.iri, namespace);
            Preconditions.checkNotNull((Object)concept, (Object)("Could not find concept with name: " + filter.iri));
            conceptIds.add(concept.getName());
            if (!filter.includeChildNodes) continue;
            Set<Concept> childConcepts = this.getConceptAndAllChildren(concept, namespace);
            conceptIds.addAll(childConcepts.stream().map(Concept::getName).collect(Collectors.toSet()));
        }
        query.hasConceptType(conceptIds);
    }

    @Override
    public void addEdgeLabelFilterToQuery(Query query, String edgeLabel, boolean includeChildNodes, String namespace) {
        Preconditions.checkNotNull((Object)edgeLabel, (Object)"edgeLabel cannot be null");
        ArrayList<SchemaRepository.ElementTypeFilter> filters = new ArrayList<SchemaRepository.ElementTypeFilter>();
        filters.add(new SchemaRepository.ElementTypeFilter(edgeLabel, includeChildNodes));
        this.addEdgeLabelFilterToQuery(query, filters, namespace);
    }

    @Override
    public void addEdgeLabelFilterToQuery(Query query, Collection<SchemaRepository.ElementTypeFilter> filters, String namespace) {
        Preconditions.checkNotNull(filters, (Object)"filters cannot be null");
        if (filters.isEmpty()) {
            return;
        }
        HashSet<String> edgeIds = new HashSet<String>(filters.size());
        for (SchemaRepository.ElementTypeFilter filter : filters) {
            Relationship relationship = this.getRelationshipByName(filter.iri, namespace);
            Preconditions.checkNotNull((Object)relationship, (Object)("Could not find edge with name: " + filter.iri));
            edgeIds.add(relationship.getName());
            if (!filter.includeChildNodes) continue;
            Set<Relationship> childRelations = this.getRelationshipAndAllChildren(relationship, namespace);
            edgeIds.addAll(childRelations.stream().map(Relationship::getName).collect(Collectors.toSet()));
        }
        query.hasEdgeLabel(edgeIds);
    }

    @Override
    public final void publishConcept(Concept concept, User user, String namespace) {
        this.checkPrivileges(user, null);
        this.internalPublishConcept(concept, user, namespace);
    }

    public abstract void internalPublishConcept(Concept var1, User var2, String var3);

    @Override
    public final void publishRelationship(Relationship relationship, User user, String namespace) {
        this.checkPrivileges(user, null);
        this.internalPublishRelationship(relationship, user, namespace);
    }

    public abstract void internalPublishRelationship(Relationship var1, User var2, String var3);

    @Override
    public void publishProperty(SchemaProperty property, User user, String namespace) {
        this.checkPrivileges(user, null);
        this.internalPublishProperty(property, user, namespace);
    }

    public abstract void internalPublishProperty(SchemaProperty var1, User var2, String var3);

    protected void checkPrivileges(User user, String namespace) {
        if (user != null && user.getUserType() == UserType.SYSTEM) {
            return;
        }
        if (user == null) {
            throw new BcAccessDeniedException("You must provide a valid user to perform this action", null, null);
        }
        if (this.isPublic(namespace)) {
            if (!this.getPrivilegeRepository().hasPrivilege(user, "ONTOLOGY_PUBLISH")) {
                throw new BcAccessDeniedException("User does not have ONTOLOGY_PUBLISH privilege", user, null);
            }
        } else {
            List<WorkspaceUser> users = this.getWorkspaceRepository().findUsersWithAccess(namespace, user);
            boolean access = users.stream().anyMatch(workspaceUser -> workspaceUser.getUserId().equals(user.getUserId()) && workspaceUser.getWorkspaceAccess().equals((Object)WorkspaceAccess.WRITE));
            if (!access) {
                throw new BcAccessDeniedException("User does not have access to workspace", user, null);
            }
            if (!this.getPrivilegeRepository().hasPrivilege(user, "ONTOLOGY_ADD")) {
                throw new BcAccessDeniedException("User does not have ONTOLOGY_ADD privilege", user, null);
            }
        }
    }

    protected void checkDeletePrivileges(User user, String namespace) {
        if (user != null && user.getUserType() == UserType.SYSTEM) {
            return;
        }
        if (user == null) {
            throw new BcAccessDeniedException("You must provide a valid user to perform this action", null, null);
        }
        if (namespace == null) {
            throw new BcAccessDeniedException("User does not have access to delete published ontology items", user, null);
        }
        if (!this.getPrivilegeRepository().hasPrivilege(user, "ADMIN")) {
            throw new BcAccessDeniedException("User does not have admin privilege", user, null);
        }
    }

    private List<Concept> findLoadedConceptsByIntent(String intent, String namespace) {
        ArrayList<Concept> results = new ArrayList<Concept>();
        for (Concept concept : this.getConceptsWithProperties(namespace)) {
            String[] conceptIntents = concept.getIntents();
            if (!Arrays.asList(conceptIntents).contains(intent)) continue;
            results.add(concept);
        }
        return results;
    }

    private List<Relationship> findLoadedRelationshipsByIntent(String intent, String namespace) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship relationship : this.getRelationships(namespace)) {
            String[] relationshipIntents = relationship.getIntents();
            if (!Arrays.asList(relationshipIntents).contains(intent)) continue;
            results.add(relationship);
        }
        return results;
    }

    protected User getSystemUser() {
        return new SystemUser();
    }

    protected PrivilegeRepository getPrivilegeRepository() {
        if (this.privilegeRepository == null) {
            this.privilegeRepository = InjectHelper.getInstance(PrivilegeRepository.class);
        }
        return this.privilegeRepository;
    }

    protected WorkspaceRepository getWorkspaceRepository() {
        if (this.workspaceRepository == null) {
            this.workspaceRepository = InjectHelper.getInstance(WorkspaceRepository.class);
        }
        return this.workspaceRepository;
    }

    protected abstract void deleteChangeableProperties(SchemaElement var1, Authorizations var2);

    protected abstract void deleteChangeableProperties(SchemaProperty var1, Authorizations var2);

    protected boolean isPublic(String worksapceId) {
        return worksapceId == null || "public-ontology".equals(worksapceId);
    }

    protected void validateRelationship(String relationshipName, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts) {
        if (!relationshipName.equals(TOP_OBJECT_PROPERTY_NAME) && (IterableUtils.isEmpty(domainConcepts) || IterableUtils.isEmpty(rangeConcepts))) {
            throw new BcException(relationshipName + " must have at least one domain and range ");
        }
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    @Override
    public Map<String, String> getVisibleProperties(String[] keepOntologyProps) {
        HashMap<String, String> visibleProperties = (HashMap<String, String>)this.cacheService.getIfPresent(ONTOLOGY_VISIBLEPROPS_CACHE_NAME, "public-ontology");
        if (visibleProperties != null) {
            return visibleProperties;
        }
        visibleProperties = new HashMap<String, String>();
        for (SchemaProperty property : this.getOntology("public-ontology").getProperties()) {
            if (property == null) continue;
            String key = property.getName();
            String title = property.getName();
            boolean propertVisible = property.getUserVisible() || Arrays.asList(keepOntologyProps).contains(key);
            if (!propertVisible || visibleProperties.containsKey(key)) continue;
            visibleProperties.put(key, title);
        }
        this.cacheService.put(ONTOLOGY_VISIBLEPROPS_CACHE_NAME, "public-ontology", visibleProperties, this.ontologyCacheOptions);
        return visibleProperties;
    }
}

