/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema.inmemory;

import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.user.User;
import com.mware.core.util.JSONUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class InMemoryConcept
extends Concept {
    private String name;
    private String color;
    private String displayName;
    private String displayType;
    private String titleFormula;
    private String subtitleFormula;
    private String timeFormula;
    private List<String> addRelatedConceptWhiteList;
    private byte[] glyphIcon;
    private String glyphIconFilePath;
    private byte[] glyphIconSelected;
    private String glyphIconSelectedFilePath;
    private byte[] mapGlyphIcon;
    private boolean userVisible = true;
    private boolean updateable = true;
    private boolean deleteable = true;
    private boolean coreConcept = true;
    private Boolean searchable;
    private Boolean addable;
    private Map<String, String> metadata = new HashMap<String, String>();
    private Set<String> intents = new HashSet<String>();
    private String workspaceId;

    public InMemoryConcept(String conceptName, String parentName, String workspaceId) {
        super(parentName, new ArrayList<SchemaProperty>());
        this.name = conceptName;
        this.workspaceId = workspaceId;
    }

    InMemoryConcept shallowCopy() {
        InMemoryConcept other = new InMemoryConcept(this.name, this.getParentConceptName(), this.workspaceId);
        other.getProperties().addAll(this.getProperties());
        other.name = this.name;
        other.color = this.color;
        other.displayName = this.displayName;
        other.displayType = this.displayType;
        other.titleFormula = this.titleFormula;
        other.subtitleFormula = this.subtitleFormula;
        other.timeFormula = this.timeFormula;
        other.addRelatedConceptWhiteList = this.addRelatedConceptWhiteList;
        other.glyphIcon = this.glyphIcon;
        other.glyphIconFilePath = this.glyphIconFilePath;
        other.glyphIconSelected = this.glyphIconSelected;
        other.glyphIconSelectedFilePath = this.glyphIconSelectedFilePath;
        other.mapGlyphIcon = this.mapGlyphIcon;
        other.userVisible = this.userVisible;
        other.updateable = this.updateable;
        other.deleteable = this.deleteable;
        other.searchable = this.searchable;
        other.addable = this.addable;
        other.metadata.putAll(this.metadata);
        other.intents.addAll(this.intents);
        return other;
    }

    @Override
    public String[] getIntents() {
        return this.intents.toArray(new String[this.intents.size()]);
    }

    @Override
    public void addIntent(String intent, User user, Authorizations authorizations) {
        this.intents.add(intent);
    }

    @Override
    public void removeIntent(String intent, Authorizations authorizations) {
        this.intents.remove(intent);
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasGlyphIconResource() {
        return this.glyphIcon != null || this.glyphIconFilePath != null;
    }

    @Override
    public boolean hasGlyphIconSelectedResource() {
        return this.glyphIconSelected != null || this.glyphIconSelectedFilePath != null;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayType() {
        return this.displayType;
    }

    @Override
    public String getTitleFormula() {
        return this.titleFormula;
    }

    @Override
    public Boolean getSearchable() {
        return this.searchable;
    }

    @Override
    public String getSubtitleFormula() {
        return this.subtitleFormula;
    }

    @Override
    public String getTimeFormula() {
        return this.timeFormula;
    }

    @Override
    public boolean getUserVisible() {
        return this.userVisible;
    }

    @Override
    public boolean getDeleteable() {
        return this.deleteable;
    }

    @Override
    public boolean getUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean getCoreConcept() {
        return false;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public List<String> getAddRelatedConceptWhiteList() {
        return this.addRelatedConceptWhiteList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(String name, Value value, User user, Authorizations authorizations) {
        if (SchemaProperties.COLOR.getPropertyName().equals(name)) {
            this.color = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.DISPLAY_TYPE.getPropertyName().equals(name)) {
            this.displayType = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = ((BooleanValue)value).booleanValue();
            return;
        } else if (SchemaProperties.GLYPH_ICON.getPropertyName().equals(name)) {
            try {
                StreamingPropertyValue spv = (StreamingPropertyValue)value;
                if (spv == null) return;
                this.glyphIcon = IOUtils.toByteArray((InputStream)spv.getInputStream());
                return;
            }
            catch (IOException e) {
                throw new BcResourceNotFoundException("Could not retrieve glyph icon");
            }
        } else if (SchemaProperties.GLYPH_ICON_FILE_NAME.getPropertyName().equals(name)) {
            this.glyphIconFilePath = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.GLYPH_ICON_SELECTED.getPropertyName().equals(name)) {
            this.glyphIconSelected = ((ByteArray)value).asObjectCopy();
            return;
        } else if (SchemaProperties.GLYPH_ICON_SELECTED_FILE_NAME.getPropertyName().equals(name)) {
            this.glyphIconSelectedFilePath = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.MAP_GLYPH_ICON.getPropertyName().equals(name)) {
            this.mapGlyphIcon = ((ByteArray)value).asObjectCopy();
            return;
        } else if (SchemaProperties.TITLE.getPropertyName().equals(name)) {
            this.name = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = ((TextValue)value).stringValue();
            return;
        } else if (SchemaProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName().equals(name)) {
            this.addRelatedConceptWhiteList = JSONUtil.toStringList(JSONUtil.parseArray(((TextValue)value).stringValue()));
            return;
        } else if (SchemaProperties.SEARCHABLE.getPropertyName().equals(name)) {
            this.searchable = value instanceof BooleanValue ? Boolean.valueOf(((BooleanValue)value).booleanValue()) : Boolean.valueOf(Boolean.parseBoolean(((TextValue)value).stringValue()));
            return;
        } else if (SchemaProperties.ADDABLE.getPropertyName().equals(name)) {
            this.addable = value instanceof BooleanValue ? Boolean.valueOf(((BooleanValue)value).booleanValue()) : Boolean.valueOf(Boolean.parseBoolean(((TextValue)value).stringValue()));
            return;
        } else if (SchemaProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
            return;
        } else if (SchemaProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
            return;
        } else {
            if (value == null) return;
            this.metadata.put(name, value.toString());
        }
    }

    @Override
    public void removeProperty(String name, Authorizations authorizations) {
        if (SchemaProperties.COLOR.getPropertyName().equals(name)) {
            this.color = null;
        } else if (SchemaProperties.DISPLAY_TYPE.getPropertyName().equals(name)) {
            this.displayType = null;
        } else if (SchemaProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = null;
        } else if (SchemaProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = null;
        } else if (SchemaProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = null;
        } else if (SchemaProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = true;
        } else if (SchemaProperties.GLYPH_ICON.getPropertyName().equals(name)) {
            this.glyphIcon = null;
        } else if (SchemaProperties.GLYPH_ICON_FILE_NAME.getPropertyName().equals(name)) {
            this.glyphIconFilePath = null;
        } else if (SchemaProperties.GLYPH_ICON_SELECTED.getPropertyName().equals(name)) {
            this.glyphIconSelected = null;
        } else if (SchemaProperties.GLYPH_ICON_SELECTED_FILE_NAME.getPropertyName().equals(name)) {
            this.glyphIconSelectedFilePath = null;
        } else if (SchemaProperties.MAP_GLYPH_ICON.getPropertyName().equals(name)) {
            this.mapGlyphIcon = null;
        } else if (SchemaProperties.TITLE.getPropertyName().equals(name)) {
            this.name = null;
        } else if (SchemaProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = null;
        } else if (SchemaProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName().equals(name)) {
            this.addRelatedConceptWhiteList = Collections.emptyList();
        } else if (SchemaProperties.SEARCHABLE.getPropertyName().equals(name)) {
            this.searchable = null;
        } else if (SchemaProperties.ADDABLE.getPropertyName().equals(name)) {
            this.addable = null;
        } else if (SchemaProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = true;
        } else if (SchemaProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = true;
        } else if (SchemaProperties.INTENT.getPropertyName().equals(name)) {
            this.intents.clear();
        } else if (this.metadata.containsKey(name)) {
            this.metadata.remove(name);
        }
    }

    @Override
    public byte[] getGlyphIcon() {
        return this.glyphIcon;
    }

    @Override
    public byte[] getGlyphIconSelected() {
        return this.glyphIconSelected;
    }

    @Override
    public String getGlyphIconFilePath() {
        return this.glyphIconFilePath;
    }

    @Override
    public String getGlyphIconSelectedFilePath() {
        return this.glyphIconSelectedFilePath;
    }

    @Override
    public byte[] getMapGlyphIcon() {
        return this.mapGlyphIcon;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void removeWorkspaceId() {
        this.workspaceId = null;
    }

    void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return this.workspaceId == null ? SandboxStatus.PUBLIC : SandboxStatus.PRIVATE;
    }
}

