/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema.inmemory;

import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InMemoryRelationship
extends Relationship {
    private String name;
    private String displayName;
    private List<Relationship> inverseOfs = new ArrayList<Relationship>();
    private Set<String> intents = new HashSet<String>();
    private boolean userVisible = true;
    private boolean deleteable;
    private boolean updateable;
    private boolean coreConcept;
    private String titleFormula;
    private String subtitleFormula;
    private String timeFormula;
    private String workspaceId;
    private String color;
    private Map<String, String> metadata = new HashMap<String, String>();

    protected InMemoryRelationship(String parentName, String name, List<String> domainConceptNames, List<String> rangeConceptNames, Collection<SchemaProperty> properties, String workspaceId) {
        super(parentName, domainConceptNames, rangeConceptNames, properties);
        this.name = name;
        this.workspaceId = workspaceId;
    }

    InMemoryRelationship shallowCopy() {
        InMemoryRelationship other = new InMemoryRelationship(this.getParentName(), this.getName(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<SchemaProperty>(), this.workspaceId);
        other.getSourceConceptNames().addAll(this.getSourceConceptNames());
        other.getTargetConceptNames().addAll(this.getTargetConceptNames());
        other.getProperties().addAll(this.getProperties());
        other.displayName = this.displayName;
        other.inverseOfs.addAll(this.inverseOfs);
        other.intents.addAll(this.intents);
        other.userVisible = this.userVisible;
        other.deleteable = this.deleteable;
        other.updateable = this.updateable;
        other.titleFormula = this.titleFormula;
        other.subtitleFormula = this.subtitleFormula;
        other.timeFormula = this.timeFormula;
        return other;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Iterable<String> getInverseOfNames() {
        return new ConvertingIterable<Relationship, String>(this.inverseOfs){

            @Override
            protected String convert(Relationship o) {
                return o.getName();
            }
        };
    }

    @Override
    public boolean getUserVisible() {
        return this.userVisible;
    }

    @Override
    public boolean getDeleteable() {
        return this.deleteable;
    }

    @Override
    public boolean getUpdateable() {
        return this.updateable;
    }

    @Override
    public boolean getCoreConcept() {
        return false;
    }

    @Override
    public String getTitleFormula() {
        return this.titleFormula;
    }

    @Override
    public String getSubtitleFormula() {
        return this.subtitleFormula;
    }

    @Override
    public String getTimeFormula() {
        return this.timeFormula;
    }

    @Override
    public String[] getIntents() {
        return this.intents.toArray(new String[this.intents.size()]);
    }

    @Override
    public void addIntent(String intent, User user, Authorizations authorizations) {
        this.intents.add(intent);
    }

    @Override
    public void removeIntent(String intent, Authorizations authorizations) {
        this.intents.remove(intent);
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public void setProperty(String name, Value value, User user, Authorizations authorizations) {
        if (SchemaProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = ((TextValue)value).stringValue();
        } else if (SchemaProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = ((TextValue)value).stringValue();
        } else if (SchemaProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = ((TextValue)value).stringValue();
        } else if (SchemaProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = ((TextValue)value).stringValue();
        } else if (SchemaProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = ((BooleanValue)value).booleanValue();
        } else if (SchemaProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = ((BooleanValue)value).booleanValue();
        } else if (SchemaProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = ((BooleanValue)value).booleanValue();
        } else if (value != null) {
            this.metadata.put(name, value.toString());
        }
    }

    @Override
    public void removeProperty(String name, Authorizations authorizations) {
        if (SchemaProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = null;
        } else if (SchemaProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = null;
        } else if (SchemaProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = null;
        } else if (SchemaProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = null;
        } else if (SchemaProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = false;
        } else if (SchemaProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = false;
        } else if (SchemaProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = false;
        } else if (SchemaProperties.INTENT.getPropertyName().equals(name)) {
            this.intents.clear();
        } else {
            this.metadata.remove(name);
        }
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addInverseOf(Relationship inverseOfRelationship) {
        this.inverseOfs.add(inverseOfRelationship);
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void removeWorkspaceId() {
        this.workspaceId = null;
    }

    void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return this.workspaceId == null ? SandboxStatus.PUBLIC : SandboxStatus.PRIVATE;
    }
}

