/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema.inmemory;

import com.google.common.collect.ImmutableList;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InMemorySchemaProperty
extends SchemaProperty {
    private String name;
    private boolean userVisible;
    private boolean searchable;
    private boolean sortable;
    private boolean addable;
    private String displayName;
    private String propertyGroup;
    private PropertyType dataType;
    private Map<String, String> possibleValues;
    private String displayType;
    private Double boost;
    private String validationFormula;
    private String displayFormula;
    private boolean updateable;
    private boolean deleteable;
    private Integer sortPriority;
    private boolean searchFacet;
    private boolean systemProperty;
    private String aggType;
    private int aggPrecision;
    private String aggInterval;
    private long aggMinDocumentCount;
    private String aggTimeZone;
    private String aggCalendarField;
    private ImmutableList<String> dependentPropertyNames = ImmutableList.of();
    private List<String> intents = new ArrayList<String>();
    private List<String> textIndexHints = new ArrayList<String>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<String> conceptNames = new ArrayList<String>();
    private List<String> relationshipNames = new ArrayList<String>();
    private String workspaceId;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean getUserVisible() {
        return this.userVisible;
    }

    @Override
    public PropertyType getDataType() {
        return this.dataType;
    }

    @Override
    public Double getBoost() {
        return this.boost;
    }

    @Override
    public Map<String, String> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public String getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public boolean getSearchable() {
        return this.searchable;
    }

    @Override
    public boolean getSearchFacet() {
        return false;
    }

    @Override
    public boolean getSystemProperty() {
        return false;
    }

    @Override
    public boolean getAddable() {
        return this.addable;
    }

    @Override
    public boolean getSortable() {
        return this.sortable;
    }

    @Override
    public Integer getSortPriority() {
        return this.sortPriority;
    }

    @Override
    public String getAggType() {
        return this.aggType;
    }

    @Override
    public int getAggPrecision() {
        return this.aggPrecision;
    }

    @Override
    public String getAggInterval() {
        return this.aggInterval;
    }

    @Override
    public long getAggMinDocumentCount() {
        return this.aggMinDocumentCount;
    }

    @Override
    public String getAggTimeZone() {
        return this.aggTimeZone;
    }

    @Override
    public String getAggCalendarField() {
        return this.aggCalendarField;
    }

    @Override
    public String getValidationFormula() {
        return this.validationFormula;
    }

    @Override
    public String getDisplayFormula() {
        return this.displayFormula;
    }

    @Override
    public ImmutableList<String> getDependentPropertyNames() {
        return this.dependentPropertyNames;
    }

    @Override
    public boolean getDeleteable() {
        return this.deleteable;
    }

    @Override
    public boolean getUpdateable() {
        return this.updateable;
    }

    @Override
    public String[] getIntents() {
        return this.intents.toArray(new String[this.intents.size()]);
    }

    @Override
    public String[] getTextIndexHints() {
        return this.textIndexHints.toArray(new String[this.textIndexHints.size()]);
    }

    @Override
    public void addTextIndexHints(String textIndexHints, Authorizations authorizations) {
        this.addTextIndexHints(textIndexHints);
    }

    public void addTextIndexHints(String textIndexHints) {
        this.textIndexHints.add(textIndexHints);
    }

    @Override
    public String getDisplayType() {
        return this.displayType;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public void setAddable(boolean addable) {
        this.addable = addable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setSortPriority(Integer sortPriority) {
        this.sortPriority = sortPriority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUserVisible(boolean userVisible) {
        this.userVisible = userVisible;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDataType(PropertyType dataType) {
        this.dataType = dataType;
    }

    public void setPossibleValues(Map<String, String> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public void setBoost(Double boost) {
        this.boost = boost;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public void setPropertyGroup(String propertyGroup) {
        this.propertyGroup = propertyGroup;
    }

    public void setValidationFormula(String validationFormula) {
        this.validationFormula = validationFormula;
    }

    public void setDisplayFormula(String displayFormula) {
        this.displayFormula = displayFormula;
    }

    public void setDependentPropertyNames(Collection<String> dependentPropertyNames) {
        this.dependentPropertyNames = dependentPropertyNames == null ? ImmutableList.of() : ImmutableList.copyOf(dependentPropertyNames);
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public void setDeleteable(boolean deleteable) {
        this.deleteable = deleteable;
    }

    @Override
    public void setProperty(String name, Value value, User user, Authorizations authorizations) {
        if (SchemaProperties.DISPLAY_TYPE.getPropertyName().equals(name)) {
            this.displayType = ((TextValue)value).stringValue();
        } else if (SchemaProperties.DISPLAY_FORMULA.getPropertyName().equals(name)) {
            this.displayFormula = ((TextValue)value).stringValue();
        } else if (SchemaProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = ((TextValue)value).stringValue();
        } else if (SchemaProperties.PROPERTY_GROUP.getPropertyName().equals(name)) {
            this.propertyGroup = ((TextValue)value).stringValue();
        } else if (SchemaProperties.SEARCHABLE.getPropertyName().equals(name)) {
            this.searchable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
        } else if (SchemaProperties.SORTABLE.getPropertyName().equals(name)) {
            this.sortable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
        } else if (SchemaProperties.SORT_PRIORITY.getPropertyName().equals(name)) {
            this.sortPriority = value == null ? null : (value instanceof IntValue ? Integer.valueOf(((IntValue)value).value()) : Integer.valueOf(Integer.parseInt(((TextValue)value).stringValue())));
        } else if (SchemaProperties.ADDABLE.getPropertyName().equals(name)) {
            this.addable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
        } else if (SchemaProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
        } else if (SchemaProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
        } else if (SchemaProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = value instanceof BooleanValue ? ((BooleanValue)value).booleanValue() : Boolean.parseBoolean(((TextValue)value).stringValue());
        } else if (value != null) {
            this.metadata.put(name, value.toString());
        } else {
            this.metadata.remove(name);
        }
    }

    public void addIntent(String intent) {
        this.intents.add(intent);
    }

    @Override
    public void addIntent(String intent, Authorizations authorizations) {
        this.intents.add(intent);
    }

    @Override
    public void removeIntent(String intent, Authorizations authorizations) {
        this.intents.remove(intent);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public List<String> getConceptNames() {
        return this.conceptNames;
    }

    @Override
    public List<String> getRelationshipNames() {
        return this.relationshipNames;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void removeWorkspaceId() {
        this.workspaceId = null;
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return this.workspaceId == null ? SandboxStatus.PUBLIC : SandboxStatus.PRIVATE;
    }
}

