/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.schema.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.cache.CacheService;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.properties.SchemaProperties;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaElement;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaRepositoryBase;
import com.mware.core.model.schema.inmemory.InMemoryConcept;
import com.mware.core.model.schema.inmemory.InMemoryExtendedDataTableSchemaProperty;
import com.mware.core.model.schema.inmemory.InMemoryRelationship;
import com.mware.core.model.schema.inmemory.InMemorySchemaProperty;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.TextIndexHint;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

@Singleton
public class InMemorySchemaRepository
extends SchemaRepositoryBase {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(InMemorySchemaRepository.class);
    private static final String PUBLIC_ONTOLOGY_CACHE_KEY = "InMemoryOntologyRepository.PUBLIC";
    private final Graph graph;
    private final Map<String, Map<String, InMemoryConcept>> conceptsCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, InMemoryRelationship>> relationshipsCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, InMemorySchemaProperty>> propertiesCache = Collections.synchronizedMap(new HashMap());

    @Inject
    public InMemorySchemaRepository(Graph graph, Configuration configuration, CacheService cacheService) throws Exception {
        super(configuration, graph, cacheService);
        this.graph = graph;
        this.clearCache();
        this.conceptsCache.put(PUBLIC_ONTOLOGY_CACHE_KEY, new HashMap());
        this.relationshipsCache.put(PUBLIC_ONTOLOGY_CACHE_KEY, new HashMap());
        this.propertiesCache.put(PUBLIC_ONTOLOGY_CACHE_KEY, new HashMap());
        this.loadOntologies();
    }

    private Map<String, InMemoryConcept> computeConceptCacheForWorkspace(String namespace) {
        Map<String, InMemoryConcept> workspaceConcepts = this.computeCacheForWorkspace(this.conceptsCache, namespace);
        if (!this.isPublic(namespace) && this.propertiesCache.containsKey(namespace)) {
            this.propertiesCache.get(namespace).values().forEach(workspaceProperty -> workspaceProperty.getConceptNames().forEach(conceptName -> {
                InMemoryConcept concept = (InMemoryConcept)workspaceConcepts.get(conceptName);
                if (concept.getSandboxStatus() == SandboxStatus.PUBLIC) {
                    concept = concept.shallowCopy();
                    concept.getProperties().add((SchemaProperty)workspaceProperty);
                    workspaceConcepts.put((String)conceptName, concept);
                }
            }));
        }
        return workspaceConcepts;
    }

    private Map<String, InMemoryRelationship> computeRelationshipCacheForWorkspace(String namespace) {
        Map<String, InMemoryRelationship> workspaceRelationships = this.computeCacheForWorkspace(this.relationshipsCache, namespace);
        if (!this.isPublic(namespace) && this.propertiesCache.containsKey(namespace)) {
            this.propertiesCache.get(namespace).values().forEach(workspaceProperty -> workspaceProperty.getRelationshipNames().forEach(relationshipName -> {
                InMemoryRelationship relationship = (InMemoryRelationship)workspaceRelationships.get(relationshipName);
                if (relationship.getSandboxStatus() == SandboxStatus.PUBLIC) {
                    relationship = relationship.shallowCopy();
                    relationship.getProperties().add((SchemaProperty)workspaceProperty);
                    workspaceRelationships.put((String)relationshipName, relationship);
                }
            }));
        }
        return workspaceRelationships;
    }

    private Map<String, InMemorySchemaProperty> computePropertyCacheForWorkspace(String namespace) {
        return this.computeCacheForWorkspace(this.propertiesCache, namespace);
    }

    private <T> Map<String, T> computeCacheForWorkspace(Map<String, Map<String, T>> cache, String namespace) {
        HashMap<String, T> result = new HashMap<String, T>();
        result.putAll(cache.compute(PUBLIC_ONTOLOGY_CACHE_KEY, (k, v) -> v == null ? new HashMap() : v));
        if (!this.isPublic(namespace) && cache.containsKey(namespace)) {
            result.putAll(cache.get(namespace));
        }
        return result;
    }

    @Override
    public void updatePropertyDependentNames(SchemaProperty property, Collection<String> dependentPropertyNames, User user, String namespace) {
        if (!this.isPublic(namespace) || property.getSandboxStatus() == SandboxStatus.PRIVATE) {
            throw new UnsupportedOperationException("Sandboxed updating of dependent names is not currently supported for properties");
        }
        InMemorySchemaProperty inMemoryOntologyProperty = (InMemorySchemaProperty)property;
        inMemoryOntologyProperty.setDependentPropertyNames(dependentPropertyNames);
    }

    @Override
    public void addDomainConceptsToRelationshipType(String relationshipName, List<String> conceptNames, User user, String namespace) {
        InMemoryRelationship relationship = this.computeRelationshipCacheForWorkspace(namespace).get(relationshipName);
        if (!this.isPublic(namespace) && relationship.getSandboxStatus() != SandboxStatus.PRIVATE) {
            throw new UnsupportedOperationException("Sandboxed updating of domain names is not currently supported for published relationships");
        }
        List missingConcepts = conceptNames.stream().filter(c -> !relationship.getSourceConceptNames().contains(c)).collect(Collectors.toList());
        if (relationship.getSandboxStatus() == SandboxStatus.PRIVATE) {
            relationship.getSourceConceptNames().addAll(missingConcepts);
        } else {
            InMemoryRelationship inMemoryRelationship = relationship.shallowCopy();
            inMemoryRelationship.getSourceConceptNames().addAll(missingConcepts);
            Map workspaceCache = this.relationshipsCache.compute(namespace, (k, v) -> v == null ? new HashMap() : v);
            workspaceCache.put(inMemoryRelationship.getName(), inMemoryRelationship);
        }
    }

    @Override
    public void addRangeConceptsToRelationshipType(String relationshipName, List<String> conceptNames, User user, String namespace) {
        InMemoryRelationship relationship = this.computeRelationshipCacheForWorkspace(namespace).get(relationshipName);
        if (!this.isPublic(namespace) && relationship.getSandboxStatus() != SandboxStatus.PRIVATE) {
            throw new UnsupportedOperationException("Sandboxed updating of range names is not currently supported for published relationships");
        }
        List missingConcepts = conceptNames.stream().filter(c -> !relationship.getTargetConceptNames().contains(c)).collect(Collectors.toList());
        if (relationship.getSandboxStatus() == SandboxStatus.PRIVATE) {
            relationship.getTargetConceptNames().addAll(missingConcepts);
        } else {
            InMemoryRelationship inMemoryRelationship = relationship.shallowCopy();
            inMemoryRelationship.getTargetConceptNames().addAll(missingConcepts);
            Map workspaceCache = this.relationshipsCache.compute(namespace, (k, v) -> v == null ? new HashMap() : v);
            workspaceCache.put(inMemoryRelationship.getName(), inMemoryRelationship);
        }
    }

    @Override
    public SchemaProperty addPropertyTo(List<Concept> concepts, List<Relationship> relationships, List<String> extendedDataTableNames, String propertyName, String displayName, PropertyType dataType, Map<String, String> possibleValues, Collection<TextIndexHint> textIndexHints, boolean userVisible, boolean searchFacet, boolean systemProperty, String aggType, int aggPrecision, String aggInterval, long aggMinDocumentCount, String aggTimeZone, String aggCalendarField, boolean searchable, boolean addable, boolean sortable, Integer sortPriority, String displayType, String propertyGroup, Double boost, String validationFormula, String displayFormula, ImmutableList<String> dependentPropertyNames, String[] intents, boolean deleteable, boolean updateable, User user, String namespace) {
        Preconditions.checkNotNull(concepts, (Object)"concept was null");
        InMemorySchemaProperty property = this.getPropertyByName(propertyName, namespace);
        if (property == null) {
            searchable = this.determineSearchable(propertyName, dataType, textIndexHints, searchable);
            this.definePropertyOnGraph(this.graph, propertyName, PropertyType.getTypeClass(dataType), textIndexHints, boost, sortable);
            property = dataType.equals((Object)PropertyType.EXTENDED_DATA_TABLE) ? new InMemoryExtendedDataTableSchemaProperty() : new InMemorySchemaProperty();
            property.setDataType(dataType);
        } else {
            this.deleteChangeableProperties(property, null);
        }
        property.setUserVisible(userVisible);
        property.setSearchable(searchable);
        property.setAddable(addable);
        property.setSortable(sortable);
        property.setSortPriority(sortPriority);
        property.setName(propertyName);
        property.setBoost(boost);
        property.setDisplayType(displayType);
        property.setPropertyGroup(propertyGroup);
        property.setValidationFormula(validationFormula);
        property.setDisplayFormula(displayFormula);
        property.setDeleteable(deleteable);
        property.setUpdateable(updateable);
        property.setWorkspaceId(this.isPublic(namespace) ? null : namespace);
        if (dependentPropertyNames != null && !dependentPropertyNames.isEmpty()) {
            property.setDependentPropertyNames((Collection<String>)dependentPropertyNames);
        }
        if (intents != null) {
            for (String intent : intents) {
                property.addIntent(intent);
            }
        }
        if (displayName != null && !displayName.trim().isEmpty()) {
            property.setDisplayName(displayName);
        }
        if (textIndexHints != null && textIndexHints.size() > 0) {
            for (TextIndexHint textIndexHint : textIndexHints) {
                property.addTextIndexHints(textIndexHint.toString());
            }
        }
        property.setPossibleValues(possibleValues);
        String cacheKey = this.isPublic(namespace) ? PUBLIC_ONTOLOGY_CACHE_KEY : namespace;
        Map workspaceCache = this.propertiesCache.compute(cacheKey, (k, v) -> v == null ? new HashMap() : v);
        workspaceCache.put(propertyName, property);
        for (Concept concept : concepts) {
            property.getConceptNames().add(concept.getName());
            if (!this.isPublic(namespace) && concept.getSandboxStatus() != SandboxStatus.PRIVATE) continue;
            concept.getProperties().add(property);
        }
        for (Relationship relationship : relationships) {
            property.getRelationshipNames().add(relationship.getName());
            if (!this.isPublic(namespace) && relationship.getSandboxStatus() != SandboxStatus.PRIVATE) continue;
            relationship.getProperties().add(property);
        }
        if (extendedDataTableNames != null) {
            for (String extendedDataTableName : extendedDataTableNames) {
                InMemoryExtendedDataTableSchemaProperty edtp = (InMemoryExtendedDataTableSchemaProperty)this.getPropertyByName(extendedDataTableName, namespace);
                edtp.addTableProperty(property.getName());
            }
        }
        Preconditions.checkNotNull((Object)property, (Object)("Could not find property: " + propertyName));
        return property;
    }

    @Override
    public void updatePropertyDomainNames(SchemaProperty property, Set<String> domainNames, User user, String namespace) {
        if (!this.isPublic(namespace) && property.getSandboxStatus() != SandboxStatus.PRIVATE) {
            throw new UnsupportedOperationException("Sandboxed updating of domain names is not currently supported for published properties");
        }
        InMemorySchemaProperty inMemoryProperty = (InMemorySchemaProperty)property;
        for (Concept concept : this.getConceptsWithProperties(namespace)) {
            if (!concept.getProperties().contains(property) || domainNames.remove(concept.getName())) continue;
            if (this.isPublic(namespace) || concept.getSandboxStatus() == SandboxStatus.PRIVATE) {
                concept.getProperties().remove(property);
            }
            inMemoryProperty.getConceptNames().remove(concept.getName());
        }
        for (Relationship relationship : this.getRelationships(namespace)) {
            if (!relationship.getProperties().contains(property) || domainNames.remove(relationship.getName())) continue;
            if (this.isPublic(namespace) || relationship.getSandboxStatus() == SandboxStatus.PRIVATE) {
                relationship.getProperties().remove(property);
            }
            inMemoryProperty.getRelationshipNames().remove(relationship.getName());
        }
        for (String domainName : domainNames) {
            InMemoryConcept concept = this.getConceptByName(domainName, namespace);
            if (concept != null) {
                if (this.isPublic(namespace) || concept.getSandboxStatus() == SandboxStatus.PRIVATE) {
                    concept.getProperties().add(property);
                }
                inMemoryProperty.getConceptNames().add(concept.getName());
                continue;
            }
            InMemoryRelationship relationship = this.getRelationshipByName(domainName, namespace);
            if (relationship != null) {
                if (this.isPublic(namespace) || relationship.getSandboxStatus() == SandboxStatus.PRIVATE) {
                    relationship.getProperties().add(property);
                }
                inMemoryProperty.getRelationshipNames().add(relationship.getName());
                continue;
            }
            throw new BcException("Could not find domain with name " + domainName);
        }
    }

    @Override
    public void internalPublishConcept(Concept concept, User user, String namespace) {
        Map<String, InMemoryConcept> sandboxedConcepts;
        if (this.conceptsCache.containsKey(namespace) && (sandboxedConcepts = this.conceptsCache.get(namespace)).containsKey(concept.getName())) {
            InMemoryConcept sandboxConcept = sandboxedConcepts.remove(concept.getName());
            sandboxConcept.removeWorkspaceId();
            this.conceptsCache.get(PUBLIC_ONTOLOGY_CACHE_KEY).put(concept.getName(), sandboxConcept);
        }
    }

    @Override
    public void internalPublishRelationship(Relationship relationship, User user, String namespace) {
        Map<String, InMemoryRelationship> sandboxedRelationships;
        if (this.relationshipsCache.containsKey(namespace) && (sandboxedRelationships = this.relationshipsCache.get(namespace)).containsKey(relationship.getName())) {
            InMemoryRelationship sandboxRelationship = sandboxedRelationships.remove(relationship.getName());
            sandboxRelationship.removeWorkspaceId();
            this.relationshipsCache.get(PUBLIC_ONTOLOGY_CACHE_KEY).put(relationship.getName(), sandboxRelationship);
        }
    }

    @Override
    public void internalPublishProperty(SchemaProperty property, User user, String namespace) {
        Map<String, InMemorySchemaProperty> sandboxedProperties;
        if (this.propertiesCache.containsKey(namespace) && (sandboxedProperties = this.propertiesCache.get(namespace)).containsKey(property.getName())) {
            InMemorySchemaProperty sandboxProperty = sandboxedProperties.remove(property.getName());
            sandboxProperty.removeWorkspaceId();
            this.propertiesCache.get(PUBLIC_ONTOLOGY_CACHE_KEY).put(property.getName(), sandboxProperty);
            Map<String, InMemoryConcept> publicConcepts = this.conceptsCache.get(PUBLIC_ONTOLOGY_CACHE_KEY);
            sandboxProperty.getConceptNames().forEach(c -> ((InMemoryConcept)publicConcepts.get(c)).getProperties().add(sandboxProperty));
            Map<String, InMemoryRelationship> publicRelationships = this.relationshipsCache.get(PUBLIC_ONTOLOGY_CACHE_KEY);
            sandboxProperty.getRelationshipNames().forEach(r -> ((InMemoryRelationship)publicRelationships.get(r)).getProperties().add(sandboxProperty));
        }
    }

    @Override
    public void getOrCreateInverseOfRelationship(Relationship fromRelationship, Relationship inverseOfRelationship) {
        InMemoryRelationship fromRelationshipMem = (InMemoryRelationship)fromRelationship;
        InMemoryRelationship inverseOfRelationshipMem = (InMemoryRelationship)inverseOfRelationship;
        fromRelationshipMem.addInverseOf(inverseOfRelationshipMem);
        inverseOfRelationshipMem.addInverseOf(fromRelationshipMem);
    }

    @Override
    public void removeInverseOfRelationship(Relationship fromRelationship, Relationship inverseOfRelationship) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Iterable<Relationship> getRelationships(String namespace) {
        return new ArrayList<Relationship>(this.computeRelationshipCacheForWorkspace(namespace).values());
    }

    @Override
    public Iterable<Relationship> getRelationships(Iterable<String> ids, String namespace) {
        if (ids != null) {
            List<String> idList = IterableUtils.toList(ids);
            Iterable<Relationship> workspaceRelationships = this.getRelationships(namespace);
            return StreamSupport.stream(workspaceRelationships.spliterator(), true).filter(r -> idList.contains(r.getId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<SchemaProperty> getProperties(Iterable<String> ids, String namespace) {
        if (ids != null) {
            List<String> idList = IterableUtils.toList(ids);
            Iterable<SchemaProperty> workspaceProps = this.getProperties(namespace);
            return StreamSupport.stream(workspaceProps.spliterator(), true).filter(p -> idList.contains(p.getId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<SchemaProperty> getProperties(String namespace) {
        return new ArrayList<SchemaProperty>(this.computePropertyCacheForWorkspace(namespace).values());
    }

    @Override
    public String getDisplayNameForLabel(String relationshipName, String namespace) {
        InMemoryRelationship relationship = this.computeRelationshipCacheForWorkspace(namespace).get(relationshipName);
        Preconditions.checkNotNull((Object)relationship, (Object)("Could not find relationship " + relationshipName));
        return relationship.getDisplayName();
    }

    @Override
    public InMemorySchemaProperty getPropertyByName(String propertyName, String namespace) {
        return this.computePropertyCacheForWorkspace(namespace).get(propertyName);
    }

    @Override
    public InMemoryRelationship getRelationshipByName(String relationshipName, String namespace) {
        return this.computeRelationshipCacheForWorkspace(namespace).get(relationshipName);
    }

    @Override
    public InMemoryConcept getConceptByName(String conceptName, String namespace) {
        return this.computeConceptCacheForWorkspace(namespace).get(conceptName);
    }

    @Override
    public boolean hasRelationshipByName(String relationshipName, String namespace) {
        return this.getRelationshipByName(relationshipName, namespace) != null;
    }

    @Override
    public Iterable<Concept> getConceptsWithProperties(String namespace) {
        return new ArrayList<Concept>(this.computeConceptCacheForWorkspace(namespace).values());
    }

    @Override
    public Concept getRootConcept(String namespace) {
        return this.computeConceptCacheForWorkspace(namespace).get("__root");
    }

    @Override
    public Concept getThingConcept(String namespace) {
        return this.computeConceptCacheForWorkspace(namespace).get("thing");
    }

    @Override
    public Concept getParentConcept(Concept concept, String namespace) {
        return this.computeConceptCacheForWorkspace(namespace).get(concept.getParentConceptName());
    }

    @Override
    public Relationship getParentRelationship(Relationship relationship, String namespace) {
        return this.computeRelationshipCacheForWorkspace(namespace).get(relationship.getParentName());
    }

    @Override
    public Iterable<Concept> getConcepts(Iterable<String> ids, String namespace) {
        if (ids != null) {
            List<String> idList = IterableUtils.toList(ids);
            Iterable<Concept> workspaceConcepts = this.getConceptsWithProperties(namespace);
            return StreamSupport.stream(workspaceConcepts.spliterator(), true).filter(c -> idList.contains(c.getId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    protected void internalDeleteConcept(Concept concept, String namespace) {
        String cacheKey = namespace;
        Map workspaceCache = this.conceptsCache.compute(cacheKey, (k, v) -> v == null ? new HashMap() : v);
        workspaceCache.remove(concept.getName());
        for (SchemaProperty property : this.getProperties(namespace)) {
            property.getConceptNames().remove(concept.getName());
        }
    }

    @Override
    protected void internalDeleteProperty(SchemaProperty property, String namespace) {
        String cacheKey = namespace;
        Map workspaceCache = this.propertiesCache.compute(cacheKey, (k, v) -> v == null ? new HashMap() : v);
        workspaceCache.remove(property.getName());
    }

    @Override
    protected void internalDeleteRelationship(Relationship relationship, String namespace) {
        String cacheKey = namespace;
        Map workspaceCache = this.relationshipsCache.compute(cacheKey, (k, v) -> v == null ? new HashMap() : v);
        workspaceCache.remove(relationship.getName());
        for (SchemaProperty property : this.getProperties(namespace)) {
            property.getRelationshipNames().remove(relationship.getName());
        }
    }

    @Override
    public List<Concept> getChildConcepts(Concept concept, String namespace) {
        Map<String, InMemoryConcept> workspaceConcepts = this.computeConceptCacheForWorkspace(namespace);
        return workspaceConcepts.values().stream().filter(workspaceConcept -> concept.getName().equals(workspaceConcept.getParentConceptName())).collect(Collectors.toList());
    }

    @Override
    protected List<Relationship> getChildRelationships(Relationship relationship, String namespace) {
        Map<String, InMemoryRelationship> workspaceRelationships = this.computeRelationshipCacheForWorkspace(namespace);
        return workspaceRelationships.values().stream().filter(workspaceRelationship -> relationship.getName().equals(workspaceRelationship.getParentName())).collect(Collectors.toList());
    }

    @Override
    protected Concept internalGetOrCreateConcept(Concept parent, String conceptName, String displayName, String glyphIconHref, String color, boolean deleteChangeableProperties, boolean isCoreConcept, User user, String namespace) {
        InMemoryConcept concept = this.getConceptByName(conceptName, namespace);
        if (concept != null) {
            if (deleteChangeableProperties) {
                this.deleteChangeableProperties(concept, null);
            }
            return concept;
        }
        concept = parent == null ? new InMemoryConcept(conceptName, null, this.isPublic(namespace) ? null : namespace) : new InMemoryConcept(conceptName, parent.getName(), this.isPublic(namespace) ? null : namespace);
        concept.setProperty(SchemaProperties.TITLE.getPropertyName(), Values.stringValue(conceptName), user, null);
        concept.setProperty(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue(displayName), user, null);
        if (conceptName.equals("thing")) {
            concept.setProperty(SchemaProperties.TITLE_FORMULA.getPropertyName(), Values.stringValue("prop('title') || ''"), user, null);
            concept.setProperty(SchemaProperties.SUBTITLE_FORMULA.getPropertyName(), Values.stringValue("prop('source') || ''"), user, null);
            concept.setProperty(SchemaProperties.TIME_FORMULA.getPropertyName(), Values.stringValue("''"), user, null);
        }
        if (!StringUtils.isEmpty((String)glyphIconHref)) {
            concept.setProperty(SchemaProperties.GLYPH_ICON_FILE_NAME.getPropertyName(), Values.stringValue(glyphIconHref), user, null);
        }
        if (!StringUtils.isEmpty((String)color)) {
            concept.setProperty(SchemaProperties.COLOR.getPropertyName(), Values.stringValue(color), user, null);
        }
        String cacheKey = this.isPublic(namespace) ? PUBLIC_ONTOLOGY_CACHE_KEY : namespace;
        Map workspaceCache = this.conceptsCache.compute(cacheKey, (k, v) -> v == null ? new HashMap() : v);
        workspaceCache.put(conceptName, concept);
        return concept;
    }

    @Override
    protected Relationship internalGetOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipName, String displayName, boolean deleteChangeableProperties, boolean coreConcept, User user, String namespace) {
        InMemoryRelationship relationship = this.getRelationshipByName(relationshipName, namespace);
        if (relationship != null) {
            if (deleteChangeableProperties) {
                this.deleteChangeableProperties(relationship, null);
            }
            for (Concept domainConcept : domainConcepts) {
                if (relationship.getSourceConceptNames().contains(domainConcept.getName())) continue;
                relationship.getSourceConceptNames().add(domainConcept.getName());
            }
            for (Concept rangeConcept : rangeConcepts) {
                if (relationship.getTargetConceptNames().contains(rangeConcept.getName())) continue;
                relationship.getTargetConceptNames().add(rangeConcept.getName());
            }
            return relationship;
        }
        this.validateRelationship(relationshipName, domainConcepts, rangeConcepts);
        List<String> domainConceptNames = IterableUtils.toList(new ConvertingIterable<Concept, String>(domainConcepts){

            @Override
            protected String convert(Concept o) {
                return o.getName();
            }
        });
        List<String> rangeConceptNames = IterableUtils.toList(new ConvertingIterable<Concept, String>(rangeConcepts){

            @Override
            protected String convert(Concept o) {
                return o.getName();
            }
        });
        String parentName = parent == null ? null : parent.getName();
        ArrayList<SchemaProperty> properties = new ArrayList<SchemaProperty>();
        InMemoryRelationship inMemRelationship = new InMemoryRelationship(parentName, relationshipName, domainConceptNames, rangeConceptNames, properties, this.isPublic(namespace) ? null : namespace);
        if (displayName != null) {
            inMemRelationship.setProperty(SchemaProperties.DISPLAY_NAME.getPropertyName(), Values.stringValue(displayName), user, this.getAuthorizations(namespace, new String[0]));
        }
        String cacheKey = this.isPublic(namespace) ? PUBLIC_ONTOLOGY_CACHE_KEY : namespace;
        Map workspaceCache = this.relationshipsCache.compute(cacheKey, (k, v) -> v == null ? new HashMap() : v);
        workspaceCache.put(relationshipName, inMemRelationship);
        return inMemRelationship;
    }

    protected Authorizations getAuthorizations(String namespace, String ... otherAuthorizations) {
        if (this.isPublic(namespace) && (otherAuthorizations == null || otherAuthorizations.length == 0)) {
            return new Authorizations("ontology");
        }
        if (this.isPublic(namespace)) {
            return new Authorizations((String[])ArrayUtils.add((Object[])otherAuthorizations, (Object)"ontology"));
        }
        if (otherAuthorizations == null || otherAuthorizations.length == 0) {
            return new Authorizations("ontology", namespace);
        }
        return new Authorizations((String[])ArrayUtils.addAll((Object[])otherAuthorizations, (Object[])new String[]{"ontology", namespace}));
    }

    @Override
    protected Graph getGraph() {
        return this.graph;
    }

    @Override
    protected void deleteChangeableProperties(SchemaProperty property, Authorizations authorizations) {
        for (String propertyName : SchemaProperties.CHANGEABLE_PROPERTY_NAME) {
            if (SchemaProperties.INTENT.getPropertyName().equals(propertyName)) {
                for (String intent : property.getIntents()) {
                    property.removeIntent(intent, null);
                }
                continue;
            }
            property.setProperty(propertyName, null, null, null);
        }
    }

    @Override
    protected void deleteChangeableProperties(SchemaElement element, Authorizations authorizations) {
        for (String propertyName : SchemaProperties.CHANGEABLE_PROPERTY_NAME) {
            if (element instanceof InMemoryRelationship) {
                InMemoryRelationship inMemoryRelationship = (InMemoryRelationship)element;
                if (SchemaProperties.INTENT.getPropertyName().equals(propertyName)) {
                    for (String intent : inMemoryRelationship.getIntents()) {
                        inMemoryRelationship.removeIntent(intent, null);
                    }
                    continue;
                }
                inMemoryRelationship.removeProperty(propertyName, null);
                continue;
            }
            InMemoryConcept inMemoryConcept = (InMemoryConcept)element;
            if (SchemaProperties.INTENT.getPropertyName().equals(propertyName)) {
                for (String intent : inMemoryConcept.getIntents()) {
                    inMemoryConcept.removeIntent(intent, null);
                }
                continue;
            }
            inMemoryConcept.removeProperty(propertyName, null);
        }
    }
}

