/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.search.GeObjectSearchRunnerWithRelatedBase;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.GeObjectType;
import com.mware.ge.Graph;
import com.mware.ge.query.Query;
import java.util.EnumSet;
import org.json.JSONArray;

@Singleton
public class ElementSearchRunner
extends GeObjectSearchRunnerWithRelatedBase {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ElementSearchRunner.class);
    public static final String URI = "/element/search";

    @Inject
    public ElementSearchRunner(SchemaRepository schemaRepository, Graph graph, Configuration configuration) {
        super(schemaRepository, graph, configuration);
    }

    @Override
    protected EnumSet<GeObjectType> getResultType() {
        return EnumSet.of(GeObjectType.EDGE, GeObjectType.VERTEX);
    }

    @Override
    public String getUri() {
        return URI;
    }

    @Override
    protected Query getQuery(SearchOptions searchOptions, Authorizations authorizations) {
        JSONArray filterJson = this.getFilterJson(searchOptions, searchOptions.getWorkspaceId());
        String queryString = searchOptions.getRequiredParameter("q", String.class);
        LOGGER.debug("search %s\n%s", queryString, filterJson.toString(2));
        return this.query(queryString, authorizations);
    }

    private Query query(String query, Authorizations authorizations) {
        return this.getGraph().query(query, authorizations);
    }
}

