/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.schema.SchemaProperty;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.search.QueryResultsIterableSearchResults;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.model.search.SearchRunner;
import com.mware.core.trace.Trace;
import com.mware.core.trace.TraceSpan;
import com.mware.core.user.User;
import com.mware.core.util.ClientApiConverter;
import com.mware.core.util.JSONUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.GeObject;
import com.mware.ge.GeObjectType;
import com.mware.ge.Graph;
import com.mware.ge.Range;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Contains;
import com.mware.ge.query.GeoCompare;
import com.mware.ge.query.HasExtendedDataFilter;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryBase;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.SortDirection;
import com.mware.ge.query.TextPredicate;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.AvgAggregation;
import com.mware.ge.query.aggregations.ChronoFieldAggregation;
import com.mware.ge.query.aggregations.GeohashAggregation;
import com.mware.ge.query.aggregations.HistogramAggregation;
import com.mware.ge.query.aggregations.MaxAggregation;
import com.mware.ge.query.aggregations.MinAggregation;
import com.mware.ge.query.aggregations.StatisticsAggregation;
import com.mware.ge.query.aggregations.SumAggregation;
import com.mware.ge.query.aggregations.SupportOrderByAggregation;
import com.mware.ge.query.aggregations.SupportsNestedAggregationsAggregation;
import com.mware.ge.query.aggregations.TermsAggregation;
import com.mware.ge.time.Clocks;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class GeObjectSearchRunnerBase
extends SearchRunner {
    protected final Graph graph;
    protected final SchemaRepository schemaRepository;
    protected long defaultSearchResultCount;
    private static final TextValue EMPTY_REFINEMENT_STRING = Values.stringValue("N/A");

    protected GeObjectSearchRunnerBase(SchemaRepository schemaRepository, Graph graph, Configuration configuration) {
        this.schemaRepository = schemaRepository;
        this.graph = graph;
        this.defaultSearchResultCount = configuration.getInt("search.defaultSearchCount", 100).intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QueryResultsIterableSearchResults run(SearchOptions searchOptions, User user, Authorizations authorizations) {
        Long offset;
        JSONArray filterJson = this.getFilterJson(searchOptions, searchOptions.getWorkspaceId());
        JSONArray sourceFilterJson = this.getSourceFilterJson(searchOptions);
        String sourceLogicalOperator = this.getSourceLogicalOperator(searchOptions);
        Query query = this.getQuery(searchOptions, authorizations);
        this.applyLogicalOperatorsToQuery(query, sourceLogicalOperator);
        this.applyFiltersToQuery(query, filterJson, user, searchOptions);
        this.applyConceptTypeFilterToQuery(query, searchOptions);
        this.applyRefinementsToQuery(query, searchOptions);
        this.applyEdgeLabelFilterToQuery(query, searchOptions);
        this.applySortToQuery(query, searchOptions);
        this.applyAggregationsToQuery(query, searchOptions);
        this.applyExtendedDataFilters(query, searchOptions);
        if (searchOptions.getOptionalParameter("includeFacets", Boolean.FALSE).booleanValue()) {
            this.applyDefaultAggregationsToQuery(query, searchOptions.getWorkspaceId());
        }
        if (sourceFilterJson != null) {
            this.applyFiltersToQuery(query, sourceFilterJson, user, searchOptions);
        }
        FetchHints fetchHints = this.getFetchHints(searchOptions);
        Long size = searchOptions.getOptionalParameter("size", this.defaultSearchResultCount);
        if (size != null && size != -1L) {
            query.limit(size);
        }
        if ((offset = searchOptions.getOptionalParameter("offset", 0L)) != null) {
            query.skip(offset.intValue());
        }
        try (QueryResultsIterable<? extends GeObject> searchResults = this.getSearchResults(query, fetchHints);){
            if (searchResults == null) {
                throw new BcException("Failed to extract search results.");
            }
            QueryResultsIterableSearchResults queryResultsIterableSearchResults = new QueryResultsIterableSearchResults(searchResults, query, offset, size);
            return queryResultsIterableSearchResults;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private FetchHints getFetchHints(SearchOptions searchOptions) {
        String fetchHintsString = (String)((Object)searchOptions.getOptionalParameter("fetchHints", String.class));
        if (fetchHintsString == null) {
            return ClientApiConverter.SEARCH_FETCH_HINTS;
        }
        return FetchHintsBuilder.parse(new JSONObject(fetchHintsString)).build();
    }

    private void applyExtendedDataFilters(Query query, SearchOptions searchOptions) {
        String[] filterStrings = (String[])searchOptions.getOptionalParameter("extendedDataFilters[]", String[].class);
        if (filterStrings == null || filterStrings.length == 0) {
            return;
        }
        ArrayList<HasExtendedDataFilter> filters = new ArrayList<HasExtendedDataFilter>();
        for (String filterString : filterStrings) {
            JSONObject filterJson = new JSONObject(filterString);
            String elementTypeString = filterJson.optString("elementType");
            ElementType elementType = elementTypeString == null ? null : ElementType.valueOf(elementTypeString);
            String elementId = filterJson.optString("elementId");
            String tableName = filterJson.optString("tableName");
            filters.add(new HasExtendedDataFilter(elementType, elementId, tableName));
        }
        query.hasExtendedData(filters);
    }

    private void applyAggregationsToQuery(Query query, SearchOptions searchOptions) {
        String[] aggregates = (String[])searchOptions.getOptionalParameter("aggregations[]", String[].class);
        if (aggregates == null) {
            return;
        }
        for (String aggregate : aggregates) {
            JSONObject aggregateJson = new JSONObject(aggregate);
            Aggregation aggregation = this.getAggregation(aggregateJson);
            query.addAggregation(aggregation);
        }
    }

    private void applyDefaultAggregationsToQuery(Query query, String workspaceId) {
        TermsAggregation ctAgg = new TermsAggregation("Concept", "__conceptType");
        ctAgg.setMissingValue(EMPTY_REFINEMENT_STRING);
        query.addAggregation(ctAgg);
        for (SchemaProperty prop : this.schemaRepository.getProperties(workspaceId)) {
            Aggregation aggregation;
            boolean showFacet = prop.getSearchFacet();
            if (!showFacet) continue;
            String aggregationName = prop.getDisplayName();
            String type = prop.getAggType();
            String field = prop.getName();
            if (type == null) {
                throw new BcException("Aggregation type cannot be null for property " + prop.getName());
            }
            switch (type) {
                case "term": {
                    aggregation = new TermsAggregation(aggregationName, field);
                    aggregation.setMissingValue(EMPTY_REFINEMENT_STRING);
                    break;
                }
                case "geohash": {
                    aggregation = new GeohashAggregation(aggregationName, field, prop.getAggPrecision());
                    break;
                }
                case "histogram": {
                    aggregation = new HistogramAggregation(aggregationName, field, prop.getAggInterval(), prop.getAggMinDocumentCount());
                    ((HistogramAggregation)aggregation).setMissingValue(EMPTY_REFINEMENT_STRING);
                    break;
                }
                case "statistics": {
                    aggregation = new StatisticsAggregation(aggregationName, field);
                    break;
                }
                case "calendar": {
                    TimeZone timeZone = prop.getAggTimeZone() == null ? TimeZone.getDefault() : TimeZone.getTimeZone(prop.getAggTimeZone());
                    ChronoField chronoField = this.getChronoField(prop.getAggCalendarField());
                    aggregation = new ChronoFieldAggregation(aggregationName, field, prop.getAggMinDocumentCount(), timeZone, chronoField);
                    break;
                }
                default: {
                    throw new BcException("Invalid aggregation type: " + type + " for property: " + field);
                }
            }
            query.addAggregation(aggregation);
        }
    }

    private Aggregation getAggregation(JSONObject aggregateJson) {
        Aggregation aggregation;
        String type;
        String aggregationName = aggregateJson.getString("name");
        switch (type = aggregateJson.getString("type")) {
            case "term": {
                aggregation = this.getTermsAggregation(aggregationName, aggregateJson);
                break;
            }
            case "geohash": {
                aggregation = this.getGeohashAggregation(aggregationName, aggregateJson);
                break;
            }
            case "histogram": {
                aggregation = this.getHistogramAggregation(aggregationName, aggregateJson);
                break;
            }
            case "statistics": {
                aggregation = this.getStatisticsAggregation(aggregationName, aggregateJson);
                break;
            }
            case "calendar": {
                aggregation = this.getCalendarFieldAggregation(aggregationName, aggregateJson);
                break;
            }
            case "sum": {
                aggregation = this.getSumAggregation(aggregationName, aggregateJson);
                break;
            }
            case "avg": {
                aggregation = this.getAvgAggregation(aggregationName, aggregateJson);
                break;
            }
            case "min": {
                aggregation = this.getMinAggregation(aggregationName, aggregateJson);
                break;
            }
            case "max": {
                aggregation = this.getMaxAggregation(aggregationName, aggregateJson);
                break;
            }
            default: {
                throw new BcException("Invalid aggregation type: " + type);
            }
        }
        return this.addNestedAggregations(aggregation, aggregateJson);
    }

    private Aggregation addNestedAggregations(Aggregation aggregation, JSONObject aggregateJson) {
        JSONArray nestedAggregates = aggregateJson.optJSONArray("nested");
        if (nestedAggregates != null && nestedAggregates.length() > 0) {
            if (!(aggregation instanceof SupportsNestedAggregationsAggregation)) {
                throw new BcException("Aggregation does not support nesting: " + aggregation.getClass().getName());
            }
            for (int i = 0; i < nestedAggregates.length(); ++i) {
                JSONObject nestedAggregateJson = nestedAggregates.getJSONObject(i);
                Aggregation nestedAggregate = this.getAggregation(nestedAggregateJson);
                if (nestedAggregateJson.has("orderBy") && aggregation instanceof SupportOrderByAggregation) {
                    SortDirection sortDirection = SortDirection.valueOf(nestedAggregateJson.getString("orderBy"));
                    ((SupportOrderByAggregation)((Object)aggregation)).setOrderBy(new SupportOrderByAggregation.AggregationSortContainer(nestedAggregate, sortDirection));
                }
                ((SupportsNestedAggregationsAggregation)((Object)aggregation)).addNestedAggregation(nestedAggregate);
            }
        }
        return aggregation;
    }

    private Aggregation getTermsAggregation(String aggregationName, JSONObject aggregateJson) {
        String excluded;
        String field = aggregateJson.getString("field");
        TermsAggregation terms = new TermsAggregation(aggregationName, field);
        int size = aggregateJson.optInt("size", 0);
        if (size > 0) {
            terms.setSize(size);
        }
        if (!StringUtils.isEmpty((CharSequence)(excluded = aggregateJson.optString("excluded", "")))) {
            terms.setExcluded(excluded);
        }
        return terms;
    }

    private Aggregation getGeohashAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        int precision = aggregateJson.getInt("precision");
        return new GeohashAggregation(aggregationName, field, precision);
    }

    private Aggregation getHistogramAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        String interval = aggregateJson.getString("interval");
        Long minDocumentCount = JSONUtil.getOptionalLong(aggregateJson, "minDocumentCount");
        return new HistogramAggregation(aggregationName, field, interval, minDocumentCount);
    }

    private Aggregation getStatisticsAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        return new StatisticsAggregation(aggregationName, field);
    }

    private Aggregation getSumAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        return new SumAggregation(aggregationName, field);
    }

    private Aggregation getAvgAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        return new AvgAggregation(aggregationName, field);
    }

    private Aggregation getMinAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        return new MinAggregation(aggregationName, field);
    }

    private Aggregation getMaxAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        return new MaxAggregation(aggregationName, field);
    }

    private Aggregation getCalendarFieldAggregation(String aggregationName, JSONObject aggregateJson) {
        String field = aggregateJson.getString("field");
        Long minDocumentCount = JSONUtil.getOptionalLong(aggregateJson, "minDocumentCount");
        String timeZoneString = aggregateJson.optString("timeZone");
        TimeZone timeZone = timeZoneString == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneString);
        ChronoField calendarField = this.getChronoField(aggregateJson.getString("calendarField"));
        return new ChronoFieldAggregation(aggregationName, field, minDocumentCount, timeZone, calendarField);
    }

    private ChronoField getChronoField(String chronoField) {
        return ChronoField.valueOf(chronoField);
    }

    protected void applySortToQuery(Query query, SearchOptions searchOptions) {
        JSONArray sortsJson;
        String[] sorts = (String[])searchOptions.getOptionalParameter("sort[]", String[].class);
        if (sorts == null && (sortsJson = (JSONArray)searchOptions.getOptionalParameter("sort", JSONArray.class)) != null) {
            sorts = JSONUtil.toStringList(sortsJson).toArray(new String[sortsJson.length()]);
        }
        if (sorts == null) {
            return;
        }
        String[] stringArray = sorts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String sort;
            String propertyName = sort = stringArray[i];
            SortDirection direction = SortDirection.ASCENDING;
            if (propertyName.toUpperCase().endsWith(":ASCENDING")) {
                propertyName = propertyName.substring(0, propertyName.length() - ":ASCENDING".length());
            } else if (propertyName.toUpperCase().endsWith(":DESCENDING")) {
                direction = SortDirection.DESCENDING;
                propertyName = propertyName.substring(0, propertyName.length() - ":DESCENDING".length());
            }
            query.sort(propertyName, direction);
        }
    }

    /*
     * Loose catch block
     */
    protected QueryResultsIterable<? extends GeObject> getSearchResults(Query query, FetchHints fetchHints) {
        Throwable throwable = null;
        try (TraceSpan trace = Trace.start("getSearchResults");){
            QueryResultsIterable<? extends GeObject> queryResultsIterable;
            Throwable throwable2;
            QueryResultsIterable<? extends GeObject> iter;
            block28: {
                block29: {
                    iter = query.search(this.getResultType(), fetchHints);
                    throwable2 = null;
                    queryResultsIterable = iter;
                    if (iter == null) break block28;
                    if (throwable2 == null) break block29;
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    break block28;
                }
                iter.close();
            }
            return queryResultsIterable;
            catch (Throwable throwable4) {
                try {
                    try {
                        try {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (iter != null) {
                                if (throwable2 != null) {
                                    try {
                                        iter.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    iter.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throwable2 = null;
                        return throwable2;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    throw throwable8;
                }
            }
        }
    }

    protected abstract EnumSet<GeObjectType> getResultType();

    protected abstract Query getQuery(SearchOptions var1, Authorizations var2);

    protected void applyConceptTypeFilterToQuery(Query query, SearchOptions searchOptions) {
        Collection<SchemaRepository.ElementTypeFilter> conceptTypeFilters = this.getConceptTypeFilters(searchOptions);
        if (conceptTypeFilters != null) {
            this.schemaRepository.addConceptTypeFilterToQuery(query, conceptTypeFilters, searchOptions.getWorkspaceId());
        }
    }

    protected void applyEdgeLabelFilterToQuery(Query query, SearchOptions searchOptions) {
        Collection<SchemaRepository.ElementTypeFilter> edgeFilters = this.getEdgeLabelFilters(searchOptions);
        if (edgeFilters != null) {
            this.schemaRepository.addEdgeLabelFilterToQuery(query, edgeFilters, searchOptions.getWorkspaceId());
        }
    }

    protected Collection<SchemaRepository.ElementTypeFilter> getEdgeLabelFilters(SearchOptions searchOptions) {
        return this.getElementTypeFilters("edgeLabels", "edgeLabel", searchOptions);
    }

    protected Collection<SchemaRepository.ElementTypeFilter> getConceptTypeFilters(SearchOptions searchOptions) {
        return this.getElementTypeFilters("conceptTypes", "conceptType", searchOptions);
    }

    private Collection<SchemaRepository.ElementTypeFilter> getElementTypeFilters(String parameterName, String legacyParameterName, SearchOptions searchOptions) {
        String typesStr = (String)((Object)searchOptions.getOptionalParameter(parameterName, String.class));
        if (typesStr != null) {
            JSONArray types = new JSONArray(typesStr);
            ArrayList<SchemaRepository.ElementTypeFilter> filters = new ArrayList<SchemaRepository.ElementTypeFilter>(types.length());
            for (int i = 0; i < types.length(); ++i) {
                JSONObject type = types.getJSONObject(i);
                SchemaRepository.ElementTypeFilter filter = ClientApiConverter.toClientApi(type, SchemaRepository.ElementTypeFilter.class);
                filters.add(filter);
            }
            return filters;
        }
        String elementType = (String)((Object)searchOptions.getOptionalParameter(legacyParameterName, String.class));
        if (elementType != null) {
            Boolean includeChildNodes = (Boolean)((Object)searchOptions.getOptionalParameter("includeChildNodes", Boolean.class));
            if (includeChildNodes == null) {
                includeChildNodes = true;
            }
            return Collections.singleton(new SchemaRepository.ElementTypeFilter(elementType, includeChildNodes));
        }
        return null;
    }

    protected void applyFiltersToQuery(Query query, JSONArray filterJson, User user, SearchOptions searchOptions) {
        for (int i = 0; i < filterJson.length(); ++i) {
            JSONObject obj = filterJson.getJSONObject(i);
            if (obj.length() <= 0) continue;
            if (obj.has("propertyName")) {
                this.updateQueryWithPropertyNameFilter(query, obj, user, searchOptions);
                continue;
            }
            if (obj.has("dataType")) {
                this.updateQueryWithDataTypeFilter(query, obj, user, searchOptions);
                continue;
            }
            throw new BcException("Query filters must have either a propertyName or dataType field. Invalid filter: " + filterJson.toString());
        }
    }

    private void updateQueryWithPropertyNameFilter(Query graphQuery, JSONObject obj, User user, SearchOptions searchOptions) {
        block18: {
            try {
                String predicateString = obj.optString("predicate");
                String propertyName = obj.getString("propertyName");
                if ("has".equals(predicateString)) {
                    graphQuery.has(propertyName);
                    break block18;
                }
                if ("hasNot".equals(predicateString)) {
                    graphQuery.hasNot(propertyName);
                    break block18;
                }
                if ("in".equals(predicateString)) {
                    JSONArray arr = obj.getJSONArray("values");
                    Value valueArr = this.convertJsonArray(arr);
                    graphQuery.has(propertyName, (Predicate)Contains.IN, valueArr);
                    break block18;
                }
                PropertyType propertyDataType = PropertyType.convert(obj.optString("propertyDataType"));
                JSONArray values = obj.getJSONArray("values");
                Object value0 = this.jsonValueToObject(values, propertyDataType, 0);
                if (PropertyType.STRING.equals((Object)propertyDataType) && (predicateString == null || "~".equals(predicateString) || "".equals(predicateString))) {
                    graphQuery.has(propertyName, (Predicate)TextPredicate.CONTAINS, (Value)value0);
                    break block18;
                }
                if (PropertyType.DATE.equals((Object)propertyDataType)) {
                    this.applyDateToQuery(graphQuery, obj, predicateString, values, searchOptions);
                    break block18;
                }
                if (PropertyType.BOOLEAN.equals((Object)propertyDataType)) {
                    graphQuery.has(propertyName, (Predicate)Compare.EQUAL, (Value)value0);
                    break block18;
                }
                if (PropertyType.GEO_LOCATION.equals((Object)propertyDataType)) {
                    GeoCompare geoComparePredicate = GeoCompare.valueOf(predicateString.toUpperCase());
                    graphQuery.has(propertyName, (Predicate)geoComparePredicate, (Value)value0);
                    break block18;
                }
                if ("<".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, (Value)value0);
                    break block18;
                }
                if ("<=".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN_EQUAL, (Value)value0);
                    break block18;
                }
                if (">".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN, (Value)value0);
                    break block18;
                }
                if (">=".equals(predicateString)) {
                    graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Value)value0);
                    break block18;
                }
                if ("range".equals(predicateString)) {
                    Object value1 = this.jsonValueToObject(values, propertyDataType, 1);
                    if (value0 instanceof DateTimeValue && value1 instanceof DateTimeValue) {
                        ZonedDateTime start = (ZonedDateTime)((DateTimeValue)value0).asObjectCopy();
                        ZonedDateTime end = (ZonedDateTime)((DateTimeValue)value1).asObjectCopy();
                        graphQuery.has(propertyName, (Predicate)Compare.RANGE, Values.of(new Range<ZonedDateTime>(start, true, end, false)));
                        break block18;
                    }
                    throw new IllegalArgumentException("Range query must have DateTimeValue values");
                }
                if ("=".equals(predicateString) || "equal".equals(predicateString)) {
                    if (PropertyType.DOUBLE.equals((Object)propertyDataType)) {
                        this.applyDoubleEqualityToQuery(graphQuery, obj, value0);
                    } else {
                        graphQuery.has(propertyName, (Predicate)Compare.EQUAL, (Value)value0);
                    }
                    break block18;
                }
                throw new BcException("unhandled query\n" + obj.toString(2));
            }
            catch (ParseException ex) {
                throw new BcException("Could not update query with filter:\n" + obj.toString(2), ex);
            }
        }
    }

    private void updateQueryWithDataTypeFilter(Query graphQuery, JSONObject obj, User user, SearchOptions searchOptions) {
        block6: {
            String dataType = obj.getString("dataType");
            String predicateString = obj.optString("predicate");
            PropertyType propertyType = PropertyType.valueOf(dataType);
            try {
                if ("has".equals(predicateString)) {
                    graphQuery.has(PropertyType.getTypeClass(propertyType));
                    break block6;
                }
                if ("hasNot".equals(predicateString)) {
                    graphQuery.hasNot(PropertyType.getTypeClass(propertyType));
                    break block6;
                }
                if ("in".equals(predicateString)) {
                    JSONArray values = obj.getJSONArray("values");
                    Value valueArr = this.convertJsonArray(values);
                    graphQuery.has(PropertyType.getTypeClass(propertyType), (Predicate)Contains.IN, Values.of(valueArr));
                    break block6;
                }
                JSONArray values = obj.getJSONArray("values");
                Object value0 = this.jsonValueToObject(values, propertyType, 0);
                if (PropertyType.GEO_LOCATION.equals((Object)propertyType)) {
                    GeoCompare geoComparePredicate = GeoCompare.valueOf(predicateString.toUpperCase());
                    graphQuery.has(GeoShapeValue.class, (Predicate)geoComparePredicate, (Value)value0);
                    break block6;
                }
                throw new UnsupportedOperationException("Data type queries are not yet supported for type: " + dataType);
            }
            catch (ParseException ex) {
                throw new BcException("Could not update query with filter:\n" + obj.toString(2), ex);
            }
        }
    }

    protected void applyLogicalOperatorsToQuery(Query currentQuery, String logicalSourceString) {
        if (currentQuery instanceof QueryBase) {
            ((QueryBase)currentQuery).setLogicalQuery(logicalSourceString);
        }
    }

    protected JSONArray getFilterJson(SearchOptions searchOptions, String workspaceId) {
        JSONArray filterJson = searchOptions.getRequiredParameter("filter", JSONArray.class);
        this.schemaRepository.resolvePropertyIds(filterJson, workspaceId);
        return filterJson;
    }

    protected JSONArray getSourceFilterJson(SearchOptions searchOptions) {
        JSONArray filterJson = (JSONArray)searchOptions.getOptionalParameter("source", JSONArray.class);
        if (filterJson != null) {
            this.schemaRepository.resolvePropertyIds(filterJson);
        }
        return filterJson;
    }

    protected String getSourceLogicalOperator(SearchOptions searchOptions) {
        return (String)((Object)searchOptions.getOptionalParameter("logicalSourceString", String.class));
    }

    protected void applyRefinementsToQuery(Query query, SearchOptions searchOptions) {
        JSONArray refinementJson = (JSONArray)searchOptions.getOptionalParameter("refinement", JSONArray.class);
        if (refinementJson == null) {
            return;
        }
        block10: for (int i = 0; i < refinementJson.length(); ++i) {
            boolean isDateOnly;
            String displayType;
            JSONObject obj = refinementJson.getJSONObject(i);
            if (obj.length() <= 0) continue;
            String propertyName = obj.getString("field");
            String refinementType = obj.getString("type");
            if ("conceptType".equals(propertyName) || "__conceptType".equals(propertyName)) {
                String propertyValue = obj.getString("bucketKey");
                query.hasConceptType(propertyValue);
                continue;
            }
            SchemaProperty property = this.schemaRepository.getPropertyByName(propertyName);
            PropertyType propertyDataType = property.getDataType();
            if ("term".equals(refinementType)) {
                String propertyValue = obj.getString("bucketKey");
                if (EMPTY_REFINEMENT_STRING.equals(propertyValue)) {
                    query.hasNot(propertyName);
                    continue;
                }
                switch (propertyDataType) {
                    case DATE: {
                        DateTimeValue dtv = DateTimeValue.ofEpochMillis(Values.longValue(Long.parseLong(propertyValue)));
                        displayType = property.getDisplayType();
                        isDateOnly = displayType != null && displayType.equals("dateOnly");
                        dtv = this.moveDateToStart(dtv);
                        query.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, dtv);
                        dtv = this.moveDateToEnd(dtv, isDateOnly);
                        query.has(propertyName, (Predicate)Compare.LESS_THAN, dtv);
                        break;
                    }
                    case BOOLEAN: {
                        query.has(propertyName, (Predicate)Compare.EQUAL, Values.booleanValue(Boolean.parseBoolean(propertyValue)));
                        break;
                    }
                    case DOUBLE: {
                        query.has(propertyName, (Predicate)Compare.EQUAL, Values.doubleValue(Double.parseDouble(propertyValue)));
                        break;
                    }
                    case INTEGER: {
                        query.has(propertyName, (Predicate)Compare.EQUAL, Values.intValue(Integer.parseInt(propertyValue)));
                        break;
                    }
                    default: {
                        query.has(propertyName, (Predicate)Compare.EQUAL, Values.of(propertyValue));
                    }
                }
                continue;
            }
            if ("histogram".equals(refinementType)) {
                String fromValue = null;
                String toValue = null;
                if (obj.has("bucketFromValue")) {
                    fromValue = obj.getString("bucketFromValue");
                }
                if (obj.has("bucketToValue")) {
                    toValue = obj.getString("bucketToValue");
                }
                switch (propertyDataType) {
                    case DATE: {
                        DateTimeValue dtv;
                        displayType = property.getDisplayType();
                        boolean bl = isDateOnly = displayType != null && displayType.equals("dateOnly");
                        if (fromValue != null) {
                            dtv = DateTimeValue.ofEpochMillis(Values.longValue(Long.parseLong(fromValue)));
                            dtv = this.moveDateToStart(dtv);
                            query.has(propertyName, (Predicate)Compare.GREATER_THAN, dtv);
                        }
                        if (toValue == null) continue block10;
                        dtv = DateTimeValue.ofEpochMillis(Values.longValue(Long.parseLong(toValue)));
                        dtv = this.moveDateToEnd(dtv, isDateOnly);
                        query.has(propertyName, (Predicate)Compare.LESS_THAN_EQUAL, dtv);
                        break;
                    }
                    case DOUBLE: 
                    case INTEGER: {
                        if (fromValue != null) {
                            query.has(propertyName, (Predicate)Compare.GREATER_THAN, Values.doubleValue(Double.parseDouble(fromValue)));
                        }
                        if (toValue == null) continue block10;
                        query.has(propertyName, (Predicate)Compare.LESS_THAN_EQUAL, Values.doubleValue(Double.parseDouble(toValue)));
                        break;
                    }
                    default: {
                        throw new BcException("unhandled histogram type\n" + obj.toString(2));
                    }
                }
                continue;
            }
            throw new BcException("unhandled refinement type\n" + obj.toString(2));
        }
    }

    private void applyDoubleEqualityToQuery(Query graphQuery, JSONObject obj, Object value0) throws ParseException {
        JSONObject metadata;
        String propertyName = obj.getString("propertyName");
        JSONObject jSONObject = metadata = obj.has("metadata") ? obj.getJSONObject("metadata") : null;
        if (metadata != null && metadata.has("inputPrecision") && value0 instanceof Double) {
            int inputPrecision;
            double lowerBound;
            double doubleParam = (Double)value0;
            double upperBound = Precision.equals((double)doubleParam, (double)(lowerBound = Precision.round((double)doubleParam, (int)(inputPrecision = Math.max(metadata.getInt("inputPrecision"), 0)), (int)1)), (double)Precision.EPSILON) ? lowerBound + Math.pow(10.0, -inputPrecision) : Precision.round((double)doubleParam, (int)inputPrecision, (int)0);
            graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, Values.doubleValue(lowerBound - Precision.EPSILON));
            graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN, Values.doubleValue(upperBound + Precision.EPSILON));
        } else {
            graphQuery.has(propertyName, (Predicate)Compare.EQUAL, Values.of(value0));
        }
    }

    private void applyDateToQuery(Query graphQuery, JSONObject obj, String predicate, JSONArray values, SearchOptions searchOptions) throws ParseException {
        String propertyName = obj.getString("propertyName");
        SchemaProperty property = this.schemaRepository.getPropertyByName(propertyName, searchOptions.getWorkspaceId());
        if (property != null && values.length() > 0) {
            DateTimeValue calendar = this.convertToDateTimeValue(values, 0);
            if (predicate == null || predicate.equals("equal") || predicate.equals("=")) {
                graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, calendar);
                graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN_EQUAL, calendar);
            } else if (predicate.equals("range")) {
                if (values.length() > 1) {
                    ZonedDateTime end;
                    DateTimeValue startCalendar = this.convertToDateTimeValue(values, 0);
                    DateTimeValue endCalendar = this.convertToDateTimeValue(values, 1);
                    ZonedDateTime start = (ZonedDateTime)startCalendar.asObjectCopy();
                    if (start.isBefore(end = (ZonedDateTime)endCalendar.asObjectCopy())) {
                        graphQuery.has(propertyName, (Predicate)Compare.RANGE, Values.of(new Range<ZonedDateTime>(start, true, end, false)));
                    } else {
                        graphQuery.has(propertyName, (Predicate)Compare.RANGE, Values.of(new Range<ZonedDateTime>(end, true, start, false)));
                    }
                }
            } else if (predicate.equals("<")) {
                graphQuery.has(propertyName, (Predicate)Compare.LESS_THAN_EQUAL, calendar);
            } else if (predicate.equals(">")) {
                graphQuery.has(propertyName, (Predicate)Compare.GREATER_THAN_EQUAL, calendar);
            }
        }
    }

    DateTimeValue convertToDateTimeValue(JSONArray values, int index) throws ParseException {
        DateTimeValue calendar;
        boolean isRelative = values.get(index) instanceof JSONObject;
        if (isRelative) {
            JSONObject fromNow = (JSONObject)values.get(index);
            calendar = DateTimeValue.now(Clocks.systemClock());
            calendar = this.moveDate(calendar, fromNow.getInt("unit"), fromNow.getInt("amount"));
        } else {
            calendar = (DateTimeValue)this.jsonValueToObject(values, PropertyType.DATE, index);
        }
        return calendar;
    }

    private DateTimeValue moveDate(DateTimeValue calendar, int calendarField, int amount) {
        switch (calendarField) {
            case 1: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.YEARS);
            }
            case 2: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.MONTHS);
            }
            case 3: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.WEEKS);
            }
            case 5: 
            case 6: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.DAYS);
            }
            case 10: 
            case 11: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.HOURS);
            }
            case 12: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.MINUTES);
            }
            case 13: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.SECONDS);
            }
            case 14: {
                return (DateTimeValue)calendar.plus(amount, ChronoUnit.MILLIS);
            }
        }
        throw new IllegalArgumentException("Unknown calendar field: " + calendarField);
    }

    private DateTimeValue moveDateToStart(DateTimeValue dtv) {
        ZonedDateTime zdt = (ZonedDateTime)dtv.asObjectCopy();
        return DateTimeValue.datetime(zdt.truncatedTo(ChronoUnit.DAYS));
    }

    private DateTimeValue moveDateToEnd(DateTimeValue dtv, boolean dateOnly) {
        if (dateOnly) {
            return (DateTimeValue)dtv.plus(1L, ChronoUnit.DAYS);
        }
        return (DateTimeValue)dtv.plus(1L, ChronoUnit.MINUTES);
    }

    private Object jsonValueToObject(JSONArray values, PropertyType propertyDataType, int index) throws ParseException {
        if (values.get(index) instanceof JSONObject) {
            return values.get(index);
        }
        return SchemaProperty.convert(values, propertyDataType, index);
    }

    protected Graph getGraph() {
        return this.graph;
    }

    public SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    private Value convertJsonArray(JSONArray arr) {
        Object[] valueArr = new Object[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            valueArr[i] = arr.get(i);
        }
        if (valueArr.length > 0) {
            Class<?> valueType = valueArr[0].getClass();
            Object[] newArr = (Object[])Array.newInstance(valueType, valueArr.length);
            System.arraycopy(valueArr, 0, newArr, 0, valueArr.length);
            return Values.of(newArr);
        }
        return Values.stringArray(new String[0]);
    }
}

