/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.mware.core.config.Configuration;
import com.mware.core.model.schema.Relationship;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.search.GeObjectSearchRunnerBase;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.EdgeInfo;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.query.EmptyResultsGraphQuery;
import com.mware.ge.query.Query;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class GeObjectSearchRunnerWithRelatedBase
extends GeObjectSearchRunnerBase {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GeObjectSearchRunnerWithRelatedBase.class);

    protected GeObjectSearchRunnerWithRelatedBase(SchemaRepository schemaRepository, Graph graph, Configuration configuration) {
        super(schemaRepository, graph, configuration);
    }

    @Override
    protected Query getQuery(SearchOptions searchOptions, Authorizations authorizations) {
        JSONArray filterJson = this.getFilterJson(searchOptions, searchOptions.getWorkspaceId());
        String queryStringParam = (String)((Object)searchOptions.getOptionalParameter("q", String.class));
        Object[] relatedToVertexIdsParam = (String[])searchOptions.getOptionalParameter("relatedToVertexIds[]", String[].class);
        String elementExtendedDataParam = (String)((Object)searchOptions.getOptionalParameter("elementExtendedData", String.class));
        ImmutableList relatedToVertexIds = ImmutableList.of();
        ElementExtendedData elementExtendedData = null;
        if (relatedToVertexIdsParam == null && elementExtendedDataParam == null) {
            queryStringParam = searchOptions.getRequiredParameter("q", String.class);
        } else if (elementExtendedDataParam != null) {
            elementExtendedData = ElementExtendedData.fromJsonString(elementExtendedDataParam);
        } else {
            relatedToVertexIds = ImmutableList.copyOf((Object[])relatedToVertexIdsParam);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("search %s (relatedToVertexIds: %s, elementExtendedData: %s)\n%s", queryStringParam, Joiner.on((String)",").join((Iterable)relatedToVertexIds), elementExtendedData, filterJson.toString(2));
        }
        Query graphQuery = this.getGraph().query(queryStringParam, authorizations);
        if (elementExtendedData != null) {
            graphQuery = graphQuery.hasExtendedData(elementExtendedData.elementType, elementExtendedData.elementId, elementExtendedData.tableName);
        } else if (!relatedToVertexIds.isEmpty()) {
            String[] edgeLabels = this.getEdgeLabels(searchOptions);
            Set<String> allRelatedIds = relatedToVertexIds.stream().map(vertexId -> {
                Vertex vertex = this.getGraph().getVertex((String)vertexId, FetchHints.EDGE_REFS, authorizations);
                Preconditions.checkNotNull((Object)vertex, (Object)("Could not find vertex: " + vertexId));
                return vertex;
            }).flatMap(vertex -> {
                Iterable<EdgeInfo> edgeInfos = vertex.getEdgeInfos(Direction.BOTH, edgeLabels, authorizations);
                return StreamSupport.stream(edgeInfos.spliterator(), false).map(EdgeInfo::getVertexId);
            }).collect(Collectors.toSet());
            graphQuery = allRelatedIds.isEmpty() ? new EmptyResultsGraphQuery() : graphQuery.hasId(allRelatedIds);
        }
        return graphQuery;
    }

    private String[] getEdgeLabels(SearchOptions searchOptions) {
        Collection<SchemaRepository.ElementTypeFilter> edgeLabelFilters = this.getEdgeLabelFilters(searchOptions);
        if (edgeLabelFilters == null || edgeLabelFilters.isEmpty()) {
            return null;
        }
        return (String[])edgeLabelFilters.stream().flatMap(filter -> {
            if (filter.includeChildNodes) {
                return this.getSchemaRepository().getRelationshipAndAllChildrenByName(filter.iri, searchOptions.getWorkspaceId()).stream().map(Relationship::getName);
            }
            return Stream.of(filter.iri);
        }).toArray(String[]::new);
    }

    private static class ElementExtendedData {
        public final ElementType elementType;
        public final String elementId;
        public final String tableName;

        private ElementExtendedData(ElementType elementType, String elementId, String tableName) {
            this.elementType = elementType;
            this.elementId = elementId;
            this.tableName = tableName;
        }

        public static ElementExtendedData fromJsonString(String str) {
            JSONObject json = new JSONObject(str);
            ElementType elementType = null;
            String elementTypeString = json.optString("elementType");
            if (!Strings.isNullOrEmpty((String)elementTypeString)) {
                elementType = ElementType.valueOf(elementTypeString.toUpperCase());
            }
            String elementId = json.optString("elementId", null);
            String tableName = json.optString("tableName", null);
            return new ElementExtendedData(elementType, elementId, tableName);
        }

        public String toString() {
            return "ElementExtendedData{elementType='" + (Object)((Object)this.elementType) + '\'' + ", elementId='" + this.elementId + '\'' + ", tableName='" + this.tableName + '\'' + '}';
        }
    }
}

