/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.google.inject.Inject;
import com.mware.core.model.clientapi.dto.ClientApiElementSearchResponse;
import com.mware.core.model.clientapi.dto.ClientApiGeObject;
import com.mware.core.model.clientapi.dto.ClientApiSearch;
import com.mware.core.model.clientapi.dto.ClientApiVertex;
import com.mware.core.model.search.QueryResultsIterableSearchResults;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.model.search.SearchRepository;
import com.mware.core.model.search.SearchResults;
import com.mware.core.model.search.SearchRunner;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchHelper {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SearchHelper.class);
    protected final SearchRepository searchRepository;
    protected final GraphBaseWithSearchIndex graph;

    @Inject
    public SearchHelper(SearchRepository searchRepository, Graph graph) {
        this.searchRepository = searchRepository;
        this.graph = (GraphBaseWithSearchIndex)graph;
    }

    public List<Element> search(ClientApiSearch savedSearch, User user, Authorizations authorizations, boolean includeEdges) {
        SearchRunner searchRunner = this.searchRepository.findSearchRunnerByUri(savedSearch.url);
        LOGGER.debug("SEARCH - Found search runner: %s", searchRunner.getUri());
        Map<String, Object> searchParams = savedSearch.prepareParamsForSearch();
        ArrayList<Element> results = new ArrayList<Element>();
        searchParams.put("size", -1);
        SearchOptions searchOptions = new SearchOptions(searchParams, "public-ontology");
        try (SearchResults searchResults = searchRunner.run(searchOptions, user, authorizations);){
            QueryResultsIterableSearchResults geObjectsSearchResults = (QueryResultsIterableSearchResults)searchResults;
            for (GeObject geObject : geObjectsSearchResults.getGeObjects()) {
                if (geObject instanceof Vertex || includeEdges) {
                    results.add((Element)geObject);
                    continue;
                }
                LOGGER.warn("Can only process instances of Vertex.", new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Job with id %s failed. Error msg : %s", savedSearch.id, e.getMessage()), e);
        }
        return results;
    }

    public List<String> searchCypher(ClientApiSearch savedSearch, User user, Authorizations authorizations) {
        SearchRunner searchRunner = this.searchRepository.findSearchRunnerByUri(savedSearch.url);
        LOGGER.debug("SEARCH CYPHER - Found search runner: %s", searchRunner.getUri());
        Map<String, Object> searchParams = savedSearch.prepareParamsForSearch();
        ArrayList<String> results = new ArrayList<String>();
        SearchOptions searchOptions = new SearchOptions(searchParams, "public-ontology");
        try (SearchResults searchResults = searchRunner.run(searchOptions, user, authorizations);){
            if (searchResults instanceof ClientApiElementSearchResponse) {
                ClientApiElementSearchResponse elementResponse = (ClientApiElementSearchResponse)searchResults;
                for (ClientApiGeObject geo : elementResponse.getElements()) {
                    if (geo instanceof ClientApiVertex) {
                        results.add(((ClientApiVertex)geo).getId());
                        continue;
                    }
                    LOGGER.warn("Can only process instances of Vertex.", new Object[0]);
                }
            } else {
                LOGGER.warn(String.format("Don't know how to process search results of type: %s", searchResults.getClass().getName()), new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Job with id %s failed. Error msg : %s", savedSearch.id, e.getMessage()), e);
        }
        return results;
    }
}

