/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.google.common.base.Preconditions;
import com.mware.core.exception.BcException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SearchOptions {
    private final Map<String, Object> parameters;
    private final String workspaceId;

    public SearchOptions(Map<String, Object> parameters, String workspaceId) {
        this.parameters = parameters;
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public <T> T getOptionalParameter(String parameterName, Class<T> resultType) {
        Object obj = this.parameters.get(parameterName);
        if (obj == null) {
            return null;
        }
        try {
            if (resultType.isArray() && obj instanceof Collection) {
                Collection collection = (Collection)obj;
                Class<?> type = resultType.getComponentType();
                return (T)collection.toArray((Object[])Array.newInstance(type, collection.size()));
            }
            if (resultType.isArray() && !obj.getClass().isArray()) {
                Object[] array = (Object[])Array.newInstance(resultType.getComponentType(), 1);
                array[0] = this.objectToType(obj, resultType.getComponentType());
                return this.objectToType(array, resultType);
            }
            return this.objectToType(obj, resultType);
        }
        catch (Exception ex) {
            throw new BcException("Could not cast object \"" + obj + "\" to type \"" + resultType.getName() + "\"", ex);
        }
    }

    private <T> T objectToType(Object obj, Class<T> resultType) {
        if (obj != null && resultType == obj.getClass()) {
            return (T)obj;
        }
        if (resultType == Integer.class && obj instanceof String) {
            return resultType.cast(Integer.parseInt((String)obj));
        }
        if (resultType == Long.class && obj instanceof String) {
            return resultType.cast(Long.parseLong((String)obj));
        }
        if (resultType == Long.class && obj instanceof Integer) {
            return resultType.cast(((Integer)obj).longValue());
        }
        if (resultType == Double.class && obj instanceof String) {
            return resultType.cast(Double.parseDouble((String)obj));
        }
        if (resultType == Float.class && obj instanceof String) {
            return resultType.cast(Float.valueOf(Float.parseFloat((String)obj)));
        }
        if (resultType == JSONArray.class && obj instanceof String) {
            return resultType.cast(new JSONArray((String)obj));
        }
        if (resultType == JSONArray.class && obj instanceof String[]) {
            return resultType.cast(new JSONArray(obj));
        }
        if (resultType == Boolean.class && obj instanceof String) {
            return resultType.cast(Boolean.parseBoolean((String)obj));
        }
        if (resultType == String.class && obj instanceof JSONObject) {
            return resultType.cast(obj.toString());
        }
        return resultType.cast(obj);
    }

    public <T> T getOptionalParameter(String parameterName, T defaultValue) {
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue cannot be null");
        Class<?> obj = this.getOptionalParameter(parameterName, (T)defaultValue.getClass());
        if (obj == null) {
            if (this.parameters.containsKey(parameterName)) {
                return null;
            }
            return defaultValue;
        }
        return (T)obj;
    }

    public <T> T getRequiredParameter(String parameterName, Class<T> resultType) {
        Class<T> obj = this.getOptionalParameter(parameterName, (T)resultType);
        if (obj == null) {
            throw new BcException("Missing parameter: " + parameterName);
        }
        return (T)obj;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "SearchOptions{parameters=" + this.parameters + ", workspaceId='" + this.workspaceId + '\'' + '}';
    }
}

