/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.model.clientapi.dto.ClientApiSearch;
import com.mware.core.model.clientapi.dto.ClientApiSearchListResponse;
import com.mware.core.model.search.SearchRunner;
import com.mware.core.user.User;
import java.util.Collection;
import org.json.JSONObject;

public abstract class SearchRepository {
    private final Collection<SearchRunner> searchRunners;

    protected SearchRepository(Configuration configuration) {
        this.searchRunners = InjectHelper.getInjectedServices(SearchRunner.class, configuration);
    }

    public abstract String saveSearch(String var1, String var2, String var3, JSONObject var4, User var5, boolean var6);

    public abstract String saveGlobalSearch(String var1, String var2, String var3, JSONObject var4, User var5, boolean var6);

    public abstract ClientApiSearchListResponse getSavedSearches(User var1);

    public abstract ClientApiSearch getSavedSearch(String var1, User var2);

    public abstract ClientApiSearch getSavedSearchOnWorkspace(String var1, User var2, String var3);

    public abstract void deleteSearch(String var1, User var2);

    public SearchRunner findSearchRunnerByUri(String searchUri) {
        for (SearchRunner searchRunner : this.searchRunners) {
            if (!searchRunner.getUri().equals(searchUri)) continue;
            return searchRunner;
        }
        return null;
    }
}

