/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.search;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.model.search.SearchRunner;
import com.mware.core.model.search.VertexFindRelatedSearchResults;
import com.mware.core.user.User;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class VertexFindRelatedSearchRunner
extends SearchRunner {
    public static final String URI = "/vertex/find-related";
    private final SchemaRepository schemaRepository;
    private final Graph graph;

    @Inject
    public VertexFindRelatedSearchRunner(Graph graph, SchemaRepository schemaRepository) {
        this.graph = graph;
        this.schemaRepository = schemaRepository;
    }

    @Override
    public String getUri() {
        return URI;
    }

    @Override
    public VertexFindRelatedSearchResults run(SearchOptions searchOptions, User user, Authorizations authorizations) {
        String[] graphVertexIds = searchOptions.getRequiredParameter("graphVertexIds[]", String[].class);
        String limitParentConceptId = (String)((Object)searchOptions.getOptionalParameter("limitParentConceptId", String.class));
        String limitEdgeLabel = (String)((Object)searchOptions.getOptionalParameter("limitEdgeLabel", String.class));
        long maxVerticesToReturn = searchOptions.getOptionalParameter("maxVerticesToReturn", 1000L);
        HashSet<String> limitConceptIds = new HashSet<String>();
        if (limitParentConceptId != null) {
            Set<Concept> limitConcepts = this.schemaRepository.getConceptAndAllChildrenByName(limitParentConceptId, searchOptions.getWorkspaceId());
            if (limitConcepts == null) {
                throw new RuntimeException("Bad 'limitParentConceptId', no concept found for id: " + limitParentConceptId);
            }
            for (Concept con : limitConcepts) {
                limitConceptIds.add(con.getName());
            }
        }
        return this.getSearchResults(graphVertexIds, limitEdgeLabel, limitConceptIds, maxVerticesToReturn, authorizations);
    }

    private VertexFindRelatedSearchResults getSearchResults(String[] graphVertexIds, String limitEdgeLabel, Set<String> limitConceptIds, long maxVerticesToReturn, Authorizations authorizations) {
        HashSet<Object> visitedIds = new HashSet<Object>();
        long count = visitedIds.size();
        Iterable<Vertex> vertices = this.graph.getVertices(Lists.newArrayList((Object[])graphVertexIds), FetchHints.EDGE_REFS, authorizations);
        ArrayList<Vertex> elements = new ArrayList<Vertex>();
        for (Vertex v : vertices) {
            Iterable<Vertex> relatedVertices = v.getVertices(Direction.BOTH, limitEdgeLabel, ClientApiConverter.SEARCH_FETCH_HINTS, authorizations);
            for (Vertex vertex : relatedVertices) {
                if (!visitedIds.add(vertex.getId()) || limitConceptIds.size() != 0 && this.isLimited(vertex, limitConceptIds)) continue;
                if (count < maxVerticesToReturn) {
                    elements.add(vertex);
                }
                ++count;
            }
        }
        return new VertexFindRelatedSearchResults(elements, count);
    }

    private boolean isLimited(Vertex vertex, Set<String> limitConceptIds) {
        return !limitConceptIds.contains(vertex.getConceptType());
    }
}

