/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.termMention;

import com.google.common.base.Preconditions;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.termMention.TermMentionFor;
import com.mware.core.security.BcVisibility;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeBuilderByVertexId;
import com.mware.ge.Element;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import java.time.ZonedDateTime;

public class TermMentionBuilder {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(TermMentionBuilder.class);
    private Vertex outVertex;
    private String propertyKey;
    private String propertyName;
    private long start = -1L;
    private long end = -1L;
    private String title;
    private String conceptName;
    private VisibilityJson visibilityJson;
    private String process;
    private String resolvedToVertexId;
    private String resolvedEdgeId;
    private String snippet;
    private String resolvedFromTermMention;
    private String type;
    private String style;
    private Double score;

    public TermMentionBuilder() {
    }

    public TermMentionBuilder(Vertex existingTermMention, Vertex outVertex) {
        this.outVertex = outVertex;
        this.resolvedFromTermMention = existingTermMention.getId();
        this.propertyKey = (String)BcSchema.TERM_MENTION_PROPERTY_KEY.getPropertyValue(existingTermMention);
        this.propertyName = (String)BcSchema.TERM_MENTION_PROPERTY_NAME.getPropertyValue(existingTermMention);
        this.start = BcSchema.TERM_MENTION_START_OFFSET.getPropertyValue((Element)existingTermMention, 0L);
        this.end = BcSchema.TERM_MENTION_END_OFFSET.getPropertyValue((Element)existingTermMention, 0L);
        this.title = BcSchema.TERM_MENTION_TITLE.getPropertyValue(existingTermMention, "");
        this.snippet = (String)BcSchema.TERM_MENTION_SNIPPET.getPropertyValue(existingTermMention);
        this.conceptName = BcSchema.TERM_MENTION_CONCEPT_TYPE.getPropertyValue(existingTermMention, "");
        this.type = BcSchema.TERM_MENTION_TYPE.getPropertyValue(existingTermMention, "");
        this.style = BcSchema.TERM_MENTION_STYLE.getPropertyValue(existingTermMention, "");
        this.score = BcSchema.TERM_MENTION_SCORE.getPropertyValue((Element)existingTermMention, 0.0);
        this.visibilityJson = BcSchema.TERM_MENTION_VISIBILITY_JSON.getPropertyValue(existingTermMention, new VisibilityJson());
    }

    public TermMentionBuilder type(String type) {
        this.type = type;
        return this;
    }

    public TermMentionBuilder style(String style) {
        this.style = style;
        return this;
    }

    public TermMentionBuilder score(Double score) {
        this.score = score;
        return this;
    }

    public TermMentionBuilder start(long start) {
        this.start = start;
        return this;
    }

    public TermMentionBuilder end(long end) {
        this.end = end;
        return this;
    }

    public TermMentionBuilder propertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
    }

    public TermMentionBuilder resolvedFromTermMention(String resolvedFromFromTermMention) {
        this.resolvedFromTermMention = resolvedFromFromTermMention;
        return this;
    }

    public TermMentionBuilder propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public TermMentionBuilder visibilityJson(String visibilityJsonString) {
        return this.visibilityJson(TermMentionBuilder.visibilityJsonStringToJson(visibilityJsonString));
    }

    public TermMentionBuilder visibilityJson(VisibilityJson visibilitySource) {
        this.visibilityJson = visibilitySource;
        return this;
    }

    private static VisibilityJson visibilityJsonStringToJson(String visibilityJsonString) {
        if (visibilityJsonString == null) {
            return new VisibilityJson();
        }
        if (visibilityJsonString.length() == 0) {
            return new VisibilityJson();
        }
        return ClientApiConverter.toClientApi(visibilityJsonString, VisibilityJson.class);
    }

    public TermMentionBuilder resolvedTo(Vertex resolvedToVertex, Edge resolvedEdge) {
        return this.resolvedTo((String)resolvedToVertex.getId(), (String)resolvedEdge.getId());
    }

    public TermMentionBuilder resolvedTo(String resolvedToVertexId, String resolvedEdgeId) {
        this.resolvedToVertexId = resolvedToVertexId;
        this.resolvedEdgeId = resolvedEdgeId;
        return this;
    }

    public TermMentionBuilder process(String process) {
        this.process = process;
        return this;
    }

    public TermMentionBuilder outVertex(Vertex outVertex) {
        this.outVertex = outVertex;
        return this;
    }

    public TermMentionBuilder title(String title) {
        this.title = title;
        return this;
    }

    public TermMentionBuilder snippet(String snippet) {
        this.snippet = snippet;
        return this;
    }

    public TermMentionBuilder conceptName(String conceptName) {
        this.conceptName = conceptName;
        return this;
    }

    public Vertex save(Graph graph, VisibilityTranslator visibilityTranslator, User user, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)this.outVertex, (Object)"outVertex cannot be null");
        Preconditions.checkNotNull((Object)this.propertyKey, (Object)"propertyKey cannot be null");
        Preconditions.checkNotNull((Object)this.title, (Object)"title cannot be null");
        Preconditions.checkArgument((this.title.length() > 0 ? 1 : 0) != 0, (Object)"title cannot be an empty string");
        Preconditions.checkNotNull((Object)this.visibilityJson, (Object)"visibilityJson cannot be null");
        Preconditions.checkNotNull((Object)this.process, (Object)"process cannot be null");
        Preconditions.checkArgument((this.process.length() > 0 ? 1 : 0) != 0, (Object)"process cannot be an empty string");
        Preconditions.checkArgument((this.start >= 0L ? 1 : 0) != 0, (Object)"start must be greater than or equal to 0");
        Preconditions.checkArgument((this.end >= 0L ? 1 : 0) != 0, (Object)"start must be greater than or equal to 0");
        if (this.propertyName == null) {
            LOGGER.warn("Not setting a propertyName when building a term mention is deprecated", new Object[0]);
        }
        ZonedDateTime now = ZonedDateTime.now();
        Visibility defaultVisibility = visibilityTranslator.getDefaultVisibility();
        Visibility visibility = BcVisibility.and(visibilityTranslator.toVisibility(this.visibilityJson).getVisibility(), "termMention");
        VertexBuilder vertexBuilder = graph.prepareVertex(visibility, "thing");
        BcSchema.TERM_MENTION_VISIBILITY_JSON.setProperty(vertexBuilder, this.visibilityJson, visibility);
        BcSchema.TERM_MENTION_CONCEPT_TYPE.setProperty(vertexBuilder, this.conceptName, visibility);
        BcSchema.TERM_MENTION_TYPE.setProperty(vertexBuilder, this.type, visibility);
        BcSchema.TERM_MENTION_START_OFFSET.setProperty(vertexBuilder, this.start, visibility);
        BcSchema.TERM_MENTION_END_OFFSET.setProperty(vertexBuilder, this.end, visibility);
        BcSchema.TERM_MENTION_PROCESS.setProperty(vertexBuilder, this.process, visibility);
        BcSchema.TERM_MENTION_PROPERTY_KEY.setProperty(vertexBuilder, this.propertyKey, visibility);
        BcSchema.TERM_MENTION_TITLE.setProperty(vertexBuilder, this.title, visibility);
        BcSchema.TERM_MENTION_STYLE.setProperty(vertexBuilder, this.style, visibility);
        BcSchema.TERM_MENTION_SCORE.setProperty(vertexBuilder, this.score, visibility);
        if (this.propertyName != null) {
            BcSchema.TERM_MENTION_PROPERTY_NAME.setProperty(vertexBuilder, this.propertyName, visibility);
        }
        if (this.resolvedEdgeId != null) {
            BcSchema.TERM_MENTION_RESOLVED_EDGE_ID.setProperty(vertexBuilder, this.resolvedEdgeId, visibility);
        }
        if (this.snippet != null) {
            BcSchema.TERM_MENTION_SNIPPET.setProperty(vertexBuilder, this.snippet, visibility);
        }
        if (this.resolvedToVertexId != null) {
            BcSchema.TERM_MENTION_FOR_ELEMENT_ID.setProperty(vertexBuilder, this.resolvedToVertexId, visibility);
            BcSchema.TERM_MENTION_FOR_TYPE.setProperty(vertexBuilder, TermMentionFor.VERTEX, visibility);
        }
        Authorizations termMentionAuthorizations = graph.createAuthorizations(authorizations, "termMention");
        Vertex termMentionVertex = vertexBuilder.save(termMentionAuthorizations);
        EdgeBuilder termMentionEdgeBuilder = graph.prepareEdge(this.outVertex, termMentionVertex, "tmHasTermMention", visibility);
        BcSchema.TERM_MENTION_VISIBILITY_JSON.setProperty(termMentionEdgeBuilder, this.visibilityJson, visibility);
        BcSchema.MODIFIED_BY.setProperty(termMentionEdgeBuilder, user.getUserId(), defaultVisibility);
        BcSchema.MODIFIED_DATE.setProperty(termMentionEdgeBuilder, now, defaultVisibility);
        termMentionEdgeBuilder.save(termMentionAuthorizations);
        if (this.resolvedToVertexId != null) {
            EdgeBuilderByVertexId resolvedToEdgeBuilder = graph.prepareEdge((String)termMentionVertex.getId(), this.resolvedToVertexId, "tmRsolvedTo", visibility);
            BcSchema.TERM_MENTION_VISIBILITY_JSON.setProperty(resolvedToEdgeBuilder, this.visibilityJson, visibility);
            BcSchema.MODIFIED_BY.setProperty(resolvedToEdgeBuilder, user.getUserId(), defaultVisibility);
            BcSchema.MODIFIED_DATE.setProperty(resolvedToEdgeBuilder, now, defaultVisibility);
            resolvedToEdgeBuilder.save(termMentionAuthorizations);
            if (this.resolvedFromTermMention != null) {
                EdgeBuilderByVertexId resolvedFromEdgeBuilder = graph.prepareEdge((String)termMentionVertex.getId(), this.resolvedFromTermMention, "tmResolvedFrom", visibility);
                BcSchema.TERM_MENTION_VISIBILITY_JSON.setProperty(resolvedFromEdgeBuilder, this.visibilityJson, visibility);
                BcSchema.MODIFIED_BY.setProperty(resolvedFromEdgeBuilder, user.getUserId(), defaultVisibility);
                BcSchema.MODIFIED_DATE.setProperty(resolvedFromEdgeBuilder, now, defaultVisibility);
                resolvedFromEdgeBuilder.save(termMentionAuthorizations);
            }
        }
        return termMentionVertex;
    }
}

