/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.termMention;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.model.clientapi.dto.ClientApiSourceInfo;
import com.mware.core.model.clientapi.dto.ClientApiTermMentionsResponse;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.termMention.TermMentionFor;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.security.BcVisibility;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.mware.core.util.SourceInfoSnippetSanitizer;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.Graph;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.JoinIterable;
import com.mware.ge.util.StreamUtils;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

@Singleton
public class TermMentionRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(TermMentionRepository.class);
    public static final String VISIBILITY_STRING = "termMention";
    private final Graph graph;

    @Inject
    public TermMentionRepository(Graph graph, GraphAuthorizationRepository graphAuthorizationRepository) {
        this.graph = graph;
        graphAuthorizationRepository.addAuthorizationToGraph(VISIBILITY_STRING);
    }

    public Iterable<Vertex> findByOutVertexAndProperty(String outVertexId, final String propertyKey, final String propertyName, Authorizations authorizations) {
        authorizations = this.getAuthorizations(authorizations);
        return new FilterIterable<Vertex>(this.findByOutVertex(outVertexId, authorizations)){

            @Override
            protected boolean isIncluded(Vertex v) {
                String vertexPropertyKey = (String)BcSchema.TERM_MENTION_PROPERTY_KEY.getPropertyValue(v);
                if (!propertyKey.equals(vertexPropertyKey)) {
                    return false;
                }
                String vertexPropertyName = BcSchema.TERM_MENTION_PROPERTY_NAME.getPropertyValue(v, null);
                if (BcSchema.TEXT.getPropertyName().equals(propertyName) && vertexPropertyName == null) {
                    return true;
                }
                return propertyName.equals(vertexPropertyName);
            }
        };
    }

    public Iterable<Vertex> findByOutVertex(String outVertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizationsWithTermMention);
        return outVertex.getVertices(Direction.OUT, "tmHasTermMention", authorizationsWithTermMention);
    }

    public void deleteAllTermMentions(String outVertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizationsWithTermMention);
        Iterable<String> termMentionVertices = outVertex.getVertexIds(Direction.OUT, "tmHasTermMention", authorizationsWithTermMention);
        this.graph.deleteElements(StreamUtils.stream(termMentionVertices).map(id -> ElementId.create(ElementType.VERTEX, id)), authorizationsWithTermMention);
    }

    public void deleteTermMentions(String type, String outVertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizationsWithTermMention);
        Iterable<Vertex> termMentionVertices = outVertex.getVertices(Direction.OUT, "tmHasTermMention", authorizationsWithTermMention);
        this.graph.deleteElements(StreamUtils.stream(termMentionVertices).filter(v -> {
            if (StringUtils.isEmpty((String)type)) {
                return StringUtils.isEmpty((String)((String)BcSchema.TERM_MENTION_TYPE.getPropertyValue((Element)v)));
            }
            return type.equals(BcSchema.TERM_MENTION_TYPE.getPropertyValue((Element)v));
        }).map(v -> ElementId.create(ElementType.VERTEX, (String)v.getId())), authorizationsWithTermMention);
    }

    public Iterable<Vertex> findByVertexId(String vertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex vertex = this.graph.getVertex(vertexId, authorizationsWithTermMention);
        String[] labels = new String[]{"tmHasTermMention", "tmRsolvedTo"};
        return vertex.getVertices(Direction.BOTH, labels, authorizationsWithTermMention);
    }

    public Iterable<Vertex> findByEdge(Edge edge, Authorizations authorizations) {
        return new JoinIterable<Vertex>(this.findByVertexId(edge.getVertexId(Direction.IN), authorizations), this.findByVertexId(edge.getVertexId(Direction.OUT), authorizations));
    }

    public Iterable<Vertex> findByVertexIdForVertex(final String vertexId, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByVertexId(vertexId, authorizations)){

            @Override
            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)BcSchema.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue(termMention);
                if (forElementId == null || !forElementId.equals(vertexId)) {
                    return false;
                }
                TermMentionFor forType = (TermMentionFor)((Object)BcSchema.TERM_MENTION_FOR_TYPE.getPropertyValue(termMention));
                return forType != null && forType == TermMentionFor.VERTEX;
            }
        };
    }

    public Iterable<Vertex> findByEdgeForEdge(final Edge edge, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByEdge(edge, authorizations)){

            @Override
            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)BcSchema.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue(termMention);
                if (forElementId == null || !forElementId.equals(edge.getId())) {
                    return false;
                }
                TermMentionFor forType = (TermMentionFor)((Object)BcSchema.TERM_MENTION_FOR_TYPE.getPropertyValue(termMention));
                return forType != null && forType == TermMentionFor.EDGE;
            }
        };
    }

    public Iterable<Vertex> findByVertexIdAndProperty(final String vertexId, final String propertyKey, final String propertyName, final Visibility propertyVisibility, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByVertexId(vertexId, authorizations)){

            @Override
            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)BcSchema.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue(termMention);
                if (forElementId == null || !forElementId.equals(vertexId)) {
                    return false;
                }
                return TermMentionRepository.this.isTermMentionForProperty(termMention, propertyKey, propertyName, propertyVisibility);
            }
        };
    }

    public Iterable<Vertex> findByEdgeIdAndProperty(final Edge edge, final String propertyKey, final String propertyName, final Visibility propertyVisibility, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByEdge(edge, authorizations)){

            @Override
            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)BcSchema.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue(termMention);
                if (forElementId == null || !forElementId.equals(edge.getId())) {
                    return false;
                }
                return TermMentionRepository.this.isTermMentionForProperty(termMention, propertyKey, propertyName, propertyVisibility);
            }
        };
    }

    private boolean isTermMentionForProperty(Vertex termMention, String propertyKey, String propertyName, Visibility propertyVisibility) {
        TermMentionFor forType = (TermMentionFor)((Object)BcSchema.TERM_MENTION_FOR_TYPE.getPropertyValue(termMention));
        if (forType == null || forType != TermMentionFor.PROPERTY) {
            return false;
        }
        String refPropertyKey = (String)BcSchema.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue(termMention);
        if (refPropertyKey == null || !refPropertyKey.equals(propertyKey)) {
            return false;
        }
        String refPropertyName = (String)BcSchema.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue(termMention);
        if (refPropertyName == null || !refPropertyName.equals(propertyName)) {
            return false;
        }
        String refPropertyVisibilityString = (String)BcSchema.TERM_MENTION_REF_PROPERTY_VISIBILITY.getPropertyValue(termMention);
        return refPropertyVisibilityString != null && refPropertyVisibilityString.equals(propertyVisibility.getVisibilityString());
    }

    public Vertex findById(String termMentionId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        return this.graph.getVertex(termMentionId, authorizationsWithTermMention);
    }

    public void updateVisibility(Vertex termMention, Visibility newVisibility, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Visibility newVisibilityWithTermMention = BcVisibility.and(newVisibility, VISIBILITY_STRING);
        ExistingVertexMutation m = termMention.prepareMutation();
        m.alterElementVisibility(newVisibilityWithTermMention);
        for (Property property : termMention.getProperties()) {
            m.alterPropertyVisibility(property, newVisibilityWithTermMention);
        }
        Property refPropertyVisibility = BcSchema.TERM_MENTION_REF_PROPERTY_VISIBILITY.getProperty(termMention);
        if (refPropertyVisibility != null) {
            BcSchema.TERM_MENTION_REF_PROPERTY_VISIBILITY.setProperty(m, newVisibility.getVisibilityString(), refPropertyVisibility.getMetadata(), newVisibilityWithTermMention);
        }
        m.save(authorizationsWithTermMention);
        for (Edge edge : termMention.getEdges(Direction.BOTH, authorizationsWithTermMention)) {
            ExistingEdgeMutation edgeMutation = edge.prepareMutation();
            edgeMutation.alterElementVisibility(newVisibilityWithTermMention);
            for (Property property : edge.getProperties()) {
                edgeMutation.alterPropertyVisibility(property, newVisibilityWithTermMention);
            }
            edgeMutation.save(authorizationsWithTermMention);
        }
    }

    public Iterable<Vertex> findResolvedTo(String inVertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex inVertex = this.graph.getVertex(inVertexId, authorizationsWithTermMention);
        return inVertex.getVertices(Direction.IN, "tmRsolvedTo", authorizationsWithTermMention);
    }

    public Stream<Vertex> findResolvedToForRef(String inVertexId, String refPropertyKey, String refPropertyName, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)refPropertyKey, (Object)"refPropertyKey cannot be null");
        Preconditions.checkNotNull((Object)refPropertyName, (Object)"refPropertyName cannot be null");
        return StreamUtil.stream(this.findResolvedTo(inVertexId, authorizations)).filter(vertex -> {
            String vertexRefPropertyKey = BcSchema.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)vertex, null);
            String vertexRefPropertyName = BcSchema.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)vertex, null);
            return refPropertyKey.equals(vertexRefPropertyKey) && refPropertyName.equals(vertexRefPropertyName);
        });
    }

    public Stream<Vertex> findResolvedToForRefElement(String inVertexId, Authorizations authorizations) {
        return StreamUtil.stream(this.findResolvedTo(inVertexId, authorizations)).filter(vertex -> {
            String vertexRefPropertyKey = BcSchema.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)vertex, null);
            String vertexRefPropertyName = BcSchema.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)vertex, null);
            return vertexRefPropertyKey == null && vertexRefPropertyName == null;
        });
    }

    public void delete(Vertex termMention, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        this.graph.softDeleteVertex(termMention, authorizationsWithTermMention);
    }

    public void markHidden(Vertex termMention, Visibility hiddenVisibility, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        this.graph.markVertexHidden(termMention, hiddenVisibility, authorizationsWithTermMention);
    }

    public Iterable<Vertex> findByEdgeId(String outVertexId, final String edgeId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizationsWithTermMention);
        return new FilterIterable<Vertex>(outVertex.getVertices(Direction.OUT, "tmHasTermMention", authorizationsWithTermMention)){

            @Override
            protected boolean isIncluded(Vertex v) {
                String vertexEdgeId = (String)BcSchema.TERM_MENTION_RESOLVED_EDGE_ID.getPropertyValue(v);
                return edgeId.equals(vertexEdgeId);
            }
        };
    }

    public Vertex findOutVertex(Vertex termMention, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        return IterableUtils.singleOrDefault(termMention.getVertices(Direction.IN, "tmHasTermMention", authorizationsWithTermMention), null);
    }

    public Authorizations getAuthorizations(Authorizations authorizations) {
        return this.graph.createAuthorizations(authorizations, VISIBILITY_STRING);
    }

    public void addJustification(Vertex vertex, String justificationText, ClientApiSourceInfo sourceInfo, BcVisibility bcVisibility, Authorizations authorizations) {
        if (justificationText != null) {
            this.removeSourceInfoEdgeFromVertex((String)vertex.getId(), (String)vertex.getId(), null, null, bcVisibility, authorizations);
            BcSchema.JUSTIFICATION.setProperty(vertex, justificationText, bcVisibility.getVisibility(), authorizations);
        } else if (sourceInfo != null) {
            Vertex outVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            BcSchema.JUSTIFICATION.removeProperty(vertex, authorizations);
            this.addSourceInfoToVertex(vertex, sourceInfo.vertexId, TermMentionFor.VERTEX, null, null, null, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, outVertex, bcVisibility.getVisibility(), authorizations);
        }
    }

    public <T extends Element> void addSourceInfo(T element, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex outVertex, Visibility visibility, Authorizations authorizations) {
        if (element instanceof Vertex) {
            this.addSourceInfoToVertex((Vertex)element, forElementId, forType, propertyKey, propertyName, propertyVisibility, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, outVertex, visibility, authorizations);
        } else {
            this.addSourceInfoEdgeToEdge((Edge)element, forElementId, forType, propertyKey, propertyName, propertyVisibility, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, outVertex, visibility, authorizations);
        }
    }

    public void addSourceInfoToVertex(Vertex vertex, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex outVertex, Visibility visibility, Authorizations authorizations) {
        this.addSourceInfoToVertex(vertex, forElementId, forType, propertyKey, propertyName, propertyVisibility, null, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, outVertex, visibility, authorizations);
    }

    public void addSourceInfoToVertex(Vertex vertex, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String edgeId, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex outVertex, Visibility visibility, Authorizations authorizations) {
        visibility = BcVisibility.and(visibility, VISIBILITY_STRING);
        String termMentionVertexId = (String)vertex.getId() + "hasSource" + (String)outVertex.getId();
        if (propertyKey != null) {
            termMentionVertexId = termMentionVertexId + ":" + propertyKey;
        }
        if (propertyName != null) {
            termMentionVertexId = termMentionVertexId + ":" + propertyName;
        }
        if (propertyVisibility != null) {
            termMentionVertexId = termMentionVertexId + ":" + propertyVisibility;
        }
        if (edgeId != null) {
            termMentionVertexId = termMentionVertexId + ":" + edgeId;
        }
        VertexBuilder m = this.graph.prepareVertex(termMentionVertexId, visibility, "thing");
        BcSchema.TERM_MENTION_FOR_ELEMENT_ID.setProperty(m, forElementId, visibility);
        BcSchema.TERM_MENTION_FOR_TYPE.setProperty(m, forType, visibility);
        if (propertyKey != null) {
            BcSchema.TERM_MENTION_REF_PROPERTY_KEY.setProperty(m, propertyKey, visibility);
        }
        if (propertyName != null) {
            BcSchema.TERM_MENTION_REF_PROPERTY_NAME.setProperty(m, propertyName, visibility);
        }
        if (propertyVisibility != null) {
            BcSchema.TERM_MENTION_REF_PROPERTY_VISIBILITY.setProperty(m, propertyVisibility.getVisibilityString(), visibility);
        }
        BcSchema.TERM_MENTION_SNIPPET.setProperty(m, snippet, visibility);
        BcSchema.TERM_MENTION_PROPERTY_KEY.setProperty(m, textPropertyKey, visibility);
        if (textPropertyName == null) {
            LOGGER.warn("not providing a property name for a term mention is deprecate", new Object[0]);
        } else {
            BcSchema.TERM_MENTION_PROPERTY_NAME.setProperty(m, textPropertyName, visibility);
        }
        BcSchema.TERM_MENTION_START_OFFSET.setProperty(m, startOffset, visibility);
        BcSchema.TERM_MENTION_END_OFFSET.setProperty(m, endOffset, visibility);
        Vertex termMention = m.save(authorizations);
        this.graph.addEdge("tmHasTermMention" + termMentionVertexId, outVertex, termMention, "tmHasTermMention", visibility, authorizations);
        this.graph.addEdge("tmRsolvedTo" + termMentionVertexId, termMention, vertex, "tmRsolvedTo", visibility, authorizations);
        this.graph.flush();
        LOGGER.debug("added source info: %s", termMention.getId());
    }

    public void addSourceInfoEdgeToEdge(Edge edge, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex originalVertex, Visibility visibility, Authorizations authorizations) {
        Vertex inVertex = edge.getVertex(Direction.IN, authorizations);
        this.addSourceInfoToVertex(inVertex, forElementId, forType, propertyKey, propertyName, propertyVisibility, (String)edge.getId(), snippet, textPropertyKey, textPropertyName, startOffset, endOffset, originalVertex, visibility, authorizations);
    }

    public void removeSourceInfoEdge(Element element, String propertyKey, String propertyName, BcVisibility bcVisibility, Authorizations authorizations) {
        if (element instanceof Vertex) {
            this.removeSourceInfoEdgeFromVertex((String)element.getId(), (String)element.getId(), propertyKey, propertyName, bcVisibility, authorizations);
        } else {
            this.removeSourceInfoEdgeFromEdge((Edge)element, propertyKey, propertyName, bcVisibility, authorizations);
        }
    }

    public void removeSourceInfoEdgeFromVertex(String vertexId, String sourceInfoElementId, String propertyKey, String propertyName, BcVisibility bcVisibility, Authorizations authorizations) {
        Vertex termMention = this.findTermMention(vertexId, sourceInfoElementId, propertyKey, propertyName, bcVisibility.getVisibility(), authorizations);
        if (termMention != null) {
            this.graph.softDeleteVertex(termMention, authorizations);
        }
    }

    public void removeSourceInfoEdgeFromEdge(Edge edge, String propertyKey, String propertyName, BcVisibility bcVisibility, Authorizations authorizations) {
        String inVertexId = edge.getVertexId(Direction.IN);
        this.removeSourceInfoEdgeFromVertex(inVertexId, (String)edge.getId(), propertyKey, propertyName, bcVisibility, authorizations);
    }

    private Vertex findTermMention(String vertexId, String forElementId, String propertyKey, String propertyName, Visibility propertyVisibility, Authorizations authorizations) {
        Authorizations authorizationsWithTermMentions = this.getAuthorizations(authorizations);
        Vertex vertex = this.graph.getVertex(vertexId, authorizationsWithTermMentions);
        if (vertex == null) {
            return null;
        }
        List<Vertex> termMentions = IterableUtils.toList(vertex.getVertices(Direction.IN, "tmRsolvedTo", authorizationsWithTermMentions));
        for (Vertex termMention : termMentions) {
            if (forElementId != null && !forElementId.equals(BcSchema.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue(termMention)) || propertyKey != null && !propertyKey.equals(BcSchema.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue(termMention)) || propertyName != null && !propertyName.equals(BcSchema.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue(termMention)) || propertyVisibility != null && !propertyVisibility.toString().equals(BcSchema.TERM_MENTION_REF_PROPERTY_VISIBILITY.getPropertyValue(termMention))) continue;
            return termMention;
        }
        return null;
    }

    public ClientApiSourceInfo getSourceInfoForEdge(Edge edge, Authorizations authorizations) {
        String inVertexId = edge.getVertexId(Direction.IN);
        Vertex termMention = this.findTermMention(inVertexId, (String)edge.getId(), null, null, null, authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    public ClientApiSourceInfo getSourceInfoForVertex(Vertex vertex, Authorizations authorizations) {
        Vertex termMention = this.findTermMention((String)vertex.getId(), (String)vertex.getId(), null, null, null, authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    public ClientApiSourceInfo getSourceInfoForEdgeProperty(Edge edge, Property property, Authorizations authorizations) {
        String inVertexId = edge.getVertexId(Direction.IN);
        Vertex termMention = this.findTermMention(inVertexId, (String)edge.getId(), property.getKey(), property.getName(), property.getVisibility(), authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    public ClientApiSourceInfo getSourceInfoForVertexProperty(String vertexId, Property property, Authorizations authorizations) {
        Vertex termMention = this.findTermMention(vertexId, vertexId, property.getKey(), property.getName(), property.getVisibility(), authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    private ClientApiSourceInfo getSourceInfoFromTermMention(Vertex termMention, Authorizations authorizations) {
        if (termMention == null) {
            return null;
        }
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        ClientApiSourceInfo result = new ClientApiSourceInfo();
        result.vertexId = IterableUtils.single(termMention.getVertexIds(Direction.IN, "tmHasTermMention", authorizationsWithTermMention));
        result.textPropertyKey = (String)BcSchema.TERM_MENTION_PROPERTY_KEY.getPropertyValue(termMention);
        result.textPropertyName = (String)BcSchema.TERM_MENTION_PROPERTY_NAME.getPropertyValue(termMention);
        result.startOffset = (Long)BcSchema.TERM_MENTION_START_OFFSET.getPropertyValue(termMention);
        result.endOffset = (Long)BcSchema.TERM_MENTION_END_OFFSET.getPropertyValue(termMention);
        result.snippet = SourceInfoSnippetSanitizer.sanitizeSnippet((String)BcSchema.TERM_MENTION_SNIPPET.getPropertyValue(termMention));
        return result;
    }

    public ClientApiTermMentionsResponse toClientApi(Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        authorizations = this.getAuthorizations(authorizations);
        ClientApiTermMentionsResponse termMentionsResponse = new ClientApiTermMentionsResponse();
        termMentionsResponse.getTermMentions().addAll(ClientApiConverter.toClientApi(termMentions, workspaceId, true, authorizations));
        return termMentionsResponse;
    }
}

