/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.termMention;

import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.termMention.TermMentionBuilder;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.Values;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TermMentionUtils {
    private Graph graph;
    private VisibilityTranslator visibilityTranslator;
    private Authorizations authorizations;
    private User user;

    public TermMentionUtils(Graph graph, VisibilityTranslator visibilityTranslator, Authorizations authorizations, User user) {
        this.graph = graph;
        this.visibilityTranslator = visibilityTranslator;
        this.authorizations = authorizations;
        this.user = user;
    }

    public Vertex createTermMention(Vertex outVertex, String propertyKey, String propertyName, String tmName, String tmConceptType, int tmStartOffset, int tmEndOffset, VisibilityJson visibilityJson) {
        String schemaClassName = this.mapToConceptType(tmConceptType);
        if (visibilityJson == null) {
            visibilityJson = new VisibilityJson(Visibility.EMPTY.getVisibilityString());
        }
        Vertex termMention = new TermMentionBuilder().outVertex(outVertex).propertyKey(propertyKey).propertyName(propertyName).start(tmStartOffset).end(tmEndOffset).title(tmName).conceptName(schemaClassName).visibilityJson(visibilityJson).process(this.getClass().getName()).save(this.graph, this.visibilityTranslator, this.user, this.authorizations);
        return termMention;
    }

    public List<Element> resolveTermMentions(Vertex outVertex, List<Vertex> termMentions) {
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.setSource("");
        ArrayList<Element> resolvedVertices = new ArrayList<Element>();
        for (Vertex termMention : termMentions) {
            String conceptType = (String)BcSchema.TERM_MENTION_CONCEPT_TYPE.getPropertyValue(termMention);
            String tmTitle = (String)BcSchema.TERM_MENTION_TITLE.getPropertyValue(termMention);
            if (tmTitle == null) continue;
            VisibilityJson outVertexVisibilityJson = new VisibilityJson();
            Metadata metadata = Metadata.create();
            BcSchema.VISIBILITY_JSON_METADATA.setMetadata(metadata, outVertexVisibilityJson, this.visibilityTranslator.getDefaultVisibility());
            Vertex resolvedToVertex = this.findExistingVertexWithTitle(tmTitle, this.authorizations);
            if (resolvedToVertex == null) {
                String id = this.graph.getIdGenerator().nextId();
                VertexBuilder vertexMutation = this.graph.prepareVertex(id, outVertex.getVisibility(), conceptType);
                BcSchema.TITLE.addPropertyValue(vertexMutation, "NLP", tmTitle, metadata, outVertex.getVisibility());
                resolvedToVertex = (Vertex)vertexMutation.save(this.authorizations);
            }
            resolvedVertices.add(resolvedToVertex);
            String edgeId = (String)outVertex.getId() + "-" + "hasDetectedEntity" + "-" + (String)resolvedToVertex.getId();
            Edge resolvedEdge = this.graph.prepareEdge(edgeId, outVertex, resolvedToVertex, "hasDetectedEntity", outVertex.getVisibility()).save(this.authorizations);
            String processId = this.getClass().getName();
            new TermMentionBuilder(termMention, outVertex).resolvedTo(resolvedToVertex, resolvedEdge).title(tmTitle).conceptName(conceptType).process(processId).resolvedFromTermMention(null).visibilityJson(BcSchema.TERM_MENTION_VISIBILITY_JSON.getPropertyValue(termMention, new VisibilityJson())).save(this.graph, this.visibilityTranslator, this.user, this.authorizations);
        }
        return resolvedVertices;
    }

    public void removeHasDetectedEntityRelations(Vertex sourceVertex) {
        Iterable<String> detectedEntityEdges = sourceVertex.getEdgeIds(Direction.OUT, "hasDetectedEntity", sourceVertex.getAuthorizations());
        this.graph.deleteElements(StreamUtils.stream(detectedEntityEdges).map(id -> ElementId.create(ElementType.EDGE, id)), sourceVertex.getAuthorizations());
    }

    private Vertex findExistingVertexWithTitle(String title, Authorizations authorizations) {
        QueryResultsIterable<Vertex> existingVerticesIterable = this.graph.query(authorizations).has(BcSchema.TITLE.getPropertyName(), Values.stringValue(title)).vertices();
        Iterator existingVertices = existingVerticesIterable.iterator();
        if (existingVertices.hasNext()) {
            this.safeClose(existingVerticesIterable);
            return (Vertex)existingVertices.next();
        }
        this.safeClose(existingVerticesIterable);
        return null;
    }

    private void safeClose(QueryResultsIterable iterable) {
        if (iterable == null) {
            return;
        }
        try {
            iterable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String mapToConceptType(String type) {
        String conceptType = "thing";
        if ("location".equals(type) || "organization".equals(type) || "person".equals(type)) {
            conceptType = type;
        }
        return conceptType;
    }
}

