/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.google.common.collect.ImmutableMap;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.clientapi.dto.UserType;
import com.mware.core.model.properties.UserSchema;
import com.mware.core.user.User;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class GeUser
implements User,
Serializable {
    private static final long serialVersionUID = 6688073934273514248L;
    private final String userId;
    private final Map<String, Value> properties = new HashMap<String, Value>();

    public GeUser(Vertex userVertex) {
        this.userId = userVertex.getId();
        for (Property property : userVertex.getProperties()) {
            this.properties.put(property.getName(), property.getValue());
        }
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getUsername() {
        return (String)UserSchema.USERNAME.getPropertyValue(this.properties);
    }

    @Override
    public String getDisplayName() {
        return (String)UserSchema.DISPLAY_NAME.getPropertyValue(this.properties);
    }

    @Override
    public String getEmailAddress() {
        return (String)UserSchema.EMAIL_ADDRESS.getPropertyValue(this.properties);
    }

    @Override
    public ZonedDateTime getCreateDate() {
        return (ZonedDateTime)UserSchema.CREATE_DATE.getPropertyValue(this.properties);
    }

    @Override
    public ZonedDateTime getCurrentLoginDate() {
        return (ZonedDateTime)UserSchema.CURRENT_LOGIN_DATE.getPropertyValue(this.properties);
    }

    @Override
    public String getCurrentLoginRemoteAddr() {
        return (String)UserSchema.CURRENT_LOGIN_REMOTE_ADDR.getPropertyValue(this.properties);
    }

    @Override
    public ZonedDateTime getPreviousLoginDate() {
        return (ZonedDateTime)UserSchema.PREVIOUS_LOGIN_DATE.getPropertyValue(this.properties);
    }

    @Override
    public String getPreviousLoginRemoteAddr() {
        return (String)UserSchema.PREVIOUS_LOGIN_REMOTE_ADDR.getPropertyValue(this.properties);
    }

    @Override
    public int getLoginCount() {
        return UserSchema.LOGIN_COUNT.getPropertyValue(this.properties, 0);
    }

    @Override
    public UserType getUserType() {
        return UserType.USER;
    }

    @Override
    public UserStatus getUserStatus() {
        return UserStatus.valueOf((String)UserSchema.STATUS.getPropertyValue(this.properties));
    }

    public void setUserStatus(UserStatus status) {
        UserSchema.STATUS.setProperty(this.properties, status.name());
    }

    @Override
    public String getCurrentWorkspaceId() {
        return (String)UserSchema.CURRENT_WORKSPACE.getPropertyValue(this.properties);
    }

    @Override
    public JSONObject getUiPreferences() {
        JSONObject preferences = (JSONObject)UserSchema.UI_PREFERENCES.getPropertyValue(this.properties);
        if (preferences == null) {
            preferences = new JSONObject();
            UserSchema.UI_PREFERENCES.setProperty(this.properties, preferences);
        }
        return preferences;
    }

    @Override
    public String getPasswordResetToken() {
        return (String)UserSchema.PASSWORD_RESET_TOKEN.getPropertyValue(this.properties);
    }

    @Override
    public ZonedDateTime getPasswordResetTokenExpirationDate() {
        return (ZonedDateTime)UserSchema.PASSWORD_RESET_TOKEN_EXPIRATION_DATE.getPropertyValue(this.properties);
    }

    @Override
    public Value getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Map<String, Value> getCustomProperties() {
        HashMap<String, Value> results = new HashMap<String, Value>();
        for (Map.Entry<String, Value> property : this.properties.entrySet()) {
            if (UserSchema.isBuiltInProperty(property.getKey())) continue;
            results.put(property.getKey(), property.getValue());
        }
        return ImmutableMap.copyOf(results);
    }

    public void setProperty(String propertyName, Value value) {
        this.properties.put(propertyName, value);
    }

    public String toString() {
        return "GeUser{userId='" + this.getUserId() + "', displayName='" + this.getDisplayName() + "}";
    }
}

