/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.properties.UserSchema;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.GeUser;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.user.PrivilegeRepository;
import com.mware.core.model.user.UserPasswordUtil;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.user.UserSessionCounterRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.ProxyUser;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

@Singleton
public class GeUserRepository
extends UserRepository {
    private Graph graph;
    private String userConceptId;
    private Authorizations authorizations;
    private final Cache<String, Vertex> userVertexCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();

    @Inject
    public GeUserRepository(Configuration configuration, SimpleOrmSession simpleOrmSession, GraphAuthorizationRepository graphAuthorizationRepository, Graph graph, SchemaRepository schemaRepository, UserSessionCounterRepository userSessionCounterRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, LockRepository lockRepository, AuthorizationRepository authorizationRepository, PrivilegeRepository privilegeRepository) {
        super(configuration, simpleOrmSession, userSessionCounterRepository, workQueueRepository, webQueueRepository, lockRepository, authorizationRepository, privilegeRepository);
        this.graph = graph;
        graphAuthorizationRepository.addAuthorizationToGraph("user");
        graphAuthorizationRepository.addAuthorizationToGraph("administrator");
        Concept userConcept = schemaRepository.getConceptByName("__usr", "public-ontology");
        this.userConceptId = userConcept.getName();
        HashSet<String> authorizationsSet = new HashSet<String>();
        authorizationsSet.add("user");
        authorizationsSet.add("administrator");
        this.authorizations = graph.createAuthorizations(authorizationsSet);
    }

    private GeUser createFromVertex(Vertex user) {
        if (user == null) {
            return null;
        }
        return new GeUser(user);
    }

    @Override
    public User findByUsername(String username) {
        username = this.formatUsername(username);
        QueryResultsIterable<Vertex> vertices = this.graph.query(this.authorizations).has(UserSchema.USERNAME.getPropertyName(), Values.stringValue(username)).hasConceptType(this.userConceptId).vertices();
        Vertex userVertex = IterableUtils.singleOrDefault(vertices, null);
        if (userVertex == null) {
            return null;
        }
        this.userVertexCache.put(userVertex.getId(), (Object)userVertex);
        return this.createFromVertex(userVertex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<User> find(int skip, int limit) {
        try (QueryResultsIterable<Vertex> userVertices = this.graph.query(this.authorizations).hasConceptType(this.userConceptId).skip(skip).limit(limit).vertices();){
            ConvertingIterable<Vertex, User> convertingIterable = new ConvertingIterable<Vertex, User>(userVertices){

                @Override
                protected User convert(Vertex vertex) {
                    return GeUserRepository.this.createFromVertex(vertex);
                }
            };
            return convertingIterable;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<User> findByStatus(int skip, int limit, UserStatus status) {
        try (QueryResultsIterable<Vertex> userVertices = this.graph.query(this.authorizations).hasConceptType(this.userConceptId).has(UserSchema.STATUS.getPropertyName(), Values.stringValue(status.toString())).skip(skip).limit(limit).vertices();){
            ConvertingIterable<Vertex, User> convertingIterable = new ConvertingIterable<Vertex, User>(userVertices){

                @Override
                protected User convert(Vertex vertex) {
                    return GeUserRepository.this.createFromVertex(vertex);
                }
            };
            return convertingIterable;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    @Override
    public User findById(String userId) {
        if ("USER_system".equals(userId)) {
            return this.getSystemUser();
        }
        return this.createFromVertex(this.findByIdUserVertex(userId));
    }

    public Vertex findByIdUserVertex(String userId) {
        Vertex userVertex = (Vertex)this.userVertexCache.getIfPresent((Object)userId);
        if (userVertex != null) {
            return userVertex;
        }
        userVertex = this.graph.getVertex(userId, FetchHints.ALL, this.authorizations);
        if (userVertex != null) {
            this.userVertexCache.put((Object)userId, (Object)userVertex);
        }
        return userVertex;
    }

    @Override
    public User addUser(String username, String displayName, String emailAddress, String password) {
        username = this.formatUsername(username);
        displayName = displayName.trim();
        byte[] salt = UserPasswordUtil.getSalt();
        byte[] passwordHash = UserPasswordUtil.hashPassword(password, salt);
        String id = "USER_" + this.graph.getIdGenerator().nextId();
        VertexBuilder userBuilder = this.graph.prepareVertex(id, VISIBILITY.getVisibility(), this.userConceptId);
        UserSchema.USERNAME.setProperty(userBuilder, username, VISIBILITY.getVisibility());
        UserSchema.DISPLAY_NAME.setProperty(userBuilder, displayName, VISIBILITY.getVisibility());
        UserSchema.CREATE_DATE.setProperty(userBuilder, ZonedDateTime.now(), VISIBILITY.getVisibility());
        UserSchema.PASSWORD_SALT.setProperty(userBuilder, salt, VISIBILITY.getVisibility());
        UserSchema.PASSWORD_HASH.setProperty(userBuilder, passwordHash, VISIBILITY.getVisibility());
        UserSchema.STATUS.setProperty(userBuilder, UserStatus.OFFLINE.toString(), VISIBILITY.getVisibility());
        if (emailAddress != null) {
            UserSchema.EMAIL_ADDRESS.setProperty(userBuilder, emailAddress, VISIBILITY.getVisibility());
        }
        GeUser user = this.createFromVertex(userBuilder.save(this.authorizations));
        this.graph.flush();
        this.afterNewUserAdded(user);
        return user;
    }

    @Override
    public void setPassword(User user, byte[] salt, byte[] passwordHash) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.PASSWORD_SALT.setProperty(userVertex, salt, VISIBILITY.getVisibility(), this.authorizations);
        UserSchema.PASSWORD_HASH.setProperty(userVertex, passwordHash, VISIBILITY.getVisibility(), this.authorizations);
        this.graph.flush();
    }

    @Override
    public boolean isPasswordValid(User user, String password) {
        try {
            Vertex userVertex = this.findByIdUserVertex(user.getUserId());
            return UserPasswordUtil.validatePassword(password, (byte[])UserSchema.PASSWORD_SALT.getPropertyValue(userVertex), (byte[])UserSchema.PASSWORD_HASH.getPropertyValue(userVertex));
        }
        catch (Exception ex) {
            throw new RuntimeException("error validating password", ex);
        }
    }

    @Override
    public void updateUser(User user, AuthorizationContext authorizationContext) {
        String currentLoginRemoteAddr;
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        ExistingVertexMutation m = userVertex.prepareMutation();
        ZonedDateTime currentLoginDate = (ZonedDateTime)UserSchema.CURRENT_LOGIN_DATE.getPropertyValue(userVertex);
        if (currentLoginDate != null) {
            UserSchema.PREVIOUS_LOGIN_DATE.setProperty(m, currentLoginDate, VISIBILITY.getVisibility());
        }
        if ((currentLoginRemoteAddr = (String)UserSchema.CURRENT_LOGIN_REMOTE_ADDR.getPropertyValue(userVertex)) != null) {
            UserSchema.PREVIOUS_LOGIN_REMOTE_ADDR.setProperty(m, currentLoginRemoteAddr, VISIBILITY.getVisibility());
        }
        UserSchema.CURRENT_LOGIN_DATE.setProperty(m, ZonedDateTime.now(), VISIBILITY.getVisibility());
        UserSchema.CURRENT_LOGIN_REMOTE_ADDR.setProperty(m, authorizationContext.getRemoteAddr(), VISIBILITY.getVisibility());
        int loginCount = UserSchema.LOGIN_COUNT.getPropertyValue(userVertex, Integer.valueOf(0));
        UserSchema.LOGIN_COUNT.setProperty(m, loginCount + 1, VISIBILITY.getVisibility());
        m.save(this.authorizations);
        this.graph.flush();
        this.getAuthorizationRepository().updateUser(user, authorizationContext);
        this.getPrivilegeRepository().updateUser(user, authorizationContext);
        this.fireUserLoginEvent(user, authorizationContext);
    }

    @Override
    public User setCurrentWorkspace(String userId, String workspaceId) {
        User user = this.findById(userId);
        Preconditions.checkNotNull((Object)user, (Object)("Could not find user: " + userId));
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        if (workspaceId == null) {
            UserSchema.CURRENT_WORKSPACE.removeProperty(userVertex, this.authorizations);
        } else {
            UserSchema.CURRENT_WORKSPACE.setProperty(userVertex, workspaceId, VISIBILITY.getVisibility(), this.authorizations);
        }
        this.graph.flush();
        return user;
    }

    @Override
    public String getCurrentWorkspaceId(String userId) {
        User user = this.findById(userId);
        Preconditions.checkNotNull((Object)user, (Object)("Could not find user: " + userId));
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        return (String)UserSchema.CURRENT_WORKSPACE.getPropertyValue(userVertex);
    }

    @Override
    public void setUiPreferences(User user, JSONObject preferences) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.UI_PREFERENCES.setProperty(userVertex, preferences, VISIBILITY.getVisibility(), this.authorizations);
        this.graph.flush();
    }

    @Override
    public User setStatus(String userId, UserStatus status) {
        GeUser user = (GeUser)this.findById(userId);
        Preconditions.checkNotNull((Object)user, (Object)("Could not find user: " + userId));
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.STATUS.setProperty(userVertex, status.toString(), VISIBILITY.getVisibility(), this.authorizations);
        this.graph.flush();
        user.setUserStatus(status);
        this.fireUserStatusChangeEvent(user, status);
        return user;
    }

    @Override
    public void setDisplayName(User user, String displayName) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.DISPLAY_NAME.setProperty(userVertex, displayName, VISIBILITY.getVisibility(), this.authorizations);
        this.graph.flush();
    }

    @Override
    public void setEmailAddress(User user, String emailAddress) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.EMAIL_ADDRESS.setProperty(userVertex, emailAddress, VISIBILITY.getVisibility(), this.authorizations);
        this.graph.flush();
    }

    @Override
    protected void internalDelete(User user) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        this.graph.softDeleteVertex(userVertex, this.authorizations);
        this.graph.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User findByPasswordResetToken(String token) {
        try (QueryResultsIterable<Vertex> userVertices = this.graph.query(this.authorizations).has(UserSchema.PASSWORD_RESET_TOKEN.getPropertyName(), Values.stringValue(token)).hasConceptType(this.userConceptId).vertices();){
            Vertex user = IterableUtils.singleOrDefault(userVertices, null);
            GeUser geUser = this.createFromVertex(user);
            return geUser;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    @Override
    public void setPasswordResetTokenAndExpirationDate(User user, String token, ZonedDateTime expirationDate) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.PASSWORD_RESET_TOKEN.setProperty(userVertex, token, VISIBILITY.getVisibility(), this.authorizations);
        UserSchema.PASSWORD_RESET_TOKEN_EXPIRATION_DATE.setProperty(userVertex, expirationDate, VISIBILITY.getVisibility(), this.authorizations);
        this.graph.flush();
    }

    @Override
    public void clearPasswordResetTokenAndExpirationDate(User user) {
        Vertex userVertex = this.findByIdUserVertex(user.getUserId());
        UserSchema.PASSWORD_RESET_TOKEN.removeProperty(userVertex, this.authorizations);
        UserSchema.PASSWORD_RESET_TOKEN_EXPIRATION_DATE.removeProperty(userVertex, this.authorizations);
        this.graph.flush();
    }

    @Override
    public void setPropertyOnUser(User user, String propertyName, Value value) {
        if (user instanceof SystemUser) {
            throw new BcException("Cannot set properties on system user");
        }
        if (user.getCustomProperties().get(propertyName) == null || !value.equals(user.getCustomProperties().get(propertyName))) {
            User proxiedUser;
            Vertex userVertex = this.findByIdUserVertex(user.getUserId());
            userVertex.setProperty(propertyName, value, VISIBILITY.getVisibility(), this.authorizations);
            if (user instanceof ProxyUser && (proxiedUser = ((ProxyUser)user).getProxiedUser()) instanceof GeUser) {
                user = proxiedUser;
            }
            if (user instanceof GeUser) {
                ((GeUser)user).setProperty(propertyName, value);
            }
            this.graph.flush();
        }
    }
}

