/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.google.common.collect.ImmutableMap;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.clientapi.dto.UserType;
import com.mware.core.user.User;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONObject;

public class InMemoryUser
implements User {
    private final String userId;
    private final String userName;
    private final String displayName;
    private final String emailAddress;
    private final ZonedDateTime createDate;
    private final String currentWorkspaceId;
    private JSONObject preferences;
    private Map<String, Value> properties = new HashMap<String, Value>();

    public InMemoryUser(String userId) {
        this(userId, null, null, null, null);
    }

    public InMemoryUser(String userName, String displayName, String emailAddress, String currentWorkspaceId) {
        this(UUID.randomUUID().toString(), userName, displayName, emailAddress, currentWorkspaceId);
    }

    public InMemoryUser(String userId, String userName, String displayName, String emailAddress, String currentWorkspaceId) {
        this.userId = userId;
        this.userName = userName;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.createDate = ZonedDateTime.now();
        this.currentWorkspaceId = currentWorkspaceId;
        this.preferences = new JSONObject();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public ZonedDateTime getCreateDate() {
        return this.createDate;
    }

    @Override
    public ZonedDateTime getCurrentLoginDate() {
        return null;
    }

    @Override
    public String getCurrentLoginRemoteAddr() {
        return null;
    }

    @Override
    public ZonedDateTime getPreviousLoginDate() {
        return null;
    }

    @Override
    public String getPreviousLoginRemoteAddr() {
        return null;
    }

    @Override
    public int getLoginCount() {
        return 0;
    }

    @Override
    public UserType getUserType() {
        return UserType.USER;
    }

    @Override
    public UserStatus getUserStatus() {
        return UserStatus.OFFLINE;
    }

    @Override
    public String getCurrentWorkspaceId() {
        return this.currentWorkspaceId;
    }

    @Override
    public JSONObject getUiPreferences() {
        return this.preferences;
    }

    public void setPreferences(JSONObject preferences) {
        this.preferences = preferences;
    }

    @Override
    public String getPasswordResetToken() {
        return null;
    }

    @Override
    public ZonedDateTime getPasswordResetTokenExpirationDate() {
        return null;
    }

    @Override
    public Value getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Map<String, Value> getCustomProperties() {
        return ImmutableMap.copyOf(this.properties);
    }

    public void setProperty(String propertyName, Value value) {
        this.properties.put(propertyName, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryUser that = (InMemoryUser)o;
        return this.userId.equals(that.userId);
    }

    public int hashCode() {
        return this.userId.hashCode();
    }

    public String toString() {
        return "InMemoryUser{userId='" + this.userId + '\'' + '}';
    }
}

