/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.InMemoryUser;
import com.mware.core.model.user.PrivilegeRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.user.UserSessionCounterRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

@Singleton
public class InMemoryUserRepository
extends UserRepository {
    private List<User> users = new ArrayList<User>();

    @Inject
    public InMemoryUserRepository(Configuration configuration, SimpleOrmSession simpleOrmSession, UserSessionCounterRepository userSessionCounterRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, LockRepository lockRepository, AuthorizationRepository authorizationRepository, PrivilegeRepository privilegeRepository) {
        super(configuration, simpleOrmSession, userSessionCounterRepository, workQueueRepository, webQueueRepository, lockRepository, authorizationRepository, privilegeRepository);
        this.addDefaultAdminUser();
        this.addDefaultSysUser();
    }

    @Override
    public User findByUsername(String username) {
        return (User)Iterables.find(this.users, user -> user.getUsername().equals(username), null);
    }

    @Override
    public Iterable<User> find(int skip, int limit) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public User findById(String userId) {
        return (User)Iterables.find(this.users, user -> user.getUserId().equals(userId), null);
    }

    @Override
    public User addUser(String username, String displayName, String emailAddress, String password) {
        username = this.formatUsername(username);
        displayName = displayName.trim();
        InMemoryUser user = new InMemoryUser(username, displayName, emailAddress, null);
        this.afterNewUserAdded(user);
        this.users.add(user);
        return user;
    }

    @Override
    public void setPassword(User user, byte[] salt, byte[] passwordHash) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isPasswordValid(User user, String password) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void updateUser(User user, AuthorizationContext authorizationContext) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public User setCurrentWorkspace(String userId, String workspaceId) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getCurrentWorkspaceId(String userId) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public User setStatus(String userId, UserStatus status) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setUiPreferences(User user, JSONObject preferences) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setDisplayName(User user, String displayName) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setEmailAddress(User user, String emailAddress) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void internalDelete(User user) {
    }

    @Override
    public User findByPasswordResetToken(String token) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setPasswordResetTokenAndExpirationDate(User user, String token, ZonedDateTime expirationDate) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void clearPasswordResetTokenAndExpirationDate(User user) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setPropertyOnUser(User user, String propertyName, Value value) {
        if (user instanceof SystemUser) {
            throw new BcException("Cannot set properties on system user");
        }
        ((InMemoryUser)user).setProperty(propertyName, value);
    }
}

