/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.mware.core.model.user.UserSessionCounterRepository;
import com.mware.core.time.TimeRepository;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public abstract class MapUserSessionCounterRepositoryBase
implements UserSessionCounterRepository {
    public static final int UNSEEN_SESSION_DURATION = 300000;
    private final TimeRepository timeRepository;

    protected MapUserSessionCounterRepositoryBase(TimeRepository timeRepository) {
        this.timeRepository = timeRepository;
    }

    @Override
    public int updateSession(String userId, String sessionId, boolean autoDelete) {
        this.put(userId, sessionId, new SessionData(this.timeRepository.getNow(), autoDelete));
        return this.getSessionCount(userId);
    }

    protected abstract void put(String var1, String var2, SessionData var3);

    protected abstract void remove(String var1, String var2);

    protected abstract Map<String, SessionData> getRow(String var1);

    @Override
    public int getSessionCount(String userId) {
        for (Map.Entry<String, SessionData> sessionIdToSessionData : this.getRow(userId).entrySet()) {
            if (!this.shouldDelete(sessionIdToSessionData.getValue())) continue;
            this.remove(userId, sessionIdToSessionData.getKey());
        }
        return this.getRow(userId).size();
    }

    private boolean shouldDelete(SessionData sessionData) {
        if (!sessionData.isAutoDelete()) {
            return false;
        }
        long now = this.timeRepository.currentTimeMillis();
        return now - sessionData.getCreateDate().getTime() >= 300000L;
    }

    @Override
    public void deleteSessions(String userId) {
        Map<String, SessionData> sessions = this.getRow(userId);
        for (String sessionId : sessions.keySet()) {
            this.remove(userId, sessionId);
        }
    }

    @Override
    public int deleteSession(String userId, String sessionId) {
        this.remove(userId, sessionId);
        return this.getSessionCount(userId);
    }

    protected static class SessionData
    implements Serializable {
        private static final long serialVersionUID = -1883352978079887306L;
        private final Date createDate;
        private final boolean autoDelete;

        public SessionData(Date createDate, boolean autoDelete) {
            this.createDate = createDate;
            this.autoDelete = autoDelete;
        }

        public Date getCreateDate() {
            return this.createDate;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public String toString() {
            return "SessionData{createDate=" + this.createDate + ", autoDelete=" + this.autoDelete + '}';
        }
    }
}

