/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configurable;
import com.mware.core.config.Configuration;
import com.mware.core.model.clientapi.dto.Privilege;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.notification.ExpirationAge;
import com.mware.core.model.notification.UserNotification;
import com.mware.core.model.notification.UserNotificationRepository;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.role.Role;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.schema.SchemaPropertyDefinition;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.PrivilegeRepositoryBase;
import com.mware.core.model.user.UserListener;
import com.mware.core.model.user.UserPropertyPrivilegeRepositoryCliService;
import com.mware.core.model.user.cli.PrivilegeRepositoryCliService;
import com.mware.core.model.user.cli.PrivilegeRepositoryWithCliSupport;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.TextIndexHint;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class UserPropertyPrivilegeRepository
extends PrivilegeRepositoryBase
implements PrivilegeRepositoryWithCliSupport {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(UserPropertyPrivilegeRepository.class);
    public static final String PRIVILEGES_PROPERTY_NAME = "userPrivileges";
    public static final String CONFIGURATION_PREFIX = UserPropertyPrivilegeRepository.class.getName();
    private final ImmutableSet<String> defaultPrivileges;
    private final Configuration configuration;
    private final UserNotificationRepository userNotificationRepository;
    private final WebQueueRepository webQueueRepository;
    private final AuthorizationRepository authorizationRepository;
    private Collection<UserListener> userListeners;

    @Inject
    public UserPropertyPrivilegeRepository(SchemaRepository schemaRepository, Configuration configuration, UserNotificationRepository userNotificationRepository, WebQueueRepository webQueueRepository, AuthorizationRepository authorizationRepository) {
        super(configuration);
        this.configuration = configuration;
        this.userNotificationRepository = userNotificationRepository;
        this.webQueueRepository = webQueueRepository;
        this.authorizationRepository = authorizationRepository;
        this.definePrivilegesProperty(schemaRepository);
        Settings settings = new Settings();
        configuration.setConfigurables(settings, CONFIGURATION_PREFIX);
        this.defaultPrivileges = ImmutableSet.copyOf(Privilege.stringToPrivileges(settings.defaultPrivileges));
    }

    private void definePrivilegesProperty(SchemaRepository schemaRepository) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        concepts.add(schemaRepository.getConceptByName("__usr", "public-ontology"));
        SchemaPropertyDefinition propertyDefinition = new SchemaPropertyDefinition(concepts, PRIVILEGES_PROPERTY_NAME, "Privileges", PropertyType.STRING);
        propertyDefinition.setUserVisible(false);
        propertyDefinition.setTextIndexHints(TextIndexHint.NONE);
        schemaRepository.getOrCreateProperty(propertyDefinition, new SystemUser(), "public-ontology");
    }

    @Override
    public void updateUser(User user, AuthorizationContext authorizationContext) {
    }

    @Override
    public Set<String> getPrivileges(User user) {
        if (user instanceof SystemUser) {
            return Sets.newHashSet();
        }
        if (user == null) {
            return new HashSet<String>((Collection<String>)this.defaultPrivileges);
        }
        TextValue privileges = (TextValue)user.getProperty(PRIVILEGES_PROPERTY_NAME);
        HashSet<String> result = new HashSet<String>(Privilege.stringToPrivileges(privileges == null ? null : privileges.stringValue()));
        Set<Role> roles = this.authorizationRepository.getRoles(user);
        for (Role role : roles) {
            if (role.getPrivileges() == null) continue;
            result.addAll(role.getPrivileges().stream().map(p -> p.getName()).collect(Collectors.toSet()));
        }
        if (result.isEmpty()) {
            result = new HashSet<String>((Collection<String>)this.defaultPrivileges);
        }
        return result;
    }

    @Override
    public void setPrivileges(User user, Set<String> privileges, User authUser) {
        if (!privileges.equals(this.getPrivileges(user))) {
            String privilegesString = Privilege.toString(privileges);
            LOGGER.info("Setting privileges to '%s' on user '%s' by '%s'", privilegesString, user.getUsername(), authUser.getUsername());
            this.getUserRepository().setPropertyOnUser(user, PRIVILEGES_PROPERTY_NAME, Values.stringValue(privilegesString));
            this.sendNotificationToUserAboutPrivilegeChange(user, privileges, authUser);
            this.webQueueRepository.pushUserAccessChange(user);
            this.fireUserPrivilegesUpdatedEvent(user, privileges);
        }
    }

    private void sendNotificationToUserAboutPrivilegeChange(User user, Set<String> privileges, User authUser) {
        String title = "Privileges Changed";
        String message = "New Privileges: " + Joiner.on((String)", ").join(privileges);
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.webQueueRepository.pushUserNotification(userNotification);
    }

    private void fireUserPrivilegesUpdatedEvent(User user, Set<String> privileges) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userPrivilegesUpdated(user, privileges);
        }
    }

    private Collection<UserListener> getUserListeners() {
        if (this.userListeners == null) {
            this.userListeners = InjectHelper.getInjectedServices(UserListener.class, this.configuration);
        }
        return this.userListeners;
    }

    @Override
    public PrivilegeRepositoryCliService getCliService() {
        return new UserPropertyPrivilegeRepositoryCliService(this);
    }

    public ImmutableSet<String> getDefaultPrivileges() {
        return this.defaultPrivileges;
    }

    private static class Settings {
        @Configurable
        public String defaultPrivileges;

        private Settings() {
        }
    }
}

