/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user;

import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.model.clientapi.dto.ClientApiUser;
import com.mware.core.model.clientapi.dto.ClientApiUsers;
import com.mware.core.model.clientapi.dto.Privilege;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.role.Role;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.PrivilegeRepository;
import com.mware.core.model.user.UserListener;
import com.mware.core.model.user.UserPasswordUtil;
import com.mware.core.model.user.UserSessionCounterRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.security.BcVisibility;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.ClientApiConverter;
import com.mware.core.util.JSONUtil;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class UserRepository {
    public static final String GRAPH_USER_ID_PREFIX = "USER_";
    public static final String VISIBILITY_STRING = "user";
    public static final BcVisibility VISIBILITY = new BcVisibility("user");
    public static final String USER_CONCEPT_NAME = "__usr";
    private final SimpleOrmSession simpleOrmSession;
    private final UserSessionCounterRepository userSessionCounterRepository;
    private final WorkQueueRepository workQueueRepository;
    private final WebQueueRepository webQueueRepository;
    private final LockRepository lockRepository;
    private final Configuration configuration;
    private final AuthorizationRepository authorizationRepository;
    private final PrivilegeRepository privilegeRepository;
    private LongRunningProcessRepository longRunningProcessRepository;
    private Collection<UserListener> userListeners;

    protected UserRepository(Configuration configuration, SimpleOrmSession simpleOrmSession, UserSessionCounterRepository userSessionCounterRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, LockRepository lockRepository, AuthorizationRepository authorizationRepository, PrivilegeRepository privilegeRepository) {
        this.configuration = configuration;
        this.simpleOrmSession = simpleOrmSession;
        this.userSessionCounterRepository = userSessionCounterRepository;
        this.workQueueRepository = workQueueRepository;
        this.webQueueRepository = webQueueRepository;
        this.lockRepository = lockRepository;
        this.authorizationRepository = authorizationRepository;
        this.privilegeRepository = privilegeRepository;
    }

    public abstract User findByUsername(String var1);

    public abstract Iterable<User> find(int var1, int var2);

    public Iterable<User> findByStatus(int skip, int limit, UserStatus status) {
        List<User> allUsers = IterableUtils.toList(this.find(skip, limit));
        ArrayList<User> matchingUsers = new ArrayList<User>();
        for (User user : allUsers) {
            if (user.getUserStatus() != status) continue;
            matchingUsers.add(user);
        }
        return matchingUsers;
    }

    public abstract User findById(String var1);

    public abstract User addUser(String var1, String var2, String var3, String var4);

    public void setPassword(User user, String password) {
        byte[] salt = UserPasswordUtil.getSalt();
        byte[] passwordHash = UserPasswordUtil.hashPassword(password, salt);
        this.setPassword(user, salt, passwordHash);
    }

    public abstract void setPassword(User var1, byte[] var2, byte[] var3);

    public abstract boolean isPasswordValid(User var1, String var2);

    public abstract void updateUser(User var1, AuthorizationContext var2);

    public abstract User setCurrentWorkspace(String var1, String var2);

    public abstract String getCurrentWorkspaceId(String var1);

    public abstract User setStatus(String var1, UserStatus var2);

    public abstract void setDisplayName(User var1, String var2);

    public abstract void setEmailAddress(User var1, String var2);

    public abstract void setUiPreferences(User var1, JSONObject var2);

    public JSONObject toJsonWithAuths(User user) {
        JSONObject json = UserRepository.toJson(user);
        JSONArray authorizations = new JSONArray();
        for (Role a : this.authorizationRepository.getRoles(user)) {
            authorizations.put((Object)a.getRoleName());
        }
        json.put("authorizations", (Object)authorizations);
        json.put("uiPreferences", (Object)user.getUiPreferences());
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        json.put("privileges", (Object)Privilege.toJson(privileges));
        return json;
    }

    public ClientApiUser toClientApiPrivate(User user) {
        ClientApiUser u = this.toClientApi(user);
        for (Role a : this.authorizationRepository.getRoles(user)) {
            u.addAuthorization(a.getRoleName());
        }
        for (JSONObject json : this.getLongRunningProcesses(user)) {
            u.getLongRunningProcesses().add(ClientApiConverter.toClientApiValue(json));
        }
        u.setUiPreferences(JSONUtil.toJsonNode(user.getUiPreferences()));
        user.getCustomProperties().forEach((k, v) -> u.getProperties().put((String)k, v.asObjectCopy()));
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        u.getPrivileges().addAll(privileges);
        return u;
    }

    private List<JSONObject> getLongRunningProcesses(User user) {
        return this.getLongRunningProcessRepository().getLongRunningProcesses(user);
    }

    private LongRunningProcessRepository getLongRunningProcessRepository() {
        if (this.longRunningProcessRepository == null) {
            this.longRunningProcessRepository = InjectHelper.getInstance(LongRunningProcessRepository.class);
        }
        return this.longRunningProcessRepository;
    }

    public ClientApiUser toClientApi(User user) {
        return this.toClientApi(user, null);
    }

    private ClientApiUser toClientApi(User user, Map<String, String> workspaceNames) {
        ClientApiUser u = new ClientApiUser();
        u.setId(user.getUserId());
        u.setUserName(user.getUsername());
        u.setDisplayName(user.getDisplayName());
        u.setStatus(user.getUserStatus());
        u.setUserType(user.getUserType());
        u.setEmail(user.getEmailAddress());
        u.setCurrentLoginDate(user.getCurrentLoginDate());
        u.setPreviousLoginDate(user.getPreviousLoginDate());
        u.setCurrentWorkspaceId(user.getCurrentWorkspaceId());
        u.getProperties().putAll(user.getCustomProperties());
        if (workspaceNames != null) {
            String workspaceName = workspaceNames.get(user.getCurrentWorkspaceId());
            u.setCurrentWorkspaceName(workspaceName);
        }
        return u;
    }

    protected String formatUsername(String username) {
        return username.trim().toLowerCase();
    }

    public ClientApiUsers toClientApi(Iterable<User> users, Map<String, String> workspaceNames) {
        ClientApiUsers clientApiUsers = new ClientApiUsers();
        for (User user : users) {
            clientApiUsers.getUsers().add(this.toClientApi(user, workspaceNames));
        }
        return clientApiUsers;
    }

    public static JSONObject toJson(User user) {
        return UserRepository.toJson(user, null);
    }

    public static JSONObject toJson(User user, Map<String, String> workspaceNames) {
        try {
            JSONObject json = new JSONObject();
            json.put("id", (Object)user.getUserId());
            json.put("userName", (Object)user.getUsername());
            json.put("displayName", (Object)user.getDisplayName());
            json.put("status", (Object)user.getUserStatus().toString().toUpperCase());
            json.put("userType", (Object)user.getUserType().toString().toUpperCase());
            json.put("email", (Object)user.getEmailAddress());
            json.put("currentWorkspaceId", (Object)user.getCurrentWorkspaceId());
            if (workspaceNames != null) {
                String workspaceName = workspaceNames.get(user.getCurrentWorkspaceId());
                json.put("currentWorkspaceName", (Object)workspaceName);
            }
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleOrmContext getSimpleOrmContext(User user) {
        Set<Role> roles = this.authorizationRepository.getRoles(user);
        Set<String> authorizationsSet = roles.stream().map(role -> role.getRoleName()).collect(Collectors.toSet());
        String[] authorizations = authorizationsSet.toArray(new String[authorizationsSet.size()]);
        return this.getSimpleOrmContext(authorizations);
    }

    public SimpleOrmContext getSimpleOrmContext(String ... authorizations) {
        return this.simpleOrmSession.createContext(authorizations);
    }

    public User getSystemUser() {
        return new SystemUser();
    }

    public User findOrAddUser(String username, String displayName, String emailAddress, String password) {
        return this.lockRepository.lock("findOrAddUser", () -> {
            User user = this.findByUsername(username);
            if (user == null) {
                user = this.addUser(username, displayName, emailAddress, password);
            }
            return user;
        });
    }

    public final void delete(User user) {
        this.internalDelete(user);
        this.userSessionCounterRepository.deleteSessions(user.getUserId());
        this.webQueueRepository.broadcastUserStatusChange(user, UserStatus.OFFLINE);
        this.fireUserDeletedEvent(user);
    }

    protected abstract void internalDelete(User var1);

    public Iterable<User> find(String query) {
        List<User> users;
        String lowerCaseQuery = query == null ? null : query.toLowerCase();
        int skip = 0;
        int limit = 100;
        ArrayList<User> foundUsers = new ArrayList<User>();
        while ((users = IterableUtils.toList(this.find(skip, limit))).size() != 0) {
            for (User user : users) {
                if (lowerCaseQuery != null && !user.getDisplayName().toLowerCase().contains(lowerCaseQuery) && !user.getUsername().toLowerCase().contains(lowerCaseQuery)) continue;
                foundUsers.add(user);
            }
            skip += limit;
        }
        return foundUsers;
    }

    public static String createRandomPassword() {
        return new BigInteger(120, new SecureRandom()).toString(32);
    }

    public abstract User findByPasswordResetToken(String var1);

    public abstract void setPasswordResetTokenAndExpirationDate(User var1, String var2, ZonedDateTime var3);

    public abstract void clearPasswordResetTokenAndExpirationDate(User var1);

    protected void afterNewUserAdded(User newUser) {
        this.fireNewUserAddedEvent(newUser);
    }

    private void fireNewUserAddedEvent(User user) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.newUserAdded(user);
        }
    }

    private void fireUserDeletedEvent(User user) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userDeleted(user);
        }
    }

    protected void fireUserLoginEvent(User user, AuthorizationContext authorizationContext) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userLogin(user, authorizationContext);
        }
    }

    protected void fireUserStatusChangeEvent(User user, UserStatus status) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userStatusChange(user, status);
        }
    }

    protected Collection<UserListener> getUserListeners() {
        if (this.userListeners == null) {
            this.userListeners = InjectHelper.getInjectedServices(UserListener.class, this.configuration);
        }
        return this.userListeners;
    }

    public abstract void setPropertyOnUser(User var1, String var2, Value var3);

    protected AuthorizationRepository getAuthorizationRepository() {
        return this.authorizationRepository;
    }

    protected PrivilegeRepository getPrivilegeRepository() {
        return this.privilegeRepository;
    }

    public void addDefaultAdminUser() {
        User user = this.findByUsername("admin");
        if (user == null) {
            this.findOrAddUser("admin", "App Administrator", "admin@localhost", "admin");
        }
    }

    public void addDefaultSysUser() {
        User user = this.findByUsername("sys");
        if (user == null) {
            user = this.findOrAddUser("sys", "System Administrator", "sys@localhost", "ZnD5QKEWMX867rk");
            this.authorizationRepository.addRoleToUser(user, this.authorizationRepository.getAdministratorRole(), (User)new SystemUser());
        }
    }
}

