/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.user.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.mware.core.cmdline.CommandLineTool;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.properties.UserSchema;
import com.mware.core.model.user.cli.AuthorizationRepositoryCliService;
import com.mware.core.model.user.cli.AuthorizationRepositoryWithCliSupport;
import com.mware.core.model.user.cli.PrivilegeRepositoryCliService;
import com.mware.core.model.user.cli.PrivilegeRepositoryWithCliSupport;
import com.mware.core.model.user.cli.UserNotFoundException;
import com.mware.core.model.user.cli.args.Args;
import com.mware.core.model.user.cli.args.CreateUserArgs;
import com.mware.core.model.user.cli.args.DeleteUserArgs;
import com.mware.core.model.user.cli.args.ExportPasswordsArgs;
import com.mware.core.model.user.cli.args.FindUserArgs;
import com.mware.core.model.user.cli.args.ListActiveUsersArgs;
import com.mware.core.model.user.cli.args.ListUsersArgs;
import com.mware.core.model.user.cli.args.SetDisplayNameEmailArgs;
import com.mware.core.model.user.cli.args.UpdatePasswordArgs;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.ByteArray;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Parameters(commandDescription="User administration")
public class UserAdmin
extends CommandLineTool {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(UserAdmin.class, "cli-userAdmin");
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_LIST = "list";
    public static final String ACTION_ACTIVE = "active";
    public static final String ACTION_EXPORT_PASSWORDS = "export-passwords";
    public static final String ACTION_UPDATE_PASSWORD = "update-password";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_SET_DISPLAYNAME_AND_OR_EMAIL = "set-displayname-and-or-email";
    private Args args;
    private List<String> actions = new ArrayList<String>();
    private String userAdminAction;
    private Collection<String> authorizationRepositoryActions;
    private Collection<String> privilegeRepositoryActions;

    public static void main(String[] args) throws Exception {
        CommandLineTool.main(new UserAdmin(), args);
    }

    @Override
    protected JCommander parseArguments(String[] args) {
        this.actions.add(ACTION_CREATE);
        this.actions.add(ACTION_LIST);
        this.actions.add(ACTION_ACTIVE);
        this.actions.add(ACTION_EXPORT_PASSWORDS);
        this.actions.add(ACTION_UPDATE_PASSWORD);
        this.actions.add(ACTION_DELETE);
        this.actions.add(ACTION_SET_DISPLAYNAME_AND_OR_EMAIL);
        this.initializeFramework();
        if (this.getAuthorizationRepositoryCliService() != null) {
            this.authorizationRepositoryActions = this.getAuthorizationRepositoryCliService().getActions(this);
            this.actions.addAll(this.authorizationRepositoryActions);
        }
        if (this.getPrivilegeRepositoryCliService() != null) {
            this.privilegeRepositoryActions = this.getPrivilegeRepositoryCliService().getActions(this);
            this.actions.addAll(this.privilegeRepositoryActions);
        }
        if (args.length == 0 || !this.actions.contains(args[0])) {
            System.err.println("Action must be one of: " + Joiner.on((String)" | ").join(this.actions));
            return null;
        }
        this.userAdminAction = args[0];
        if (this.userAdminAction == null) {
            throw new BcException("Could not parse UserAdminAction");
        }
        this.args = this.getArgumentsObject();
        JCommander j = new JCommander((Object)this.args, Arrays.copyOfRange(args, 1, args.length));
        if (this.args.help) {
            this.printHelp(j);
            return null;
        }
        this.args.validate(j);
        if (this.getAuthorizationRepositoryCliService() != null) {
            this.getAuthorizationRepositoryCliService().validateArguments(this, this.userAdminAction, this.args);
        }
        if (this.getPrivilegeRepository() instanceof PrivilegeRepositoryWithCliSupport) {
            this.getPrivilegeRepositoryCliService().validateArguments(this, this.userAdminAction, this.args);
        }
        return j;
    }

    @Override
    protected void printHelp(JCommander j) {
        super.printHelp(j);
        if (this.getAuthorizationRepositoryCliService() != null) {
            this.getAuthorizationRepositoryCliService().printHelp(this, this.userAdminAction);
        }
        if (this.getPrivilegeRepository() instanceof PrivilegeRepositoryWithCliSupport) {
            this.getPrivilegeRepositoryCliService().printHelp(this, this.userAdminAction);
        }
    }

    private Args getArgumentsObject() {
        switch (this.userAdminAction) {
            case "create": {
                return new CreateUserArgs();
            }
            case "list": {
                return new ListUsersArgs();
            }
            case "active": {
                return new ListActiveUsersArgs();
            }
            case "export-passwords": {
                return new ExportPasswordsArgs();
            }
            case "update-password": {
                return new UpdatePasswordArgs();
            }
            case "delete": {
                return new DeleteUserArgs();
            }
            case "set-displayname-and-or-email": {
                return new SetDisplayNameEmailArgs();
            }
        }
        if (this.getAuthorizationRepositoryCliService() != null && this.authorizationRepositoryActions.contains(this.userAdminAction)) {
            return this.getAuthorizationRepositoryCliService().createArguments(this, this.userAdminAction);
        }
        if (this.getPrivilegeRepositoryCliService() != null && this.privilegeRepositoryActions.contains(this.userAdminAction)) {
            return this.getPrivilegeRepositoryCliService().createArguments(this, this.userAdminAction);
        }
        throw new BcException("Unhandled userAdminAction: " + this.userAdminAction);
    }

    @Override
    protected int run() throws Exception {
        LOGGER.info("running %s", this.userAdminAction);
        try {
            switch (this.userAdminAction) {
                case "create": {
                    return this.create((CreateUserArgs)this.args);
                }
                case "list": {
                    return this.list((ListUsersArgs)this.args);
                }
                case "active": {
                    return this.active((ListActiveUsersArgs)this.args);
                }
                case "export-passwords": {
                    return this.exportPasswords((ExportPasswordsArgs)this.args);
                }
                case "update-password": {
                    return this.updatePassword((UpdatePasswordArgs)this.args);
                }
                case "delete": {
                    return this.delete((DeleteUserArgs)this.args);
                }
                case "set-displayname-and-or-email": {
                    return this.setDisplayNameAndOrEmail((SetDisplayNameEmailArgs)this.args);
                }
            }
            if (this.getAuthorizationRepositoryCliService() != null && this.authorizationRepositoryActions.contains(this.userAdminAction)) {
                return this.getAuthorizationRepositoryCliService().run(this, this.userAdminAction, this.args, this.getUser());
            }
            if (this.getPrivilegeRepositoryCliService() != null && this.privilegeRepositoryActions.contains(this.userAdminAction)) {
                return this.getPrivilegeRepositoryCliService().run(this, this.userAdminAction, this.args, this.getUser());
            }
        }
        catch (UserNotFoundException ex) {
            System.err.println(ex.getMessage());
            return 2;
        }
        throw new BcException("Unhandled userAdminAction: " + this.userAdminAction);
    }

    private int exportPasswords(ExportPasswordsArgs args) {
        List sortedUsers = this.loadUsers().stream().sorted((u1, u2) -> u1.getUsername().compareTo(u2.getUsername())).collect(Collectors.toList());
        if (!sortedUsers.isEmpty()) {
            int maxUsernameWidth = sortedUsers.stream().map(User::getUsername).map(String::length).max(Integer::compareTo).orElseGet(() -> 0);
            String format = String.format("%%%ds %%s%%n", -1 * maxUsernameWidth);
            for (User user : sortedUsers) {
                byte[] bPasswordSalt = ((ByteArray)user.getProperty(UserSchema.PASSWORD_SALT.getPropertyName())).asObjectCopy();
                byte[] bPasswordHash = ((ByteArray)user.getProperty(UserSchema.PASSWORD_HASH.getPropertyName())).asObjectCopy();
                String passwordSalt = Base64.getEncoder().encodeToString(bPasswordSalt);
                String passwordHash = Base64.getEncoder().encodeToString(bPasswordHash);
                System.out.printf(format, user.getUsername(), passwordSalt + ":" + passwordHash);
            }
        } else {
            System.out.println("No users");
        }
        return 0;
    }

    private int create(CreateUserArgs args) {
        this.getUserRepository().findOrAddUser(args.userName, args.userName, null, args.password);
        User user = this.getUserRepository().findByUsername(args.userName);
        if (args.displayName != null) {
            this.getUserRepository().setDisplayName(user, args.displayName);
        }
        if (args.email != null) {
            this.getUserRepository().setEmailAddress(user, args.email);
        }
        if (this.getAuthorizationRepositoryCliService() != null) {
            this.getAuthorizationRepositoryCliService().onCreateUser(this, args, user, this.getUser());
        }
        if (this.getPrivilegeRepositoryCliService() != null) {
            this.getPrivilegeRepositoryCliService().onCreateUser(this, args, user, this.getUser());
        }
        this.printUser(this.getUserRepository().findById(user.getUserId()));
        return 0;
    }

    private int list(ListUsersArgs args) {
        List<User> sortedUsers = this.loadUsers().stream().sorted((u1, u2) -> {
            ZonedDateTime d2;
            ZonedDateTime d1 = u1.getCreateDate();
            return d1 == (d2 = u2.getCreateDate()) ? 0 : d1.compareTo(d2);
        }).collect(Collectors.toList());
        if (args.asTable) {
            this.printUsers(sortedUsers);
        } else {
            sortedUsers.forEach(this::printUser);
        }
        return 0;
    }

    private int active(ListActiveUsersArgs args) {
        List<User> activeUsers = this.loadUsers(UserStatus.ACTIVE);
        System.out.println(activeUsers.size() + " " + (Object)((Object)UserStatus.ACTIVE) + " user" + (activeUsers.size() == 1 ? "" : "s"));
        this.printUsers(activeUsers);
        return 0;
    }

    private int updatePassword(UpdatePasswordArgs args) {
        User user = this.findUser(args);
        if (!Strings.isNullOrEmpty((String)args.password)) {
            this.getUserRepository().setPassword(user, args.password);
        } else if (!Strings.isNullOrEmpty((String)args.passwordSaltAndHash)) {
            String[] saltAndHashStrings = args.passwordSaltAndHash.split(":", -1);
            byte[] salt = Base64.getDecoder().decode(saltAndHashStrings[0]);
            byte[] passwordHash = Base64.getDecoder().decode(saltAndHashStrings[1]);
            this.getUserRepository().setPassword(user, salt, passwordHash);
        }
        this.printUser(user);
        return 0;
    }

    private int delete(DeleteUserArgs args) {
        User user = this.findUser(args);
        this.getUserRepository().delete(user);
        System.out.println("Deleted user " + user.getUserId());
        return 0;
    }

    private int setDisplayNameAndOrEmail(SetDisplayNameEmailArgs args) {
        if (args.displayName == null && args.email == null) {
            System.out.println("no display name or e-mail address provided");
            return -2;
        }
        User user = this.findUser(args);
        if (args.displayName != null) {
            this.getUserRepository().setDisplayName(user, args.displayName);
        }
        if (args.email != null) {
            this.getUserRepository().setEmailAddress(user, args.email);
        }
        this.printUser(this.getUserRepository().findById(user.getUserId()));
        return 0;
    }

    public User findUser(FindUserArgs findUserArgs) {
        User user = null;
        if (findUserArgs.userName != null) {
            user = this.getUserRepository().findByUsername(findUserArgs.userName);
        } else if (findUserArgs.userId != null) {
            user = this.getUserRepository().findById(findUserArgs.userId);
        }
        if (user == null) {
            throw new UserNotFoundException(findUserArgs);
        }
        return user;
    }

    public void printUser(User user) {
        String formatString = "%30s: %s";
        System.out.println(String.format(formatString, "ID", user.getUserId()));
        System.out.println(String.format(formatString, "Username", user.getUsername()));
        System.out.println(String.format(formatString, "E-Mail Address", this.valueOrBlank(user.getEmailAddress())));
        System.out.println(String.format(formatString, "Display Name", user.getDisplayName()));
        System.out.println(String.format(formatString, "Create Date", this.valueOrBlank(user.getCreateDate())));
        System.out.println(String.format(formatString, "Current Login Date", this.valueOrBlank(user.getCurrentLoginDate())));
        System.out.println(String.format(formatString, "Current Login Remote Addr", this.valueOrBlank(user.getCurrentLoginRemoteAddr())));
        System.out.println(String.format(formatString, "Previous Login Date", this.valueOrBlank(user.getPreviousLoginDate())));
        System.out.println(String.format(formatString, "Previous Login Remote Addr", this.valueOrBlank(user.getPreviousLoginRemoteAddr())));
        System.out.println(String.format(formatString, "Login Count", user.getLoginCount()));
        if (this.getAuthorizationRepositoryCliService() != null) {
            this.getAuthorizationRepositoryCliService().onPrintUser(this, this.args, formatString, user);
        }
        if (this.getPrivilegeRepositoryCliService() != null) {
            this.getPrivilegeRepositoryCliService().onPrintUser(this, this.args, formatString, user);
        }
        System.out.println("");
    }

    private void printUsers(Iterable<User> users) {
        if (users != null) {
            int maxCreateDateWidth = 1;
            int maxIdWidth = 1;
            int maxUsernameWidth = 1;
            int maxEmailAddressWidth = 1;
            int maxDisplayNameWidth = 1;
            int maxLoginCountWidth = 1;
            for (User user : users) {
                maxCreateDateWidth = this.maxWidth(user.getCreateDate(), maxCreateDateWidth);
                maxIdWidth = this.maxWidth(user.getUserId(), maxIdWidth);
                maxUsernameWidth = this.maxWidth(user.getUsername(), maxUsernameWidth);
                maxEmailAddressWidth = this.maxWidth(user.getEmailAddress(), maxEmailAddressWidth);
                maxDisplayNameWidth = this.maxWidth(user.getDisplayName(), maxDisplayNameWidth);
                maxLoginCountWidth = this.maxWidth(Integer.toString(user.getLoginCount()), maxLoginCountWidth);
            }
            String format = String.format("%%%ds %%%ds %%%ds %%%ds %%%ds %%%dd %%n", -1 * maxCreateDateWidth, -1 * maxIdWidth, -1 * maxUsernameWidth, -1 * maxEmailAddressWidth, -1 * maxDisplayNameWidth, maxLoginCountWidth);
            for (User user : users) {
                System.out.printf(format, this.valueOrBlank(user.getCreateDate()), user.getUserId(), user.getUsername(), this.valueOrBlank(user.getEmailAddress()), user.getDisplayName(), user.getLoginCount());
            }
        } else {
            System.out.println("No users");
        }
    }

    private String valueOrBlank(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            return sdf.format(o);
        }
        return o.toString();
    }

    private int maxWidth(Object o, int max) {
        int width = this.valueOrBlank(o).length();
        return width > max ? width : max;
    }

    private List<User> loadUsers() {
        return this.loadUsers(null);
    }

    private List<User> loadUsers(UserStatus filter) {
        Iterable<User> usersIterable;
        List<User> userPage;
        ArrayList<User> allUsers = new ArrayList<User>();
        int limit = 100;
        int skip = 0;
        while ((userPage = IterableUtils.toList(usersIterable = filter == null ? this.getUserRepository().find(skip, limit) : this.getUserRepository().findByStatus(skip, limit, filter))).size() != 0) {
            allUsers.addAll(userPage);
            skip += limit;
        }
        return allUsers;
    }

    private PrivilegeRepositoryCliService getPrivilegeRepositoryCliService() {
        if (this.getPrivilegeRepository() instanceof PrivilegeRepositoryWithCliSupport) {
            return ((PrivilegeRepositoryWithCliSupport)this.getPrivilegeRepository()).getCliService();
        }
        return null;
    }

    private AuthorizationRepositoryCliService getAuthorizationRepositoryCliService() {
        if (this.getAuthorizationRepository() instanceof AuthorizationRepositoryWithCliSupport) {
            return ((AuthorizationRepositoryWithCliSupport)this.getAuthorizationRepository()).getCliService();
        }
        return null;
    }
}

