/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.watcher;

import com.mware.core.orm.Entity;
import com.mware.core.orm.Field;
import com.mware.core.orm.Id;
import java.util.Date;
import java.util.UUID;
import org.json.JSONObject;

@Entity(tableName="watchlist")
public class Watch {
    @Id
    private String id;
    @Field
    private String elementId;
    @Field
    private String userId;
    @Field
    private String propertyName;
    @Field
    private String elementTitle;

    public Watch(String userId, String elementId, String propertyName, String elementTitle) {
        this(Watch.createRowKey(new Date()), userId, elementId, propertyName, elementTitle);
    }

    public Watch(String id, String userId, String elementId, String propertyName, String elementTitle) {
        this.id = id;
        this.userId = userId;
        this.elementId = elementId;
        this.propertyName = propertyName;
        this.elementTitle = elementTitle;
    }

    protected Watch() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getElementTitle() {
        return this.elementTitle;
    }

    public void setElementTitle(String elementTitle) {
        this.elementTitle = elementTitle;
    }

    private static String createRowKey(Date date) {
        return date.getTime() + ":" + UUID.randomUUID().toString();
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("propertyName", (Object)this.getPropertyName());
        json.put("elementId", (Object)this.getElementId());
        if (this.getElementTitle() != null) {
            json.put("elementTitle", (Object)this.getElementTitle());
        } else {
            json.put("elementTitle", (Object)"No title");
        }
        return json;
    }
}

