/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.watcher;

import com.google.inject.Inject;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.watcher.Watch;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.User;
import com.mware.core.util.StreamUtil;
import java.util.stream.Stream;

public class WatchlistRepository {
    private static final String VISIBILITY_STRING = "";
    private final SimpleOrmSession simpleOrmSession;
    private UserRepository userRepository;

    @Inject
    public WatchlistRepository(SimpleOrmSession simpleOrmSession) {
        this.simpleOrmSession = simpleOrmSession;
    }

    public void createWatch(String userId, String elementId, String propertyName, User authUser, String elementTitle) {
        Watch watch = new Watch(userId, elementId, propertyName, elementTitle);
        this.saveWatch(watch, authUser);
    }

    public void deleteWatch(String id, User authUser) {
        this.getSimpleOrmSession().delete(Watch.class, id, this.getUserRepository().getSimpleOrmContext(authUser));
    }

    private void saveWatch(Watch watch, User authUser) {
        this.getSimpleOrmSession().save(watch, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext(authUser));
    }

    public Stream<Watch> getUserWatches(User user) {
        return this.findAll(user).filter(watch -> user.getUserId().equals(watch.getUserId()));
    }

    public Stream<Watch> getElementWatches(String elementId) {
        return this.findAll(this.getUserRepository().getSystemUser()).filter(watch -> watch.getElementId().equals(elementId));
    }

    private Stream<Watch> findAll(User user) {
        SimpleOrmContext ctx = this.getUserRepository().getSimpleOrmContext(user);
        return StreamUtil.stream(this.getSimpleOrmSession().findAll(Watch.class, ctx));
    }

    public SimpleOrmSession getSimpleOrmSession() {
        return this.simpleOrmSession;
    }

    private UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }
}

