/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workQueue;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.ingest.WorkerSpout;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.RabbitMQWorkQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.status.model.Status;
import com.mware.ge.Element;
import com.mware.ge.Graph;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class DuplicatingWorkQueueRepository
extends WorkQueueRepository {
    private final RabbitMQWorkQueueRepository workQueueRepository;
    private final Set<String> dwQueueNames;
    private final Set<String> lrpQueueNames;

    @Inject
    public DuplicatingWorkQueueRepository(Graph graph, Configuration configuration, LifeSupportService lifeSupportService) {
        super(graph, configuration);
        String queue;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String key : configuration.getKeys("dw.queue")) {
            if (!key.endsWith(".name")) continue;
            queue = configuration.get(key, null);
            builder.add((Object)queue);
        }
        this.dwQueueNames = builder.build();
        builder = ImmutableSet.builder();
        for (String key : configuration.getKeys("lrp.queue")) {
            if (!key.endsWith(".name")) continue;
            queue = configuration.get(key, null);
            builder.add((Object)queue);
        }
        this.lrpQueueNames = builder.build();
        this.workQueueRepository = new RabbitMQWorkQueueRepository(graph, configuration, lifeSupportService);
        lifeSupportService.add(this);
    }

    @Override
    public void start() throws Throwable {
        this.dwQueueNames.forEach(q -> {
            try {
                this.workQueueRepository.ensureQueue((String)q);
            }
            catch (IOException e) {
                throw new BcException("Could not create queue", e);
            }
        });
    }

    @Override
    public void pushOnQueue(String queueName, byte[] data, Priority priority) {
        this.dwQueueNames.forEach(q -> this.workQueueRepository.pushOnQueue((String)q, data, priority));
    }

    @Override
    public void pushLongRunningProcessQueue(JSONObject queueItem, Priority priority) {
        this.lrpQueueNames.forEach(q -> this.workQueueRepository.pushOnQueue((String)q, queueItem, priority));
    }

    @Override
    public void flush() {
        this.workQueueRepository.flush();
    }

    @Override
    protected void deleteQueue(String queueName) {
    }

    @Override
    public WorkerSpout createWorkerSpout(String queueName) {
        return this.workQueueRepository.createWorkerSpout(queueName);
    }

    @Override
    public Map<String, Status> getQueuesStatus() {
        return this.workQueueRepository.getQueuesStatus();
    }

    @Override
    protected boolean canHandle(Element element, String propertyKey, String propertyName, ElementOrPropertyStatus status) {
        return true;
    }
}

