/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workQueue;

import com.google.inject.Inject;
import com.mware.core.model.workQueue.WebQueueRepository;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class InMemoryWebQueueRepository
extends WebQueueRepository {
    private List<WebQueueRepository.BroadcastConsumer> broadcastConsumers = new ArrayList<WebQueueRepository.BroadcastConsumer>();

    @Inject
    public InMemoryWebQueueRepository() {
    }

    @Override
    public void broadcastJson(JSONObject json) {
        for (WebQueueRepository.BroadcastConsumer consumer : this.broadcastConsumers) {
            consumer.broadcastReceived(json);
        }
    }

    @Override
    public void subscribeToBroadcastMessages(WebQueueRepository.BroadcastConsumer broadcastConsumer) {
        this.broadcastConsumers.add(broadcastConsumer);
    }

    @Override
    public void unsubscribeFromBroadcastMessages(WebQueueRepository.BroadcastConsumer broadcastConsumer) {
        this.broadcastConsumers.remove(broadcastConsumer);
    }
}

