/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workQueue;

import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.ingest.WorkerSpout;
import com.mware.core.ingest.WorkerTuple;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.status.model.QueueStatus;
import com.mware.core.status.model.Status;
import com.mware.ge.Graph;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InMemoryWorkQueueRepository
extends WorkQueueRepository {
    private static Map<String, List<byte[]>> queues = new HashMap<String, List<byte[]>>();

    @Inject
    public InMemoryWorkQueueRepository(Graph graph, Configuration configuration) {
        super(graph, configuration);
    }

    @Override
    public void pushOnQueue(String queueName, byte[] data, Priority priority) {
        LOGGER.debug("push on queue: %s: %s", queueName, data);
        this.addToQueue(queueName, data, priority);
    }

    public synchronized void addToQueue(String queueName, byte[] data, Priority priority) {
        List<byte[]> queue = InMemoryWorkQueueRepository.getQueue(queueName);
        if (priority == Priority.HIGH) {
            queue.add(0, data);
        } else {
            queue.add(data);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void format() {
        InMemoryWorkQueueRepository.clearQueue();
    }

    @Override
    public WorkerSpout createWorkerSpout(String queueName) {
        final List<byte[]> queue = InMemoryWorkQueueRepository.getQueue(queueName);
        return new WorkerSpout(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WorkerTuple nextTuple() throws Exception {
                List list = queue;
                synchronized (list) {
                    if (queue.size() == 0) {
                        Thread.sleep(100L);
                        return null;
                    }
                    byte[] entry = (byte[])queue.remove(0);
                    if (entry == null) {
                        Thread.sleep(100L);
                        return null;
                    }
                    return new WorkerTuple("", entry);
                }
            }
        };
    }

    @Override
    public Map<String, Status> getQueuesStatus() {
        HashMap<String, Status> results = new HashMap<String, Status>();
        for (Map.Entry<String, List<byte[]>> queue : queues.entrySet()) {
            results.put(queue.getKey(), new QueueStatus(queue.getValue().size()));
        }
        return results;
    }

    public static void clearQueue() {
        queues.clear();
    }

    @Override
    protected void deleteQueue(String queueName) {
        queues.remove(queueName);
    }

    public static List<byte[]> getQueue(String queueName) {
        List<byte[]> queue = queues.get(queueName);
        if (queue == null) {
            queue = new LinkedList<byte[]>();
            queues.put(queueName, queue);
        }
        return queue;
    }
}

