/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workQueue;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public class RabbitMQUtils {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(RabbitMQUtils.class);
    public static final String RABBITMQ_ADDR_PREFIX = "rabbitmq.addr";
    public static final String RABBITMQ_DELIVERY_MODE = "rabbitmq.deliveryMode";
    public static final String RABBITMQ_USERNAME = "rabbitmq.username";
    public static final String RABBITMQ_PASSWORD = "rabbitmq.password";
    private static final int DEFAULT_PORT = 5672;

    public static Connection openConnection(Address[] addresses, Configuration configuration) throws IOException {
        if (addresses.length == 0) {
            throw new BcException("Could not configure RabbitMQ. No addresses specified. expecting configuration parameter 'rabbitmq.addr.0.host'.");
        }
        String username = configuration.get(RABBITMQ_USERNAME, null);
        String password = configuration.get(RABBITMQ_PASSWORD, null);
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
            throw new BcException("Could not configure RabbitMQ. Username or password is null. Expecting configuration parameters 'rabbitmq.username' and 'rabbitmq.password'.");
        }
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setAutomaticRecoveryEnabled(true);
            connectionFactory.setUsername(username);
            connectionFactory.setPassword(password);
            Connection connection = connectionFactory.newConnection(addresses);
            ((Recoverable)connection).addRecoveryListener(new RecoveryListener(){

                public void handleRecovery(Recoverable recoverable) {
                    Connection recoveredConnection = (Connection)recoverable;
                    LOGGER.warn("recovered RabbitMQ connection to %s:%d", recoveredConnection.getAddress(), recoveredConnection.getPort());
                }

                public void handleRecoveryStarted(Recoverable recoverable) {
                }
            });
            return connection;
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }

    public static Connection openConnection(Configuration configuration) throws IOException {
        Address[] addresses = RabbitMQUtils.getAddresses(configuration);
        return RabbitMQUtils.openConnection(addresses, configuration);
    }

    public static Channel openChannel(Connection connection) {
        try {
            return connection.createChannel();
        }
        catch (IOException ex) {
            throw new BcException("Could not open channel to RabbitMQ", ex);
        }
    }

    public static Address[] getAddresses(Configuration configuration) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (String key : configuration.getKeys(RABBITMQ_ADDR_PREFIX)) {
            if (!key.endsWith(".host")) continue;
            String host = configuration.get(key, null);
            Preconditions.checkNotNull((Object)host, (Object)("Configuration " + key + " is required"));
            int port = configuration.getInt(key.replace(".host", ".port"), 5672);
            addresses.add(new Address(host, port));
        }
        return addresses.toArray(new Address[addresses.size()]);
    }

    private static Address[] createAddresses(String[] addresses) {
        List addressList = Lists.newArrayList();
        for (String address : addresses) {
            String[] addressParts = address.split(":");
            if (addressParts.length == 1) {
                addressList.add(new Address(address));
                continue;
            }
            if (addressParts.length == 2) {
                addressList.add(new Address(addressParts[0], Integer.parseInt(addressParts[1])));
                continue;
            }
            throw new IllegalArgumentException(String.format("malformed rabbitmq address: %s", address));
        }
        return addressList.toArray(new Address[0]);
    }
}

