/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workQueue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.exception.BcAccessDeniedException;
import com.mware.core.exception.BcException;
import com.mware.core.lifecycle.LifecycleAdapter;
import com.mware.core.model.clientapi.dto.ClientApiWorkspace;
import com.mware.core.model.clientapi.dto.UserStatus;
import com.mware.core.model.notification.SystemNotification;
import com.mware.core.model.notification.UserNotification;
import com.mware.core.model.properties.MediaBcSchema;
import com.mware.core.model.properties.types.BcPropertyUpdate;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workspace.Workspace;
import com.mware.core.model.workspace.WorkspaceRepository;
import com.mware.core.model.workspace.WorkspaceUser;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.Vertex;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class WebQueueRepository
extends LifecycleAdapter {
    private UserRepository userRepository;
    private AuthorizationRepository authorizationRepository;
    private WorkspaceRepository workspaceRepository;

    protected WebQueueRepository() {
    }

    public void broadcastLongRunningProcessDeleted(JSONObject longRunningProcessQueueItem) {
        String userId = longRunningProcessQueueItem.optString("userId");
        Preconditions.checkNotNull((Object)userId, (Object)"userId cannot be null");
        JSONObject json = new JSONObject();
        json.put("type", (Object)"longRunningProcessDeleted");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject data = new JSONObject();
        data.put("processId", longRunningProcessQueueItem.get("id"));
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void broadcastLongRunningProcessChange(JSONObject longRunningProcessQueueItem) {
        String userId = longRunningProcessQueueItem.optString("userId");
        Preconditions.checkNotNull((Object)userId, (Object)"userId cannot be null");
        JSONObject json = new JSONObject();
        json.put("type", (Object)"longRunningProcessChange");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject dataJson = new JSONObject(longRunningProcessQueueItem.toString());
        if (dataJson.has("results")) {
            dataJson.remove("results");
        }
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductAncillaryChange(String workProductId, String workspaceId, String ancillaryId, User user, String skipSourceGuid) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductAncillaryChange");
        json.put("permissions", (Object)this.getPermissionsWithWorkspace(workspaceId));
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)ancillaryId);
        dataJson.put("workspaceId", (Object)workspaceId);
        dataJson.put("productId", (Object)workProductId);
        dataJson.putOpt("sourceGuid", (Object)skipSourceGuid);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductPreviewChange(String workProductId, String workspaceId, User user, String md5) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductPreviewChange");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)user.getUserId());
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)workProductId);
        dataJson.put("workspaceId", (Object)workspaceId);
        dataJson.putOpt("md5", (Object)md5);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductDelete(String workProductId, ClientApiWorkspace workspace) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductDelete");
        json.put("permissions", (Object)this.getPermissionsWithUsers(workspace, null));
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)workProductId);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastEdgeDeletion(Edge edge) {
        JSONObject dataJson = new JSONObject();
        if (edge != null) {
            dataJson.put("edgeId", edge.getId());
            dataJson.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
            dataJson.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)"edgeDeletion");
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastVerticesDeletion(String vertexId) {
        JSONArray verticesDeleted = new JSONArray();
        verticesDeleted.put((Object)vertexId);
        this.broadcastVerticesDeletion(verticesDeleted);
    }

    public void broadcastVerticesDeletion(JSONArray verticesDeleted) {
        JSONObject dataJson = new JSONObject();
        if (verticesDeleted != null) {
            dataJson.put("vertexIds", (Object)verticesDeleted);
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)"verticesDeleted");
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void pushOntologyConceptsChange(String workspaceId, List<String> ids) {
        this.pushOntologyChange(workspaceId, SchemaAction.Update, ids, null, null);
    }

    public void pushOntologyConceptsChange(String workspaceId, String ... ids) {
        this.pushOntologyChange(workspaceId, SchemaAction.Update, Arrays.asList(ids), null, null);
    }

    public void pushOntologyPropertiesChange(String workspaceId, String ... ids) {
        this.pushOntologyChange(workspaceId, SchemaAction.Update, null, null, Arrays.asList(ids));
    }

    public void pushOntologyPropertiesChange(String workspaceId, List<String> ids) {
        this.pushOntologyChange(workspaceId, SchemaAction.Update, null, null, ids);
    }

    public void pushOntologyRelationshipsChange(String workspaceId, List<String> ids) {
        this.pushOntologyChange(workspaceId, SchemaAction.Update, null, ids, null);
    }

    public void pushOntologyRelationshipsChange(String workspaceId, String ... ids) {
        this.pushOntologyChange(workspaceId, SchemaAction.Update, null, Arrays.asList(ids), null);
    }

    public void pushOntologyChange(String workspaceId, SchemaAction action, Iterable<String> conceptIds, Iterable<String> relationshipIds, Iterable<String> propertyIds) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"ontologyChange");
        JSONObject data = new JSONObject();
        data.put("action", (Object)action.toString());
        data.put("idType", (Object)(action.equals((Object)SchemaAction.Update) ? "id" : "iri"));
        if (workspaceId != null) {
            data.put("workspaceId", (Object)workspaceId);
            json.put("permissions", (Object)this.getPermissionsWithWorkspace(workspaceId));
        }
        if (conceptIds != null || relationshipIds != null || propertyIds != null) {
            data.put("conceptIds", (Object)(conceptIds == null ? new JSONArray() : new JSONArray((Collection)Sets.newHashSet(conceptIds))));
            data.put("propertyIds", (Object)(propertyIds == null ? new JSONArray() : new JSONArray((Collection)Sets.newHashSet(propertyIds))));
            data.put("relationshipIds", (Object)(relationshipIds == null ? new JSONArray() : new JSONArray((Collection)Sets.newHashSet(relationshipIds))));
        }
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void pushTextUpdated(String vertexId) {
        this.pushTextUpdated(vertexId, Priority.NORMAL);
    }

    public void pushTextUpdated(String vertexId, Priority priority) {
        if (this.shouldBroadcast(priority)) {
            this.broadcastTextUpdated(vertexId);
        }
    }

    protected void broadcastTextUpdated(String vertexId) {
        JSONObject dataJson = new JSONObject();
        if (vertexId != null) {
            dataJson.put("graphVertexId", (Object)vertexId);
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)"textUpdated");
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void pushUserAccessChange(User user) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"userAccessChange");
        json.put("permissions", (Object)this.getPermissionsWithUserIds(user.getUserId()));
        json.put("data", (Object)this.getUserRepository().toJsonWithAuths(user));
        this.broadcastJson(json);
    }

    public void broadcastUserStatusChange(User user, UserStatus status) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"userStatusChange");
        JSONObject data = UserRepository.toJson(user);
        data.put("status", (Object)status.toString());
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductChange(String workProductId, String skipSourceGuid, String workspaceId, JSONObject permissions) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductChange");
        json.put("permissions", (Object)permissions);
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)workProductId);
        dataJson.put("workspaceId", (Object)workspaceId);
        dataJson.putOpt("sourceGuid", (Object)skipSourceGuid);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastUserWorkspaceChange(User user, String workspaceId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"userWorkspaceChange");
        JSONObject data = UserRepository.toJson(user);
        data.put("workspaceId", (Object)workspaceId);
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void broadcastWorkspace(ClientApiWorkspace workspace, List<ClientApiWorkspace.User> previousUsers, String changedByUserId, String changedBySourceGuid) {
        User changedByUser = this.getUserRepository().findById(changedByUserId);
        Workspace ws = this.getWorkspaceRepository().findById(workspace.getWorkspaceId(), changedByUser);
        previousUsers.forEach(workspaceUser -> {
            boolean isChangingUser = workspaceUser.getUserId().equals(changedByUserId);
            User user = isChangingUser ? changedByUser : this.getUserRepository().findById(workspaceUser.getUserId());
            Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, workspace.getWorkspaceId());
            try {
                ClientApiWorkspace userWorkspace = isChangingUser ? workspace : this.getWorkspaceRepository().toClientApi(ws, user, authorizations);
                JSONObject json = new JSONObject();
                json.put("type", (Object)"workspaceChange");
                json.put("modifiedBy", (Object)changedByUserId);
                json.put("permissions", (Object)this.getPermissionsWithUsers(null, Arrays.asList(workspaceUser)));
                json.put("data", (Object)new JSONObject(ClientApiConverter.clientApiToString(userWorkspace)));
                json.putOpt("sourceGuid", (Object)changedBySourceGuid);
                this.broadcastJson(json);
            }
            catch (BcAccessDeniedException bcAccessDeniedException) {
                // empty catch block
            }
        });
    }

    public void pushWorkspaceDelete(ClientApiWorkspace workspace) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workspaceDelete");
        json.put("permissions", (Object)this.getPermissionsWithUsers(workspace, null));
        json.put("workspaceId", (Object)workspace.getWorkspaceId());
        this.broadcastJson(json);
    }

    public void pushWorkspaceDelete(String workspaceId, String userId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workspaceDelete");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        json.put("workspaceId", (Object)workspaceId);
        this.broadcastJson(json);
    }

    public void pushSessionExpiration(String userId, String sessionId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"sessionExpiration");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        JSONArray sessionIds = new JSONArray();
        sessionIds.put((Object)sessionId);
        permissions.put("sessionIds", (Object)sessionIds);
        json.put("permissions", (Object)permissions);
        json.putOpt("sessionId", (Object)sessionId);
        this.broadcastJson(json);
    }

    public void pushUserNotification(UserNotification notification) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"notification");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)notification.getUserId());
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notification", (Object)notification.toJSONObject());
        this.broadcastJson(json);
    }

    public void pushSystemNotification(SystemNotification notification) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"notification");
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notification", (Object)notification.toJSONObject());
        this.broadcastJson(json);
    }

    public void pushSystemNotificationUpdate(SystemNotification notification) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"systemNotificationUpdated");
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notification", (Object)notification.toJSONObject());
        this.broadcastJson(json);
    }

    public void pushSystemNotificationEnded(String notificationId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"systemNotificationEnded");
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notificationId", (Object)notificationId);
        this.broadcastJson(json);
    }

    public void broadcastElementImage(Element element) {
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"entityImageUpdated");
            JSONObject dataJson = new JSONObject();
            dataJson.put("graphVertexId", element.getId());
            json.put("data", (Object)dataJson);
            this.broadcastJson(json);
        }
        catch (Exception ex) {
            throw new BcException("Could not broadcast property change", ex);
        }
    }

    public void broadcastPropertiesChange(Element element, Iterable<BcPropertyUpdate> properties, String workspaceId, Priority priority) {
        for (BcPropertyUpdate propertyUpdate : properties) {
            String propertyName = propertyUpdate.getPropertyName();
            if (!this.shouldBroadcastGraphPropertyChange(propertyName, priority)) continue;
            this.broadcastPropertyChange(element, propertyUpdate.getPropertyKey(), propertyName, workspaceId);
        }
    }

    public void broadcastPropertyChange(Element element, String propertyKey, String propertyName, String workspaceId) {
        try {
            JSONObject json;
            if (element instanceof Vertex) {
                json = new JSONObject();
                json.put("type", (Object)"propertyChange");
                JSONObject dataJson = new JSONObject();
                dataJson.put("graphVertexId", element.getId());
                dataJson.putOpt("workspaceId", (Object)workspaceId);
                json.put("data", (Object)dataJson);
            } else if (element instanceof Edge) {
                Edge edge = (Edge)element;
                json = new JSONObject();
                json.put("type", (Object)"propertyChange");
                JSONObject dataJson = new JSONObject();
                dataJson.put("graphEdgeId", edge.getId());
                dataJson.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
                dataJson.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
                dataJson.putOpt("workspaceId", (Object)workspaceId);
                json.put("data", (Object)dataJson);
            } else {
                throw new BcException("Unexpected element type: " + element.getClass().getName());
            }
            this.broadcastJson(json);
        }
        catch (Exception ex) {
            throw new BcException("Could not broadcast property change", ex);
        }
    }

    public boolean shouldBroadcast(Priority priority) {
        return priority != Priority.LOW;
    }

    public boolean shouldBroadcastGraphPropertyChange(String propertyName, Priority priority) {
        return this.shouldBroadcast(priority) && !MediaBcSchema.VIDEO_FRAME.getPropertyName().equals(propertyName);
    }

    public abstract void broadcastJson(JSONObject var1);

    private JSONObject getPermissionsWithUserIds(String ... userIds) {
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        for (String userId : userIds) {
            users.put((Object)userId);
        }
        permissions.put("users", (Object)users);
        return permissions;
    }

    private JSONObject getPermissionsWithWorkspace(String workspaceId) {
        List<WorkspaceUser> users = this.getWorkspaceRepository().findUsersWithAccess(workspaceId, new SystemUser());
        return this.getPermissionsWithUsers(users);
    }

    private JSONObject getPermissionsWithUsers(List<WorkspaceUser> workspaceUsers) {
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        if (workspaceUsers != null) {
            for (WorkspaceUser workspaceUser : workspaceUsers) {
                users.put((Object)workspaceUser.getUserId());
            }
        }
        permissions.put("users", (Object)users);
        return permissions;
    }

    public JSONObject getPermissionsWithUsers(ClientApiWorkspace workspace, List<ClientApiWorkspace.User> previousUsers) {
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        if (previousUsers != null) {
            for (ClientApiWorkspace.User user : previousUsers) {
                users.put((Object)user.getUserId());
            }
        }
        if (workspace != null) {
            for (ClientApiWorkspace.User user : workspace.getUsers()) {
                users.put((Object)user.getUserId());
            }
        }
        permissions.put("users", (Object)users);
        return permissions;
    }

    public void broadcastPublishVertexDelete(Vertex vertex) {
        this.broadcastPublish(vertex, null, null, PublishType.DELETE);
    }

    public void broadcastPublishVertex(Vertex vertex) {
        this.broadcastPublish(vertex, null, null, PublishType.TO_PUBLIC);
    }

    public void broadcastUndoVertexDelete(Vertex vertex) {
        this.broadcastPublish(vertex, null, null, PublishType.UNDO_DELETE);
    }

    public void broadcastUndoVertex(Vertex vertex) {
        this.broadcastPublish(vertex, null, null, PublishType.UNDO);
    }

    public void broadcastPublishPropertyDelete(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.DELETE);
    }

    public void broadcastPublishProperty(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.TO_PUBLIC);
    }

    public void broadcastUndoPropertyDelete(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.UNDO_DELETE);
    }

    public void broadcastUndoProperty(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.UNDO);
    }

    public void broadcastPublishEdgeDelete(Edge edge) {
        this.broadcastPublish(edge, null, null, PublishType.DELETE);
    }

    public void broadcastPublishEdge(Edge edge) {
        this.broadcastPublish(edge, null, null, PublishType.TO_PUBLIC);
    }

    public void broadcastUndoEdgeDelete(Edge edge) {
        this.broadcastPublish(edge, null, null, PublishType.UNDO_DELETE);
    }

    public void broadcastUndoEdge(Edge edge) {
        this.broadcastPublish(edge, null, null, PublishType.UNDO);
    }

    public void broadcastPublish(Element element, String propertyKey, String propertyName, PublishType publishType) {
        try {
            JSONObject json;
            if (element instanceof Vertex) {
                json = new JSONObject();
                json.put("type", (Object)"publish");
                JSONObject dataJson = new JSONObject();
                dataJson.put("graphVertexId", element.getId());
                dataJson.put("publishType", (Object)publishType.getJsonString());
                if (propertyName == null) {
                    dataJson.put("objectType", (Object)"vertex");
                } else {
                    dataJson.put("objectType", (Object)"property");
                }
                json.put("data", (Object)dataJson);
            } else if (element instanceof Edge) {
                json = new JSONObject();
                json.put("type", (Object)"publish");
                JSONObject dataJson = new JSONObject();
                dataJson.put("graphEdgeId", element.getId());
                dataJson.put("publishType", (Object)publishType.getJsonString());
                if (propertyName == null) {
                    dataJson.put("objectType", (Object)"edge");
                } else {
                    dataJson.put("objectType", (Object)"property");
                }
                json.put("data", (Object)dataJson);
            } else {
                throw new BcException("Unexpected element type: " + element.getClass().getName());
            }
            this.broadcastJson(json);
        }
        catch (Exception ex) {
            throw new BcException("Could not broadcast publish", ex);
        }
    }

    public abstract void subscribeToBroadcastMessages(BroadcastConsumer var1);

    public abstract void unsubscribeFromBroadcastMessages(BroadcastConsumer var1);

    protected UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    protected WorkspaceRepository getWorkspaceRepository() {
        if (this.workspaceRepository == null) {
            this.workspaceRepository = InjectHelper.getInstance(WorkspaceRepository.class);
        }
        return this.workspaceRepository;
    }

    public void setWorkspaceRepository(WorkspaceRepository workspaceRepository) {
        this.workspaceRepository = workspaceRepository;
    }

    protected AuthorizationRepository getAuthorizationRepository() {
        if (this.authorizationRepository == null) {
            this.authorizationRepository = InjectHelper.getInstance(AuthorizationRepository.class);
        }
        return this.authorizationRepository;
    }

    public void setAuthorizationRepository(AuthorizationRepository authorizationRepository) {
        this.authorizationRepository = authorizationRepository;
    }

    public static enum SchemaAction {
        Update,
        Delete;

    }

    public static enum PublishType {
        TO_PUBLIC("toPublic"),
        DELETE("delete"),
        UNDO_DELETE("undoDelete"),
        UNDO("undo");

        private final String jsonString;

        private PublishType(String jsonString) {
            this.jsonString = jsonString;
        }

        public String getJsonString() {
            return this.jsonString;
        }
    }

    public static abstract class BroadcastConsumer {
        private String consumerKey;

        public abstract void broadcastReceived(JSONObject var1);

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }
    }
}

