/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workQueue;

import com.google.common.base.Preconditions;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.ingest.WorkerSpout;
import com.mware.core.ingest.dataworker.DataWorkerMessage;
import com.mware.core.ingest.dataworker.DataWorkerRunner;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.lifecycle.LifecycleAdapter;
import com.mware.core.model.properties.types.BcPropertyUpdate;
import com.mware.core.model.properties.types.BcPropertyUpdateRemove;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.status.model.Status;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONObject;

public abstract class WorkQueueRepository
extends LifecycleAdapter {
    public static final String DW_DEFAULT_QUEUE_NAME = "dwQueue";
    public static final String LRP_DEFAULT_QUEUE_NAME = "lrpQueue";
    protected static final BcLogger LOGGER = BcLoggerFactory.getLogger(WorkQueueRepository.class);
    private final Configuration configuration;
    protected String queueName;
    private final Graph graph;
    private DataWorkerRunner dataWorkerRunner;

    protected WorkQueueRepository(Graph graph, Configuration configuration) {
        this.graph = graph;
        this.configuration = configuration;
        this.setQueueName(configuration.get("dw.queue.name", DW_DEFAULT_QUEUE_NAME));
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, String workspaceId, String visibilitySource, Priority priority, ElementOrPropertyStatus status, Long beforeDeleteTimestamp) {
        this.getGraph().flush();
        Preconditions.checkNotNull((Object)element);
        LOGGER.debug("pushGraphPropertyQueue: %s", element.getId());
        DataWorkerMessage data = this.createPropertySpecificMessage(propertyKey, propertyName, workspaceId, visibilitySource, status, beforeDeleteTimestamp, priority);
        this.addElementTypeToJson(data, element);
        if (this.canHandle(element, propertyKey, propertyName, status)) {
            this.pushOnQueue(this.queueName, data.toBytes(), priority);
        }
    }

    public void pushGraphPropertyQueue(Element element, Iterable<BcPropertyUpdate> properties, String workspaceId, String visibilitySource, Priority priority) {
        DataWorkerMessage data = new DataWorkerMessage();
        data.setPriority(priority);
        ArrayList<DataWorkerMessage.Property> messageProperties = new ArrayList<DataWorkerMessage.Property>();
        for (BcPropertyUpdate propertyUpdate : properties) {
            ElementOrPropertyStatus status;
            String propertyName;
            String propertyKey = propertyUpdate.getPropertyKey();
            if (!this.canHandle(element, propertyKey, propertyName = propertyUpdate.getPropertyName(), status = ElementOrPropertyStatus.getStatus(propertyUpdate))) continue;
            Long beforeDeleteTimestamp = propertyUpdate instanceof BcPropertyUpdateRemove ? Long.valueOf(((BcPropertyUpdateRemove)propertyUpdate).getBeforeDeleteTimestamp()) : null;
            DataWorkerMessage.Property property = new DataWorkerMessage.Property();
            property.setPropertyKey(propertyKey);
            property.setPropertyName(propertyName);
            property.setStatus(status);
            property.setBeforeActionTimestamp(beforeDeleteTimestamp);
            messageProperties.add(property);
        }
        if (messageProperties.size() == 0) {
            return;
        }
        data.setProperties(messageProperties.toArray(new DataWorkerMessage.Property[messageProperties.size()]));
        this.addElementTypeToJson(data, element);
        if (workspaceId != null && !workspaceId.equals("")) {
            data.setWorkspaceId(workspaceId);
            data.setVisibilitySource(visibilitySource);
        }
        this.pushOnQueue(this.queueName, data.toBytes(), priority);
    }

    private void addElementTypeToJson(DataWorkerMessage data, Element element) {
        if (element instanceof Vertex) {
            data.setGraphVertexId(new String[]{element.getId()});
        } else if (element instanceof Edge) {
            data.setGraphEdgeId(new String[]{element.getId()});
        } else {
            throw new BcException("Unexpected element type: " + element.getClass().getName());
        }
    }

    public void pushElementImageQueue(Element element, String propertyKey, String propertyName, Priority priority) {
        this.getGraph().flush();
        Preconditions.checkNotNull((Object)element);
        JSONObject data = new JSONObject();
        if (element instanceof Vertex) {
            data.put("graphVertexId", element.getId());
        } else if (element instanceof Edge) {
            data.put("graphEdgeId", element.getId());
        } else {
            throw new BcException("Unexpected element type: " + element.getClass().getName());
        }
        data.put("propertyKey", (Object)propertyKey);
        data.put("propertyName", (Object)propertyName);
        this.pushOnQueue(this.queueName, data, priority);
    }

    public void pushMultipleGraphPropertyQueue(Iterable<? extends Element> elements, String propertyKey, String propertyName, String workspaceId, String visibilitySource, Priority priority, ElementOrPropertyStatus status, Long beforeActionTimestamp) {
        Preconditions.checkNotNull(elements);
        if (!elements.iterator().hasNext()) {
            return;
        }
        this.getGraph().flush();
        DataWorkerMessage data = this.createPropertySpecificMessage(propertyKey, propertyName, workspaceId, visibilitySource, status, beforeActionTimestamp, priority);
        ArrayList<Object> vertices = new ArrayList<Object>();
        ArrayList<Object> edges = new ArrayList<Object>();
        for (Element element : elements) {
            if (!this.canHandle(element, propertyKey, propertyName, status)) continue;
            if (element instanceof Vertex) {
                vertices.add(element.getId());
                continue;
            }
            if (element instanceof Edge) {
                edges.add(element.getId());
                continue;
            }
            throw new BcException("Unexpected element type: " + element.getClass().getName());
        }
        data.setGraphVertexId(vertices.toArray(new String[vertices.size()]));
        data.setGraphEdgeId(edges.toArray(new String[edges.size()]));
        this.pushOnQueue(this.queueName, data.toBytes(), priority);
    }

    protected boolean canHandle(Element element, String propertyKey, String propertyName, ElementOrPropertyStatus status) {
        if (this.dataWorkerRunner == null) {
            return true;
        }
        if (propertyKey == null && propertyName == null) {
            return true;
        }
        return this.dataWorkerRunner.canHandle(element, propertyKey, propertyName, status);
    }

    private DataWorkerMessage createPropertySpecificMessage(String propertyKey, String propertyName, String workspaceId, String visibilitySource, ElementOrPropertyStatus status, Long beforeActionTimestamp, Priority priority) {
        DataWorkerMessage data = new DataWorkerMessage();
        if (workspaceId != null && !workspaceId.equals("")) {
            data.setWorkspaceId(workspaceId);
            data.setVisibilitySource(visibilitySource);
        }
        data.setPropertyKey(propertyKey);
        data.setPropertyName(propertyName);
        data.setStatus(status);
        data.setPriority(priority);
        if (status == ElementOrPropertyStatus.DELETION || status == ElementOrPropertyStatus.HIDDEN) {
            Preconditions.checkNotNull((Object)beforeActionTimestamp, (Object)("Timestamp before " + (Object)((Object)status) + " cannot be null"));
        }
        data.setBeforeActionTimestamp(beforeActionTimestamp);
        return data;
    }

    public final void pushOnQueue(String queueName, JSONObject json, Priority priority) {
        if (priority != null) {
            json.put("priority", (Object)priority.name());
        }
        this.pushOnQueue(queueName, json.toString().getBytes(), priority);
    }

    public abstract void pushOnQueue(String var1, byte[] var2, Priority var3);

    public abstract void flush();

    public void format() {
        this.deleteQueue(this.queueName);
    }

    protected abstract void deleteQueue(String var1);

    public Graph getGraph() {
        return this.graph;
    }

    public abstract WorkerSpout createWorkerSpout(String var1);

    public abstract Map<String, Status> getQueuesStatus();

    public void setDataWorkerRunner(DataWorkerRunner graphPropertyRunner) {
        this.dataWorkerRunner = graphPropertyRunner;
    }

    public boolean hasDataWorkerRunner() {
        return this.dataWorkerRunner != null;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public void pushLongRunningProcessQueue(JSONObject queueItem, Priority priority) {
        this.pushOnQueue(this.configuration.get("lrp.queue.name", LRP_DEFAULT_QUEUE_NAME), queueItem, priority);
    }
}

