/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workspace;

import com.mware.core.model.properties.WorkspaceSchema;
import com.mware.core.model.workspace.Workspace;
import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;

public class GeWorkspace
implements Workspace {
    private static final long serialVersionUID = -1692706831716776578L;
    private String displayTitle;
    private String workspaceId;
    private transient Vertex workspaceVertex;

    public GeWorkspace(Vertex workspaceVertex) {
        this.displayTitle = (String)WorkspaceSchema.TITLE.getPropertyValue(workspaceVertex);
        this.workspaceId = workspaceVertex.getId();
        this.workspaceVertex = workspaceVertex;
    }

    @Override
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @Override
    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public Vertex getVertex(Graph graph, boolean includeHidden, Authorizations authorizations) {
        if (this.workspaceVertex == null) {
            this.workspaceVertex = graph.getVertex(this.getWorkspaceId(), includeHidden ? FetchHints.ALL_INCLUDING_HIDDEN : FetchHints.ALL, authorizations);
        }
        return this.workspaceVertex;
    }

    public String toString() {
        return "GeWorkspace{workspaceId='" + this.workspaceId + '\'' + ", displayTitle='" + this.displayTitle + '\'' + '}';
    }
}

