/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workspace;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcAccessDeniedException;
import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.clientapi.dto.WorkspaceAccess;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.properties.WorkspaceSchema;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.termMention.TermMentionRepository;
import com.mware.core.model.user.GeUserRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.model.workspace.GeWorkspace;
import com.mware.core.model.workspace.Workspace;
import com.mware.core.model.workspace.WorkspaceEntity;
import com.mware.core.model.workspace.WorkspaceRepository;
import com.mware.core.model.workspace.WorkspaceUser;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.trace.Traced;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeInfo;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.SecurityGeException;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.search.IndexHint;
import com.mware.ge.util.FilterIterable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Singleton
public class GeWorkspaceRepository
extends WorkspaceRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GeWorkspaceRepository.class);
    private final UserRepository userRepository;
    private final GraphAuthorizationRepository graphAuthorizationRepository;
    private final LockRepository lockRepository;
    private Cache<String, Boolean> usersWithReadAccessCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private Cache<String, Boolean> usersWithCommentAccessCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private Cache<String, Boolean> usersWithWriteAccessCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private Cache<String, List<WorkspaceUser>> usersWithAccessCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();
    private Cache<String, Vertex> userWorkspaceVertexCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();

    @Override
    public void clearCache() {
        this.usersWithReadAccessCache.invalidateAll();
        this.usersWithCommentAccessCache.invalidateAll();
        this.usersWithWriteAccessCache.invalidateAll();
        this.usersWithAccessCache.invalidateAll();
        this.userWorkspaceVertexCache.invalidateAll();
    }

    @Inject
    public GeWorkspaceRepository(Graph graph, Configuration configuration, UserRepository userRepository, GraphAuthorizationRepository graphAuthorizationRepository, LockRepository lockRepository, VisibilityTranslator visibilityTranslator, TermMentionRepository termMentionRepository, SchemaRepository schemaRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, AuthorizationRepository authorizationRepository) {
        super(graph, configuration, visibilityTranslator, termMentionRepository, schemaRepository, workQueueRepository, webQueueRepository, authorizationRepository);
        this.userRepository = userRepository;
        this.graphAuthorizationRepository = graphAuthorizationRepository;
        this.lockRepository = lockRepository;
        graphAuthorizationRepository.addAuthorizationToGraph("workspace");
        graphAuthorizationRepository.addAuthorizationToGraph("administrator");
        this.userRepository.addDefaultAdminUser();
        this.userRepository.addDefaultSysUser();
    }

    @Override
    public void delete(Workspace workspace, User user) {
        if (!this.hasWritePermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have write access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        this.fireWorkspaceBeforeDelete(workspace, user);
        this.lockRepository.lock(this.getLockName(workspace), () -> {
            Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "user", "administrator", workspace.getWorkspaceId());
            Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, true, authorizations);
            Iterable<EdgeInfo> edgeInfos = workspaceVertex.getEdgeInfos(Direction.OUT, "__wsToEnt", authorizations);
            edgeInfos.forEach(edgeInfo -> this.getGraph().softDeleteEdge(edgeInfo.getEdgeId(), authorizations));
            List<String> connectedVertexIds = StreamUtil.stream(edgeInfos).map(edgeInfo -> edgeInfo.getVertexId()).collect(Collectors.toList());
            Iterable<Vertex> vertices = this.getGraph().getVertices(connectedVertexIds, authorizations);
            vertices.forEach(v -> {
                SandboxStatus sandboxStatus = SandboxStatus.getFromVisibilityString(v.getVisibility().getVisibilityString(), workspace.getWorkspaceId());
                if (sandboxStatus == SandboxStatus.PRIVATE) {
                    this.getGraph().softDeleteVertex((Vertex)v, authorizations);
                }
            });
            this.getGraph().softDeleteVertex(workspaceVertex, authorizations);
            List<WorkspaceUser> usersWithAccess = this.findUsersWithAccess(workspace.getWorkspaceId(), user);
            usersWithAccess.forEach(userWithAccess -> {
                if (workspace.getWorkspaceId().equals(this.userRepository.getCurrentWorkspaceId(userWithAccess.getUserId()))) {
                    this.userRepository.setCurrentWorkspace(userWithAccess.getUserId(), null);
                }
            });
            this.getGraph().flush();
            this.clearCache();
            this.graphAuthorizationRepository.removeAuthorizationFromGraph(workspace.getWorkspaceId());
        });
    }

    @Override
    public Vertex getVertex(String workspaceId, User user) {
        String cacheKey = this.getUserWorkspaceVertexCacheKey(workspaceId, user);
        Vertex workspaceVertex = (Vertex)this.userWorkspaceVertexCache.getIfPresent((Object)cacheKey);
        if (workspaceVertex != null) {
            return workspaceVertex;
        }
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "user", "administrator", workspaceId);
        workspaceVertex = this.getGraph().getVertex(workspaceId, FetchHints.ALL, authorizations);
        if (workspaceVertex != null) {
            this.userWorkspaceVertexCache.put((Object)cacheKey, (Object)workspaceVertex);
        }
        return workspaceVertex;
    }

    public String getUserWorkspaceVertexCacheKey(String workspaceId, User user) {
        return workspaceId + user.getUserId();
    }

    private Vertex getVertexFromWorkspace(Workspace workspace, boolean includeHidden, Authorizations authorizations) {
        if (workspace instanceof GeWorkspace) {
            return ((GeWorkspace)workspace).getVertex(this.getGraph(), includeHidden, authorizations);
        }
        return this.getGraph().getVertex(workspace.getWorkspaceId(), includeHidden ? FetchHints.ALL_INCLUDING_HIDDEN : FetchHints.ALL, authorizations);
    }

    @Override
    @Traced
    public Workspace findById(String workspaceId, boolean includeHidden, User user) {
        Vertex workspaceVertex;
        LOGGER.debug("findById(workspaceId: %s, userId: %s)", workspaceId, user.getUserId());
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", workspaceId);
        try {
            workspaceVertex = this.getGraph().getVertex(workspaceId, includeHidden ? FetchHints.ALL_INCLUDING_HIDDEN : FetchHints.ALL, authorizations);
        }
        catch (SecurityGeException e) {
            if (!this.graphAuthorizationRepository.getGraphAuthorizations().contains(workspaceId)) {
                return null;
            }
            String message = String.format("user %s does not have read access to workspace %s", user.getUserId(), workspaceId);
            LOGGER.warn("%s", message, e);
            throw new BcAccessDeniedException(message, user, workspaceId);
        }
        if (workspaceVertex == null) {
            return null;
        }
        if (!this.hasReadPermissions(workspaceId, user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have read access to workspace " + workspaceId, user, workspaceId);
        }
        return new GeWorkspace(workspaceVertex);
    }

    @Override
    public Workspace add(String workspaceId, String title, User user) {
        if (workspaceId == null) {
            workspaceId = "WORKSPACE_" + this.getGraph().getIdGenerator().nextId();
        }
        this.graphAuthorizationRepository.addAuthorizationToGraph(workspaceId);
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "user", "workspace", workspaceId);
        Vertex userVertex = null;
        if (!user.getUserId().equals(this.userRepository.getSystemUser().getUserId())) {
            userVertex = this.getGraph().getVertex(user.getUserId(), authorizations);
            Preconditions.checkNotNull((Object)userVertex, (Object)("Could not find user: " + user.getUserId()));
        }
        VertexBuilder workspaceVertexBuilder = this.getGraph().prepareVertex(workspaceId, VISIBILITY.getVisibility(), "__ws");
        WorkspaceSchema.TITLE.setProperty(workspaceVertexBuilder, title, VISIBILITY.getVisibility());
        Vertex workspaceVertex = workspaceVertexBuilder.save(authorizations);
        if (userVertex != null) {
            this.addWorkspaceToUser(workspaceVertex, userVertex, authorizations);
        }
        this.getGraph().flush();
        GeWorkspace workspace = new GeWorkspace(workspaceVertex);
        this.fireWorkspaceAdded(workspace, user);
        return workspace;
    }

    public void addWorkspaceToUser(Vertex workspaceVertex, Vertex userVertex, Authorizations authorizations) {
        EdgeBuilder edgeBuilder = this.getGraph().prepareEdge(workspaceVertex, userVertex, "__wsToUsr", VISIBILITY.getVisibility());
        WorkspaceSchema.WORKSPACE_TO_USER_IS_CREATOR.setProperty(edgeBuilder, true, VISIBILITY.getVisibility());
        WorkspaceSchema.WORKSPACE_TO_USER_ACCESS.setProperty(edgeBuilder, WorkspaceAccess.WRITE.toString(), VISIBILITY.getVisibility());
        edgeBuilder.save(authorizations);
    }

    @Override
    public Iterable<Workspace> findAllForUser(User user) {
        Preconditions.checkNotNull((Object)user, (Object)"User is required");
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", "user");
        Vertex userVertex = this.getGraph().getVertex(user.getUserId(), FetchHints.ALL, authorizations);
        Preconditions.checkNotNull((Object)userVertex, (Object)("Could not find user vertex with id " + user.getUserId()));
        return StreamUtil.stream(userVertex.getVertices(Direction.IN, "__wsToUsr", FetchHints.ALL, authorizations)).map(workspaceVertex -> {
            String cacheKey = this.getUserWorkspaceVertexCacheKey((String)workspaceVertex.getId(), user);
            this.userWorkspaceVertexCache.put((Object)cacheKey, workspaceVertex);
            return new GeWorkspace((Vertex)workspaceVertex);
        }).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Workspace> findAll(User user) {
        if (!user.equals(this.userRepository.getSystemUser())) {
            throw new BcAccessDeniedException("Only system user can access all workspaces", user, null);
        }
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", "user");
        try (QueryResultsIterable<Vertex> workspaceVertices = this.getGraph().query(authorizations).hasConceptType("__ws").vertices();){
            Iterable iterable = StreamUtil.stream(workspaceVertices).map(workspaceVertex -> {
                String cacheKey = this.getUserWorkspaceVertexCacheKey((String)workspaceVertex.getId(), user);
                this.userWorkspaceVertexCache.put((Object)cacheKey, workspaceVertex);
                return new GeWorkspace((Vertex)workspaceVertex);
            }).collect(Collectors.toList());
            return iterable;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    @Override
    public void setTitle(Workspace workspace, String title, User user) {
        if (!this.hasWritePermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have write access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, new String[0]);
        Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, false, authorizations);
        WorkspaceSchema.TITLE.setProperty(workspaceVertex, title, VISIBILITY.getVisibility(), authorizations);
        this.getGraph().flush();
    }

    @Override
    @Traced
    public List<WorkspaceUser> findUsersWithAccess(String workspaceId, User user) {
        String cacheKey = workspaceId + user.getUserId();
        List<WorkspaceUser> usersWithAccess = (List<WorkspaceUser>)this.usersWithAccessCache.getIfPresent((Object)cacheKey);
        if (usersWithAccess != null) {
            return usersWithAccess;
        }
        LOGGER.debug("BEGIN findUsersWithAccess query", new Object[0]);
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", workspaceId);
        Vertex workspaceVertex = this.getVertex(workspaceId, user);
        if (workspaceVertex == null) {
            return Lists.newArrayList();
        }
        Iterable<Edge> userEdges = workspaceVertex.getEdges(Direction.OUT, "__wsToUsr", authorizations);
        usersWithAccess = StreamUtil.stream(userEdges).map(edge -> {
            String userId = edge.getOtherVertexId(workspaceId);
            String accessString = (String)WorkspaceSchema.WORKSPACE_TO_USER_ACCESS.getPropertyValue((Element)edge);
            WorkspaceAccess workspaceAccess = WorkspaceAccess.NONE;
            if (accessString != null && accessString.length() > 0) {
                workspaceAccess = WorkspaceAccess.valueOf(accessString);
            }
            boolean isCreator = WorkspaceSchema.WORKSPACE_TO_USER_IS_CREATOR.getPropertyValue((Element)edge, false);
            return new WorkspaceUser(userId, workspaceAccess, isCreator);
        }).collect(Collectors.toList());
        this.usersWithAccessCache.put((Object)cacheKey, usersWithAccess);
        LOGGER.debug("END findUsersWithAccess query", new Object[0]);
        return usersWithAccess;
    }

    @Override
    public List<WorkspaceEntity> findEntities(Workspace workspace, boolean fetchVertices, User user, boolean lock, boolean hidden) {
        if (!this.hasReadPermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have read access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        if (lock) {
            return this.lockRepository.lock(this.getLockName(workspace), () -> this.findEntitiesNoLock(workspace, hidden, fetchVertices, user));
        }
        return this.findEntitiesNoLock(workspace, hidden, fetchVertices, user);
    }

    @Traced
    public List<WorkspaceEntity> findEntitiesNoLock(Workspace workspace, boolean includeHidden, boolean fetchVertices, User user) {
        LOGGER.debug("BEGIN findEntitiesNoLock(workspaceId: %s, includeHidden: %b, userId: %s)", workspace.getWorkspaceId(), includeHidden, user.getUserId());
        long startTime = System.currentTimeMillis();
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", workspace.getWorkspaceId());
        Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, includeHidden, authorizations);
        List<Edge> entityEdges = StreamUtil.stream(workspaceVertex.getEdges(Direction.BOTH, "__wsToEnt", includeHidden ? FetchHints.ALL_INCLUDING_HIDDEN : FetchHints.ALL, authorizations)).collect(Collectors.toList());
        Map<String, Vertex> workspaceVertices = fetchVertices ? this.getWorkspaceVertices(workspace, entityEdges, authorizations) : null;
        List<WorkspaceEntity> results = entityEdges.stream().map(edge -> {
            String entityVertexId = edge.getOtherVertexId(workspace.getWorkspaceId());
            if (!includeHidden) {
                return null;
            }
            Vertex workspaceVertex1 = null;
            if (fetchVertices) {
                workspaceVertex1 = (Vertex)workspaceVertices.get(entityVertexId);
            }
            return new WorkspaceEntity(entityVertexId, workspaceVertex1);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        LOGGER.debug("END findEntitiesNoLock (found: %d entities, time: %dms)", results.size(), System.currentTimeMillis() - startTime);
        return results;
    }

    protected Map<String, Vertex> getWorkspaceVertices(Workspace workspace, List<Edge> entityEdges, Authorizations authorizations) {
        Iterable workspaceVertexIds = entityEdges.stream().map(edge -> edge.getOtherVertexId(workspace.getWorkspaceId())).collect(Collectors.toList());
        Iterable<Vertex> vertices = this.getGraph().getVertices(workspaceVertexIds, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        ImmutableMap workspaceVertices = Maps.uniqueIndex(vertices, (Function)new Function<Vertex, String>(){

            public String apply(Vertex v) {
                return v.getId();
            }
        });
        return workspaceVertices;
    }

    @Override
    public Workspace copyTo(Workspace workspace, User destinationUser, User user) {
        Workspace newWorkspace = super.copyTo(workspace, destinationUser, user);
        this.getGraph().flush();
        return newWorkspace;
    }

    @Override
    public void softDeleteEntitiesFromWorkspace(Workspace workspace, List<String> entityIdsToDelete, User user) {
        if (entityIdsToDelete.size() == 0) {
            return;
        }
        if (!this.hasWritePermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have write access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", workspace.getWorkspaceId());
        final Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, true, authorizations);
        List allEdges = StreamUtil.stream(workspaceVertex.getEdges(Direction.BOTH, authorizations)).collect(Collectors.toList());
        for (final String vertexId : entityIdsToDelete) {
            LOGGER.debug("workspace delete (%s): %s", workspace.getWorkspaceId(), vertexId);
            FilterIterable<Edge> edges = new FilterIterable<Edge>(allEdges){

                @Override
                protected boolean isIncluded(Edge o) {
                    String entityVertexId = o.getOtherVertexId((String)workspaceVertex.getId());
                    return entityVertexId.equalsIgnoreCase(vertexId);
                }
            };
            for (Edge edge : edges) {
                ExistingEdgeMutation m = edge.prepareMutation();
                m.setIndexHint(IndexHint.DO_NOT_INDEX);
                m.save(authorizations);
            }
        }
        this.getGraph().flush();
    }

    @Override
    public void updateEntitiesOnWorkspace(Workspace workspace, Collection<String> vertexIds, User user) {
        if (vertexIds.size() == 0) {
            return;
        }
        if (!this.hasCommentPermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have comment access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        this.lockRepository.lock(this.getLockName(workspace.getWorkspaceId()), () -> {
            Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", "workspace_product", workspace.getWorkspaceId());
            Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, true, authorizations);
            if (workspaceVertex == null) {
                throw new BcResourceNotFoundException("Could not find workspace vertex: " + workspace.getWorkspaceId(), workspace.getWorkspaceId());
            }
            Iterable<Vertex> vertices = this.getGraph().getVertices(vertexIds, authorizations);
            ImmutableMap verticesMap = Maps.uniqueIndex(vertices, ElementId::getId);
            for (String vertexId : vertexIds) {
                Vertex otherVertex = (Vertex)verticesMap.get((Object)vertexId);
                if (otherVertex == null) {
                    LOGGER.error("updateEntitiesOnWorkspace: could not find vertex with id \"%s\" for workspace \"%s\"", vertexId, workspace.getWorkspaceId());
                    continue;
                }
                this.createEdge(workspaceVertex, otherVertex, authorizations);
            }
            this.getGraph().flush();
        });
        this.fireWorkspaceUpdateEntities(workspace, vertexIds, user);
    }

    private void createEdge(Vertex workspaceVertex, Vertex otherVertex, Authorizations authorizations) {
        Object workspaceVertexId = workspaceVertex.getId();
        Object entityVertexId = otherVertex.getId();
        String edgeId = GeWorkspaceRepository.getWorkspaceToEntityEdgeId((String)workspaceVertexId, (String)entityVertexId);
        EdgeBuilder edgeBuilder = this.getGraph().prepareEdge(edgeId, workspaceVertex, otherVertex, "__wsToEnt", VISIBILITY.orVisibility((String)workspaceVertexId));
        edgeBuilder.setIndexHint(IndexHint.DO_NOT_INDEX);
        edgeBuilder.save(authorizations);
    }

    @Override
    public void deleteUserFromWorkspace(Workspace workspace, String userId, User user) {
        if (!this.hasWritePermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have write access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        this.lockRepository.lock(this.getLockName(workspace), () -> {
            Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "user", "workspace", workspace.getWorkspaceId());
            Vertex userVertex = this.getGraph().getVertex(userId, authorizations);
            if (userVertex == null) {
                throw new BcResourceNotFoundException("Could not find user: " + userId, userId);
            }
            Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, true, authorizations);
            List edges = StreamUtil.stream(workspaceVertex.getEdges(userVertex, Direction.BOTH, "__wsToUsr", authorizations)).collect(Collectors.toList());
            for (Edge edge : edges) {
                this.getGraph().softDeleteEdge(edge, authorizations);
            }
            this.getGraph().flush();
            this.clearCache();
        });
        this.fireWorkspaceDeleteUser(workspace, userId, user);
    }

    @Override
    public boolean hasCommentPermissions(String workspaceId, User user) {
        if (user instanceof SystemUser) {
            return true;
        }
        String cacheKey = workspaceId + user.getUserId();
        Boolean hasCommentAccess = (Boolean)this.usersWithCommentAccessCache.getIfPresent((Object)cacheKey);
        if (hasCommentAccess != null && hasCommentAccess.booleanValue()) {
            return true;
        }
        List<WorkspaceUser> usersWithAccess = this.findUsersWithAccess(workspaceId, user);
        for (WorkspaceUser userWithAccess : usersWithAccess) {
            if (!userWithAccess.getUserId().equals(user.getUserId()) || !WorkspaceAccess.hasCommentPermissions(userWithAccess.getWorkspaceAccess())) continue;
            this.usersWithCommentAccessCache.put((Object)cacheKey, (Object)true);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWritePermissions(String workspaceId, User user) {
        if (user instanceof SystemUser) {
            return true;
        }
        String cacheKey = workspaceId + user.getUserId();
        Boolean hasWriteAccess = (Boolean)this.usersWithWriteAccessCache.getIfPresent((Object)cacheKey);
        if (hasWriteAccess != null && hasWriteAccess.booleanValue()) {
            return true;
        }
        List<WorkspaceUser> usersWithAccess = this.findUsersWithAccess(workspaceId, user);
        for (WorkspaceUser userWithAccess : usersWithAccess) {
            if (!userWithAccess.getUserId().equals(user.getUserId()) || !WorkspaceAccess.hasWritePermissions(userWithAccess.getWorkspaceAccess())) continue;
            this.usersWithWriteAccessCache.put((Object)cacheKey, (Object)true);
            return true;
        }
        return false;
    }

    @Override
    @Traced
    public boolean hasReadPermissions(String workspaceId, User user) {
        if (user == null || workspaceId == null) {
            return false;
        }
        if (user instanceof SystemUser) {
            return true;
        }
        String cacheKey = workspaceId + user.getUserId();
        Boolean hasReadAccess = (Boolean)this.usersWithReadAccessCache.getIfPresent((Object)cacheKey);
        if (hasReadAccess != null && hasReadAccess.booleanValue()) {
            return true;
        }
        List<WorkspaceUser> usersWithAccess = this.findUsersWithAccess(workspaceId, user);
        for (WorkspaceUser userWithAccess : usersWithAccess) {
            if (!userWithAccess.getUserId().equals(user.getUserId()) || !WorkspaceAccess.hasReadPermissions(userWithAccess.getWorkspaceAccess())) continue;
            return true;
        }
        return false;
    }

    @Override
    public WorkspaceRepository.UpdateUserOnWorkspaceResult updateUserOnWorkspace(Workspace workspace, String userId, WorkspaceAccess workspaceAccess, User user) {
        if (!this.hasWritePermissions(workspace.getWorkspaceId(), user)) {
            throw new BcAccessDeniedException("user " + user.getUserId() + " does not have write access to workspace " + workspace.getWorkspaceId(), user, workspace.getWorkspaceId());
        }
        return this.lockRepository.lock(this.getLockName(workspace), () -> {
            WorkspaceRepository.UpdateUserOnWorkspaceResult result;
            Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, "workspace", workspace.getWorkspaceId());
            Vertex otherUserVertex = this.userRepository instanceof GeUserRepository ? ((GeUserRepository)this.userRepository).findByIdUserVertex(userId) : this.getGraph().getVertex(userId, authorizations);
            if (otherUserVertex == null) {
                throw new BcResourceNotFoundException("Could not find user: " + userId, userId);
            }
            Vertex workspaceVertex = this.getVertexFromWorkspace(workspace, true, authorizations);
            if (workspaceVertex == null) {
                throw new BcResourceNotFoundException("Could not find workspace vertex: " + workspace.getWorkspaceId(), workspace.getWorkspaceId());
            }
            List existingEdges = StreamUtil.stream(workspaceVertex.getEdges(otherUserVertex, Direction.OUT, "__wsToUsr", authorizations)).collect(Collectors.toList());
            if (existingEdges.size() > 0) {
                for (Edge existingEdge : existingEdges) {
                    WorkspaceSchema.WORKSPACE_TO_USER_ACCESS.setProperty(existingEdge, workspaceAccess.toString(), VISIBILITY.getVisibility(), authorizations);
                }
                result = WorkspaceRepository.UpdateUserOnWorkspaceResult.UPDATE;
            } else {
                EdgeBuilder edgeBuilder = this.getGraph().prepareEdge(workspaceVertex, otherUserVertex, "__wsToUsr", VISIBILITY.getVisibility());
                WorkspaceSchema.WORKSPACE_TO_USER_ACCESS.setProperty(edgeBuilder, workspaceAccess.toString(), VISIBILITY.getVisibility());
                edgeBuilder.save(authorizations);
                result = WorkspaceRepository.UpdateUserOnWorkspaceResult.ADD;
            }
            this.getGraph().flush();
            this.clearCache();
            this.fireWorkspaceUpdateUser(workspace, userId, workspaceAccess, user);
            return result;
        });
    }
}

