/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workspace;

import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.ElementId;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WorkspaceEntity
implements Serializable {
    static long serialVersionUID = 1L;
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(WorkspaceEntity.class);
    private final String entityVertexId;
    private transient Vertex vertex;

    public WorkspaceEntity(String entityVertexId, Vertex vertex) {
        this.entityVertexId = entityVertexId;
        this.vertex = vertex;
    }

    public String getEntityVertexId() {
        return this.entityVertexId;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public static Iterable<Vertex> toVertices(Iterable<WorkspaceEntity> workspaceEntities, Graph graph, Authorizations authorizations) {
        List<String> vertexIdsToFetch = StreamUtil.stream(workspaceEntities).filter(we -> we.getVertex() == null).map(WorkspaceEntity::getEntityVertexId).collect(Collectors.toList());
        Map<String, Vertex> fetchedVerticesMap = StreamUtil.stream(graph.getVertices(vertexIdsToFetch, authorizations)).distinct().collect(Collectors.toMap(ElementId::getId, v -> v));
        return StreamUtil.stream(workspaceEntities).map(workspaceEntity -> {
            Vertex vertex;
            if (workspaceEntity.getVertex() == null && (vertex = (Vertex)fetchedVerticesMap.get(workspaceEntity.getEntityVertexId())) == null) {
                LOGGER.trace("Could not find vertex for WorkspaceEntity: %s", workspaceEntity);
                return null;
            }
            return workspaceEntity.getVertex();
        }).collect(Collectors.toList());
    }

    public String toString() {
        return "WorkspaceEntity{entityVertexId='" + this.entityVertexId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceEntity that = (WorkspaceEntity)o;
        return this.entityVertexId.equals(that.entityVertexId);
    }

    public int hashCode() {
        return this.entityVertexId.hashCode();
    }
}

