/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.workspace;

import com.google.common.base.Preconditions;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcAccessDeniedException;
import com.mware.core.model.clientapi.dto.ClientApiWorkspace;
import com.mware.core.model.clientapi.dto.WorkspaceAccess;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.termMention.TermMentionRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.model.workspace.Workspace;
import com.mware.core.model.workspace.WorkspaceEntity;
import com.mware.core.model.workspace.WorkspaceListener;
import com.mware.core.model.workspace.WorkspaceUser;
import com.mware.core.security.BcVisibility;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class WorkspaceRepository {
    public static final String TO_ENTITY_ID_SEPARATOR = "_TO_ENTITY_";
    public static final String VISIBILITY_STRING = "workspace";
    public static final String VISIBILITY_PRODUCT_STRING = "workspace_product";
    public static final BcVisibility VISIBILITY = new BcVisibility("workspace");
    public static final String WORKSPACE_CONCEPT_NAME = "__ws";
    public static final String WORKSPACE_TO_ENTITY_RELATIONSHIP_NAME = "__wsToEnt";
    public static final String WORKSPACE_TO_USER_RELATIONSHIP_NAME = "__wsToUsr";
    public static final String WORKSPACE_ID_PREFIX = "WORKSPACE_";
    private final Graph graph;
    private final Configuration configuration;
    private final VisibilityTranslator visibilityTranslator;
    private final TermMentionRepository termMentionRepository;
    private final SchemaRepository schemaRepository;
    private final WorkQueueRepository workQueueRepository;
    private final WebQueueRepository webQueueRepository;
    private final AuthorizationRepository authorizationRepository;
    private Collection<WorkspaceListener> workspaceListeners;

    protected WorkspaceRepository(Graph graph, Configuration configuration, VisibilityTranslator visibilityTranslator, TermMentionRepository termMentionRepository, SchemaRepository schemaRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        this.configuration = configuration;
        this.visibilityTranslator = visibilityTranslator;
        this.termMentionRepository = termMentionRepository;
        this.schemaRepository = schemaRepository;
        this.workQueueRepository = workQueueRepository;
        this.webQueueRepository = webQueueRepository;
        this.authorizationRepository = authorizationRepository;
    }

    public static String getWorkspaceToEntityEdgeId(String workspaceVertexId, String entityVertexId) {
        return workspaceVertexId + TO_ENTITY_ID_SEPARATOR + entityVertexId;
    }

    public abstract void delete(Workspace var1, User var2);

    public Workspace findById(String workspaceId, User user) {
        return this.findById(workspaceId, false, user);
    }

    public abstract Workspace findById(String var1, boolean var2, User var3);

    public Iterable<Workspace> findByIds(Iterable<String> workspaceIds, final User user) {
        return new ConvertingIterable<String, Workspace>(workspaceIds){

            @Override
            protected Workspace convert(String workspaceId) {
                if (workspaceId == null) {
                    return null;
                }
                try {
                    return WorkspaceRepository.this.findById(workspaceId, user);
                }
                catch (BcAccessDeniedException ex) {
                    return null;
                }
            }
        };
    }

    public abstract Vertex getVertex(String var1, User var2);

    public String getDefaultWorkspaceName(User user) {
        return String.format("Default \u2013 %s", user.getDisplayName());
    }

    public abstract Workspace add(String var1, String var2, User var3);

    public Workspace add(User user) {
        return this.add(null, user);
    }

    public Workspace add(String title, User user) {
        if (title == null) {
            title = this.getDefaultWorkspaceName(user);
        }
        return this.add(null, title, user);
    }

    public void clearCache() {
    }

    public abstract Iterable<Workspace> findAllForUser(User var1);

    public abstract Iterable<Workspace> findAll(User var1);

    public abstract void setTitle(Workspace var1, String var2, User var3);

    public abstract List<WorkspaceUser> findUsersWithAccess(String var1, User var2);

    public List<WorkspaceEntity> findEntities(Workspace workspace, User user) {
        return this.findEntities(workspace, false, user);
    }

    public List<WorkspaceEntity> findEntities(Workspace workspace, boolean fetchVertices, User user) {
        return this.findEntities(workspace, fetchVertices, user, true, false);
    }

    public abstract List<WorkspaceEntity> findEntities(Workspace var1, boolean var2, User var3, boolean var4, boolean var5);

    public Workspace copy(Workspace workspace, User user) {
        return this.copyTo(workspace, user, user);
    }

    public Workspace copyTo(Workspace workspace, User destinationUser, User user) {
        return this.add("Copy of " + workspace.getDisplayTitle(), destinationUser);
    }

    public abstract void softDeleteEntitiesFromWorkspace(Workspace var1, List<String> var2, User var3);

    public abstract void deleteUserFromWorkspace(Workspace var1, String var2, User var3);

    public abstract UpdateUserOnWorkspaceResult updateUserOnWorkspace(Workspace var1, String var2, WorkspaceAccess var3, User var4);

    public String getCreatorUserId(String workspaceId, User user) {
        for (WorkspaceUser workspaceUser : this.findUsersWithAccess(workspaceId, user)) {
            if (!workspaceUser.isCreator()) continue;
            return workspaceUser.getUserId();
        }
        return null;
    }

    public String getLockName(Workspace workspace) {
        return this.getLockName(workspace.getWorkspaceId());
    }

    public String getLockName(String workspaceId) {
        return WORKSPACE_ID_PREFIX + workspaceId;
    }

    public abstract boolean hasCommentPermissions(String var1, User var2);

    public abstract boolean hasWritePermissions(String var1, User var2);

    public abstract boolean hasReadPermissions(String var1, User var2);

    public JSONArray toJson(Iterable<Workspace> workspaces, User user) {
        JSONArray resultJson = new JSONArray();
        for (Workspace workspace : workspaces) {
            resultJson.put((Object)this.toJson(workspace, user));
        }
        return resultJson;
    }

    public JSONObject toJson(Workspace workspace, User user) {
        Preconditions.checkNotNull((Object)workspace, (Object)"workspace cannot be null");
        Preconditions.checkNotNull((Object)user, (Object)"user cannot be null");
        try {
            JSONObject workspaceJson = new JSONObject();
            workspaceJson.put("workspaceId", (Object)workspace.getWorkspaceId());
            workspaceJson.put("title", (Object)workspace.getDisplayTitle());
            String creatorUserId = this.getCreatorUserId(workspace.getWorkspaceId(), user);
            if (creatorUserId != null) {
                workspaceJson.put("createdBy", (Object)creatorUserId);
                workspaceJson.put("sharedToUser", !creatorUserId.equals(user.getUserId()));
            }
            workspaceJson.put("editable", this.hasWritePermissions(workspace.getWorkspaceId(), user));
            JSONArray usersJson = new JSONArray();
            for (WorkspaceUser workspaceUser : this.findUsersWithAccess(workspace.getWorkspaceId(), user)) {
                String userId = workspaceUser.getUserId();
                JSONObject userJson = new JSONObject();
                userJson.put("userId", (Object)userId);
                userJson.put("access", (Object)workspaceUser.getWorkspaceAccess().toString().toLowerCase());
                usersJson.put((Object)userJson);
            }
            workspaceJson.put("users", (Object)usersJson);
            return workspaceJson;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientApiWorkspace toClientApi(Workspace workspace, User user, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)workspace, (Object)"workspace cannot be null");
        Preconditions.checkNotNull((Object)user, (Object)"user cannot be null");
        try {
            ClientApiWorkspace workspaceClientApi = new ClientApiWorkspace();
            workspaceClientApi.setWorkspaceId(workspace.getWorkspaceId());
            workspaceClientApi.setTitle(workspace.getDisplayTitle());
            String creatorUserId = this.getCreatorUserId(workspace.getWorkspaceId(), user);
            if (creatorUserId == null) {
                workspaceClientApi.setSharedToUser(true);
            } else {
                workspaceClientApi.setCreatedBy(creatorUserId);
                workspaceClientApi.setSharedToUser(!creatorUserId.equals(user.getUserId()));
            }
            workspaceClientApi.setEditable(this.hasWritePermissions(workspace.getWorkspaceId(), user));
            workspaceClientApi.setCommentable(this.hasCommentPermissions(workspace.getWorkspaceId(), user));
            for (WorkspaceUser u : this.findUsersWithAccess(workspace.getWorkspaceId(), user)) {
                String userId = u.getUserId();
                ClientApiWorkspace.User workspaceUser = new ClientApiWorkspace.User();
                workspaceUser.setUserId(userId);
                workspaceUser.setAccess(u.getWorkspaceAccess());
                workspaceClientApi.addUser(workspaceUser);
            }
            return workspaceClientApi;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected Graph getGraph() {
        return this.graph;
    }

    public abstract void updateEntitiesOnWorkspace(Workspace var1, Collection<String> var2, User var3);

    public void updateEntityOnWorkspace(Workspace workspace, String vertexId, User user) {
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add(vertexId);
        this.updateEntitiesOnWorkspace(workspace, vertexIds, user);
    }

    public void updateEntityOnWorkspace(String workspaceId, String vertexId, User user) {
        Workspace workspace = this.findById(workspaceId, user);
        this.updateEntityOnWorkspace(workspace, vertexId, user);
    }

    @Deprecated
    public List<String> findEntityVertexIds(Workspace workspace, User user) {
        List<WorkspaceEntity> workspaceEntities = this.findEntities(workspace, user);
        return IterableUtils.toList(new ConvertingIterable<WorkspaceEntity, String>(workspaceEntities){

            @Override
            protected String convert(WorkspaceEntity workspaceEntity) {
                return workspaceEntity.getEntityVertexId();
            }
        });
    }

    protected VisibilityTranslator getVisibilityTranslator() {
        return this.visibilityTranslator;
    }

    protected TermMentionRepository getTermMentionRepository() {
        return this.termMentionRepository;
    }

    protected SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    protected WorkQueueRepository getWorkQueueRepository() {
        return this.workQueueRepository;
    }

    public WebQueueRepository getWebQueueRepository() {
        return this.webQueueRepository;
    }

    protected void fireWorkspaceBeforeDelete(Workspace workspace, User user) {
        for (WorkspaceListener workspaceListener : this.getWorkspaceListeners()) {
            workspaceListener.workspaceBeforeDelete(workspace, user);
        }
    }

    protected void fireWorkspaceUpdateEntities(Workspace workspace, Collection<String> vertexIds, User user) {
        for (WorkspaceListener workspaceListener : this.getWorkspaceListeners()) {
            workspaceListener.workspaceUpdateEntities(workspace, vertexIds, user);
        }
    }

    protected void fireWorkspaceUpdateUser(Workspace workspace, String userId, WorkspaceAccess workspaceAccess, User user) {
        for (WorkspaceListener workspaceListener : this.getWorkspaceListeners()) {
            workspaceListener.workspaceUpdateUser(workspace, userId, workspaceAccess, user);
        }
    }

    protected void fireWorkspaceAdded(Workspace workspace, User user) {
        for (WorkspaceListener workspaceListener : this.getWorkspaceListeners()) {
            workspaceListener.workspaceAdded(workspace, user);
        }
    }

    protected void fireWorkspaceDeleteUser(Workspace workspace, String userId, User user) {
        for (WorkspaceListener workspaceListener : this.getWorkspaceListeners()) {
            workspaceListener.workspaceDeleteUser(workspace, userId, user);
        }
    }

    public Collection<WorkspaceListener> getWorkspaceListeners() {
        if (this.workspaceListeners == null) {
            this.workspaceListeners = InjectHelper.getInjectedServices(WorkspaceListener.class, this.configuration);
        }
        return this.workspaceListeners;
    }

    protected AuthorizationRepository getAuthorizationRepository() {
        return this.authorizationRepository;
    }

    public static enum UpdateUserOnWorkspaceResult {
        ADD,
        UPDATE;

    }
}

