/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm;

import com.mware.core.orm.ModelMetadataBuilder;
import com.mware.core.orm.SimpleOrmException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class ModelMetadata<T> {
    public static final String DEFAULT_DISCRIMINATOR = "";
    private final Class entityRowClass;
    private final String discriminatorColumnFamily;
    private final String discriminatorColumnName;
    private final String tableName;
    private final IdField idField;
    private final Map<String, Type> types;
    private static final Map<Class, ModelMetadata> rowClassMetadata = new HashMap<Class, ModelMetadata>();

    public ModelMetadata(Class entityRowClass, IdField idField, Map<String, Type> types, String discriminatorColumnFamily, String discriminatorColumnName, String tableName) {
        this.entityRowClass = entityRowClass;
        this.idField = idField;
        this.types = types;
        this.discriminatorColumnFamily = discriminatorColumnFamily;
        this.discriminatorColumnName = discriminatorColumnName;
        this.tableName = tableName;
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public String getDiscriminatorColumnFamily() {
        return this.discriminatorColumnFamily;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class getEntityRowClass() {
        return this.entityRowClass;
    }

    public Collection<Type> getTypes() {
        return this.types.values();
    }

    public Set<Field> getFields() {
        HashSet<Field> fields = new HashSet<Field>();
        for (Type t : this.getTypes()) {
            for (Field field : t.getAllFields()) {
                fields.add(field);
            }
        }
        return fields;
    }

    public Type getType(String discriminatorValue) {
        if (discriminatorValue == null) {
            discriminatorValue = DEFAULT_DISCRIMINATOR;
        }
        return this.types.get(discriminatorValue);
    }

    public static <T> ModelMetadata<T> getModelMetadata(Class<T> rowClass) {
        ModelMetadata metadata = rowClassMetadata.get(rowClass);
        if (metadata == null) {
            for (Class<T> c = rowClass.getSuperclass(); c != null && metadata == null; c = c.getSuperclass()) {
                metadata = rowClassMetadata.get(c);
            }
        }
        if (metadata != null) {
            return metadata;
        }
        metadata = ModelMetadataBuilder.build(rowClass);
        rowClassMetadata.put(metadata.getEntityRowClass(), metadata);
        return metadata;
    }

    public static <T> ModelMetadata<T> getModelMetadata(T obj) {
        return ModelMetadata.getModelMetadata(obj.getClass());
    }

    public Type getTypeFromObject(T obj) {
        for (Type t : this.types.values()) {
            if (!t.getRowClass().equals(obj.getClass())) continue;
            return t;
        }
        return null;
    }

    public void setIdField(Object obj, String rowKey) {
        if (this.idField == null) {
            return;
        }
        this.idField.set(obj, rowKey);
    }

    public String getId(Object obj) {
        if (this.idField == null) {
            return null;
        }
        return this.idField.getString(obj);
    }

    public static class ByteArrayField
    extends Field<byte[]> {
        public ByteArrayField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected byte[] valueToJava(byte[] value) {
            return value;
        }

        @Override
        protected byte[] javaToByteArray(byte[] value) {
            return value;
        }
    }

    public static class BooleanField
    extends Field<Boolean> {
        public BooleanField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected Boolean valueToJava(byte[] value) {
            return value[0] != 0;
        }

        @Override
        protected byte[] javaToByteArray(Boolean value) {
            byte b = (byte)(value != false ? 1 : 0);
            return new byte[]{b};
        }
    }

    public static class LongField
    extends Field<Long> {
        public LongField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected Long valueToJava(byte[] value) {
            return ByteBuffer.wrap(value).getLong();
        }

        @Override
        protected byte[] javaToByteArray(Long value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(value);
            return buffer.array();
        }
    }

    public static class IntegerField
    extends Field<Integer> {
        public IntegerField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected Integer valueToJava(byte[] value) {
            return ByteBuffer.wrap(value).getInt();
        }

        @Override
        protected byte[] javaToByteArray(Integer value) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(value);
            return buffer.array();
        }
    }

    public static class JSONObjectField
    extends Field<JSONObject> {
        public JSONObjectField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected JSONObject valueToJava(byte[] value) {
            return new JSONObject(new String(value));
        }

        @Override
        protected byte[] javaToByteArray(JSONObject value) {
            return value.toString().getBytes();
        }
    }

    public static class ObjectField<T>
    extends Field<T> {
        public ObjectField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected T valueToJava(byte[] value) {
            try {
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(value));
                return (T)in.readObject();
            }
            catch (Exception e) {
                throw new SimpleOrmException("Could not read map", e);
            }
        }

        @Override
        protected byte[] javaToByteArray(T value) {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(buffer);
                out.writeObject(value);
                out.close();
                return buffer.toByteArray();
            }
            catch (IOException e) {
                throw new SimpleOrmException("Could not write map", e);
            }
        }
    }

    public static class DateField
    extends Field<Date> {
        public DateField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected Date valueToJava(byte[] value) {
            long time = ByteBuffer.wrap(value).getLong();
            return new Date(time);
        }

        @Override
        protected byte[] javaToByteArray(Date value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(value.getTime());
            return buffer.array();
        }
    }

    public static class EnumField
    extends Field<Enum> {
        public EnumField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected Enum valueToJava(byte[] value) {
            String str = new String(value);
            Class<?> fieldType = this.getField().getType();
            return Enum.valueOf(fieldType, str);
        }

        @Override
        protected byte[] javaToByteArray(Enum value) {
            return value.name().getBytes();
        }
    }

    public static class IdField
    extends StringField {
        public IdField(java.lang.reflect.Field field) {
            super(field, null, null);
        }

        public void set(Object o, String value) {
            try {
                this.getField().set(o, value);
            }
            catch (IllegalAccessException e) {
                throw new SimpleOrmException("Could not set field: " + this.getField().getName() + " on class " + o.getClass().getName());
            }
        }

        public String getString(Object obj) {
            return (String)this.getRaw(obj);
        }
    }

    public static class StringField
    extends Field<String> {
        public StringField(java.lang.reflect.Field field, String columnFamily, String columnName) {
            super(field, columnFamily, columnName);
        }

        @Override
        protected String valueToJava(byte[] value) {
            return new String(value);
        }

        @Override
        protected byte[] javaToByteArray(String value) {
            return value.getBytes();
        }
    }

    public static abstract class Field<T> {
        private final java.lang.reflect.Field field;
        private final String columnFamily;
        private final String columnName;

        public Field(java.lang.reflect.Field field, String columnFamily, String columnName) {
            this.field = field;
            this.columnFamily = columnFamily;
            this.columnName = columnName;
            this.field.setAccessible(true);
        }

        public String getColumnFamily() {
            return this.columnFamily;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void set(Object o, byte[] value) {
            try {
                this.getField().set(o, value == null ? null : this.valueToJava(value));
            }
            catch (IllegalAccessException e) {
                throw new SimpleOrmException("Could not set field: " + this.getField().getName() + " on class " + o.getClass().getName());
            }
        }

        public T getRaw(Object obj) {
            try {
                return (T)this.getField().get(obj);
            }
            catch (IllegalAccessException e) {
                throw new SimpleOrmException("Could not get field value: " + this.getField().getName() + " on class " + obj.getClass().getName());
            }
        }

        protected java.lang.reflect.Field getField() {
            return this.field;
        }

        protected abstract T valueToJava(byte[] var1);

        public final byte[] get(Object obj) {
            T rawValue = this.getRaw(obj);
            if (rawValue == null) {
                return null;
            }
            return this.javaToByteArray(rawValue);
        }

        protected abstract byte[] javaToByteArray(T var1);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field other = (Field)o;
            if (this.columnFamily != null ? !this.columnFamily.equals(other.columnFamily) : other.columnFamily != null) {
                return false;
            }
            return !(this.columnName != null ? !this.columnName.equals(other.columnName) : other.columnName != null);
        }

        public int hashCode() {
            return (this.getColumnFamily() != null ? this.getColumnFamily().hashCode() : 0) ^ (this.getColumnName() != null ? this.getColumnName().hashCode() : 0);
        }

        public void setRaw(Object obj, T value) {
            try {
                this.getField().set(obj, value);
            }
            catch (IllegalAccessException e) {
                throw new SimpleOrmException("Could not set field: " + this.getField().getName(), e);
            }
        }
    }

    public static class Type {
        private final Class rowClass;
        private final Constructor constructor;
        private final Map<String, Map<String, Field>> fields;

        public Type(Class rowClass, Constructor constructor, Map<String, Map<String, Field>> fields) {
            this.rowClass = rowClass;
            this.constructor = constructor;
            this.constructor.setAccessible(true);
            this.fields = fields;
        }

        public Class getRowClass() {
            return this.rowClass;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }

        public Map<String, Map<String, Field>> getFields() {
            return this.fields;
        }

        public <T> T newInstance() {
            try {
                return this.getConstructor().newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SimpleOrmException("Could not create class: " + this.getRowClass().getName());
            }
        }

        public Field getFieldForColumn(String columnFamily, String columnName) {
            Map<String, Field> columnFamilyFields = this.fields.get(columnFamily);
            if (columnFamilyFields == null) {
                return null;
            }
            return columnFamilyFields.get(columnName);
        }

        public Collection<Field> getAllFields() {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Map<String, Field> fieldsForColumnFamily : this.getFields().values()) {
                for (Field field : fieldsForColumnFamily.values()) {
                    fields.add(field);
                }
            }
            return fields;
        }
    }
}

