/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm;

import com.google.common.base.Preconditions;
import com.mware.core.orm.Entity;
import com.mware.core.orm.EntitySubTypes;
import com.mware.core.orm.Field;
import com.mware.core.orm.Id;
import com.mware.core.orm.ModelMetadata;
import com.mware.core.orm.SimpleOrmException;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ModelMetadataBuilder {
    public static <T> ModelMetadata<T> build(Class<T> rowClass) {
        Class entityRowClass;
        String discriminatorColumnName;
        String discriminatorColumnFamily;
        HashMap<String, ModelMetadata.Type> types = new HashMap<String, ModelMetadata.Type>();
        AnnotationAndClass<EntitySubTypes> subTypes = ModelMetadataBuilder.findAnnotation(rowClass, EntitySubTypes.class);
        if (subTypes == null) {
            discriminatorColumnFamily = null;
            discriminatorColumnName = null;
            entityRowClass = rowClass;
            ModelMetadata.Type t = new ModelMetadata.Type(rowClass, ModelMetadataBuilder.getConstructor(rowClass), ModelMetadataBuilder.getFields(rowClass));
            types.put("", t);
        } else {
            discriminatorColumnFamily = subTypes.getAnnotation().discriminatorColumnFamily();
            discriminatorColumnName = subTypes.getAnnotation().discriminatorColumnName();
            entityRowClass = subTypes.getClazz();
            for (EntitySubTypes.Type subType : subTypes.getAnnotation().types()) {
                Class<?> subTypeClass = subType.value();
                ModelMetadata.Type t = new ModelMetadata.Type(subTypeClass, ModelMetadataBuilder.getConstructor(subTypeClass), ModelMetadataBuilder.getFields(subTypeClass));
                types.put(subType.name(), t);
            }
        }
        return new ModelMetadata(entityRowClass, ModelMetadataBuilder.getIdField(rowClass), types, discriminatorColumnFamily, discriminatorColumnName, ModelMetadataBuilder.getTableName(rowClass));
    }

    private static <T> Constructor<T> getConstructor(Class<T> rowClass) {
        try {
            return rowClass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception ex) {
            throw new SimpleOrmException("Could not get constructor for class: " + rowClass.getName());
        }
    }

    private static String getTableName(Class rowClass) {
        AnnotationAndClass<Entity> entityAnnotation = ModelMetadataBuilder.findAnnotation(rowClass, Entity.class);
        Preconditions.checkNotNull(entityAnnotation, (Object)("Could not find " + Entity.class.getName() + " on class " + rowClass.getName()));
        return entityAnnotation.getAnnotation().tableName();
    }

    private static <T> AnnotationAndClass<T> findAnnotation(Class clazz, Class<T> annotationType) {
        T annotation = clazz.getAnnotation(annotationType);
        while (annotation == null && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            annotation = clazz.getAnnotation(annotationType);
        }
        if (annotation == null) {
            return null;
        }
        return new AnnotationAndClass(annotation, clazz);
    }

    private static Map<String, Map<String, ModelMetadata.Field>> getFields(Class rowClass) {
        HashMap<String, Map<String, ModelMetadata.Field>> fields = new HashMap<String, Map<String, ModelMetadata.Field>>();
        ModelMetadataBuilder.getFields(rowClass, fields);
        return fields;
    }

    private static <T> ModelMetadata.IdField getIdField(Class<T> clazz) {
        for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
            Id idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation == null) continue;
            return new ModelMetadata.IdField(field);
        }
        if (clazz.getSuperclass() != null) {
            return ModelMetadataBuilder.getIdField(clazz.getSuperclass());
        }
        return null;
    }

    private static void getFields(Class clazz, Map<String, Map<String, ModelMetadata.Field>> fields) {
        for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
            ModelMetadataBuilder.getField(field, fields);
        }
        if (clazz.getSuperclass() != null) {
            ModelMetadataBuilder.getFields(clazz.getSuperclass(), fields);
        }
    }

    private static void getField(java.lang.reflect.Field field, Map<String, Map<String, ModelMetadata.Field>> fields) {
        String fieldColumnName;
        Field fieldAnnotation = field.getAnnotation(Field.class);
        if (fieldAnnotation == null) {
            return;
        }
        String fieldColumnFamily = fieldAnnotation.columnFamily();
        Map<String, ModelMetadata.Field> columnFamilyFields = fields.get(fieldColumnFamily);
        if (columnFamilyFields == null) {
            columnFamilyFields = new HashMap<String, ModelMetadata.Field>();
            fields.put(fieldColumnFamily, columnFamilyFields);
        }
        if ((fieldColumnName = fieldAnnotation.columnName()).length() == 0) {
            fieldColumnName = field.getName();
        }
        if (columnFamilyFields.get(fieldColumnName) != null) {
            throw new SimpleOrmException("Multiple columns map to same field: " + fieldColumnFamily + " " + fieldColumnName);
        }
        columnFamilyFields.put(fieldColumnName, ModelMetadataBuilder.createField(field, fieldColumnFamily, fieldColumnName));
    }

    private static ModelMetadata.Field createField(java.lang.reflect.Field field, String columnFamily, String columnName) {
        Class<?> fieldType = field.getType();
        if (fieldType.isEnum()) {
            return new ModelMetadata.EnumField(field, columnFamily, columnName);
        }
        if (fieldType == String.class) {
            return new ModelMetadata.StringField(field, columnFamily, columnName);
        }
        if (fieldType == Date.class) {
            return new ModelMetadata.DateField(field, columnFamily, columnName);
        }
        if (fieldType == Map.class) {
            return new ModelMetadata.ObjectField(field, columnFamily, columnName);
        }
        if (fieldType == JSONObject.class) {
            return new ModelMetadata.JSONObjectField(field, columnFamily, columnName);
        }
        if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            return new ModelMetadata.IntegerField(field, columnFamily, columnName);
        }
        if (fieldType == Long.class || fieldType == Long.TYPE) {
            return new ModelMetadata.LongField(field, columnFamily, columnName);
        }
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            return new ModelMetadata.BooleanField(field, columnFamily, columnName);
        }
        if (fieldType.isArray() && fieldType.getComponentType() == Byte.TYPE) {
            return new ModelMetadata.ByteArrayField(field, columnFamily, columnName);
        }
        throw new SimpleOrmException("Unhandled field type: " + fieldType);
    }

    private static class AnnotationAndClass<T> {
        private final T annotation;
        private final Class clazz;

        private AnnotationAndClass(T annotation, Class clazz) {
            this.annotation = annotation;
            this.clazz = clazz;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public Class getClazz() {
            return this.clazz;
        }
    }
}

