/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.orm.graph;

import com.google.inject.Inject;
import com.mware.core.orm.ModelMetadata;
import com.mware.core.orm.ModelMetadataBuilder;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.orm.graph.GraphSimpleOrmContext;
import com.mware.ge.Authorizations;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.GeNotSupportedException;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.search.IndexHint;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.Values;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GraphSimpleOrmSession
extends SimpleOrmSession {
    private static final String ORM_VERTEX_ID = "__ORM__";
    private static final String EXTDATA_ROW_COLUMN = "__VALUE__";
    private static final Visibility ORM_VERTEX_VISIBILITY = new Visibility("__ORM__");
    private final GraphBaseWithSearchIndex graph;
    private final GeSerializer serializer;
    private Map<Class, OrmTable> cache = new ConcurrentHashMap<Class, OrmTable>();

    @Inject
    public GraphSimpleOrmSession(Graph graph) {
        this.graph = (GraphBaseWithSearchIndex)graph;
        this.serializer = this.graph.getConfiguration().createSerializer(graph);
        graph.createAuthorizations(ORM_VERTEX_VISIBILITY.getVisibilityString());
    }

    @Override
    public SimpleOrmContext createContext(String ... authorizations) {
        return new GraphSimpleOrmContext(authorizations);
    }

    @Override
    public String getTablePrefix() {
        return "";
    }

    @Override
    public Iterable<String> getTableList(SimpleOrmContext simpleOrmContext) {
        Vertex orm = this.getOrmVertex(simpleOrmContext.getAuthorizations());
        return orm.getExtendedDataTableNames();
    }

    @Override
    public void deleteTable(String table, SimpleOrmContext context) {
        Vertex orm = this.getOrmVertex(context.getAuthorizations());
        orm.prepareMutation().setIndexHint(IndexHint.DO_NOT_INDEX).deleteExtendedDataTable(table).save(context.getAuthorizations());
    }

    @Override
    public void clearTable(String table, SimpleOrmContext context) {
        this.deleteTable(table, context);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> rowClass, SimpleOrmContext context) {
        Vertex orm = this.getOrmVertex(context.getAuthorizations());
        OrmTable<T> table = this.getTable(rowClass);
        return new ConvertingIterable<ExtendedDataRow, T>(orm.getExtendedData(table.getName())){

            @Override
            protected T convert(ExtendedDataRow row) {
                return GraphSimpleOrmSession.this.realValue(row);
            }
        };
    }

    private <T> T realValue(ExtendedDataRow row) {
        if (row != null) {
            ByteArray value = (ByteArray)row.getPropertyValue(EXTDATA_ROW_COLUMN);
            if (value == null) {
                return null;
            }
            return this.serializer.bytesToObject(value.asObjectCopy());
        }
        return null;
    }

    @Override
    public <T> Iterable<T> findAllInRange(String startKey, String endKey, Class<T> rowClass, SimpleOrmContext context) {
        throw new GeNotSupportedException("Not implemented");
    }

    @Override
    public <T> T findById(Class<T> rowClass, String id, SimpleOrmContext context) {
        OrmTable<T> table = this.getTable(rowClass);
        ExtendedDataRow row = this.graph.getExtendedData(new ExtendedDataRowId(ElementType.VERTEX, ORM_VERTEX_ID, table.getName(), id), context.getAuthorizations());
        return this.realValue(row);
    }

    @Override
    public <T> Iterable<T> findByIdStartsWith(Class<T> rowClass, String idPrefix, SimpleOrmContext context) {
        OrmTable table = this.getTable(rowClass);
        return () -> StreamUtils.stream(this.findAll(rowClass, context)).filter(t -> table.getId(t).startsWith(idPrefix)).iterator();
    }

    @Override
    public <T> void save(T obj, String visibility, SimpleOrmContext context) {
        Vertex orm = this.getOrmVertex(context.getAuthorizations());
        OrmTable<?> table = this.getTable(obj.getClass());
        String rowId = table.getId(obj);
        Visibility rowVisibility = new Visibility(visibility);
        byte[] val = this.serializer.objectToBytes(obj);
        orm.prepareMutation().setIndexHint(IndexHint.DO_NOT_INDEX).addExtendedData(table.getName(), rowId, EXTDATA_ROW_COLUMN, Values.byteArray(val), rowVisibility).save(context.getAuthorizations());
    }

    @Override
    public <T> void delete(Class<T> rowClass, String id, SimpleOrmContext context) {
        Vertex orm = this.getOrmVertex(context.getAuthorizations());
        OrmTable<T> table = this.getTable(rowClass);
        orm.prepareMutation().setIndexHint(IndexHint.DO_NOT_INDEX).deleteExtendedData(table.getName(), id).save(context.getAuthorizations());
    }

    @Override
    public void close() {
    }

    private Vertex getOrmVertex(Authorizations authorizations) {
        Vertex v = this.graph.getVertex(ORM_VERTEX_ID, authorizations);
        if (v == null) {
            v = this.graph.prepareVertex(ORM_VERTEX_ID, ORM_VERTEX_VISIBILITY, "thing").save(authorizations);
        }
        return v;
    }

    protected <T> OrmTable<T> getTable(Class<T> rowClass) {
        OrmTable table = this.cache.get(rowClass);
        if (table == null) {
            for (Class<T> c = rowClass.getSuperclass(); c != null && table == null; c = c.getSuperclass()) {
                table = this.cache.get(c);
            }
        }
        if (table != null) {
            return table;
        }
        table = new OrmTable(rowClass);
        this.cache.put(table.getEntityRowClass(), table);
        return table;
    }

    public static class OrmTable<T> {
        protected final ModelMetadata<T> modelMetadata;

        public OrmTable(Class<T> rowClass) {
            this.modelMetadata = ModelMetadataBuilder.build(rowClass);
        }

        public Class getEntityRowClass() {
            return this.modelMetadata.getEntityRowClass();
        }

        public String getName() {
            return this.modelMetadata.getTableName();
        }

        public Set<ModelMetadata.Field> getColumns() {
            return this.modelMetadata.getFields();
        }

        public String getId(T obj) {
            return this.modelMetadata.getId(obj);
        }
    }
}

